/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.pkstore.keystore;

import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.pkstore.CertStoreException;
import es.mityc.javasign.pkstore.IPassStoreKS;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class KeyTool {
    private static final Log LOG = LogFactory.getLog(KeyTool.class);
    private static final II18nManager I18N = I18nFactory.getI18nManager((String)"MITyCLibCert");
    static final char[] EMPTY_STRING = "".toCharArray();

    public static List<X509Certificate> getCertificatesWithKeys(KeyStore ks) throws CertStoreException {
        return KeyTool.getCertificates(ks, true);
    }

    public static List<X509Certificate> getCertificatesWithoutKeys(KeyStore ks) throws CertStoreException {
        return KeyTool.getCertificates(ks, false);
    }

    private static List<X509Certificate> getCertificates(KeyStore ks, boolean getPrivates) throws CertStoreException {
        try {
            Enumeration<String> total = ks.aliases();
            ArrayList<X509Certificate> listaPrivada = new ArrayList<X509Certificate>();
            ArrayList<X509Certificate> listaPublica = new ArrayList<X509Certificate>();
            while (total.hasMoreElements()) {
                String alias = total.nextElement();
                Certificate cert = ks.getCertificate(alias);
                if (ks.isKeyEntry(alias)) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Certificado con alias " + alias + " tiene un key asociada"));
                    }
                    if (!(cert instanceof X509Certificate)) continue;
                    listaPrivada.add((X509Certificate)cert);
                    continue;
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Certificado con alias " + alias + " no tiene un key asociada"));
                }
                if (!(cert instanceof X509Certificate)) continue;
                listaPublica.add((X509Certificate)cert);
            }
            if (getPrivates) {
                return listaPrivada;
            }
            return listaPublica;
        }
        catch (KeyStoreException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.ks.1", new Object[]{ks.getType(), ex.getMessage(), ex}));
        }
    }

    public static PrivateKey findPrivateKey(KeyStore ks, X509Certificate certificate, IPassStoreKS passHandler, char[] nullPassword) throws CertStoreException {
        try {
            String alias = ks.getCertificateAlias(certificate);
            if (!ks.isKeyEntry(alias)) {
                LOG.trace((Object)("Certificado con alias " + alias + " no tiene clave. Se procede a b\u00fasqueda de todos los certificados con clave."));
                try {
                    Enumeration<String> total = ks.aliases();
                    while (total.hasMoreElements()) {
                        Certificate cert;
                        String keyAlias = total.nextElement();
                        if (!ks.isKeyEntry(keyAlias) || !((cert = ks.getCertificate(keyAlias)) instanceof X509Certificate) || !cert.equals(certificate)) continue;
                        alias = keyAlias;
                        LOG.trace((Object)("Certificado con clave coincide con certificado buscado: " + alias));
                        break;
                    }
                }
                catch (KeyStoreException ex) {
                    throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.ks.1", new Object[]{ex.getMessage(), ex}));
                }
            }
            if (alias == null) {
                throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.ks.6"));
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Pidiendo key asociado al alias " + alias));
            }
            PrivateKey resultado = null;
            try {
                resultado = (PrivateKey)ks.getKey(alias, nullPassword);
            }
            catch (UnrecoverableKeyException e) {
                char[] passwd = passHandler.getPassword(certificate, alias);
                resultado = (PrivateKey)ks.getKey(alias, passwd);
            }
            if (resultado == null) {
                throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.ks.5"));
            }
            return resultado;
        }
        catch (KeyStoreException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.ks.1", new Object[]{ex.getMessage(), ex}));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.ks.2", new Object[]{ex.getMessage(), ex}));
        }
        catch (UnrecoverableKeyException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.ks.4", new Object[]{ex.getMessage()}));
        }
    }

    public static PrivateKey findPrivateKey(KeyStore ks, X509Certificate certificate, IPassStoreKS passHandler) throws CertStoreException {
        return KeyTool.findPrivateKey(ks, certificate, passHandler, EMPTY_STRING);
    }

    public static List<X509Certificate> getTrustCertificates(KeyStore ks) throws CertStoreException {
        try {
            Enumeration<String> total = ks.aliases();
            ArrayList<X509Certificate> lista = new ArrayList<X509Certificate>();
            while (total.hasMoreElements()) {
                Certificate cert;
                String alias = total.nextElement();
                if (!ks.isCertificateEntry(alias) || ks.isKeyEntry(alias) || !((cert = ks.getCertificate(alias)) instanceof X509Certificate)) continue;
                lista.add((X509Certificate)cert);
            }
            return lista;
        }
        catch (KeyStoreException ex) {
            throw new CertStoreException(I18N.getLocalMessage("i18n.mityc.cert.ks.1", new Object[]{ex.getMessage(), ex}));
        }
    }

    private KeyTool() {
    }
}

