/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.pkstore.mozilla;

import es.mityc.javasign.exception.CopyFileException;
import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.pkstore.CertStoreException;
import es.mityc.javasign.pkstore.mozilla.IPINDialogConfigurable;
import es.mityc.javasign.pkstore.mozilla.PassStoreMozilla;
import es.mityc.javasign.utils.CopyFilesTool;
import es.mityc.javasign.utils.OSTool;
import es.mityc.javasign.utils.WinRegistryUtils;
import iaik.pkcs.pkcs11.objects.X509PublicKeyCertificate;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.util.PasswordCallback;

public class MozillaStoreUtils {
    private static final Log LOG = LogFactory.getLog(MozillaStoreUtils.class);
    private static final II18nManager I18N = I18nFactory.getI18nManager((String)"MITyCLibCert");
    private static final String STR_MOZILLA = "mozilla";
    private static final String STR_PASS_HANDLER = "passCallbackHandler";
    private static String tmpDir = "";
    private static final String SOFTOKN3_DLL = "softokn3.dll";
    private static final String MSVCR100_DLL = "msvcr100.dll";
    private static final String MOZGLUE_DLL = "mozglue.dll";
    private static final String NSS3_DLL = "nss3.dll";
    private static final String NSPR4_SO = "/lib/libnspr4.so";
    private static String nssLibDir = null;
    private static final String DIR_TAG = "<DIR>";
    private static final String P11_CONFIG_VALID_CHARS = ":\\0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-_.~";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static synchronized String initialize(String profile, LIB_MODE mode) throws CertStoreException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Inicializando CSP Firefox. Profile: " + profile + "\nModo: " + (Object)((Object)mode)));
        }
        if (profile == null) {
            try {
                profile = MozillaStoreUtils.getMozillaUserProfileDirectory();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Encontrada ruta al perfil de firefox: " + profile));
                }
            }
            catch (Exception e) {
                LOG.debug((Object)"No se encontr\u00f3 la ruta al perfil", (Throwable)e);
            }
        }
        String rutaFirefox = null;
        try {
            rutaFirefox = MozillaStoreUtils.getSystemNSSLibDir();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Encontrada ruta al NSS de firefox: " + rutaFirefox));
            }
        }
        catch (Exception e) {
            LOG.debug((Object)"No se pudo encontrar la ruta al NSS de Firefox", (Throwable)e);
        }
        Vector<String> arrayACargar = new Vector<String>();
        if (rutaFirefox != null) {
            int i = rutaFirefox.indexOf("firefox.exe");
            if (i != -1) {
                if ((rutaFirefox = rutaFirefox.substring(0, i)).startsWith("\"")) {
                    rutaFirefox = rutaFirefox.substring(1);
                }
                tmpDir = rutaFirefox;
            }
            arrayACargar = MozillaStoreUtils.getNSSDependencies(rutaFirefox);
            Vector<String> dlls = MozillaStoreUtils.copyLibraries(mode, rutaFirefox);
            if (dlls == null) throw new CertStoreException("No se pudo copiar la librer\u00eda de enlace con NSS");
            arrayACargar.addAll(dlls);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"No se detect\u00f3 NSS.- Se provee de una copia interna");
            }
            arrayACargar.add("NeedCopy");
        }
        try {
            MozillaStoreUtils.load(arrayACargar);
            return tmpDir;
        }
        catch (Throwable ex) {
            LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mozilla.2", new Object[]{ex.getMessage()}), ex);
            throw new CertStoreException(ex);
        }
    }

    private static synchronized Vector<String> copyLibraries(LIB_MODE mode, String dir) {
        try {
            CopyFilesTool cft = new CopyFilesTool("libs/mozilla/MITyCLibCertJNI_mozilla.properties", MozillaStoreUtils.class.getClassLoader());
            switch (mode) {
                case FULL: {
                    tmpDir = cft.copyFilesOS(dir, "mozilla.cliente", true);
                    if (!LOG.isDebugEnabled()) break;
                    LOG.debug((Object)("Librer\u00edas copiadas: " + cft.getCopiedLibraries() + " en dir " + tmpDir));
                    break;
                }
                case ONLY_JSS: {
                    tmpDir = cft.copyFilesOS(dir, "mozilla.jss", true);
                    if (!LOG.isDebugEnabled()) break;
                    LOG.debug((Object)("Librer\u00eda copiada: " + cft.getCopiedLibraries() + " en dir " + tmpDir));
                    break;
                }
                case ONLY_PKCS11: {
                    tmpDir = cft.copyFilesOS(dir, "mozilla.pkcs11", true);
                    if (!LOG.isDebugEnabled()) break;
                    LOG.debug((Object)("Librer\u00eda copiada: " + cft.getCopiedLibraries() + " en dir " + tmpDir));
                    break;
                }
                default: {
                    if (!LOG.isDebugEnabled()) break;
                    LOG.debug((Object)"Modo de librer\u00edas no soportado");
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Se terminaron de copiar las dependencias para el CSP de Mozilla");
            }
            if (tmpDir != null && !tmpDir.trim().equals("")) {
                if (!tmpDir.endsWith(File.separator)) {
                    tmpDir = String.valueOf(tmpDir) + File.separator;
                }
                Vector copiedLibraries = cft.getCopiedLibraries();
                Vector<String> absoluteLibraries = new Vector<String>();
                int i = 0;
                while (i < copiedLibraries.size()) {
                    absoluteLibraries.add(String.valueOf(tmpDir) + (String)copiedLibraries.get(i));
                    ++i;
                }
                return absoluteLibraries;
            }
            return cft.getCopiedLibraries();
        }
        catch (SecurityException ex) {
            LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mozilla.1", new Object[]{ex.getMessage()}), (Throwable)ex);
        }
        catch (UnsatisfiedLinkError ex) {
            LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mozilla.1", new Object[]{ex.getMessage()}), (Throwable)ex);
        }
        catch (CopyFileException ex) {
            LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mozilla.1", new Object[]{ex.getMessage()}), (Throwable)ex);
        }
        catch (Throwable e) {
            LOG.debug((Object)("No se pudo cargar la instancia de la librer\u00eda: " + e.getMessage()), e);
        }
        return null;
    }

    private static void load(Vector<String> keys) throws Exception {
        if (keys == null || keys.size() == 0) {
            throw new IOException("La cadena de librerias a cargar est\u00e1 vac\u00eda");
        }
        try {
            String key = null;
            int i = 0;
            while (i < keys.size()) {
                key = keys.get(i);
                if (key != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Cargando la librer\u00eda: " + key));
                    }
                    if (new File(key).exists()) {
                        System.load(key);
                    } else {
                        try {
                            System.loadLibrary(key.substring(key.lastIndexOf(File.separator) + 1));
                        }
                        catch (Exception e) {
                            throw new FileNotFoundException(key);
                        }
                    }
                }
                ++i;
            }
        }
        catch (Throwable e) {
            LOG.debug((Object)("No se pudo cargar la instancia de la pasarela con Firefox: " + e.getMessage()), e);
            try {
                keys = MozillaStoreUtils.copyLibraries(LIB_MODE.FULL, null);
                String key = null;
                int i = 0;
                while (i < keys.size()) {
                    File lib;
                    key = keys.get(i);
                    if (key == null) {
                        LOG.error((Object)"No se pudieron copiar las dependencias de NSS para Firefox");
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Cargando la librer\u00eda: " + key));
                    }
                    if ((lib = new File(key)).exists()) {
                        System.load(lib.getAbsolutePath());
                    } else {
                        int j = -1;
                        j = key.indexOf(".");
                        if (j != -1) {
                            key = key.substring(0, j);
                        }
                        if (key.startsWith("lib")) {
                            key = key.substring(3);
                        }
                        try {
                            System.loadLibrary(key.substring(key.lastIndexOf(File.separator) + 1));
                        }
                        catch (Exception ex) {
                            throw new FileNotFoundException(key);
                        }
                    }
                    ++i;
                }
            }
            catch (Throwable e2) {
                try {
                    LOG.debug((Object)"No se han cargado las dependencias tal cual, se intenta con un nombre alternativo.");
                    String random = new Long(System.currentTimeMillis()).toString();
                    CopyFilesTool cft = new CopyFilesTool("libs/mozilla/MITyCLibCertJNI_mozilla.properties", MozillaStoreUtils.class.getClassLoader());
                    tmpDir = cft.copyFilesOS(null, "mozilla.cliente", true, random);
                    keys = cft.getCopiedLibraries();
                    String key = null;
                    int i = 0;
                    while (i < keys.size()) {
                        key = (String)keys.get(i);
                        if (key == null) {
                            LOG.error((Object)"No se pudieron copiar las dependencias de NSS para Firefox");
                            break;
                        }
                        File lib = new File(String.valueOf(tmpDir) + File.separator + key);
                        if (lib.exists()) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Cargando la librer\u00eda alternativa: " + lib.getAbsolutePath()));
                            }
                            System.load(lib.getAbsolutePath());
                        } else {
                            int j = -1;
                            j = key.indexOf(".");
                            if (j != -1) {
                                key = key.substring(0, j);
                            }
                            try {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)("Cargando la librer\u00eda alternativa dos: " + key.substring(key.lastIndexOf(File.separator) + 1)));
                                }
                                System.loadLibrary(key.substring(key.lastIndexOf(File.separator) + 1));
                            }
                            catch (Exception e3) {
                                throw new FileNotFoundException(key);
                            }
                        }
                        ++i;
                    }
                }
                catch (Throwable e3) {
                    LOG.debug((Object)("No se pudo cargar definitivamente la instancia de las librer\u00edas de Firefox: " + e3.getMessage()), e3);
                    throw new Exception(e3);
                }
            }
        }
    }

    protected static PasswordCallback getPassHandler(IPINDialogConfigurable.MESSAGES_MODE mode, String title, String pinMessage) {
        PasswordCallback handler = null;
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"Obteniendo Passhandler...");
            }
            ResourceBundle rb = ResourceBundle.getBundle(STR_MOZILLA);
            String handlerClass = rb.getString(STR_PASS_HANDLER);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Nombre de ventana de pin: " + handlerClass));
            }
            handler = (PasswordCallback)Class.forName(handlerClass).newInstance();
            ((IPINDialogConfigurable)handler).setMessagesMode(mode);
            if (title != null) {
                ((IPINDialogConfigurable)handler).setTitle(title);
            }
            if (pinMessage != null) {
                ((IPINDialogConfigurable)handler).setPINMessage(pinMessage);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"Pashandler configurado");
            }
        }
        catch (MissingResourceException ex) {
            LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mozilla.3", new Object[]{ex.getMessage()}));
            handler = new PassStoreMozilla();
        }
        catch (InstantiationException ex) {
            LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mozilla.3", new Object[]{ex.getMessage()}));
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)ex);
            }
            handler = new PassStoreMozilla();
        }
        catch (IllegalAccessException ex) {
            LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mozilla.3", new Object[]{ex.getMessage()}));
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)ex);
            }
            handler = new PassStoreMozilla();
        }
        catch (ClassNotFoundException ex) {
            LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mozilla.3", new Object[]{ex.getMessage()}));
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)ex);
            }
            handler = new PassStoreMozilla();
        }
        catch (ClassCastException ex) {
            LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mozilla.3", new Object[]{ex.getMessage()}));
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)ex);
            }
            handler = new PassStoreMozilla();
        }
        return handler;
    }

    protected static java.security.cert.X509Certificate convert(X509Certificate certificate) {
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Convirtiendo certificado JSS: " + certificate.getSubjectDN()));
            }
            byte[] certFirma = certificate.getEncoded();
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            return (java.security.cert.X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certFirma));
        }
        catch (CertificateEncodingException ex) {
            LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mozilla.4", new Object[]{ex.getMessage()}), (Throwable)ex);
        }
        catch (CertificateException ex) {
            LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mozilla.4", new Object[]{ex.getMessage()}), (Throwable)ex);
        }
        return null;
    }

    protected static java.security.cert.X509Certificate convert(X509PublicKeyCertificate certificate) {
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Convirtiendo certificado PKCS11: " + certificate.getLabel()));
            }
            byte[] encCert = certificate.getValue().getByteArrayValue();
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            return (java.security.cert.X509Certificate)cf.generateCertificate(new ByteArrayInputStream(encCert));
        }
        catch (CertificateEncodingException ex) {
            LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mozilla.4", new Object[]{ex.getMessage()}), (Throwable)ex);
        }
        catch (CertificateException ex) {
            LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mozilla.4", new Object[]{ex.getMessage()}), (Throwable)ex);
        }
        return null;
    }

    static String createPKCS11NSSConfigFile(String userProfileDirectory, String libDir) {
        String softoknLib = "libsoftokn3.so";
        if (OSTool.getSO().isWindows()) {
            softoknLib = SOFTOKN3_DLL;
        } else if (OSTool.getSO().isMacOsX()) {
            softoknLib = "libsoftokn3.dylib";
        }
        if (libDir == null) {
            LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mozilla.9"));
            return "";
        }
        if (!libDir.endsWith(File.separator)) {
            libDir.concat(File.separator);
        }
        StringBuilder buffer = new StringBuilder("name=NSS-PKCS11\r\n");
        buffer.append("library=").append(libDir).append(softoknLib).append("\r\n").append("attributes=compatibility\r\n").append("configdir='").append(userProfileDirectory).append("' ").append("certPrefix='' ").append("keyPrefix='' ").append("secmod='secmod.db' ").append("flags=readOnly");
        return buffer.toString();
    }

    static String getSystemNSSLibDir() throws Exception {
        if (nssLibDir != null) {
            return nssLibDir;
        }
        if (OSTool.getSO().isWindows()) {
            return MozillaStoreUtils.getSystemNSSLibDirWindows();
        }
        if (OSTool.getSO().isLinux() || OSTool.getSO().getVersion().contains("olaris")) {
            return MozillaStoreUtils.getSystemNSSLibDirUnix();
        }
        if (OSTool.getSO().isMacOsX()) {
            return MozillaStoreUtils.getSystemNSSLibDirMacOsX();
        }
        LOG.debug((Object)"No se han encontrado bibliotecas NSS instaladas en su sistema operativo");
        return null;
    }

    private static String getSystemNSSLibDirWindows() throws Exception {
        String dir = WinRegistryUtils.readString((int)-2147483647, (String)"Software\\Classes\\FirefoxURL\\shell\\open\\command", (String)"");
        if (dir == null && (dir = WinRegistryUtils.readString((int)-2147483646, (String)"SOFTWARE\\Classes\\FirefoxURL\\shell\\open\\command", (String)"")) == null) {
            throw new FileNotFoundException("No se ha podido localizar el directorio de Firefox a traves del registro de Windows");
        }
        String regKeyLowCase = dir.toLowerCase();
        int pos = regKeyLowCase.indexOf("firefox.exe");
        if (pos != -1) {
            File tmpFile;
            if ((dir = dir.substring(0, pos)).startsWith("\"")) {
                dir = dir.substring(1);
            }
            if (dir.endsWith(File.separator)) {
                dir = dir.substring(0, dir.length() - 1);
            }
            if ((tmpFile = new File(dir)).exists() && tmpFile.isDirectory() && (tmpFile = new File(String.valueOf(dir) + File.separator + SOFTOKN3_DLL)).exists()) {
                char c;
                block13: {
                    try {
                        dir = tmpFile.getParentFile().getCanonicalPath();
                    }
                    catch (Exception e) {
                        if (!dir.contains("~")) break block13;
                        throw new FileNotFoundException("No se ha podido obtener el nombre del directorio del modulo PKCS#11, parece estar establecido como un nombre corto (8+3): " + e);
                    }
                }
                boolean illegalChars = false;
                char[] cArray = dir.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    c = cArray[n2];
                    if (P11_CONFIG_VALID_CHARS.indexOf(c) == -1) {
                        illegalChars = true;
                        break;
                    }
                    ++n2;
                }
                if (illegalChars || dir.contains("~")) {
                    LOG.error((Object)("Si esta version de JRE esta afectada por el error 6581254 de Java es posible que no pueda cargarse: " + dir));
                }
                cArray = dir.toCharArray();
                n = cArray.length;
                n2 = 0;
                while (n2 < n) {
                    c = cArray[n2];
                    if (P11_CONFIG_VALID_CHARS.indexOf(c) == -1) {
                        dir = dir.replace(System.getProperty("user.home"), MozillaStoreUtils.getShort(System.getProperty("user.home")));
                        break;
                    }
                    ++n2;
                }
                return dir;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"No se ha encontrado un NSS compatible en Windows");
        }
        return null;
    }

    private static String getShort(String longPath) {
        InputStream is;
        block9: {
            if (longPath == null) {
                return longPath;
            }
            File dir = new File(longPath);
            if (!dir.exists() || !dir.isDirectory()) {
                return longPath;
            }
            Process p = new ProcessBuilder("cmd.exe", "/c", "dir /ad /x \"" + longPath + "\\..\\?" + longPath.substring(longPath.lastIndexOf(92) + 2) + "\"").start();
            is = p.getInputStream();
            if (is != null) break block9;
            return null;
        }
        try {
            int nBytes = 0;
            byte[] buffer = new byte[4096];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((nBytes = is.read(buffer)) != -1) {
                baos.write(buffer, 0, nBytes);
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(baos.toByteArray())));
            String line = br.readLine();
            while (line != null) {
                if (line.contains(DIR_TAG)) {
                    String path = longPath.substring(0, longPath.lastIndexOf(92) + 1);
                    String filenames = line.substring(line.indexOf(DIR_TAG) + DIR_TAG.length()).trim();
                    int index = filenames.indexOf(" ");
                    String shortName = null;
                    shortName = index > 0 ? filenames.substring(0, filenames.indexOf(" ")) : filenames.substring(0);
                    if (!"".equals(shortName)) {
                        return String.valueOf(path) + shortName;
                    }
                    return longPath;
                }
                line = br.readLine();
            }
        }
        catch (Exception e) {
            LOG.error((Object)("No se ha podido obtener el nombre corto de " + longPath), (Throwable)e);
        }
        return longPath;
    }

    private static String getSystemNSSLibDirMacOsX() throws FileNotFoundException {
        String[] posiblesRutas;
        String[] stringArray = posiblesRutas = new String[]{"/Applications/Firefox.app/Contents/MacOS", "/lib", "/usr/lib", "/usr/lib/nss", "/Applications/Minefield.app/Contents/MacOS"};
        int n = posiblesRutas.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            if (new File(String.valueOf(path) + "/libsoftokn3.dylib").exists()) {
                nssLibDir = path;
            }
            ++n2;
        }
        if (nssLibDir == null) {
            throw new FileNotFoundException("No se ha podido determinar la localizacion de NSS en Mac OS X");
        }
        return nssLibDir;
    }

    private static String getSystemNSSLibDirUnix() throws FileNotFoundException {
        String[] posiblesRutas;
        if (new File("/usr/lib/libsoftokn3.so").exists() && new File(NSPR4_SO).exists()) {
            try {
                System.load(NSPR4_SO);
                nssLibDir = "/usr/lib";
            }
            catch (Exception e) {
                nssLibDir = null;
                LOG.debug((Object)("Se descarta el NSS situado entre /lib y /usr/lib. No puede ser cargado: " + e));
            }
            if (nssLibDir != null) {
                return nssLibDir;
            }
        }
        String[] stringArray = posiblesRutas = new String[]{"/usr/lib/firefox-" + MozillaStoreUtils.searchLastFirefoxVersion("/usr/lib/"), "/usr/lib/firefox", "/opt/firefox", "/opt/firefox-" + MozillaStoreUtils.searchLastFirefoxVersion("/opt/"), "/lib", "/usr/lib", "/usr/lib/nss", "/opt/fedora-ds/clients/lib"};
        int n = posiblesRutas.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            if (new File(String.valueOf(path) + "/libsoftokn3.so").exists() && new File(String.valueOf(path) + "/libnspr4.so").exists()) {
                try {
                    System.load(String.valueOf(path) + "/libnspr4.so");
                    nssLibDir = path;
                }
                catch (Exception e) {
                    nssLibDir = null;
                    LOG.error((Object)("Se descarta el NSS situado en '" + path + "' porque no puede cargarse adecuadamente: " + e));
                }
                if (nssLibDir != null) {
                    return nssLibDir;
                }
            }
            ++n2;
        }
        if (nssLibDir == null) {
            throw new FileNotFoundException("No se ha podido determinar la localizacion de NSS en UNIX");
        }
        return nssLibDir;
    }

    private static String searchLastFirefoxVersion(String startDir) {
        File directoryLib = new File(startDir);
        if (directoryLib.isDirectory()) {
            String[] filenames = directoryLib.list();
            ArrayList<String> firefoxDirectories = new ArrayList<String>();
            String[] stringArray = filenames;
            int n = filenames.length;
            int n2 = 0;
            while (n2 < n) {
                String filename = stringArray[n2];
                if (filename.startsWith("firefox-")) {
                    firefoxDirectories.add(filename.replace("firefox-", ""));
                }
                ++n2;
            }
            if (firefoxDirectories.isEmpty()) {
                return "";
            }
            int i = 0;
            while (i < firefoxDirectories.size()) {
                try {
                    Integer.getInteger((String)firefoxDirectories.get(i));
                }
                catch (Exception e) {
                    firefoxDirectories.remove(i);
                }
                ++i;
            }
            if (firefoxDirectories.size() == 1) {
                return (String)firefoxDirectories.get(0);
            }
            Collections.sort(firefoxDirectories, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareTo(o2);
                }
            });
            return (String)firefoxDirectories.get(0);
        }
        return "";
    }

    private static Vector<String> getNSSDependencies(String nssDirectory) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Buscando dependencias NSS");
        }
        Vector<String> dependList = new Vector<String>();
        if (OSTool.getSO().isLinux() && new File("/usr/lib/libsoftokn3.so").exists() && new File(NSPR4_SO).exists()) {
            dependList.add(NSPR4_SO);
            dependList.add("/lib/libplds4.so");
            dependList.add("/usr/lib/libplds4.so");
            dependList.add("/lib/libplc4.so");
            dependList.add("/usr/lib/libplc4.so");
            dependList.add("/lib/libnssutil3.so");
            dependList.add("/usr/lib/libnssutil3.so");
            dependList.add("/lib/libsqlite3.so");
            dependList.add("/usr/lib/libsqlite3.so");
            dependList.add("/lib/libmozsqlite3.so");
            dependList.add("/usr/lib/libmozsqlite3.so");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Encontrado NSS Fedora: " + dependList));
            }
        } else {
            String path = String.valueOf(nssDirectory) + (nssDirectory.endsWith(File.separator) ? "" : File.separator);
            String[] dependList2 = MozillaStoreUtils.getSoftkn3Dependencies(path);
            dependList.addAll(Arrays.asList(dependList2));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Encontrado NSS: " + dependList));
            }
        }
        return dependList;
    }

    private static String[] getSoftkn3Dependencies(String path) {
        String nssPath;
        if (path == null) {
            return new String[0];
        }
        if (OSTool.getSO().isMacOsX()) {
            LOG.error((Object)"NSS MacOS no soportado: ");
            return new String[0];
        }
        String string = nssPath = !path.endsWith(File.separator) ? String.valueOf(path) + File.separator : path;
        if (OSTool.getSO().isWindows()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"NSS Windows");
            }
            if (OSTool.getSO().is64bits()) {
                return new String[]{String.valueOf(nssPath) + MSVCR100_DLL, String.valueOf(nssPath) + MOZGLUE_DLL, String.valueOf(nssPath) + NSS3_DLL, String.valueOf(nssPath) + SOFTOKN3_DLL};
            }
            return new String[]{String.valueOf(nssPath) + MSVCR100_DLL, String.valueOf(nssPath) + MOZGLUE_DLL, String.valueOf(nssPath) + NSS3_DLL, String.valueOf(nssPath) + SOFTOKN3_DLL};
        }
        if (OSTool.getSO().isLinux() || OSTool.getSO().getVersion().contains("olaris")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"NSS Linux");
            }
            return new String[]{String.valueOf(nssPath) + "libnspr4.so", String.valueOf(nssPath) + "libplds4.so", String.valueOf(nssPath) + "libplc4.so", String.valueOf(nssPath) + "libnssutil3.so", String.valueOf(nssPath) + "libsqlite3.so", String.valueOf(nssPath) + "libmozsqlite3.so", String.valueOf(nssPath) + "libsoftokn3.so"};
        }
        LOG.error((Object)("Plataforma no soportada para la precarga de las bibliotecas NSS: " + OSTool.getSO() + " + Java " + OSTool.getSO().getVersion()));
        return new String[0];
    }

    public static String getMozillaUserProfileDirectory() throws Exception {
        if (OSTool.getSO().isWindows()) {
            return MozillaStoreUtils.getMozillaUserProfileDirectoryWindows();
        }
        if (OSTool.getSO().isMacOsX()) {
            return MozillaStoreUtils.getMozillaUserProfileDirectoryMacOsX();
        }
        return MozillaStoreUtils.getMozillaUserProfileDirectoryUnix();
    }

    private static String getMozillaUserProfileDirectoryUnix() {
        File regFile = new File(String.valueOf(System.getProperty("user.home")) + "/.mozilla/firefox/profiles.ini");
        try {
            if (regFile.exists()) {
                return MozillaStoreUtils.getFireFoxUserProfileDirectory(regFile);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error obteniendo el directorio de perfil de Firefox (UNIX): " + e));
        }
        return null;
    }

    private static String getMozillaUserProfileDirectoryWindows() throws Exception {
        String appDataDir = WinRegistryUtils.readString((int)-2147483647, (String)"Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", (String)"AppData");
        if (appDataDir != null) {
            String finalDir = null;
            File regFile = new File(String.valueOf(appDataDir) + "\\Mozilla\\Firefox\\profiles.ini");
            try {
                if (regFile.exists()) {
                    finalDir = MozillaStoreUtils.getFireFoxUserProfileDirectory(regFile);
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Error obteniendo el directorio de perfil de Firefox: " + e));
                return null;
            }
            if (finalDir != null) {
                char[] cArray = finalDir.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char c = cArray[n2];
                    if (P11_CONFIG_VALID_CHARS.indexOf(c) == -1) {
                        finalDir = finalDir.replace(System.getProperty("user.home"), MozillaStoreUtils.getShort(System.getProperty("user.home")));
                        break;
                    }
                    ++n2;
                }
                return finalDir.replace('\\', '/');
            }
        }
        LOG.error((Object)"Error obteniendo el directorio de perfil de usuario de Mozilla Firefox (Windows)");
        return null;
    }

    private static String getMozillaUserProfileDirectoryMacOsX() {
        File regFile = new File(String.valueOf(System.getProperty("user.home")) + "/Library/Application Support/Firefox/profiles.ini");
        try {
            if (regFile.exists()) {
                return MozillaStoreUtils.getFireFoxUserProfileDirectory(regFile);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error obteniendo el directorio de perfil de Firefox (" + regFile.getAbsolutePath() + "): " + e));
        }
        return null;
    }

    static void configureMacNSS(String binDir) throws Exception {
        if (!OSTool.getSO().isMacOsX()) {
            LOG.error((Object)("No se ha detectado MacOS: " + OSTool.getSO()));
            return;
        }
        if (binDir == null) {
            LOG.error((Object)"El directorio de NSS para configurar proporcionado es nulo, no se realizara ninguna accion");
            return;
        }
        String nssBinDir = binDir.endsWith("/") ? binDir : String.valueOf(binDir) + "/";
        try {
            System.load(String.valueOf(nssBinDir) + "libsoftokn3.dylib");
            return;
        }
        catch (Exception exception) {
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        String[] libs = new String[]{"libmozutils.dylib", "libnspr4.dylib", "libplds4.dylib", "libplc4.dylib", "libmozsqlite3.dylib", "libnssutil3.dylib"};
        StringBuilder sb = new StringBuilder();
        String[] stringArray = libs;
        int n = libs.length;
        int n2 = 0;
        while (n2 < n) {
            String lib = stringArray[n2];
            if (new File(String.valueOf(nssBinDir) + lib).exists()) {
                sb.append("ln -s ");
                sb.append(nssBinDir);
                sb.append(lib);
                sb.append(" /usr/lib/");
                sb.append(lib);
                sb.append("; ");
            }
            ++n2;
        }
        try {
            Class<?> scriptEngineManagerClass = Class.forName("javax.script.ScriptEngineManager");
            Object scriptEngineManager = scriptEngineManagerClass.newInstance();
            Method getEngineByNameMethod = scriptEngineManagerClass.getMethod("getEngineByName", String.class);
            Object scriptEngine = getEngineByNameMethod.invoke(scriptEngineManager, "AppleScript");
            Class<?> scriptEngineClass = Class.forName("javax.script.ScriptEngine");
            Method evalMethod = scriptEngineClass.getMethod("eval", String.class);
            evalMethod.invoke(scriptEngine, "do shell script \"" + sb.toString() + "\" with administrator privileges");
        }
        catch (Exception e) {
            LOG.error((Object)("No se ha podido crear los enlaces simbolicos para NSS: " + e));
        }
        try {
            System.load(String.valueOf(nssBinDir) + "libsoftokn3.dylib");
        }
        catch (Exception e) {
            throw new Exception("La configuracion de NSS para Mac OS X ha fallado por motivos de seguridad: " + e);
        }
        catch (UnsatisfiedLinkError e) {
            throw new Exception("La configuracion de NSS para Mac OS X ha fallado: " + e);
        }
    }

    private static String getFireFoxUserProfileDirectory(File iniFile) throws IOException {
        FirefoxProfile profile;
        FirefoxProfile[] profiles;
        if (iniFile == null) {
            throw new IllegalArgumentException("El fichero INI es nulo y no se podra determinar el directorio del usuario de firefox");
        }
        if (!iniFile.exists() || !iniFile.isFile()) {
            throw new IOException("No se ha encontrado el fichero con los perfiles de firefox");
        }
        String currentProfilePath = null;
        FirefoxProfile[] firefoxProfileArray = profiles = MozillaStoreUtils.readProfiles(iniFile);
        int n = profiles.length;
        int n2 = 0;
        while (n2 < n) {
            profile = firefoxProfileArray[n2];
            if (MozillaStoreUtils.isProfileLocked(profile)) {
                currentProfilePath = profile.getAbsolutePath();
                break;
            }
            ++n2;
        }
        if (currentProfilePath == null) {
            firefoxProfileArray = profiles;
            n = profiles.length;
            n2 = 0;
            while (n2 < n) {
                profile = firefoxProfileArray[n2];
                if (profile.isDefault()) {
                    currentProfilePath = profile.getAbsolutePath();
                    break;
                }
                ++n2;
            }
        }
        if (profiles.length > 0) {
            currentProfilePath = profiles[0].getAbsolutePath();
        }
        return currentProfilePath;
    }

    private static FirefoxProfile[] readProfiles(File iniFile) throws IOException {
        String nameAtr = "name=";
        String isRelativeAtr = "isrelative=";
        String pathProfilesAtr = "path=";
        String isDefaultAtr = "default=";
        String line = null;
        ArrayList<FirefoxProfile> profiles = new ArrayList<FirefoxProfile>();
        BufferedReader in = new BufferedReader(new FileReader(iniFile));
        try {
            try {
                while ((line = in.readLine()) != null) {
                    if (!line.trim().toLowerCase().startsWith("[profile")) continue;
                    FirefoxProfile profile = new FirefoxProfile();
                    while ((line = in.readLine()) != null && line.trim().length() > 0 && !line.trim().toLowerCase().startsWith("[profile")) {
                        if (line.trim().toLowerCase().startsWith("name=")) {
                            profile.setName(line.trim().substring("name=".length()));
                            continue;
                        }
                        if (line.trim().toLowerCase().startsWith("isrelative=")) {
                            profile.setRelative(line.trim().substring("isrelative=".length()).equals("1"));
                            continue;
                        }
                        if (line.trim().toLowerCase().startsWith("path=")) {
                            profile.setPath(line.trim().substring("path=".length()));
                            continue;
                        }
                        if (!line.trim().toLowerCase().startsWith("default=")) break;
                        profile.setDefault(line.trim().substring("default=".length()).equals("1"));
                    }
                    if (profile.getName() == null && profile.getPath() == null) continue;
                    profile.setAbsolutePath(profile.isRelative() ? new File(iniFile.getParent(), profile.getPath()).toString() : profile.getPath());
                    profiles.add(profile);
                }
            }
            catch (Exception e) {
                throw new IOException("Error al leer la configuracion de los perfiles de Firefox: " + e);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
        return profiles.toArray(new FirefoxProfile[profiles.size()]);
    }

    private static boolean isProfileLocked(FirefoxProfile profile) {
        return new File(profile.getAbsolutePath(), "parent.lock").exists() || new File(profile.getAbsolutePath(), "lock").exists();
    }

    private static final class FirefoxProfile {
        private String name = null;
        private boolean relative = true;
        private String path = null;
        private String absolutePath = null;
        private boolean def = false;

        private FirefoxProfile() {
        }

        String getName() {
            return this.name;
        }

        void setName(String n) {
            this.name = n;
        }

        boolean isRelative() {
            return this.relative;
        }

        void setRelative(boolean r) {
            this.relative = r;
        }

        String getPath() {
            return this.path;
        }

        void setPath(String p) {
            this.path = p;
        }

        String getAbsolutePath() {
            return this.absolutePath;
        }

        void setAbsolutePath(String ap) {
            this.absolutePath = ap;
        }

        boolean isDefault() {
            return this.def;
        }

        void setDefault(boolean d) {
            this.def = d;
        }
    }

    public static enum LIB_MODE {
        FULL,
        ONLY_JSS,
        ONLY_PKCS11;

    }
}

