/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.pkstore.mscapi.mityc;

import es.mityc.javasign.pkstore.mscapi.mityc.Key;
import es.mityc.javasign.pkstore.mscapi.mityc.RSAPrivateKey;
import es.mityc.javasign.pkstore.mscapi.mityc.RSAPublicKey;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;

abstract class RSASignature
extends SignatureSpi {
    private final MessageDigest messageDigest;
    private boolean needsReset;
    private Key privateKey = null;
    private Key publicKey = null;

    RSASignature(String digestName) {
        try {
            this.messageDigest = MessageDigest.getInstance(digestName);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ProviderException(e);
        }
        this.needsReset = false;
    }

    @Override
    protected void engineInitVerify(PublicKey key) throws InvalidKeyException {
        if (!(key instanceof java.security.interfaces.RSAPublicKey)) {
            throw new InvalidKeyException("Key type not supported");
        }
        java.security.interfaces.RSAPublicKey rsaKey = (java.security.interfaces.RSAPublicKey)key;
        if (!(key instanceof RSAPublicKey)) {
            BigInteger modulus = rsaKey.getModulus();
            BigInteger exponent = rsaKey.getPublicExponent();
            byte[] modulusBytes = modulus.toByteArray();
            byte[] exponentBytes = exponent.toByteArray();
            int keyBitLength = modulusBytes[0] == 0 ? (modulusBytes.length - 1) * 8 : modulusBytes.length * 8;
            byte[] keyBlob = this.generatePublicKeyBlob(keyBitLength, modulusBytes, exponentBytes);
            this.publicKey = this.importPublicKey(keyBlob, keyBitLength);
        } else {
            this.publicKey = (RSAPublicKey)key;
        }
        if (this.needsReset) {
            this.messageDigest.reset();
            this.needsReset = false;
        }
    }

    @Override
    protected void engineInitSign(PrivateKey key) throws InvalidKeyException {
        if (!(key instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("Key type not supported");
        }
        this.privateKey = (RSAPrivateKey)key;
        if (this.needsReset) {
            this.messageDigest.reset();
            this.needsReset = false;
        }
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        this.messageDigest.update(b);
        this.needsReset = true;
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.messageDigest.update(b, off, len);
        this.needsReset = true;
    }

    @Override
    protected void engineUpdate(ByteBuffer input) {
        this.messageDigest.update(input);
        this.needsReset = true;
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] hash = this.messageDigest.digest();
        this.needsReset = false;
        byte[] result = RSASignature.signHash(hash, hash.length, this.messageDigest.getAlgorithm(), this.privateKey.getHCryptProvider(), this.privateKey.getHCryptKey());
        return this.convertEndianArray(result);
    }

    private byte[] convertEndianArray(byte[] byteArray) {
        if (byteArray == null || byteArray.length == 0) {
            return byteArray;
        }
        byte[] retval = new byte[byteArray.length];
        int i = 0;
        while (i < byteArray.length) {
            retval[i] = byteArray[byteArray.length - i - 1];
            ++i;
        }
        return retval;
    }

    private static native byte[] signHash(byte[] var0, int var1, String var2, long var3, long var5) throws SignatureException;

    private static native boolean verifySignedHash(byte[] var0, int var1, String var2, byte[] var3, int var4, long var5, long var7) throws SignatureException;

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        byte[] hash = this.messageDigest.digest();
        this.needsReset = false;
        return RSASignature.verifySignedHash(hash, hash.length, this.messageDigest.getAlgorithm(), this.convertEndianArray(sigBytes), sigBytes.length, this.publicKey.getHCryptProvider(), this.publicKey.getHCryptKey());
    }

    @Override
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        throw new InvalidParameterException("Parameter not supported");
    }

    @Override
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        throw new InvalidParameterException("Parameter not supported");
    }

    private native byte[] generatePublicKeyBlob(int var1, byte[] var2, byte[] var3);

    private native RSAPublicKey importPublicKey(byte[] var1, int var2);

    public static final class MD2
    extends RSASignature {
        public MD2() {
            super("MD2");
        }
    }

    public static final class MD5
    extends RSASignature {
        public MD5() {
            super("MD5");
        }
    }

    public static final class SHA1
    extends RSASignature {
        public SHA1() {
            super("SHA1");
        }
    }

    public static final class SHA256
    extends RSASignature {
        public SHA256() {
            super("SHA-256");
        }
    }

    public static final class SHA384
    extends RSASignature {
        public SHA384() {
            super("SHA-384");
        }
    }

    public static final class SHA512
    extends RSASignature {
        public SHA512() {
            super("SHA-512");
        }
    }
}

