/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.pass;

import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.pass.PBESecurity;
import es.mityc.javasign.pass.PassSecurityException;
import es.mityc.javasign.utils.HexUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Properties;

public class PBEFileSecurity
extends PBESecurity {
    private static final II18nManager I18N = I18nFactory.getI18nManager("MITyCLibAPI");
    private static final String PROP_FILE_CONF = "filePBE.URI";
    private static final String PROP_DEFAULT_FILE = "./pbesec.properties";
    private static final String PROP_FILE_SALT = "simplePBE.salt=";
    private static final String PROP_FILE_ITERATION = "simplePBE.iteration=";
    private static final String PROP_FILE_MASTERKEY = "simplePBE.masterkey=";
    private static final int MAX_VALUE_ITER = 4096;
    private static final int MAX_SIZE_MASTER_KEY = 20;
    private static final int MAX_SIZE_BYTES_SALT = 8;

    public PBEFileSecurity() throws PassSecurityException {
    }

    public PBEFileSecurity(Properties props) throws PassSecurityException {
        super(props);
    }

    @Override
    protected void init() throws PassSecurityException {
        this.init(PROP_DEFAULT_FILE);
    }

    protected void init(String path) throws PassSecurityException {
        try {
            InputStream is;
            block8: {
                URI uri = new URI(path);
                if (!uri.isAbsolute()) {
                    uri = new File("./").toURI().resolve(uri);
                }
                is = null;
                try {
                    is = uri.toURL().openStream();
                }
                catch (IOException ex) {
                    File file;
                    if (!"file".equals(uri.getScheme()) || (file = new File(uri)).exists()) break block8;
                    file.getParentFile().mkdirs();
                    this.createSecFile(file);
                    is = new FileInputStream(file);
                }
            }
            if (is == null) {
                throw new PassSecurityException(I18N.getLocalMessage("i18n.mityc.api.pass.4", path));
            }
            Properties props = new Properties();
            props.load(is);
            super.init(props);
        }
        catch (URISyntaxException ex) {
            throw new PassSecurityException(ex.getMessage(), ex);
        }
        catch (MalformedURLException ex) {
            throw new PassSecurityException(ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new PassSecurityException(ex.getMessage(), ex);
        }
    }

    @Override
    protected void init(Properties props) throws PassSecurityException {
        String file = props.getProperty(PROP_FILE_CONF);
        if (file != null && file.trim().length() > 0) {
            this.init(file);
        } else {
            this.init();
        }
    }

    protected void createSecFile(File file) throws IOException {
        PrintWriter pw;
        SecureRandom random = null;
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IOException(I18N.getLocalMessage("i18n.mityc.api.pass.9", ex.getMessage()));
        }
        if (file.createNewFile()) {
            pw = new PrintWriter(file);
            pw.println(I18N.getLocalMessage("i18n.mityc.api.pass.6"));
            pw.print(PROP_FILE_SALT);
            byte[] data = new byte[8];
            random.nextBytes(data);
            pw.println(HexUtils.convert(data));
            pw.println(I18N.getLocalMessage("i18n.mityc.api.pass.7"));
            pw.print(PROP_FILE_ITERATION);
            pw.println(random.nextInt(4096));
            pw.println(I18N.getLocalMessage("i18n.mityc.api.pass.8"));
            pw.print(PROP_FILE_MASTERKEY);
            int i = 0;
            while (i < 20) {
                char c = (char)(random.nextInt(94) + 33);
                pw.print(c);
                ++i;
            }
        } else {
            throw new IOException(I18N.getLocalMessage("i18n.mityc.api.pass.5", file.getAbsolutePath()));
        }
        pw.println();
        pw.flush();
        pw.close();
    }
}

