/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.trust;

import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.trust.TrustAbstract;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TrustFactory {
    private static final Log LOG = LogFactory.getLog(TrustFactory.class);
    private static final II18nManager I18N = I18nFactory.getI18nManager("MITyCLibAPI");
    private static final String METHOD_GET_INSTANCE = "getInstance";
    private static final String METHOD_NEW_INSTANCE = "newInstance";
    private static final String STRING_EMPTY = "";
    private static final String TRUST_SERVICES_FILE_CONF = "META-INF/trust/trustservices.properties";
    private static final String TRUST_SERVICES_FACTORY_CLASS = "services.trust.factory.class";
    private static final String TRUST_FILE_CONF = "trust/trust.properties";
    private static final String TRUSTER_PROP_NO_AVALAIBLE = "none";
    private Properties props = null;
    private static TrustFactory instance = null;

    protected TrustFactory() {
        this.loadConfig();
    }

    private static ClassLoader getClassLoader() {
        try {
            ClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    ClassLoader classLoader = null;
                    try {
                        classLoader = Thread.currentThread().getContextClassLoader();
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    return classLoader;
                }
            });
            if (cl != null) {
                return cl;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return TrustFactory.class.getClassLoader();
    }

    private void loadConfig() {
        ClassLoader cl = TrustFactory.getClassLoader();
        try {
            ArrayList<URL> resources = new ArrayList<URL>();
            Enumeration<URL> en = cl.getResources(TRUST_FILE_CONF);
            while (en.hasMoreElements()) {
                resources.add(0, en.nextElement());
            }
            Properties base = null;
            for (URL url : resources) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Cargando el fichero de propiedades de listas de confianza: " + url));
                    }
                    InputStream is = url.openStream();
                    Properties properties = new Properties(base);
                    properties.load(is);
                    base = properties;
                }
                catch (IOException ex) {
                    LOG.error((Object)I18N.getLocalMessage("i18n.mityc.api.trust.9", url, ex.getMessage()));
                }
            }
            this.props = base;
        }
        catch (IOException ex) {
            LOG.error((Object)I18N.getLocalMessage("i18n.mityc.api.trust.1", ex.getMessage()));
        }
    }

    public static TrustFactory getInstance() {
        if (instance == null) {
            block21: {
                try {
                    String classname = null;
                    ClassLoader cl = TrustFactory.getClassLoader();
                    InputStream is = cl.getResourceAsStream(TRUST_SERVICES_FILE_CONF);
                    if (is != null) {
                        Properties rb = new Properties();
                        try {
                            rb.load(is);
                            classname = rb.getProperty(TRUST_SERVICES_FACTORY_CLASS);
                        }
                        catch (IOException ex) {
                            LOG.warn((Object)I18N.getLocalMessage("i18n.mityc.api.trust.9", TRUST_SERVICES_FACTORY_CLASS, ex.getMessage()));
                        }
                    }
                    if (classname == null) break block21;
                    try {
                        Method method;
                        Class<TrustFactory> returnType;
                        Class<?> classFactory = null;
                        classFactory = cl != null ? cl.loadClass(classname) : Class.forName(classname);
                        if (classFactory != null && (returnType = (method = classFactory.getDeclaredMethod(METHOD_NEW_INSTANCE, new Class[0])).getReturnType()) != null && returnType.isAssignableFrom(TrustFactory.class)) {
                            instance = (TrustFactory)method.invoke(null, new Object[0]);
                        }
                    }
                    catch (IllegalAccessException ex) {
                        LOG.error((Object)I18N.getLocalMessage("i18n.mityc.api.trust.8", classname));
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)STRING_EMPTY, (Throwable)ex);
                        }
                    }
                    catch (ClassNotFoundException ex) {
                        LOG.error((Object)I18N.getLocalMessage("i18n.mityc.api.trust.8", classname));
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)STRING_EMPTY, (Throwable)ex);
                        }
                    }
                    catch (ClassCastException ex) {
                        LOG.error((Object)I18N.getLocalMessage("i18n.mityc.api.trust.8", classname));
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)STRING_EMPTY, (Throwable)ex);
                        }
                    }
                    catch (NoSuchMethodException ex) {
                        LOG.error((Object)I18N.getLocalMessage("i18n.mityc.api.trust.8", classname));
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)STRING_EMPTY, (Throwable)ex);
                        }
                    }
                    catch (IllegalArgumentException ex) {
                        LOG.error((Object)I18N.getLocalMessage("i18n.mityc.api.trust.8", classname));
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)STRING_EMPTY, (Throwable)ex);
                        }
                    }
                    catch (InvocationTargetException ex) {
                        LOG.error((Object)I18N.getLocalMessage("i18n.mityc.api.trust.8", classname));
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)STRING_EMPTY, (Throwable)ex);
                        }
                    }
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            if (instance == null) {
                instance = TrustFactory.newInstance();
            }
        }
        return instance;
    }

    protected static TrustFactory newInstance() {
        return new TrustFactory();
    }

    public static void setDefault(TrustFactory factory) {
        instance = factory;
    }

    protected String getClassname(String key) {
        String classname = this.props.getProperty(key);
        if (classname == null) {
            LOG.warn((Object)I18N.getLocalMessage("i18n.mityc.api.trust.6", key));
        }
        return classname;
    }

    public TrustAbstract getTruster(String key) {
        TrustAbstract truster;
        block14: {
            String classname;
            truster = null;
            if (instance != null && (classname = this.getClassname(key)) != null && !TRUSTER_PROP_NO_AVALAIBLE.equals(classname.trim().toLowerCase())) {
                try {
                    Method method;
                    Object obj;
                    ClassLoader cl = TrustFactory.getClassLoader();
                    Class<?> classTruster = null;
                    classTruster = cl != null ? cl.loadClass(classname) : Class.forName(classname);
                    if (classTruster != null && (obj = (method = classTruster.getMethod(METHOD_GET_INSTANCE, new Class[0])).invoke(null, new Object[0])) instanceof TrustAbstract) {
                        truster = (TrustAbstract)obj;
                    }
                }
                catch (IllegalAccessException ex) {
                    LOG.error((Object)I18N.getLocalMessage("i18n.mityc.api.trust.3", key, classname));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)STRING_EMPTY, (Throwable)ex);
                    }
                }
                catch (ClassNotFoundException ex) {
                    LOG.error((Object)I18N.getLocalMessage("i18n.mityc.api.trust.4", key, classname));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)STRING_EMPTY, (Throwable)ex);
                    }
                }
                catch (ClassCastException ex) {
                    LOG.error((Object)I18N.getLocalMessage("i18n.mityc.api.trust.5", key, classname));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)STRING_EMPTY, (Throwable)ex);
                    }
                }
                catch (NoSuchMethodException ex) {
                    LOG.error((Object)I18N.getLocalMessage("i18n.mityc.api.trust.6", key, classname));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)STRING_EMPTY, (Throwable)ex);
                    }
                }
                catch (IllegalArgumentException ex) {
                    LOG.error((Object)I18N.getLocalMessage("i18n.mityc.api.trust.3", key, classname));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)STRING_EMPTY, (Throwable)ex);
                    }
                }
                catch (InvocationTargetException ex) {
                    LOG.error((Object)I18N.getLocalMessage("i18n.mityc.api.trust.2", key, classname));
                    if (!LOG.isDebugEnabled()) break block14;
                    LOG.debug((Object)STRING_EMPTY, (Throwable)ex);
                }
            }
        }
        return truster;
    }
}

