/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.libreria.utilidades;

import es.mityc.firmaJava.libreria.utilidades.I18n;
import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UtilidadFirmaElectronica {
    private static final Log LOG;
    private static final II18nManager I18N;
    private static final String POLICY_DNIE_AUTHENTICATE = "2.16.724.1.2.2.2.4";
    private static final String POLICY_DNIE_SIGN = "2.16.724.1.2.2.2.3";
    private static final X509CertSelector CS_DNIE_AUTHENTICATE;
    private static final X509CertSelector CS_DNIE_SIGN;
    public static final String DIGEST_ALG_SHA1 = "http://www.w3.org/2000/09/xmldsig#sha1";
    public static final String DIGEST_ALG_SHA256 = "http://www.w3.org/2001/04/xmldsig-more#sha256";
    public static final String DIGEST_ALG_SHA256_enc = "http://www.w3.org/2001/04/xmlenc#sha256";
    public static final String DIGEST_ALG_SHA256_hmac = "http://www.w3.org/2001/04/xmldsig-more#hmac-sha256";
    public static final String DIGEST_ALG_SHA512 = "http://www.w3.org/2001/04/xmldsig-more#sha512";
    public static final String DIGEST_ALG_SHA512_enc = "http://www.w3.org/2001/04/xmlenc#sha512";
    public static final String DIGEST_ALG_SHA512_hmac = "http://www.w3.org/2001/04/xmldsig-more#hmac-sha512";
    public static final String DIGEST_ALG_SHA224 = "http://www.w3.org/2001/04/xmldsig-more#sha224";
    public static final String DIGEST_ALG_SHA384 = "http://www.w3.org/2001/04/xmldsig-more#sha384";
    public static final String DIGEST_ALG_MD2 = "http://www.w3.org/2001/04/xmldsig-more#md2";
    public static final String DIGEST_ALG_MD4 = "http://www.w3.org/2001/04/xmldsig-more#md4";
    public static final String DIGEST_ALG_MD5 = "http://www.w3.org/2001/04/xmldsig-more#md5";
    public static final String DIGEST_ALG_RIPEMD128 = "http://www.w3.org/2001/04/xmldsig-more#ripemd128";
    public static final String DIGEST_ALG_RIPEMD160 = "http://www.w3.org/2001/04/xmldsig-more#ripemd160";
    public static final String DIGEST_ALG_RIPEMD256 = "http://www.w3.org/2001/04/xmldsig-more#ripemd256";
    public static final String DIGEST_ALG_RIPEMD320 = "http://www.w3.org/2001/04/xmldsig-more#ripemd320";
    public static final String DIGEST_ALG_TIGER = "http://www.w3.org/2001/04/xmldsig-more#tiger";
    public static final String DIGEST_ALG_WHIRLPOOL = "http://www.w3.org/2001/04/xmldsig-more#whirlpool";
    public static final String DIGEST_ALG_GOST3411 = "http://www.w3.org/2001/04/xmldsig-more#gost3411";

    static {
        block2: {
            LOG = LogFactory.getLog(UtilidadFirmaElectronica.class);
            I18N = I18nFactory.getI18nManager((String)"MITyCLibXAdES");
            CS_DNIE_AUTHENTICATE = new X509CertSelector();
            CS_DNIE_SIGN = new X509CertSelector();
            try {
                CS_DNIE_AUTHENTICATE.setPolicy(new HashSet<String>(Arrays.asList(POLICY_DNIE_AUTHENTICATE)));
                CS_DNIE_SIGN.setPolicy(new HashSet<String>(Arrays.asList(POLICY_DNIE_SIGN)));
            }
            catch (IOException ex) {
                LOG.warn((Object)I18N.getLocalMessage("i18n.mityc.xades.utils.2"));
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public static String decodeUTF(byte[] input) {
        int longitud = input.length;
        char[] output = new char[longitud];
        int i = 0;
        int j = 0;
        while (i < longitud) {
            int b = input[i++] & 0xFF;
            switch (b >>> 5) {
                default: {
                    output[j++] = (char)(b & 0x7F);
                    break;
                }
                case 6: {
                    int y = b & 0x1F;
                    int x = input[i++] & 0x3F;
                    output[j++] = (char)(y << 6 | x);
                    break;
                }
                case 7: {
                    if ((b & 0x10) == 0) {
                        throw new RuntimeException("UTF8Decoder does not handle 32-bit characters");
                    }
                    int z = b & 0xF;
                    int y = input[i++] & 0x3F;
                    int x = input[i++] & 0x3F;
                    int asint = z << 12 | y << 6 | x;
                    output[j++] = (char)asint;
                }
            }
        }
        return new String(output, 0, j);
    }

    public static List<X509Certificate> filtraCertificados(List<X509Certificate> listaCertificadosTemp, String emisorDN) {
        String[] allIssuers = emisorDN.split("#");
        ArrayList<X509Certificate> devuelveCertificados = new ArrayList<X509Certificate>();
        Date hoy = new Date();
        int longitudCertificados = listaCertificadosTemp.size();
        int a = 0;
        while (a < longitudCertificados) {
            X509Certificate certTemp = listaCertificadosTemp.get(a);
            int longitudIssuers = allIssuers.length;
            int b = 0;
            while (b < longitudIssuers) {
                if (certTemp.getIssuerDN().toString().indexOf(allIssuers[b]) >= 0) {
                    try {
                        certTemp.checkValidity(hoy);
                    }
                    catch (CertificateExpiredException e) {
                        break;
                    }
                    catch (CertificateNotYetValidException e) {
                        break;
                    }
                    devuelveCertificados.add(certTemp);
                    break;
                }
                ++b;
            }
            ++a;
        }
        return devuelveCertificados;
    }

    public static List<X509Certificate> filtraDNIe(List<X509Certificate> listaCertificadosTemp) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"Filtrando certificados del DNIe...");
        }
        ArrayList<X509Certificate> returnCertificates = new ArrayList<X509Certificate>();
        Date hoy = new Date();
        for (X509Certificate certTemp : listaCertificadosTemp) {
            try {
                certTemp.checkValidity(hoy);
            }
            catch (CertificateExpiredException e) {
                continue;
            }
            catch (CertificateNotYetValidException e) {
                continue;
            }
            if (CS_DNIE_AUTHENTICATE.match(certTemp)) continue;
            returnCertificates.add(certTemp);
        }
        return returnCertificates;
    }

    public static String obtenerTipoReference(String esquema) {
        String tipoEsquema = null;
        if ("http://uri.etsi.org/01903/v1.3.2#".equals(esquema)) {
            tipoEsquema = "http://uri.etsi.org/01903#SignedProperties";
        } else if ("http://uri.etsi.org/01903/v1.2.2#".equals(esquema)) {
            tipoEsquema = "http://uri.etsi.org/01903/v1.2.2#SignedProperties";
        } else if ("http://uri.etsi.org/01903/v1.1.1#".equals(esquema)) {
            tipoEsquema = "http://uri.etsi.org/01903/v1.1.1#SignedProperties";
        } else {
            LOG.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error1"));
            return null;
        }
        return tipoEsquema;
    }

    public static MessageDigest getMessageDigest(String uri) {
        MessageDigest md = null;
        if (uri != null) {
            try {
                if (uri.equals(DIGEST_ALG_SHA1)) {
                    md = MessageDigest.getInstance("SHA-1");
                } else if (uri.equals(DIGEST_ALG_SHA256) || uri.equals(DIGEST_ALG_SHA256_enc) || uri.equals(DIGEST_ALG_SHA256_hmac)) {
                    md = MessageDigest.getInstance("SHA-256");
                } else if (uri.equals(DIGEST_ALG_SHA512) || uri.equals(DIGEST_ALG_SHA512_enc) || uri.equals(DIGEST_ALG_SHA512_hmac)) {
                    md = MessageDigest.getInstance("SHA-512");
                } else if (uri.equals(DIGEST_ALG_SHA224)) {
                    md = MessageDigest.getInstance("SHA-224");
                } else if (uri.equals(DIGEST_ALG_SHA384)) {
                    md = MessageDigest.getInstance("SHA-384");
                } else if (uri.equals(DIGEST_ALG_MD2)) {
                    md = MessageDigest.getInstance("MD2");
                } else if (uri.equals(DIGEST_ALG_MD4)) {
                    md = MessageDigest.getInstance("MD4");
                } else if (uri.equals(DIGEST_ALG_MD5)) {
                    md = MessageDigest.getInstance("MD5");
                } else if (uri.equals(DIGEST_ALG_RIPEMD128)) {
                    md = MessageDigest.getInstance("RIPEDM128");
                } else if (uri.equals(DIGEST_ALG_RIPEMD160)) {
                    md = MessageDigest.getInstance("RIPEMD160");
                } else if (uri.equals(DIGEST_ALG_RIPEMD256)) {
                    md = MessageDigest.getInstance("RIPEMD256");
                } else if (uri.equals(DIGEST_ALG_RIPEMD320)) {
                    md = MessageDigest.getInstance("RIPEMD320");
                } else if (uri.equals(DIGEST_ALG_TIGER)) {
                    md = MessageDigest.getInstance("Tiger");
                } else if (uri.equals(DIGEST_ALG_WHIRLPOOL)) {
                    md = MessageDigest.getInstance("WHIRLPOOL");
                } else if (uri.equals(DIGEST_ALG_GOST3411)) {
                    md = MessageDigest.getInstance("GOST3411");
                }
            }
            catch (NoSuchAlgorithmException ex) {
                LOG.info((Object)("Algoritmo de digest no disponible para: " + uri), (Throwable)ex);
            }
        }
        return md;
    }
}

