/*
 * Decompiled with CFR 0.152.
 */
package adsi.org.apache.xml.security.encryption;

import adsi.org.apache.xml.security.algorithms.JCEMapper;
import adsi.org.apache.xml.security.c14n.Canonicalizer;
import adsi.org.apache.xml.security.c14n.InvalidCanonicalizerException;
import adsi.org.apache.xml.security.encryption.AgreementMethod;
import adsi.org.apache.xml.security.encryption.CipherData;
import adsi.org.apache.xml.security.encryption.CipherReference;
import adsi.org.apache.xml.security.encryption.CipherValue;
import adsi.org.apache.xml.security.encryption.EncryptedData;
import adsi.org.apache.xml.security.encryption.EncryptedKey;
import adsi.org.apache.xml.security.encryption.EncryptionMethod;
import adsi.org.apache.xml.security.encryption.EncryptionProperties;
import adsi.org.apache.xml.security.encryption.EncryptionProperty;
import adsi.org.apache.xml.security.encryption.Reference;
import adsi.org.apache.xml.security.encryption.ReferenceList;
import adsi.org.apache.xml.security.encryption.Transforms;
import adsi.org.apache.xml.security.encryption.XMLCipherInput;
import adsi.org.apache.xml.security.encryption.XMLEncryptionException;
import adsi.org.apache.xml.security.exceptions.XMLSecurityException;
import adsi.org.apache.xml.security.keys.KeyInfo;
import adsi.org.apache.xml.security.keys.keyresolver.KeyResolverException;
import adsi.org.apache.xml.security.keys.keyresolver.implementations.EncryptedKeyResolver;
import adsi.org.apache.xml.security.signature.XMLSignatureException;
import adsi.org.apache.xml.security.transforms.InvalidTransformException;
import adsi.org.apache.xml.security.transforms.TransformationException;
import adsi.org.apache.xml.security.utils.Base64;
import adsi.org.apache.xml.security.utils.ElementProxy;
import adsi.org.apache.xml.security.utils.XMLUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.utils.URI;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLCipher {
    private static Log logger = LogFactory.getLog((String)XMLCipher.class.getName());
    public static final String TRIPLEDES = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
    public static final String AES_128 = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
    public static final String AES_256 = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
    public static final String AES_192 = "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
    public static final String RSA_v1dot5 = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
    public static final String RSA_OAEP = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
    public static final String DIFFIE_HELLMAN = "http://www.w3.org/2001/04/xmlenc#dh";
    public static final String TRIPLEDES_KeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
    public static final String AES_128_KeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes128";
    public static final String AES_256_KeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes256";
    public static final String AES_192_KeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes192";
    public static final String SHA1 = "http://www.w3.org/2000/09/xmldsig#sha1";
    public static final String SHA256 = "http://www.w3.org/2001/04/xmlenc#sha256";
    public static final String SHA512 = "http://www.w3.org/2001/04/xmlenc#sha512";
    public static final String RIPEMD_160 = "http://www.w3.org/2001/04/xmlenc#ripemd160";
    public static final String XML_DSIG = "http://www.w3.org/2000/09/xmldsig#";
    public static final String N14C_XML = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    public static final String N14C_XML_WITH_COMMENTS = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments";
    public static final String EXCL_XML_N14C = "http://www.w3.org/2001/10/xml-exc-c14n#";
    public static final String EXCL_XML_N14C_WITH_COMMENTS = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";
    public static final String BASE64_ENCODING = "http://www.w3.org/2000/09/xmldsig#base64";
    public static final int ENCRYPT_MODE = 1;
    public static final int DECRYPT_MODE = 2;
    public static final int UNWRAP_MODE = 4;
    public static final int WRAP_MODE = 3;
    private static final String ENC_ALGORITHMS = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc\nhttp://www.w3.org/2001/04/xmlenc#aes128-cbc\nhttp://www.w3.org/2001/04/xmlenc#aes256-cbc\nhttp://www.w3.org/2001/04/xmlenc#aes192-cbc\nhttp://www.w3.org/2001/04/xmlenc#rsa-1_5\nhttp://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p\nhttp://www.w3.org/2001/04/xmlenc#kw-tripledes\nhttp://www.w3.org/2001/04/xmlenc#kw-aes128\nhttp://www.w3.org/2001/04/xmlenc#kw-aes256\nhttp://www.w3.org/2001/04/xmlenc#kw-aes192\n";
    private Cipher _contextCipher;
    private int _cipherMode = Integer.MIN_VALUE;
    private String _algorithm = null;
    private String _requestedJCEProvider = null;
    private Canonicalizer _canon;
    private Document _contextDocument;
    private Factory _factory;
    private Serializer _serializer;
    private Key _key;
    private Key _kek;
    private EncryptedKey _ek;
    private EncryptedData _ed;

    private XMLCipher() {
        logger.debug((Object)"Constructing XMLCipher...");
        this._factory = new Factory();
        this._serializer = new Serializer();
    }

    private static boolean isValidEncryptionAlgorithm(String algorithm) {
        boolean result = algorithm.equals(TRIPLEDES) || algorithm.equals(AES_128) || algorithm.equals(AES_256) || algorithm.equals(AES_192) || algorithm.equals(RSA_v1dot5) || algorithm.equals(RSA_OAEP) || algorithm.equals(TRIPLEDES_KeyWrap) || algorithm.equals(AES_128_KeyWrap) || algorithm.equals(AES_256_KeyWrap) || algorithm.equals(AES_192_KeyWrap);
        return result;
    }

    public static XMLCipher getInstance(String transformation) throws XMLEncryptionException {
        logger.debug((Object)"Getting XMLCipher...");
        if (transformation == null) {
            logger.error((Object)"Transformation unexpectedly null...");
        }
        if (!XMLCipher.isValidEncryptionAlgorithm(transformation)) {
            logger.warn((Object)"Algorithm non-standard, expected one of http://www.w3.org/2001/04/xmlenc#tripledes-cbc\nhttp://www.w3.org/2001/04/xmlenc#aes128-cbc\nhttp://www.w3.org/2001/04/xmlenc#aes256-cbc\nhttp://www.w3.org/2001/04/xmlenc#aes192-cbc\nhttp://www.w3.org/2001/04/xmlenc#rsa-1_5\nhttp://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p\nhttp://www.w3.org/2001/04/xmlenc#kw-tripledes\nhttp://www.w3.org/2001/04/xmlenc#kw-aes128\nhttp://www.w3.org/2001/04/xmlenc#kw-aes256\nhttp://www.w3.org/2001/04/xmlenc#kw-aes192\n");
        }
        XMLCipher instance = new XMLCipher();
        instance._algorithm = transformation;
        instance._key = null;
        instance._kek = null;
        try {
            instance._canon = Canonicalizer.getInstance(N14C_XML_WITH_COMMENTS);
        }
        catch (InvalidCanonicalizerException ice) {
            throw new XMLEncryptionException("empty", ice);
        }
        String jceAlgorithm = JCEMapper.translateURItoJCEID(transformation);
        try {
            instance._contextCipher = Cipher.getInstance(jceAlgorithm);
            logger.debug((Object)("cihper.algoritm = " + instance._contextCipher.getAlgorithm()));
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new XMLEncryptionException("empty", nsae);
        }
        catch (NoSuchPaddingException nspe) {
            throw new XMLEncryptionException("empty", nspe);
        }
        return instance;
    }

    public static XMLCipher getInstance(String transformation, String canon) throws XMLEncryptionException {
        XMLCipher instance = XMLCipher.getInstance(transformation);
        if (canon != null) {
            try {
                instance._canon = Canonicalizer.getInstance(canon);
            }
            catch (InvalidCanonicalizerException ice) {
                throw new XMLEncryptionException("empty", ice);
            }
        }
        return instance;
    }

    public static XMLCipher getProviderInstance(String transformation, String provider) throws XMLEncryptionException {
        logger.debug((Object)"Getting XMLCipher...");
        if (transformation == null) {
            logger.error((Object)"Transformation unexpectedly null...");
        }
        if (provider == null) {
            logger.error((Object)"Provider unexpectedly null..");
        }
        if ("" == provider) {
            logger.error((Object)"Provider's value unexpectedly not specified...");
        }
        if (!XMLCipher.isValidEncryptionAlgorithm(transformation)) {
            logger.warn((Object)"Algorithm non-standard, expected one of http://www.w3.org/2001/04/xmlenc#tripledes-cbc\nhttp://www.w3.org/2001/04/xmlenc#aes128-cbc\nhttp://www.w3.org/2001/04/xmlenc#aes256-cbc\nhttp://www.w3.org/2001/04/xmlenc#aes192-cbc\nhttp://www.w3.org/2001/04/xmlenc#rsa-1_5\nhttp://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p\nhttp://www.w3.org/2001/04/xmlenc#kw-tripledes\nhttp://www.w3.org/2001/04/xmlenc#kw-aes128\nhttp://www.w3.org/2001/04/xmlenc#kw-aes256\nhttp://www.w3.org/2001/04/xmlenc#kw-aes192\n");
        }
        XMLCipher instance = new XMLCipher();
        instance._algorithm = transformation;
        instance._requestedJCEProvider = provider;
        instance._key = null;
        instance._kek = null;
        try {
            instance._canon = Canonicalizer.getInstance(N14C_XML_WITH_COMMENTS);
        }
        catch (InvalidCanonicalizerException ice) {
            throw new XMLEncryptionException("empty", ice);
        }
        try {
            String jceAlgorithm = JCEMapper.translateURItoJCEID(transformation);
            instance._contextCipher = Cipher.getInstance(jceAlgorithm, provider);
            logger.debug((Object)("cipher._algorithm = " + instance._contextCipher.getAlgorithm()));
            logger.debug((Object)("provider.name = " + provider));
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new XMLEncryptionException("empty", nsae);
        }
        catch (NoSuchProviderException nspre) {
            throw new XMLEncryptionException("empty", nspre);
        }
        catch (NoSuchPaddingException nspe) {
            throw new XMLEncryptionException("empty", nspe);
        }
        return instance;
    }

    public static XMLCipher getProviderInstance(String transformation, String provider, String canon) throws XMLEncryptionException {
        XMLCipher instance = XMLCipher.getProviderInstance(transformation, provider);
        if (canon != null) {
            try {
                instance._canon = Canonicalizer.getInstance(canon);
            }
            catch (InvalidCanonicalizerException ice) {
                throw new XMLEncryptionException("empty", ice);
            }
        }
        return instance;
    }

    public static XMLCipher getInstance() throws XMLEncryptionException {
        logger.debug((Object)"Getting XMLCipher for no transformation...");
        XMLCipher instance = new XMLCipher();
        instance._algorithm = null;
        instance._requestedJCEProvider = null;
        instance._key = null;
        instance._kek = null;
        instance._contextCipher = null;
        try {
            instance._canon = Canonicalizer.getInstance(N14C_XML_WITH_COMMENTS);
        }
        catch (InvalidCanonicalizerException ice) {
            throw new XMLEncryptionException("empty", ice);
        }
        return instance;
    }

    public static XMLCipher getProviderInstance(String provider) throws XMLEncryptionException {
        logger.debug((Object)"Getting XMLCipher, provider but no transformation");
        if (provider == null) {
            logger.error((Object)"Provider unexpectedly null..");
        }
        if ("" == provider) {
            logger.error((Object)"Provider's value unexpectedly not specified...");
        }
        XMLCipher instance = new XMLCipher();
        instance._algorithm = null;
        instance._requestedJCEProvider = provider;
        instance._key = null;
        instance._kek = null;
        instance._contextCipher = null;
        try {
            instance._canon = Canonicalizer.getInstance(N14C_XML_WITH_COMMENTS);
        }
        catch (InvalidCanonicalizerException ice) {
            throw new XMLEncryptionException("empty", ice);
        }
        return instance;
    }

    public void init(int opmode, Key key) throws XMLEncryptionException {
        logger.debug((Object)"Initializing XMLCipher...");
        this._ek = null;
        this._ed = null;
        switch (opmode) {
            case 1: {
                logger.debug((Object)"opmode = ENCRYPT_MODE");
                this._ed = this.createEncryptedData(1, "NO VALUE YET");
                break;
            }
            case 2: {
                logger.debug((Object)"opmode = DECRYPT_MODE");
                break;
            }
            case 3: {
                logger.debug((Object)"opmode = WRAP_MODE");
                this._ek = this.createEncryptedKey(1, "NO VALUE YET");
                break;
            }
            case 4: {
                logger.debug((Object)"opmode = UNWRAP_MODE");
                break;
            }
            default: {
                logger.error((Object)"Mode unexpectedly invalid");
                throw new XMLEncryptionException("Invalid mode in init");
            }
        }
        this._cipherMode = opmode;
        this._key = key;
    }

    public EncryptedData getEncryptedData() {
        logger.debug((Object)"Returning EncryptedData");
        return this._ed;
    }

    public EncryptedKey getEncryptedKey() {
        logger.debug((Object)"Returning EncryptedKey");
        return this._ek;
    }

    public void setKEK(Key kek) {
        this._kek = kek;
    }

    public Element martial(EncryptedData encryptedData) {
        return this._factory.toElement(encryptedData);
    }

    public Element martial(EncryptedKey encryptedKey) {
        return this._factory.toElement(encryptedKey);
    }

    public Element martial(Document context, EncryptedData encryptedData) {
        this._contextDocument = context;
        return this._factory.toElement(encryptedData);
    }

    public Element martial(Document context, EncryptedKey encryptedKey) {
        this._contextDocument = context;
        return this._factory.toElement(encryptedKey);
    }

    private Document encryptElement(Element element) throws Exception {
        logger.debug((Object)"Encrypting element...");
        if (element == null) {
            logger.error((Object)"Element unexpectedly null...");
        }
        if (this._cipherMode != 1) {
            logger.debug((Object)"XMLCipher unexpectedly not in ENCRYPT_MODE...");
        }
        if (this._algorithm == null) {
            throw new XMLEncryptionException("XMLCipher instance without transformation specified");
        }
        this.encryptData(this._contextDocument, element, false);
        Element encryptedElement = this._factory.toElement(this._ed);
        Node sourceParent = element.getParentNode();
        sourceParent.replaceChild(encryptedElement, element);
        return this._contextDocument;
    }

    private Document encryptElementContent(Element element) throws Exception {
        logger.debug((Object)"Encrypting element content...");
        if (element == null) {
            logger.error((Object)"Element unexpectedly null...");
        }
        if (this._cipherMode != 1) {
            logger.debug((Object)"XMLCipher unexpectedly not in ENCRYPT_MODE...");
        }
        if (this._algorithm == null) {
            throw new XMLEncryptionException("XMLCipher instance without transformation specified");
        }
        this.encryptData(this._contextDocument, element, true);
        Element encryptedElement = this._factory.toElement(this._ed);
        XMLCipher.removeContent(element);
        element.appendChild(encryptedElement);
        return this._contextDocument;
    }

    public Document doFinal(Document context, Document source) throws Exception {
        logger.debug((Object)"Processing source document...");
        if (context == null) {
            logger.error((Object)"Context document unexpectedly null...");
        }
        if (source == null) {
            logger.error((Object)"Source document unexpectedly null...");
        }
        this._contextDocument = context;
        Document result = null;
        switch (this._cipherMode) {
            case 2: {
                result = this.decryptElement(source.getDocumentElement());
                break;
            }
            case 1: {
                result = this.encryptElement(source.getDocumentElement());
                break;
            }
            case 4: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new XMLEncryptionException("empty", new IllegalStateException());
            }
        }
        return result;
    }

    public Document doFinal(Document context, Element element) throws Exception {
        logger.debug((Object)"Processing source element...");
        if (context == null) {
            logger.error((Object)"Context document unexpectedly null...");
        }
        if (element == null) {
            logger.error((Object)"Source element unexpectedly null...");
        }
        this._contextDocument = context;
        Document result = null;
        switch (this._cipherMode) {
            case 2: {
                result = this.decryptElement(element);
                break;
            }
            case 1: {
                result = this.encryptElement(element);
                break;
            }
            case 4: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new XMLEncryptionException("empty", new IllegalStateException());
            }
        }
        return result;
    }

    public Document doFinal(Document context, Element element, boolean content) throws Exception {
        logger.debug((Object)"Processing source element...");
        if (context == null) {
            logger.error((Object)"Context document unexpectedly null...");
        }
        if (element == null) {
            logger.error((Object)"Source element unexpectedly null...");
        }
        this._contextDocument = context;
        Document result = null;
        switch (this._cipherMode) {
            case 2: {
                if (content) {
                    result = this.decryptElementContent(element);
                    break;
                }
                result = this.decryptElement(element);
                break;
            }
            case 1: {
                if (content) {
                    result = this.encryptElementContent(element);
                    break;
                }
                result = this.encryptElement(element);
                break;
            }
            case 4: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new XMLEncryptionException("empty", new IllegalStateException());
            }
        }
        return result;
    }

    public EncryptedData encryptData(Document context, Element element) throws Exception {
        return this.encryptData(context, element, false);
    }

    public EncryptedData encryptData(Document context, String type, InputStream serializedData) throws Exception {
        logger.debug((Object)"Encrypting element...");
        if (context == null) {
            logger.error((Object)"Context document unexpectedly null...");
        }
        if (serializedData == null) {
            logger.error((Object)"Serialized data unexpectedly null...");
        }
        if (this._cipherMode != 1) {
            logger.debug((Object)"XMLCipher unexpectedly not in ENCRYPT_MODE...");
        }
        return this.encryptData(context, null, type, serializedData);
    }

    public EncryptedData encryptData(Document context, Element element, boolean contentMode) throws Exception {
        logger.debug((Object)"Encrypting element...");
        if (context == null) {
            logger.error((Object)"Context document unexpectedly null...");
        }
        if (element == null) {
            logger.error((Object)"Element unexpectedly null...");
        }
        if (this._cipherMode != 1) {
            logger.debug((Object)"XMLCipher unexpectedly not in ENCRYPT_MODE...");
        }
        if (contentMode) {
            return this.encryptData(context, element, "http://www.w3.org/2001/04/xmlenc#Content", null);
        }
        return this.encryptData(context, element, "http://www.w3.org/2001/04/xmlenc#Element", null);
    }

    /*
     * Unable to fully structure code
     */
    private EncryptedData encryptData(Document context, Element element, String type, InputStream serializedData) throws Exception {
        block23: {
            this._contextDocument = context;
            if (this._algorithm == null) {
                throw new XMLEncryptionException("XMLCipher instance without transformation specified");
            }
            serializedOctets = null;
            if (serializedData != null) break block23;
            if (type != "http://www.w3.org/2001/04/xmlenc#Content") ** GOTO lbl13
            children = element.getChildNodes();
            if (children != null) {
                serializedOctets = this._serializer.serialize(children);
            } else {
                exArgs = new Object[]{"Element has no content."};
                throw new XMLEncryptionException("empty", exArgs);
lbl13:
                // 1 sources

                serializedOctets = this._serializer.serialize(element);
            }
            XMLCipher.logger.debug((Object)("Serialized octets:\n" + serializedOctets));
        }
        encryptedBytes = null;
        if (this._contextCipher == null) {
            jceAlgorithm = JCEMapper.translateURItoJCEID(this._algorithm);
            XMLCipher.logger.debug((Object)("alg = " + jceAlgorithm));
            try {
                if (this._requestedJCEProvider == null) {
                    c = Cipher.getInstance(jceAlgorithm);
                }
                c = Cipher.getInstance(jceAlgorithm, this._requestedJCEProvider);
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new XMLEncryptionException("empty", nsae);
            }
            catch (NoSuchProviderException nspre) {
                throw new XMLEncryptionException("empty", nspre);
            }
            catch (NoSuchPaddingException nspae) {
                throw new XMLEncryptionException("empty", nspae);
            }
        } else {
            c = this._contextCipher;
        }
        try {
            c.init(this._cipherMode, this._key);
        }
        catch (InvalidKeyException ike) {
            throw new XMLEncryptionException("empty", ike);
        }
        try {
            if (serializedData != null) {
                buf = new byte[8192];
                baos = new ByteArrayOutputStream();
                while ((numBytes = serializedData.read(buf)) != -1) {
                    data = c.update(buf, 0, numBytes);
                    baos.write(data);
                }
                baos.write(c.doFinal());
                encryptedBytes = baos.toByteArray();
            } else {
                encryptedBytes = c.doFinal(serializedOctets.getBytes("UTF-8"));
                XMLCipher.logger.debug((Object)("Expected cipher.outputSize = " + Integer.toString(c.getOutputSize(serializedOctets.getBytes().length))));
            }
            XMLCipher.logger.debug((Object)("Actual cipher.outputSize = " + Integer.toString(encryptedBytes.length)));
        }
        catch (IllegalStateException ise) {
            throw new XMLEncryptionException("empty", ise);
        }
        catch (IllegalBlockSizeException ibse) {
            throw new XMLEncryptionException("empty", ibse);
        }
        catch (BadPaddingException bpe) {
            throw new XMLEncryptionException("empty", bpe);
        }
        catch (UnsupportedEncodingException uee) {
            throw new XMLEncryptionException("empty", uee);
        }
        iv = c.getIV();
        finalEncryptedBytes = new byte[iv.length + encryptedBytes.length];
        System.arraycopy(iv, 0, finalEncryptedBytes, 0, iv.length);
        System.arraycopy(encryptedBytes, 0, finalEncryptedBytes, iv.length, encryptedBytes.length);
        base64EncodedEncryptedOctets = Base64.encode(finalEncryptedBytes);
        XMLCipher.logger.debug((Object)("Encrypted octets:\n" + base64EncodedEncryptedOctets));
        XMLCipher.logger.debug((Object)("Encrypted octets length = " + base64EncodedEncryptedOctets.length()));
        try {
            cd = this._ed.getCipherData();
            cv = cd.getCipherValue();
            cv.setValue(base64EncodedEncryptedOctets);
            if (type != null) {
                this._ed.setType(new URI(type).toString());
            }
            method = this._factory.newEncryptionMethod(new URI(this._algorithm).toString());
            this._ed.setEncryptionMethod(method);
        }
        catch (URI.MalformedURIException mfue) {
            throw new XMLEncryptionException("empty", (Exception)mfue);
        }
        return this._ed;
    }

    public EncryptedData loadEncryptedData(Document context, Element element) throws XMLEncryptionException {
        logger.debug((Object)"Loading encrypted element...");
        if (context == null) {
            logger.error((Object)"Context document unexpectedly null...");
        }
        if (element == null) {
            logger.error((Object)"Element unexpectedly null...");
        }
        if (this._cipherMode != 2) {
            logger.error((Object)"XMLCipher unexpectedly not in DECRYPT_MODE...");
        }
        this._contextDocument = context;
        this._ed = this._factory.newEncryptedData(element);
        return this._ed;
    }

    public EncryptedKey loadEncryptedKey(Document context, Element element) throws XMLEncryptionException {
        logger.debug((Object)"Loading encrypted key...");
        if (context == null) {
            logger.error((Object)"Context document unexpectedly null...");
        }
        if (element == null) {
            logger.error((Object)"Element unexpectedly null...");
        }
        if (this._cipherMode != 4 && this._cipherMode != 2) {
            logger.debug((Object)"XMLCipher unexpectedly not in UNWRAP_MODE or DECRYPT_MODE...");
        }
        this._contextDocument = context;
        this._ek = this._factory.newEncryptedKey(element);
        return this._ek;
    }

    public EncryptedKey loadEncryptedKey(Element element) throws XMLEncryptionException {
        return this.loadEncryptedKey(element.getOwnerDocument(), element);
    }

    public EncryptedKey encryptKey(Document doc, Key key) throws XMLEncryptionException {
        Cipher c;
        logger.debug((Object)"Encrypting key ...");
        if (key == null) {
            logger.error((Object)"Key unexpectedly null...");
        }
        if (this._cipherMode != 3) {
            logger.debug((Object)"XMLCipher unexpectedly not in WRAP_MODE...");
        }
        if (this._algorithm == null) {
            throw new XMLEncryptionException("XMLCipher instance without transformation specified");
        }
        this._contextDocument = doc;
        byte[] encryptedBytes = null;
        if (this._contextCipher == null) {
            String jceAlgorithm = JCEMapper.translateURItoJCEID(this._algorithm);
            logger.debug((Object)("alg = " + jceAlgorithm));
            try {
                if (this._requestedJCEProvider == null) {
                    c = Cipher.getInstance(jceAlgorithm);
                }
                c = Cipher.getInstance(jceAlgorithm, this._requestedJCEProvider);
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new XMLEncryptionException("empty", nsae);
            }
            catch (NoSuchProviderException nspre) {
                throw new XMLEncryptionException("empty", nspre);
            }
            catch (NoSuchPaddingException nspae) {
                throw new XMLEncryptionException("empty", nspae);
            }
        } else {
            c = this._contextCipher;
        }
        try {
            c.init(3, this._key);
            encryptedBytes = c.wrap(key);
        }
        catch (InvalidKeyException ike) {
            throw new XMLEncryptionException("empty", ike);
        }
        catch (IllegalBlockSizeException ibse) {
            throw new XMLEncryptionException("empty", ibse);
        }
        String base64EncodedEncryptedOctets = Base64.encode(encryptedBytes);
        logger.debug((Object)("Encrypted key octets:\n" + base64EncodedEncryptedOctets));
        logger.debug((Object)("Encrypted key octets length = " + base64EncodedEncryptedOctets.length()));
        CipherValue cv = this._ek.getCipherData().getCipherValue();
        cv.setValue(base64EncodedEncryptedOctets);
        try {
            EncryptionMethod method = this._factory.newEncryptionMethod(new URI(this._algorithm).toString());
            this._ek.setEncryptionMethod(method);
        }
        catch (URI.MalformedURIException mfue) {
            throw new XMLEncryptionException("empty", (Exception)((Object)mfue));
        }
        return this._ek;
    }

    public Key decryptKey(EncryptedKey encryptedKey, String algorithm) throws XMLEncryptionException {
        Key ret;
        Cipher c;
        logger.debug((Object)"Decrypting key from previously loaded EncryptedKey...");
        if (this._cipherMode != 4) {
            logger.debug((Object)"XMLCipher unexpectedly not in UNWRAP_MODE...");
        }
        if (algorithm == null) {
            throw new XMLEncryptionException("Cannot decrypt a key without knowing the algorithm");
        }
        if (this._key == null) {
            logger.debug((Object)"Trying to find a KEK via key resolvers");
            KeyInfo ki = encryptedKey.getKeyInfo();
            if (ki != null) {
                try {
                    this._key = ki.getSecretKey();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this._key == null) {
                logger.error((Object)"XMLCipher::decryptKey called without a KEK and cannot resolve");
                throw new XMLEncryptionException("Unable to decrypt without a KEK");
            }
        }
        XMLCipherInput cipherInput = new XMLCipherInput(encryptedKey);
        byte[] encryptedBytes = cipherInput.getBytes();
        String jceKeyAlgorithm = JCEMapper.getJCEKeyAlgorithmFromURI(algorithm);
        if (this._contextCipher == null) {
            String jceAlgorithm = JCEMapper.translateURItoJCEID(encryptedKey.getEncryptionMethod().getAlgorithm());
            logger.debug((Object)("JCE Algorithm = " + jceAlgorithm));
            try {
                if (this._requestedJCEProvider == null) {
                    c = Cipher.getInstance(jceAlgorithm);
                }
                c = Cipher.getInstance(jceAlgorithm, this._requestedJCEProvider);
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new XMLEncryptionException("empty", nsae);
            }
            catch (NoSuchProviderException nspre) {
                throw new XMLEncryptionException("empty", nspre);
            }
            catch (NoSuchPaddingException nspae) {
                throw new XMLEncryptionException("empty", nspae);
            }
        } else {
            c = this._contextCipher;
        }
        try {
            c.init(4, this._key);
            ret = c.unwrap(encryptedBytes, jceKeyAlgorithm, 3);
        }
        catch (InvalidKeyException ike) {
            throw new XMLEncryptionException("empty", ike);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new XMLEncryptionException("empty", nsae);
        }
        logger.debug((Object)("Decryption of key type " + algorithm + " OK"));
        return ret;
    }

    public Key decryptKey(EncryptedKey encryptedKey) throws XMLEncryptionException {
        return this.decryptKey(encryptedKey, this._ed.getEncryptionMethod().getAlgorithm());
    }

    private static void removeContent(Node node) {
        while (node.hasChildNodes()) {
            node.removeChild(node.getFirstChild());
        }
    }

    private Document decryptElement(Element element) throws XMLEncryptionException {
        String octets;
        logger.debug((Object)"Decrypting element...");
        if (this._cipherMode != 2) {
            logger.error((Object)"XMLCipher unexpectedly not in DECRYPT_MODE...");
        }
        try {
            octets = new String(this.decryptToByteArray(element), "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new XMLEncryptionException("empty", uee);
        }
        logger.debug((Object)("Decrypted octets:\n" + octets));
        Node sourceParent = element.getParentNode();
        DocumentFragment decryptedFragment = this._serializer.deserialize(octets, sourceParent);
        if (sourceParent instanceof Document) {
            this._contextDocument.removeChild(this._contextDocument.getDocumentElement());
            this._contextDocument.appendChild(decryptedFragment);
        } else {
            sourceParent.replaceChild(decryptedFragment, element);
        }
        return this._contextDocument;
    }

    private Document decryptElementContent(Element element) throws XMLEncryptionException {
        Element e = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedData").item(0);
        if (e == null) {
            throw new XMLEncryptionException("No EncryptedData child element.");
        }
        return this.decryptElement(e);
    }

    public byte[] decryptToByteArray(Element element) throws XMLEncryptionException {
        byte[] plainBytes;
        Cipher c;
        logger.debug((Object)"Decrypting to ByteArray...");
        if (this._cipherMode != 2) {
            logger.error((Object)"XMLCipher unexpectedly not in DECRYPT_MODE...");
        }
        EncryptedData encryptedData = this._factory.newEncryptedData(element);
        if (this._key == null) {
            KeyInfo ki = encryptedData.getKeyInfo();
            if (ki != null) {
                try {
                    ki.registerInternalKeyResolver(new EncryptedKeyResolver(encryptedData.getEncryptionMethod().getAlgorithm(), this._kek));
                    this._key = ki.getSecretKey();
                }
                catch (KeyResolverException keyResolverException) {
                    // empty catch block
                }
            }
            if (this._key == null) {
                logger.error((Object)"XMLCipher::decryptElement called without a key and unable to resolve");
                throw new XMLEncryptionException("encryption.nokey");
            }
        }
        XMLCipherInput cipherInput = new XMLCipherInput(encryptedData);
        byte[] encryptedBytes = cipherInput.getBytes();
        String jceAlgorithm = JCEMapper.translateURItoJCEID(encryptedData.getEncryptionMethod().getAlgorithm());
        try {
            c = this._requestedJCEProvider == null ? Cipher.getInstance(jceAlgorithm) : Cipher.getInstance(jceAlgorithm, this._requestedJCEProvider);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new XMLEncryptionException("empty", nsae);
        }
        catch (NoSuchProviderException nspre) {
            throw new XMLEncryptionException("empty", nspre);
        }
        catch (NoSuchPaddingException nspae) {
            throw new XMLEncryptionException("empty", nspae);
        }
        int ivLen = c.getBlockSize();
        byte[] ivBytes = new byte[ivLen];
        System.arraycopy(encryptedBytes, 0, ivBytes, 0, ivLen);
        IvParameterSpec iv = new IvParameterSpec(ivBytes);
        try {
            c.init(this._cipherMode, this._key, iv);
        }
        catch (InvalidKeyException ike) {
            throw new XMLEncryptionException("empty", ike);
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new XMLEncryptionException("empty", iape);
        }
        try {
            plainBytes = c.doFinal(encryptedBytes, ivLen, encryptedBytes.length - ivLen);
        }
        catch (IllegalBlockSizeException ibse) {
            throw new XMLEncryptionException("empty", ibse);
        }
        catch (BadPaddingException bpe) {
            throw new XMLEncryptionException("empty", bpe);
        }
        return plainBytes;
    }

    public EncryptedData createEncryptedData(int type, String value) throws XMLEncryptionException {
        EncryptedData result = null;
        CipherData data = null;
        switch (type) {
            case 2: {
                CipherReference cipherReference = this._factory.newCipherReference(value);
                data = this._factory.newCipherData(type);
                data.setCipherReference(cipherReference);
                result = this._factory.newEncryptedData(data);
                break;
            }
            case 1: {
                CipherValue cipherValue = this._factory.newCipherValue(value);
                data = this._factory.newCipherData(type);
                data.setCipherValue(cipherValue);
                result = this._factory.newEncryptedData(data);
            }
        }
        return result;
    }

    public EncryptedKey createEncryptedKey(int type, String value) throws XMLEncryptionException {
        EncryptedKey result = null;
        CipherData data = null;
        switch (type) {
            case 2: {
                CipherReference cipherReference = this._factory.newCipherReference(value);
                data = this._factory.newCipherData(type);
                data.setCipherReference(cipherReference);
                result = this._factory.newEncryptedKey(data);
                break;
            }
            case 1: {
                CipherValue cipherValue = this._factory.newCipherValue(value);
                data = this._factory.newCipherData(type);
                data.setCipherValue(cipherValue);
                result = this._factory.newEncryptedKey(data);
            }
        }
        return result;
    }

    public AgreementMethod createAgreementMethod(String algorithm) {
        return this._factory.newAgreementMethod(algorithm);
    }

    public CipherData createCipherData(int type) {
        return this._factory.newCipherData(type);
    }

    public CipherReference createCipherReference(String uri) {
        return this._factory.newCipherReference(uri);
    }

    public CipherValue createCipherValue(String value) {
        return this._factory.newCipherValue(value);
    }

    public EncryptionMethod createEncryptionMethod(String algorithm) {
        return this._factory.newEncryptionMethod(algorithm);
    }

    public EncryptionProperties createEncryptionProperties() {
        return this._factory.newEncryptionProperties();
    }

    public EncryptionProperty createEncryptionProperty() {
        return this._factory.newEncryptionProperty();
    }

    public ReferenceList createReferenceList(int type) {
        return this._factory.newReferenceList(type);
    }

    public Transforms createTransforms() {
        return this._factory.newTransforms();
    }

    public Transforms createTransforms(Document doc) {
        return this._factory.newTransforms(doc);
    }

    private class Factory {
        private Factory() {
        }

        AgreementMethod newAgreementMethod(String algorithm) {
            return new AgreementMethodImpl(algorithm);
        }

        CipherData newCipherData(int type) {
            return new CipherDataImpl(type);
        }

        CipherReference newCipherReference(String uri) {
            return new CipherReferenceImpl(uri);
        }

        CipherValue newCipherValue(String value) {
            return new CipherValueImpl(value);
        }

        EncryptedData newEncryptedData(CipherData data) {
            return new EncryptedDataImpl(data);
        }

        EncryptedKey newEncryptedKey(CipherData data) {
            return new EncryptedKeyImpl(data);
        }

        EncryptionMethod newEncryptionMethod(String algorithm) {
            return new EncryptionMethodImpl(algorithm);
        }

        EncryptionProperties newEncryptionProperties() {
            return new EncryptionPropertiesImpl();
        }

        EncryptionProperty newEncryptionProperty() {
            return new EncryptionPropertyImpl();
        }

        ReferenceList newReferenceList(int type) {
            return new ReferenceListImpl(type);
        }

        Transforms newTransforms() {
            return new TransformsImpl();
        }

        Transforms newTransforms(Document doc) {
            return new TransformsImpl(doc);
        }

        AgreementMethod newAgreementMethod(Element element) throws XMLEncryptionException {
            Element recipientKeyInfoElement;
            Element originatorKeyInfoElement;
            if (element == null) {
                throw new NullPointerException("element is null");
            }
            String algorithm = element.getAttributeNS(null, "Algorithm");
            AgreementMethod result = this.newAgreementMethod(algorithm);
            Element kaNonceElement = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "KA-Nonce").item(0);
            if (kaNonceElement != null) {
                result.setKANonce(kaNonceElement.getNodeValue().getBytes());
            }
            if ((originatorKeyInfoElement = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "OriginatorKeyInfo").item(0)) != null) {
                try {
                    result.setOriginatorKeyInfo(new KeyInfo(originatorKeyInfoElement, null));
                }
                catch (XMLSecurityException xse) {
                    throw new XMLEncryptionException("empty", xse);
                }
            }
            if ((recipientKeyInfoElement = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "RecipientKeyInfo").item(0)) != null) {
                try {
                    result.setRecipientKeyInfo(new KeyInfo(recipientKeyInfoElement, null));
                }
                catch (XMLSecurityException xse) {
                    throw new XMLEncryptionException("empty", xse);
                }
            }
            return result;
        }

        CipherData newCipherData(Element element) throws XMLEncryptionException {
            if (element == null) {
                throw new NullPointerException("element is null");
            }
            int type = 0;
            Element e = null;
            if (element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherValue").getLength() > 0) {
                type = 1;
                e = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherValue").item(0);
            } else if (element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherReference").getLength() > 0) {
                type = 2;
                e = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherReference").item(0);
            }
            CipherData result = this.newCipherData(type);
            if (type == 1) {
                result.setCipherValue(this.newCipherValue(e));
            } else if (type == 2) {
                result.setCipherReference(this.newCipherReference(e));
            }
            return result;
        }

        CipherReference newCipherReference(Element element) throws XMLEncryptionException {
            Attr URIAttr = element.getAttributeNodeNS(null, "URI");
            CipherReferenceImpl result = new CipherReferenceImpl(URIAttr);
            NodeList transformsElements = element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "Transforms");
            Element transformsElement = (Element)transformsElements.item(0);
            if (transformsElement != null) {
                logger.debug((Object)"Creating a DSIG based Transforms element");
                try {
                    result.setTransforms(new TransformsImpl(transformsElement));
                }
                catch (XMLSignatureException xse) {
                    throw new XMLEncryptionException("empty", xse);
                }
                catch (InvalidTransformException ite) {
                    throw new XMLEncryptionException("empty", ite);
                }
                catch (XMLSecurityException xse) {
                    throw new XMLEncryptionException("empty", xse);
                }
            }
            return result;
        }

        CipherValue newCipherValue(Element element) {
            String value = XMLUtils.getFullTextChildrenFromElement(element);
            CipherValue result = this.newCipherValue(value);
            return result;
        }

        EncryptedData newEncryptedData(Element element) throws XMLEncryptionException {
            Element encryptionPropertiesElement;
            Element keyInfoElement;
            EncryptedData result = null;
            NodeList dataElements = element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherData");
            Element dataElement = (Element)dataElements.item(dataElements.getLength() - 1);
            CipherData data = this.newCipherData(dataElement);
            result = this.newEncryptedData(data);
            result.setId(element.getAttributeNS(null, "Id"));
            result.setType(element.getAttributeNS(null, "Type"));
            result.setMimeType(element.getAttributeNS(null, "MimeType"));
            result.setEncoding(element.getAttributeNS(null, "Encoding"));
            Element encryptionMethodElement = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptionMethod").item(0);
            if (encryptionMethodElement != null) {
                result.setEncryptionMethod(this.newEncryptionMethod(encryptionMethodElement));
            }
            if ((keyInfoElement = (Element)element.getElementsByTagNameNS(XMLCipher.XML_DSIG, "KeyInfo").item(0)) != null) {
                try {
                    result.setKeyInfo(new KeyInfo(keyInfoElement, null));
                }
                catch (XMLSecurityException xse) {
                    throw new XMLEncryptionException("Error loading Key Info", xse);
                }
            }
            if ((encryptionPropertiesElement = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptionProperties").item(0)) != null) {
                result.setEncryptionProperties(this.newEncryptionProperties(encryptionPropertiesElement));
            }
            return result;
        }

        EncryptedKey newEncryptedKey(Element element) throws XMLEncryptionException {
            Element carriedNameElement;
            Element referenceListElement;
            Element encryptionPropertiesElement;
            Element keyInfoElement;
            EncryptedKey result = null;
            NodeList dataElements = element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherData");
            Element dataElement = (Element)dataElements.item(dataElements.getLength() - 1);
            CipherData data = this.newCipherData(dataElement);
            result = this.newEncryptedKey(data);
            result.setId(element.getAttributeNS(null, "Id"));
            result.setType(element.getAttributeNS(null, "Type"));
            result.setMimeType(element.getAttributeNS(null, "MimeType"));
            result.setEncoding(element.getAttributeNS(null, "Encoding"));
            result.setRecipient(element.getAttributeNS(null, "Recipient"));
            Element encryptionMethodElement = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptionMethod").item(0);
            if (encryptionMethodElement != null) {
                result.setEncryptionMethod(this.newEncryptionMethod(encryptionMethodElement));
            }
            if ((keyInfoElement = (Element)element.getElementsByTagNameNS(XMLCipher.XML_DSIG, "KeyInfo").item(0)) != null) {
                try {
                    result.setKeyInfo(new KeyInfo(keyInfoElement, null));
                }
                catch (XMLSecurityException xse) {
                    throw new XMLEncryptionException("Error loading Key Info", xse);
                }
            }
            if ((encryptionPropertiesElement = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptionProperties").item(0)) != null) {
                result.setEncryptionProperties(this.newEncryptionProperties(encryptionPropertiesElement));
            }
            if ((referenceListElement = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "ReferenceList").item(0)) != null) {
                result.setReferenceList(this.newReferenceList(referenceListElement));
            }
            if ((carriedNameElement = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CarriedKeyName").item(0)) != null) {
                result.setCarriedName(carriedNameElement.getFirstChild().getNodeValue());
            }
            return result;
        }

        EncryptionMethod newEncryptionMethod(Element element) {
            Element oaepParamsElement;
            String algorithm = element.getAttributeNS(null, "Algorithm");
            EncryptionMethod result = this.newEncryptionMethod(algorithm);
            Element keySizeElement = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "KeySize").item(0);
            if (keySizeElement != null) {
                result.setKeySize(Integer.valueOf(keySizeElement.getFirstChild().getNodeValue()));
            }
            if ((oaepParamsElement = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "OAEPparams").item(0)) != null) {
                result.setOAEPparams(oaepParamsElement.getNodeValue().getBytes());
            }
            return result;
        }

        EncryptionProperties newEncryptionProperties(Element element) {
            EncryptionProperties result = this.newEncryptionProperties();
            result.setId(element.getAttributeNS(null, "Id"));
            NodeList encryptionPropertyList = element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptionProperty");
            int i = 0;
            while (i < encryptionPropertyList.getLength()) {
                Node n = encryptionPropertyList.item(i);
                if (n != null) {
                    result.addEncryptionProperty(this.newEncryptionProperty((Element)n));
                }
                ++i;
            }
            return result;
        }

        EncryptionProperty newEncryptionProperty(Element element) {
            EncryptionProperty result = this.newEncryptionProperty();
            result.setTarget(element.getAttributeNS(null, "Target"));
            result.setId(element.getAttributeNS(null, "Id"));
            return result;
        }

        ReferenceList newReferenceList(Element element) {
            int type = 0;
            if (element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "DataReference").item(0) != null) {
                type = 1;
            } else if (element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "KeyReference").item(0) != null) {
                type = 2;
            }
            ReferenceListImpl result = new ReferenceListImpl(type);
            NodeList list = null;
            switch (type) {
                case 1: {
                    list = element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "DataReference");
                    int i = 0;
                    while (i < list.getLength()) {
                        String uri = ((Element)list.item(i)).getAttribute("URI");
                        result.add(result.newDataReference(uri));
                        ++i;
                    }
                    break;
                }
                case 2: {
                    list = element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "KeyReference");
                    int i = 0;
                    while (i < list.getLength()) {
                        String uri = ((Element)list.item(i)).getAttribute("URI");
                        result.add(result.newKeyReference(uri));
                        ++i;
                    }
                    break;
                }
            }
            return result;
        }

        Transforms newTransforms(Element element) {
            return null;
        }

        Element toElement(AgreementMethod agreementMethod) {
            return ((AgreementMethodImpl)agreementMethod).toElement();
        }

        Element toElement(CipherData cipherData) {
            return ((CipherDataImpl)cipherData).toElement();
        }

        Element toElement(CipherReference cipherReference) {
            return ((CipherReferenceImpl)cipherReference).toElement();
        }

        Element toElement(CipherValue cipherValue) {
            return ((CipherValueImpl)cipherValue).toElement();
        }

        Element toElement(EncryptedData encryptedData) {
            return ((EncryptedDataImpl)encryptedData).toElement();
        }

        Element toElement(EncryptedKey encryptedKey) {
            return ((EncryptedKeyImpl)encryptedKey).toElement();
        }

        Element toElement(EncryptionMethod encryptionMethod) {
            return ((EncryptionMethodImpl)encryptionMethod).toElement();
        }

        Element toElement(EncryptionProperties encryptionProperties) {
            return ((EncryptionPropertiesImpl)encryptionProperties).toElement();
        }

        Element toElement(EncryptionProperty encryptionProperty) {
            return ((EncryptionPropertyImpl)encryptionProperty).toElement();
        }

        Element toElement(ReferenceList referenceList) {
            return ((ReferenceListImpl)referenceList).toElement();
        }

        Element toElement(Transforms transforms) {
            return ((TransformsImpl)transforms).toElement();
        }

        private class AgreementMethodImpl
        implements AgreementMethod {
            private byte[] kaNonce = null;
            private List agreementMethodInformation = new LinkedList();
            private KeyInfo originatorKeyInfo = null;
            private KeyInfo recipientKeyInfo = null;
            private String algorithmURI = null;

            public AgreementMethodImpl(String algorithm) {
                URI tmpAlgorithm = null;
                try {
                    tmpAlgorithm = new URI(algorithm);
                }
                catch (URI.MalformedURIException malformedURIException) {
                    // empty catch block
                }
                this.algorithmURI = tmpAlgorithm.toString();
            }

            @Override
            public byte[] getKANonce() {
                return this.kaNonce;
            }

            @Override
            public void setKANonce(byte[] kanonce) {
                this.kaNonce = kanonce;
            }

            @Override
            public Iterator getAgreementMethodInformation() {
                return this.agreementMethodInformation.iterator();
            }

            @Override
            public void addAgreementMethodInformation(Element info) {
                this.agreementMethodInformation.add(info);
            }

            @Override
            public void revoveAgreementMethodInformation(Element info) {
                this.agreementMethodInformation.remove(info);
            }

            @Override
            public KeyInfo getOriginatorKeyInfo() {
                return this.originatorKeyInfo;
            }

            @Override
            public void setOriginatorKeyInfo(KeyInfo keyInfo) {
                this.originatorKeyInfo = keyInfo;
            }

            @Override
            public KeyInfo getRecipientKeyInfo() {
                return this.recipientKeyInfo;
            }

            @Override
            public void setRecipientKeyInfo(KeyInfo keyInfo) {
                this.recipientKeyInfo = keyInfo;
            }

            @Override
            public String getAlgorithm() {
                return this.algorithmURI;
            }

            public void setAlgorithm(String algorithm) {
                URI tmpAlgorithm = null;
                try {
                    tmpAlgorithm = new URI(algorithm);
                }
                catch (URI.MalformedURIException malformedURIException) {
                    // empty catch block
                }
                this.algorithmURI = tmpAlgorithm.toString();
            }

            Element toElement() {
                Element result = ElementProxy.createElementForFamily(XMLCipher.this._contextDocument, "http://www.w3.org/2001/04/xmlenc#", "AgreementMethod");
                result.setAttributeNS(null, "Algorithm", this.algorithmURI);
                if (this.kaNonce != null) {
                    result.appendChild(ElementProxy.createElementForFamily(XMLCipher.this._contextDocument, "http://www.w3.org/2001/04/xmlenc#", "KA-Nonce")).appendChild(XMLCipher.this._contextDocument.createTextNode(new String(this.kaNonce)));
                }
                if (!this.agreementMethodInformation.isEmpty()) {
                    Iterator itr = this.agreementMethodInformation.iterator();
                    while (itr.hasNext()) {
                        result.appendChild((Element)itr.next());
                    }
                }
                if (this.originatorKeyInfo != null) {
                    result.appendChild(this.originatorKeyInfo.getElement());
                }
                if (this.recipientKeyInfo != null) {
                    result.appendChild(this.recipientKeyInfo.getElement());
                }
                return result;
            }
        }

        private class CipherDataImpl
        implements CipherData {
            private static final String valueMessage = "Data type is reference type.";
            private static final String referenceMessage = "Data type is value type.";
            private CipherValue cipherValue = null;
            private CipherReference cipherReference = null;
            private int cipherType = Integer.MIN_VALUE;

            public CipherDataImpl(int type) {
                this.cipherType = type;
            }

            @Override
            public CipherValue getCipherValue() {
                return this.cipherValue;
            }

            @Override
            public void setCipherValue(CipherValue value) throws XMLEncryptionException {
                if (this.cipherType == 2) {
                    throw new XMLEncryptionException("empty", new UnsupportedOperationException(valueMessage));
                }
                this.cipherValue = value;
            }

            @Override
            public CipherReference getCipherReference() {
                return this.cipherReference;
            }

            @Override
            public void setCipherReference(CipherReference reference) throws XMLEncryptionException {
                if (this.cipherType == 1) {
                    throw new XMLEncryptionException("empty", new UnsupportedOperationException(referenceMessage));
                }
                this.cipherReference = reference;
            }

            @Override
            public int getDataType() {
                return this.cipherType;
            }

            Element toElement() {
                Element result = ElementProxy.createElementForFamily(XMLCipher.this._contextDocument, "http://www.w3.org/2001/04/xmlenc#", "CipherData");
                if (this.cipherType == 1) {
                    result.appendChild(((CipherValueImpl)this.cipherValue).toElement());
                } else if (this.cipherType == 2) {
                    result.appendChild(((CipherReferenceImpl)this.cipherReference).toElement());
                }
                return result;
            }
        }

        private class CipherReferenceImpl
        implements CipherReference {
            private String referenceURI = null;
            private Transforms referenceTransforms = null;
            private Attr referenceNode = null;

            public CipherReferenceImpl(String uri) {
                this.referenceURI = uri;
                this.referenceNode = null;
            }

            public CipherReferenceImpl(Attr uri) {
                this.referenceURI = uri.getNodeValue();
                this.referenceNode = uri;
            }

            @Override
            public String getURI() {
                return this.referenceURI;
            }

            @Override
            public Attr getURIAsAttr() {
                return this.referenceNode;
            }

            @Override
            public Transforms getTransforms() {
                return this.referenceTransforms;
            }

            @Override
            public void setTransforms(Transforms transforms) {
                this.referenceTransforms = transforms;
            }

            Element toElement() {
                Element result = ElementProxy.createElementForFamily(XMLCipher.this._contextDocument, "http://www.w3.org/2001/04/xmlenc#", "CipherReference");
                result.setAttributeNS(null, "URI", this.referenceURI);
                if (this.referenceTransforms != null) {
                    result.appendChild(((TransformsImpl)this.referenceTransforms).toElement());
                }
                return result;
            }
        }

        private class CipherValueImpl
        implements CipherValue {
            private String cipherValue = null;

            public CipherValueImpl(String value) {
                this.cipherValue = value;
            }

            @Override
            public String getValue() {
                return this.cipherValue;
            }

            @Override
            public void setValue(String value) {
                this.cipherValue = value;
            }

            Element toElement() {
                Element result = ElementProxy.createElementForFamily(XMLCipher.this._contextDocument, "http://www.w3.org/2001/04/xmlenc#", "CipherValue");
                result.appendChild(XMLCipher.this._contextDocument.createTextNode(this.cipherValue));
                return result;
            }
        }

        private class EncryptedDataImpl
        extends EncryptedTypeImpl
        implements EncryptedData {
            public EncryptedDataImpl(CipherData data) {
                super(data);
            }

            Element toElement() {
                Element result = ElementProxy.createElementForFamily(XMLCipher.this._contextDocument, "http://www.w3.org/2001/04/xmlenc#", "EncryptedData");
                if (super.getId() != null) {
                    result.setAttributeNS(null, "Id", super.getId());
                }
                if (super.getType() != null) {
                    result.setAttributeNS(null, "Type", super.getType());
                }
                if (super.getMimeType() != null) {
                    result.setAttributeNS(null, "MimeType", super.getMimeType());
                }
                if (super.getEncoding() != null) {
                    result.setAttributeNS(null, "Encoding", super.getEncoding());
                }
                if (super.getEncryptionMethod() != null) {
                    result.appendChild(((EncryptionMethodImpl)super.getEncryptionMethod()).toElement());
                }
                if (super.getKeyInfo() != null) {
                    result.appendChild(super.getKeyInfo().getElement());
                }
                result.appendChild(((CipherDataImpl)super.getCipherData()).toElement());
                if (super.getEncryptionProperties() != null) {
                    result.appendChild(((EncryptionPropertiesImpl)super.getEncryptionProperties()).toElement());
                }
                return result;
            }
        }

        private class EncryptedKeyImpl
        extends EncryptedTypeImpl
        implements EncryptedKey {
            private String keyRecipient;
            private ReferenceList referenceList;
            private String carriedName;

            public EncryptedKeyImpl(CipherData data) {
                super(data);
                this.keyRecipient = null;
                this.referenceList = null;
                this.carriedName = null;
            }

            @Override
            public String getRecipient() {
                return this.keyRecipient;
            }

            @Override
            public void setRecipient(String recipient) {
                this.keyRecipient = recipient;
            }

            @Override
            public ReferenceList getReferenceList() {
                return this.referenceList;
            }

            @Override
            public void setReferenceList(ReferenceList list) {
                this.referenceList = list;
            }

            @Override
            public String getCarriedName() {
                return this.carriedName;
            }

            @Override
            public void setCarriedName(String name) {
                this.carriedName = name;
            }

            Element toElement() {
                Element result = ElementProxy.createElementForFamily(XMLCipher.this._contextDocument, "http://www.w3.org/2001/04/xmlenc#", "EncryptedKey");
                if (super.getId() != null) {
                    result.setAttributeNS(null, "Id", super.getId());
                }
                if (super.getType() != null) {
                    result.setAttributeNS(null, "Type", super.getType());
                }
                if (super.getMimeType() != null) {
                    result.setAttributeNS(null, "MimeType", super.getMimeType());
                }
                if (super.getEncoding() != null) {
                    result.setAttributeNS(null, "Encoding", super.getEncoding());
                }
                if (this.getRecipient() != null) {
                    result.setAttributeNS(null, "Recipient", this.getRecipient());
                }
                if (super.getEncryptionMethod() != null) {
                    result.appendChild(((EncryptionMethodImpl)super.getEncryptionMethod()).toElement());
                }
                if (super.getKeyInfo() != null) {
                    result.appendChild(super.getKeyInfo().getElement());
                }
                result.appendChild(((CipherDataImpl)super.getCipherData()).toElement());
                if (super.getEncryptionProperties() != null) {
                    result.appendChild(((EncryptionPropertiesImpl)super.getEncryptionProperties()).toElement());
                }
                if (this.referenceList != null && !this.referenceList.isEmpty()) {
                    result.appendChild(((ReferenceListImpl)this.getReferenceList()).toElement());
                }
                if (this.carriedName != null) {
                    Element element = ElementProxy.createElementForFamily(XMLCipher.this._contextDocument, "http://www.w3.org/2001/04/xmlenc#", "CarriedKeyName");
                    Text node = XMLCipher.this._contextDocument.createTextNode(this.carriedName);
                    element.appendChild(node);
                    result.appendChild(element);
                }
                return result;
            }
        }

        private abstract class EncryptedTypeImpl {
            private String id = null;
            private String type = null;
            private String mimeType = null;
            private String encoding = null;
            private EncryptionMethod encryptionMethod = null;
            private KeyInfo keyInfo = null;
            private CipherData cipherData = null;
            private EncryptionProperties encryptionProperties = null;

            protected EncryptedTypeImpl(CipherData data) {
                this.cipherData = data;
            }

            public String getId() {
                return this.id;
            }

            public void setId(String id) {
                this.id = id;
            }

            public String getType() {
                return this.type;
            }

            public void setType(String type) {
                if (type == null || type.length() == 0) {
                    this.type = null;
                } else {
                    URI tmpType = null;
                    try {
                        tmpType = new URI(type);
                    }
                    catch (URI.MalformedURIException malformedURIException) {
                        // empty catch block
                    }
                    this.type = tmpType.toString();
                }
            }

            public String getMimeType() {
                return this.mimeType;
            }

            public void setMimeType(String type) {
                this.mimeType = type;
            }

            public String getEncoding() {
                return this.encoding;
            }

            public void setEncoding(String encoding) {
                if (encoding == null || encoding.length() == 0) {
                    this.encoding = null;
                } else {
                    URI tmpEncoding = null;
                    try {
                        tmpEncoding = new URI(encoding);
                    }
                    catch (URI.MalformedURIException malformedURIException) {
                        // empty catch block
                    }
                    this.encoding = tmpEncoding.toString();
                }
            }

            public EncryptionMethod getEncryptionMethod() {
                return this.encryptionMethod;
            }

            public void setEncryptionMethod(EncryptionMethod method) {
                this.encryptionMethod = method;
            }

            public KeyInfo getKeyInfo() {
                return this.keyInfo;
            }

            public void setKeyInfo(KeyInfo info) {
                this.keyInfo = info;
            }

            public CipherData getCipherData() {
                return this.cipherData;
            }

            public EncryptionProperties getEncryptionProperties() {
                return this.encryptionProperties;
            }

            public void setEncryptionProperties(EncryptionProperties properties) {
                this.encryptionProperties = properties;
            }
        }

        private class EncryptionMethodImpl
        implements EncryptionMethod {
            private String algorithm = null;
            private int keySize = Integer.MIN_VALUE;
            private byte[] oaepParams = null;
            private List encryptionMethodInformation = null;

            public EncryptionMethodImpl(String algorithm) {
                URI tmpAlgorithm = null;
                try {
                    tmpAlgorithm = new URI(algorithm);
                }
                catch (URI.MalformedURIException malformedURIException) {
                    // empty catch block
                }
                this.algorithm = tmpAlgorithm.toString();
                this.encryptionMethodInformation = new LinkedList();
            }

            @Override
            public String getAlgorithm() {
                return this.algorithm;
            }

            @Override
            public int getKeySize() {
                return this.keySize;
            }

            @Override
            public void setKeySize(int size) {
                this.keySize = size;
            }

            @Override
            public byte[] getOAEPparams() {
                return this.oaepParams;
            }

            @Override
            public void setOAEPparams(byte[] params) {
                this.oaepParams = params;
            }

            @Override
            public Iterator getEncryptionMethodInformation() {
                return this.encryptionMethodInformation.iterator();
            }

            @Override
            public void addEncryptionMethodInformation(Element info) {
                this.encryptionMethodInformation.add(info);
            }

            @Override
            public void removeEncryptionMethodInformation(Element info) {
                this.encryptionMethodInformation.remove(info);
            }

            Element toElement() {
                Element result = ElementProxy.createElementForFamily(XMLCipher.this._contextDocument, "http://www.w3.org/2001/04/xmlenc#", "EncryptionMethod");
                result.setAttributeNS(null, "Algorithm", this.algorithm);
                if (this.keySize > 0) {
                    result.appendChild(ElementProxy.createElementForFamily(XMLCipher.this._contextDocument, "http://www.w3.org/2001/04/xmlenc#", "KeySize").appendChild(XMLCipher.this._contextDocument.createTextNode(String.valueOf(this.keySize))));
                }
                if (this.oaepParams != null) {
                    result.appendChild(ElementProxy.createElementForFamily(XMLCipher.this._contextDocument, "http://www.w3.org/2001/04/xmlenc#", "OAEPparams").appendChild(XMLCipher.this._contextDocument.createTextNode(new String(this.oaepParams))));
                }
                if (!this.encryptionMethodInformation.isEmpty()) {
                    Iterator itr = this.encryptionMethodInformation.iterator();
                    result.appendChild((Element)itr.next());
                }
                return result;
            }
        }

        private class EncryptionPropertiesImpl
        implements EncryptionProperties {
            private String id = null;
            private List encryptionProperties = new LinkedList();

            @Override
            public String getId() {
                return this.id;
            }

            @Override
            public void setId(String id) {
                this.id = id;
            }

            @Override
            public Iterator getEncryptionProperties() {
                return this.encryptionProperties.iterator();
            }

            @Override
            public void addEncryptionProperty(EncryptionProperty property) {
                this.encryptionProperties.add(property);
            }

            @Override
            public void removeEncryptionProperty(EncryptionProperty property) {
                this.encryptionProperties.remove(property);
            }

            Element toElement() {
                Element result = ElementProxy.createElementForFamily(XMLCipher.this._contextDocument, "http://www.w3.org/2001/04/xmlenc#", "EncryptionProperties");
                if (this.id != null) {
                    result.setAttributeNS(null, "Id", this.id);
                }
                Iterator itr = this.getEncryptionProperties();
                while (itr.hasNext()) {
                    result.appendChild(((EncryptionPropertyImpl)itr.next()).toElement());
                }
                return result;
            }
        }

        private class EncryptionPropertyImpl
        implements EncryptionProperty {
            private String target = null;
            private String id = null;
            private HashMap attributeMap = new HashMap();
            private List encryptionInformation = new LinkedList();

            @Override
            public String getTarget() {
                return this.target;
            }

            @Override
            public void setTarget(String target) {
                if (target == null || target.length() == 0) {
                    this.target = null;
                } else if (target.startsWith("#")) {
                    this.target = target;
                } else {
                    URI tmpTarget = null;
                    try {
                        tmpTarget = new URI(target);
                    }
                    catch (URI.MalformedURIException malformedURIException) {
                        // empty catch block
                    }
                    this.target = tmpTarget.toString();
                }
            }

            @Override
            public String getId() {
                return this.id;
            }

            @Override
            public void setId(String id) {
                this.id = id;
            }

            @Override
            public String getAttribute(String attribute) {
                return (String)this.attributeMap.get(attribute);
            }

            @Override
            public void setAttribute(String attribute, String value) {
                this.attributeMap.put(attribute, value);
            }

            @Override
            public Iterator getEncryptionInformation() {
                return this.encryptionInformation.iterator();
            }

            @Override
            public void addEncryptionInformation(Element info) {
                this.encryptionInformation.add(info);
            }

            @Override
            public void removeEncryptionInformation(Element info) {
                this.encryptionInformation.remove(info);
            }

            Element toElement() {
                Element result = ElementProxy.createElementForFamily(XMLCipher.this._contextDocument, "http://www.w3.org/2001/04/xmlenc#", "EncryptionProperty");
                if (this.target != null) {
                    result.setAttributeNS(null, "Target", this.target);
                }
                if (this.id != null) {
                    result.setAttributeNS(null, "Id", this.id);
                }
                return result;
            }
        }

        private class ReferenceListImpl
        implements ReferenceList {
            private Class sentry;
            private List references;

            public ReferenceListImpl(int type) {
                if (type == 1) {
                    this.sentry = DataReference.class;
                } else if (type == 2) {
                    this.sentry = KeyReference.class;
                } else {
                    throw new IllegalArgumentException();
                }
                this.references = new LinkedList();
            }

            @Override
            public void add(Reference reference) {
                if (!reference.getClass().equals(this.sentry)) {
                    throw new IllegalArgumentException();
                }
                this.references.add(reference);
            }

            @Override
            public void remove(Reference reference) {
                if (!reference.getClass().equals(this.sentry)) {
                    throw new IllegalArgumentException();
                }
                this.references.remove(reference);
            }

            @Override
            public int size() {
                return this.references.size();
            }

            @Override
            public boolean isEmpty() {
                return this.references.isEmpty();
            }

            @Override
            public Iterator getReferences() {
                return this.references.iterator();
            }

            Element toElement() {
                Element result = ElementProxy.createElementForFamily(XMLCipher.this._contextDocument, "http://www.w3.org/2001/04/xmlenc#", "ReferenceList");
                for (Reference reference : this.references) {
                    result.appendChild(((ReferenceImpl)reference).toElement());
                }
                return result;
            }

            @Override
            public Reference newDataReference(String uri) {
                return new DataReference(uri);
            }

            @Override
            public Reference newKeyReference(String uri) {
                return new KeyReference(uri);
            }

            private class DataReference
            extends ReferenceImpl {
                DataReference(String uri) {
                    super(uri);
                }

                @Override
                public Element toElement() {
                    return super.toElement("DataReference");
                }
            }

            private class KeyReference
            extends ReferenceImpl {
                KeyReference(String uri) {
                    super(uri);
                }

                @Override
                public Element toElement() {
                    return super.toElement("KeyReference");
                }
            }

            private abstract class ReferenceImpl
            implements Reference {
                private String uri;
                private List referenceInformation;

                ReferenceImpl(String _uri) {
                    this.uri = _uri;
                    this.referenceInformation = new LinkedList();
                }

                @Override
                public String getURI() {
                    return this.uri;
                }

                @Override
                public Iterator getElementRetrievalInformation() {
                    return this.referenceInformation.iterator();
                }

                @Override
                public void setURI(String _uri) {
                    this.uri = _uri;
                }

                @Override
                public void removeElementRetrievalInformation(Element node) {
                    this.referenceInformation.remove(node);
                }

                @Override
                public void addElementRetrievalInformation(Element node) {
                    this.referenceInformation.add(node);
                }

                public abstract Element toElement();

                Element toElement(String tagName) {
                    Element result = ElementProxy.createElementForFamily(XMLCipher.this._contextDocument, "http://www.w3.org/2001/04/xmlenc#", tagName);
                    result.setAttribute("URI", this.uri);
                    return result;
                }
            }
        }

        private class TransformsImpl
        extends adsi.org.apache.xml.security.transforms.Transforms
        implements Transforms {
            public TransformsImpl() {
                super(XMLCipher.this._contextDocument);
            }

            public TransformsImpl(Document doc) {
                if (doc == null) {
                    throw new RuntimeException("Document is null");
                }
                this._doc = doc;
                this._constructionElement = this.createElementForFamilyLocal(this._doc, this.getBaseNamespace(), this.getBaseLocalName());
            }

            public TransformsImpl(Element element) throws XMLSignatureException, InvalidTransformException, XMLSecurityException, TransformationException {
                super(element, "");
            }

            public Element toElement() {
                if (this._doc == null) {
                    this._doc = XMLCipher.this._contextDocument;
                }
                return this.getElement();
            }

            @Override
            public adsi.org.apache.xml.security.transforms.Transforms getDSTransforms() {
                return this;
            }

            @Override
            public String getBaseNamespace() {
                return "http://www.w3.org/2001/04/xmlenc#";
            }
        }
    }

    private class Serializer {
        Serializer() {
        }

        String serialize(Document document) throws Exception {
            return this.canonSerialize(document);
        }

        String serialize(Element element) throws Exception {
            return this.canonSerialize(element);
        }

        String serialize(NodeList content) throws Exception {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLCipher.this._canon.setWriter(baos);
            XMLCipher.this._canon.notReset();
            int i = 0;
            while (i < content.getLength()) {
                XMLCipher.this._canon.canonicalizeSubtree(content.item(i));
                ++i;
            }
            baos.close();
            return baos.toString("UTF-8");
        }

        String canonSerialize(Node node) throws Exception {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLCipher.this._canon.setWriter(baos);
            XMLCipher.this._canon.notReset();
            XMLCipher.this._canon.canonicalizeSubtree(node);
            baos.close();
            return baos.toString("UTF-8");
        }

        DocumentFragment deserialize(String source, Node ctx) throws XMLEncryptionException {
            DocumentFragment result;
            String tagname = "fragment";
            StringBuffer sb = new StringBuffer();
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><fragment");
            Node wk = ctx;
            while (wk != null) {
                NamedNodeMap atts = wk.getAttributes();
                int length = atts != null ? atts.getLength() : 0;
                int i = 0;
                while (i < length) {
                    Node att = atts.item(i);
                    if (att.getNodeName().startsWith("xmlns:") || att.getNodeName().equals("xmlns")) {
                        Node p = ctx;
                        boolean found = false;
                        while (p != wk) {
                            NamedNodeMap tstAtts = p.getAttributes();
                            if (tstAtts != null && tstAtts.getNamedItem(att.getNodeName()) != null) {
                                found = true;
                                break;
                            }
                            p = p.getParentNode();
                        }
                        if (!found) {
                            sb.append(" " + att.getNodeName() + "=\"" + att.getNodeValue() + "\"");
                        }
                    }
                    ++i;
                }
                wk = wk.getParentNode();
            }
            sb.append(">" + source + "</" + "fragment" + ">");
            String fragment = sb.toString();
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                dbf.setAttribute("http://xml.org/sax/features/namespaces", Boolean.TRUE);
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document d = db.parse(new InputSource(new StringReader(fragment)));
                Element fragElt = (Element)XMLCipher.this._contextDocument.importNode(d.getDocumentElement(), true);
                result = XMLCipher.this._contextDocument.createDocumentFragment();
                Node child = fragElt.getFirstChild();
                while (child != null) {
                    fragElt.removeChild(child);
                    result.appendChild(child);
                    child = fragElt.getFirstChild();
                }
            }
            catch (SAXException se) {
                throw new XMLEncryptionException("empty", se);
            }
            catch (ParserConfigurationException pce) {
                throw new XMLEncryptionException("empty", pce);
            }
            catch (IOException ioe) {
                throw new XMLEncryptionException("empty", ioe);
            }
            return result;
        }
    }
}

