/*
 * Decompiled with CFR 0.152.
 */
package adsi.org.apache.xml.security.keys.keyresolver.implementations;

import adsi.org.apache.xml.security.exceptions.XMLSecurityException;
import adsi.org.apache.xml.security.keys.content.x509.XMLX509SKI;
import adsi.org.apache.xml.security.keys.keyresolver.KeyResolverException;
import adsi.org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import adsi.org.apache.xml.security.keys.storage.StorageResolver;
import adsi.org.apache.xml.security.utils.XMLUtils;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class X509SKIResolver
extends KeyResolverSpi {
    static Log log = LogFactory.getLog(X509SKIResolver.class.getName());

    @Override
    public PublicKey engineLookupAndResolvePublicKey(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        X509Certificate cert = this.engineLookupResolveX509Certificate(element, BaseURI, storage);
        if (cert != null) {
            return cert.getPublicKey();
        }
        return null;
    }

    @Override
    public X509Certificate engineLookupResolveX509Certificate(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        if (log.isDebugEnabled()) {
            log.debug("Can I resolve " + element.getTagName() + "?");
        }
        if (!XMLUtils.elementIsInSignatureSpace(element, "X509Data")) {
            log.debug("I can't");
            return null;
        }
        XMLX509SKI[] x509childObject = null;
        Element[] x509childNodes = null;
        x509childNodes = XMLUtils.selectDsNodes(element.getFirstChild(), "X509SKI");
        if (x509childNodes == null || x509childNodes.length <= 0) {
            log.debug("I can't");
            return null;
        }
        try {
            if (storage == null) {
                Object[] exArgs = new Object[]{"X509SKI"};
                KeyResolverException ex = new KeyResolverException("KeyResolver.needStorageResolver", exArgs);
                log.info("", ex);
                throw ex;
            }
            x509childObject = new XMLX509SKI[x509childNodes.length];
            int i = 0;
            while (i < x509childNodes.length) {
                x509childObject[i] = new XMLX509SKI(x509childNodes[i], BaseURI);
                ++i;
            }
            while (storage.hasNext()) {
                X509Certificate cert = storage.next();
                XMLX509SKI certSKI = new XMLX509SKI(element.getOwnerDocument(), cert);
                int i2 = 0;
                while (i2 < x509childObject.length) {
                    if (certSKI.equals(x509childObject[i2])) {
                        log.debug("Return PublicKey from " + cert.getSubjectDN().getName());
                        return cert;
                    }
                    ++i2;
                }
            }
        }
        catch (XMLSecurityException ex) {
            throw new KeyResolverException("empty", ex);
        }
        return null;
    }

    @Override
    public SecretKey engineLookupAndResolveSecretKey(Element element, String BaseURI, StorageResolver storage) {
        return null;
    }
}

