/*
 * Decompiled with CFR 0.152.
 */
package adsi.org.apache.xml.security.keys.storage.implementations;

import adsi.org.apache.xml.security.keys.content.x509.XMLX509SKI;
import adsi.org.apache.xml.security.keys.storage.StorageResolverException;
import adsi.org.apache.xml.security.keys.storage.StorageResolverSpi;
import adsi.org.apache.xml.security.utils.Base64;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Iterator;

public class KeyStoreResolver
extends StorageResolverSpi {
    KeyStore _keyStore = null;
    Iterator _iterator = null;

    public KeyStoreResolver(KeyStore keyStore) throws StorageResolverException {
        this._keyStore = keyStore;
        this._iterator = new KeyStoreIterator(this._keyStore);
    }

    @Override
    public Iterator getIterator() {
        return this._iterator;
    }

    public static void main(String[] unused) throws Exception {
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(new FileInputStream("data/org/apache/xml/security/samples/input/keystore.jks"), "xmlsecurity".toCharArray());
        KeyStoreResolver krs = new KeyStoreResolver(ks);
        Iterator i = krs.getIterator();
        while (i.hasNext()) {
            X509Certificate cert = (X509Certificate)i.next();
            byte[] ski = XMLX509SKI.getSKIBytesFromCert(cert);
            System.out.println(Base64.encode(ski));
        }
    }

    static class KeyStoreIterator
    implements Iterator {
        KeyStore _keyStore = null;
        Enumeration _aliases = null;

        public KeyStoreIterator(KeyStore keyStore) throws StorageResolverException {
            try {
                this._keyStore = keyStore;
                this._aliases = this._keyStore.aliases();
            }
            catch (KeyStoreException ex) {
                throw new StorageResolverException("generic.EmptyMessage", ex);
            }
        }

        @Override
        public boolean hasNext() {
            return this._aliases.hasMoreElements();
        }

        public Object next() {
            String alias = (String)this._aliases.nextElement();
            try {
                return this._keyStore.getCertificate(alias);
            }
            catch (KeyStoreException ex) {
                return null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Can't remove keys from KeyStore");
        }
    }
}

