/*
 * Decompiled with CFR 0.152.
 */
package com.quijotelui.firmador;

import com.quijotelui.firmador.AutoridadesCertificantes;
import com.quijotelui.firmador.PassStoreKS;
import com.quijotelui.firmador.TokensAvailables;
import com.quijotelui.firmador.X500NameGeneral;
import es.mityc.firmaJava.libreria.utilidades.UtilidadTratarNodo;
import es.mityc.firmaJava.libreria.xades.DataToSign;
import es.mityc.firmaJava.libreria.xades.FirmaXML;
import es.mityc.javasign.pkstore.CertStoreException;
import es.mityc.javasign.pkstore.IPKStoreManager;
import es.mityc.javasign.pkstore.keystore.KSStore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class GenericXMLSignature {
    public String PKCS12_RESOURCE = "/examples/usr0061.p12";
    public String PKCS12_PASSWORD = "miclave";
    public String OUTPUT_DIRECTORY;

    public void setOUTPUT_DIRECTORY(String OUTPUT_DIRECTORY) {
        this.OUTPUT_DIRECTORY = OUTPUT_DIRECTORY;
    }

    protected boolean execute(TokensAvailables token) {
        try {
            KSStore storeManager = null;
            String aliaskey = null;
            KeyStore ks = null;
            String store = "pkcs12";
            ks = KeyStore.getInstance(store);
            if (store == "Windows-MY") {
                ks.load(this.getClass().getResourceAsStream(this.PKCS12_RESOURCE), this.PKCS12_PASSWORD.toCharArray());
                ks.load(null, null);
                storeManager = new KSStore(ks, new PassStoreKS(this.PKCS12_PASSWORD));
            } else if (store.equals("pkcs12")) {
                ks.load(new FileInputStream(this.PKCS12_RESOURCE), this.PKCS12_PASSWORD.toCharArray());
                ks.load(null, null);
                storeManager = new KSStore(ks, new PassStoreKS(this.PKCS12_PASSWORD));
            }
            if (storeManager == null) {
                System.err.println("El gestor de claves no se ha obtenido correctamente.");
                return false;
            }
            aliaskey = GenericXMLSignature.selectCertificate(ks, token);
            X509Certificate certificate = (X509Certificate)ks.getCertificate(aliaskey);
            if (certificate == null) {
                System.err.println("No existe ning\u00fan certificado para firmar");
                return false;
            }
            PrivateKey privateKey = null;
            try {
                KeyStore tmpKs = ks;
                privateKey = (PrivateKey)tmpKs.getKey(aliaskey, this.PKCS12_PASSWORD.toCharArray());
            }
            catch (UnrecoverableKeyException ex) {
                Logger.getLogger(GenericXMLSignature.class.getName()).log(Level.SEVERE, null, ex);
            }
            Provider provider = storeManager.getProvider(certificate);
            DataToSign dataToSign = this.createDataToSign();
            FirmaXML firma = new FirmaXML();
            Document docSigned = null;
            try {
                Object[] res = firma.signFile(certificate, dataToSign, privateKey, provider);
                docSigned = (Document)res[0];
            }
            catch (Exception ex) {
                System.err.println("Error realizando la firma");
                ex.printStackTrace();
                return false;
            }
            String filePath = this.OUTPUT_DIRECTORY + File.separatorChar + this.getSignatureFileName();
            System.out.println("Firma salvada en en: " + filePath);
            this.saveDocumentToFile(docSigned, filePath);
            return true;
        }
        catch (KeyStoreException ex) {
            Logger.getLogger(GenericXMLSignature.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(GenericXMLSignature.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(GenericXMLSignature.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (CertificateNotYetValidException ex) {
            Logger.getLogger(GenericXMLSignature.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (CertificateException ex) {
            Logger.getLogger(GenericXMLSignature.class.getName()).log(Level.SEVERE, null, ex);
        }
        return false;
    }

    protected abstract DataToSign createDataToSign();

    protected abstract String getSignatureFileName();

    private void saveDocumentToFile(Document document, String pathfile) {
        try {
            FileOutputStream fos = new FileOutputStream(pathfile);
            UtilidadTratarNodo.saveDocumentToOutputStream(document, fos, true);
        }
        catch (FileNotFoundException e) {
            System.err.println("Error al salvar el documento");
            e.printStackTrace();
        }
    }

    private void saveDocumentToFileUnsafeMode(Document document, String pathfile) {
        TransformerFactory tfactory = TransformerFactory.newInstance();
        try {
            Transformer serializer = tfactory.newTransformer();
            serializer.transform(new DOMSource(document), new StreamResult(new File(pathfile)));
        }
        catch (TransformerException e) {
            System.err.println("Error al salvar el documento");
            e.printStackTrace();
        }
    }

    protected Document getDocument(String resource) {
        Document doc = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        File fXmlFile = new File(resource);
        dbf.setNamespaceAware(true);
        try {
            DocumentBuilder dBuilder = dbf.newDocumentBuilder();
            doc = dBuilder.parse(fXmlFile);
        }
        catch (ParserConfigurationException ex) {
            System.err.println(GenericXMLSignature.class.getName() + " " + ex.getMessage());
        }
        catch (SAXException ex) {
            System.err.println(GenericXMLSignature.class.getName() + " " + ex.getMessage());
        }
        catch (IOException ex) {
            System.err.println(GenericXMLSignature.class.getName() + " " + ex.getMessage());
        }
        return doc;
    }

    protected String getDocumentAsString(String resource) {
        Document doc = this.getDocument(resource);
        TransformerFactory tfactory = TransformerFactory.newInstance();
        StringWriter stringWriter = new StringWriter();
        try {
            Transformer serializer = tfactory.newTransformer();
            serializer.transform(new DOMSource(doc), new StreamResult(stringWriter));
        }
        catch (TransformerException e) {
            System.err.println("Error al imprimir el documento");
            e.printStackTrace();
        }
        return stringWriter.toString();
    }

    private X509Certificate getFirstCertificate(IPKStoreManager storeManager) {
        List<X509Certificate> certs = null;
        try {
            certs = storeManager.getSignCertificates();
        }
        catch (CertStoreException ex) {
            System.err.println("Fallo obteniendo listado de certificados");
            return null;
        }
        if (certs == null || certs.size() == 0) {
            System.err.println("Lista de certificados vac\u00eda");
            return null;
        }
        X509Certificate certificate = certs.get(0);
        return certificate;
    }

    public static String selectCertificate(KeyStore keyStore, TokensAvailables tokenSelected) throws KeyStoreException {
        String aliasSeleccion = null;
        X509Certificate certificado = null;
        Enumeration<String> nombres = keyStore.aliases();
        while (nombres.hasMoreElements()) {
            String aliasKey = nombres.nextElement();
            certificado = (X509Certificate)keyStore.getCertificate(aliasKey);
            X500NameGeneral x500emisor = new X500NameGeneral(certificado.getIssuerDN().getName());
            X500NameGeneral x500sujeto = new X500NameGeneral(certificado.getSubjectDN().getName());
            String cn = x500emisor.getCN();
            String a = AutoridadesCertificantes.SECURITY_DATA.getCn();
            Boolean r = cn.contains(a);
            if ((tokenSelected.equals((Object)TokensAvailables.SD_BIOPASS) || tokenSelected.equals((Object)TokensAvailables.SD_EPASS3000)) && (x500emisor.getCN().contains(AutoridadesCertificantes.SECURITY_DATA.getCn()) || x500emisor.getCN().contains(AutoridadesCertificantes.SECURITY_DATA_SUB_1.getCn()))) {
                if (AutoridadesCertificantes.SECURITY_DATA.getO().equals(x500emisor.getO()) && AutoridadesCertificantes.SECURITY_DATA.getC().equals(x500emisor.getC()) && AutoridadesCertificantes.SECURITY_DATA.getO().equals(x500sujeto.getO()) && AutoridadesCertificantes.SECURITY_DATA.getC().equals(x500sujeto.getC()) && certificado.getKeyUsage()[0]) {
                    aliasSeleccion = aliasKey;
                    break;
                }
                if (!AutoridadesCertificantes.SECURITY_DATA_SUB_1.getO().equals(x500emisor.getO()) || !AutoridadesCertificantes.SECURITY_DATA_SUB_1.getC().equals(x500emisor.getC()) || !AutoridadesCertificantes.SECURITY_DATA_SUB_1.getO().equals(x500sujeto.getO()) || !AutoridadesCertificantes.SECURITY_DATA_SUB_1.getC().equals(x500sujeto.getC()) || !certificado.getKeyUsage()[0]) continue;
                aliasSeleccion = aliasKey;
                break;
            }
            if (tokenSelected.equals((Object)TokensAvailables.BCE_ALADDIN) || tokenSelected.equals((Object)TokensAvailables.BCE_IKEY2032) && x500emisor.getCN().contains(AutoridadesCertificantes.BANCO_CENTRAL.getCn())) {
                if (!x500emisor.getO().contains(AutoridadesCertificantes.BANCO_CENTRAL.getO()) || !AutoridadesCertificantes.BANCO_CENTRAL.getC().equals(x500emisor.getC()) || !x500sujeto.getO().contains(AutoridadesCertificantes.BANCO_CENTRAL.getO()) || !AutoridadesCertificantes.BANCO_CENTRAL.getC().equals(x500sujeto.getC()) || !certificado.getKeyUsage()[0] && !certificado.getKeyUsage()[1]) continue;
                aliasSeleccion = aliasKey;
                break;
            }
            if (tokenSelected.equals((Object)TokensAvailables.ANF1) && x500emisor.getCN().contains(AutoridadesCertificantes.ANF.getCn())) {
                if (!AutoridadesCertificantes.ANF.getO().equals(x500emisor.getO()) || !AutoridadesCertificantes.ANF.getC().equals(x500emisor.getC()) || !AutoridadesCertificantes.ANF.getC().toLowerCase().equals(x500sujeto.getC()) || !certificado.getKeyUsage()[0] && !certificado.getKeyUsage()[1]) continue;
                aliasSeleccion = aliasKey;
                break;
            }
            if (tokenSelected.equals((Object)TokensAvailables.ANF1) && x500emisor.getCN().contains(AutoridadesCertificantes.ANF.getCn())) {
                if (!AutoridadesCertificantes.ANF.getO().equals(x500emisor.getO()) || !AutoridadesCertificantes.ANF.getC().equals(x500emisor.getC()) || !AutoridadesCertificantes.ANF.getC().toLowerCase().equals(x500sujeto.getC()) || !certificado.getKeyUsage()[0] && !certificado.getKeyUsage()[1]) continue;
                aliasSeleccion = aliasKey;
                break;
            }
            if (tokenSelected.equals((Object)TokensAvailables.GENERAL)) {
                if (!certificado.getKeyUsage()[0] && !certificado.getKeyUsage()[1]) continue;
                aliasSeleccion = aliasKey;
                break;
            }
            if (!tokenSelected.equals((Object)TokensAvailables.KEY4_CONSEJO_JUDICATURA) || !x500emisor.getCN().contains(AutoridadesCertificantes.CONSEJO_JUDICATURA.getCn()) || !x500emisor.getO().contains(AutoridadesCertificantes.CONSEJO_JUDICATURA.getO()) || !AutoridadesCertificantes.CONSEJO_JUDICATURA.getC().equals(x500emisor.getC()) || !AutoridadesCertificantes.CONSEJO_JUDICATURA.getC().equals(x500sujeto.getC()) || !certificado.getKeyUsage()[0] && !certificado.getKeyUsage()[1]) continue;
            aliasSeleccion = aliasKey;
            break;
        }
        return aliasSeleccion;
    }
}

