/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.libreria.xades.elementos.xades;

import es.mityc.firmaJava.libreria.xades.XAdESSchemas;
import es.mityc.firmaJava.libreria.xades.elementos.xades.AbstractXADESElement;
import es.mityc.firmaJava.libreria.xades.elementos.xades.Description;
import es.mityc.firmaJava.libreria.xades.elementos.xades.Encoding;
import es.mityc.firmaJava.libreria.xades.elementos.xades.MimeType;
import es.mityc.firmaJava.libreria.xades.elementos.xades.ObjectIdentifier;
import es.mityc.firmaJava.libreria.xades.errores.InvalidInfoNodeException;
import java.net.URI;
import java.net.URISyntaxException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DataObjectFormatType
extends AbstractXADESElement {
    private URI objectReference;
    private Description description;
    private ObjectIdentifier objectIdentifier;
    private MimeType mimetype;
    private Encoding encoding;

    public DataObjectFormatType(XAdESSchemas schema, URI reference, String description, String mimeType) {
        super(schema);
        this.objectReference = reference;
        if (description != null) {
            this.description = new Description(schema, description);
        }
        if (mimeType != null) {
            this.mimetype = new MimeType(schema, mimeType);
        }
    }

    public DataObjectFormatType(XAdESSchemas schema) {
        super(schema);
    }

    public Description getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = new Description(this.schema, description);
    }

    public void setDescription(Description description) {
        this.description = description;
    }

    public MimeType getMimeType() {
        return this.mimetype;
    }

    public void setMimeType(String mimeType) {
        this.mimetype = new MimeType(this.schema, mimeType);
    }

    public void setMimeType(MimeType mimeType) {
        this.mimetype = mimeType;
    }

    public Encoding getEnconding() {
        return this.encoding;
    }

    public void setEncoding(URI encoding) {
        this.encoding = new Encoding(this.schema, encoding);
    }

    public void setEncoding(Encoding encoding) {
        this.encoding = encoding;
    }

    public ObjectIdentifier getObjectIdentifier() {
        return this.objectIdentifier;
    }

    public void setObjectIdentifier(ObjectIdentifier objectIdentifier) {
        this.objectIdentifier = objectIdentifier;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DataObjectFormatType) {
            DataObjectFormatType doft = (DataObjectFormatType)obj;
            if (!DataObjectFormatType.compare(this.description, doft.description)) {
                return false;
            }
            if (!DataObjectFormatType.compare(this.objectIdentifier, doft.objectIdentifier)) {
                return false;
            }
            if (!DataObjectFormatType.compare(this.mimetype, doft.mimetype)) {
                return false;
            }
            return DataObjectFormatType.compare(this.encoding, doft.encoding);
        }
        return false;
    }

    @Override
    public void load(Element element) throws InvalidInfoNodeException {
        String uri = element.getAttribute("ObjectReference");
        if (uri == null) {
            throw new InvalidInfoNodeException("No hay ObjectReference en nodo DataObjectFormatType");
        }
        try {
            this.objectReference = new URI(uri);
        }
        catch (URISyntaxException ex) {
            throw new InvalidInfoNodeException("URI en ObjectReference inv\u00e1lida");
        }
        Description description = null;
        ObjectIdentifier objIdentifier = null;
        MimeType mimeType = null;
        Encoding encoding = null;
        Node node = DataObjectFormatType.getFirstNonvoidNode(element);
        if (node != null) {
            if (node.getNodeType() != 1) {
                throw new InvalidInfoNodeException("Se esperaba elemento como hijo de DataObjectFormatType");
            }
            description = new Description(this.schema);
            if (description.isThisNode(node)) {
                description.load((Element)node);
                node = DataObjectFormatType.getNextNonvoidNode(node);
            } else {
                description = null;
            }
        }
        if (node != null) {
            if (node.getNodeType() != 1) {
                throw new InvalidInfoNodeException("Se esperaba elemento como hijo de DataObjectFormatType");
            }
            objIdentifier = new ObjectIdentifier(this.schema);
            if (objIdentifier.isThisNode(node)) {
                objIdentifier.load((Element)node);
                node = DataObjectFormatType.getNextNonvoidNode(node);
            } else {
                objIdentifier = null;
            }
        }
        if (node != null) {
            if (node.getNodeType() != 1) {
                throw new InvalidInfoNodeException("Se esperaba elemento como hijo de DataObjectFormatType");
            }
            mimeType = new MimeType(this.schema);
            if (mimeType.isThisNode(node)) {
                mimeType.load((Element)node);
                node = DataObjectFormatType.getNextNonvoidNode(node);
            } else {
                mimeType = null;
            }
        }
        if (node != null) {
            if (node.getNodeType() != 1) {
                throw new InvalidInfoNodeException("Se esperaba elemento como hijo de DataObjectFormatType");
            }
            encoding = new Encoding(this.schema);
            if (encoding.isThisNode(node)) {
                encoding.load((Element)node);
                node = DataObjectFormatType.getNextNonvoidNode(node);
            } else {
                encoding = null;
            }
        }
        if (description == null && objIdentifier == null && mimeType == null) {
            throw new InvalidInfoNodeException("No hay informaci\u00f3n de formato de objeto en nodo DataObjectFormatType");
        }
        this.description = description;
        this.objectIdentifier = objIdentifier;
        this.mimetype = mimeType;
        this.encoding = encoding;
    }

    @Override
    public void addContent(Element element, String namespaceXAdES) throws InvalidInfoNodeException {
        super.addContent(element, namespaceXAdES);
    }

    @Override
    protected void addContent(Element element) throws InvalidInfoNodeException {
        if (this.objectReference == null) {
            throw new InvalidInfoNodeException("Informaci\u00f3n insuficiente para escribir nodo DataObjectFormatType");
        }
        element.setAttributeNS(null, "ObjectReference", this.objectReference.toString());
        if (this.description == null && this.objectIdentifier == null && this.mimetype == null) {
            throw new InvalidInfoNodeException("Informaci\u00f3n insuficiente para escribir nodo DataObjectFormatType");
        }
        if (this.description != null) {
            element.appendChild(this.description.createElement(element.getOwnerDocument(), this.namespaceXAdES));
        }
        if (this.objectIdentifier != null) {
            element.appendChild(this.objectIdentifier.createElement(element.getOwnerDocument(), this.namespaceXAdES));
        }
        if (this.mimetype != null) {
            element.appendChild(this.mimetype.createElement(element.getOwnerDocument(), this.namespaceXAdES));
        }
        if (this.encoding != null) {
            element.appendChild(this.encoding.createElement(element.getOwnerDocument(), this.namespaceXAdES));
        }
    }
}

