/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.pkstore.iexplorer;

import es.mityc.javasign.exception.CopyFileException;
import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.pkstore.CertStoreException;
import es.mityc.javasign.pkstore.IPKStoreManager;
import es.mityc.javasign.pkstore.iexplorer.IECSPJNI;
import es.mityc.javasign.pkstore.iexplorer.MITyCMSProvider;
import es.mityc.javasign.pkstore.iexplorer.PKProxyIE;
import es.mityc.javasign.utils.CopyFilesTool;
import java.io.ByteArrayInputStream;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.CertPath;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IExplorerStore
implements IPKStoreManager {
    private static final Log LOG = LogFactory.getLog(IExplorerStore.class);
    private static final II18nManager I18N = I18nFactory.getI18nManager("MITyCLibCert");
    private static IECSPJNI cspBridge = null;

    public IExplorerStore() {
        this.loadLibrary();
    }

    private void copyLibrary() throws CopyFileException {
        CopyFilesTool cft = new CopyFilesTool("libs/iexplorer/MITyCLibCertJNI_iexplorer.properties", this.getClass().getClassLoader());
        cft.copyFilesOS(null, "explorer", true);
    }

    private synchronized void loadLibrary() {
        block3: {
            try {
                if (cspBridge == null) {
                    this.copyLibrary();
                    cspBridge = new IECSPJNI();
                }
            }
            catch (Exception ex) {
                LOG.fatal(I18N.getLocalMessage("i18n.mityc.cert.ie.1", ex.getMessage()));
                if (!LOG.isDebugEnabled()) break block3;
                LOG.error("", ex);
            }
        }
    }

    @Override
    public CertPath getCertPath(X509Certificate certificate) throws CertStoreException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public PrivateKey getPrivateKey(X509Certificate certificate) throws CertStoreException {
        return new PKProxyIE(certificate);
    }

    @Override
    public Provider getProvider(X509Certificate cert) {
        return new MITyCMSProvider();
    }

    @Override
    public List<X509Certificate> getSignCertificates() throws CertStoreException {
        ArrayList<X509Certificate> allCerts = new ArrayList<X509Certificate>();
        if (cspBridge != null) {
            byte[][] bCertificados = cspBridge.getCertificatesInSystemStore("MY");
            int i = 0;
            while (i < bCertificados.length) {
                byte[] bc = bCertificados[i];
                try {
                    CertificateFactory cfTemporal = CertificateFactory.getInstance("X.509");
                    X509Certificate certX509Temporal = (X509Certificate)cfTemporal.generateCertificate(new ByteArrayInputStream(bc));
                    allCerts.add(certX509Temporal);
                }
                catch (CertificateException ex) {
                    LOG.error(ex.getMessage(), ex);
                }
                ++i;
            }
        }
        return allCerts;
    }

    @Override
    public List<X509Certificate> getTrustCertificates() throws CertStoreException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public List<X509Certificate> getPublicCertificates() throws CertStoreException {
        throw new UnsupportedOperationException("Not implemented yet");
    }
}

