/*
 * Decompiled with CFR 0.152.
 */
package adsi.org.apache.xml.security.transforms.implementations;

import adsi.org.apache.xml.security.c14n.CanonicalizationException;
import adsi.org.apache.xml.security.exceptions.Base64DecodingException;
import adsi.org.apache.xml.security.signature.XMLSignatureInput;
import adsi.org.apache.xml.security.transforms.Transform;
import adsi.org.apache.xml.security.transforms.TransformSpi;
import adsi.org.apache.xml.security.transforms.TransformationException;
import adsi.org.apache.xml.security.utils.Base64;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class TransformBase64Decode
extends TransformSpi {
    public static final String implementedTransformURI = "http://www.w3.org/2000/09/xmldsig#base64";

    @Override
    protected String engineGetURI() {
        return implementedTransformURI;
    }

    @Override
    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput input, Transform _transformObject) throws IOException, CanonicalizationException, TransformationException {
        return this.enginePerformTransform(input, null, _transformObject);
    }

    @Override
    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput input, OutputStream os, Transform _transformObject) throws IOException, CanonicalizationException, TransformationException {
        try {
            if (input.isElement()) {
                Node el = input.getSubNode();
                if (input.getSubNode().getNodeType() == 3) {
                    el = el.getParentNode();
                }
                StringBuffer sb = new StringBuffer();
                this.traverseElement((Element)el, sb);
                if (os == null) {
                    byte[] decodedBytes = Base64.decode(sb.toString());
                    return new XMLSignatureInput(decodedBytes);
                }
                Base64.decode(sb.toString(), os);
                XMLSignatureInput output = new XMLSignatureInput(null);
                output.setOutputStream(os);
                return output;
            }
            if (input.isOctetStream() || input.isNodeSet()) {
                if (os == null) {
                    byte[] base64Bytes = input.getBytes();
                    byte[] decodedBytes = Base64.decode(base64Bytes);
                    return new XMLSignatureInput(decodedBytes);
                }
                if (input.isByteArray() || input.isNodeSet()) {
                    Base64.decode(input.getBytes(), os);
                } else {
                    Base64.decode(new BufferedInputStream(input.getOctetStreamReal()), os);
                }
                XMLSignatureInput output = new XMLSignatureInput(null);
                output.setOutputStream(os);
                return output;
            }
            try {
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(input.getOctetStream());
                Element rootNode = doc.getDocumentElement();
                StringBuffer sb = new StringBuffer();
                this.traverseElement(rootNode, sb);
                byte[] decodedBytes = Base64.decode(sb.toString());
                return new XMLSignatureInput(decodedBytes);
            }
            catch (ParserConfigurationException e) {
                throw new TransformationException("c14n.Canonicalizer.Exception", e);
            }
            catch (SAXException e) {
                throw new TransformationException("SAX exception", e);
            }
        }
        catch (Base64DecodingException e) {
            throw new TransformationException("Base64Decoding", e);
        }
    }

    void traverseElement(Element node, StringBuffer sb) {
        Node sibling = node.getFirstChild();
        while (sibling != null) {
            switch (sibling.getNodeType()) {
                case 1: {
                    this.traverseElement((Element)sibling, sb);
                    break;
                }
                case 3: {
                    sb.append(((Text)sibling).getData());
                }
            }
            sibling = sibling.getNextSibling();
        }
    }
}

