/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.libreria.utilidades;

import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.jce.X509Principal;

public class UtilidadDNIe {
    static Log log = LogFactory.getLog(UtilidadDNIe.class);

    public static String getCN(X509Certificate cert, SUBJECT_OR_ISSUER tipo) {
        String retorno = "";
        X509Principal nombre = null;
        try {
            nombre = tipo == SUBJECT_OR_ISSUER.ISSUER ? PrincipalUtil.getIssuerX509Principal((X509Certificate)cert) : PrincipalUtil.getSubjectX509Principal((X509Certificate)cert);
        }
        catch (CertificateEncodingException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return retorno;
        }
        Vector commonNameOIDs = nombre.getOIDs();
        Vector commonName = nombre.getValues();
        int longitudValues = commonName.size();
        if (longitudValues != 0) {
            int indexO;
            Object elemento;
            int indexOU;
            int indexCN = commonNameOIDs.indexOf(X509Name.CN);
            if (indexCN != -1) {
                Object elemento2 = commonName.get(indexCN);
                if (elemento2 instanceof String) {
                    retorno = (String)elemento2;
                } else {
                    log.error((Object)"El CN obtenido no es de tipo String");
                }
            }
            if (retorno == "" && (indexOU = commonNameOIDs.indexOf(X509Name.OU)) != -1) {
                elemento = commonName.get(indexOU);
                if (elemento instanceof String) {
                    retorno = (String)elemento;
                } else {
                    log.error((Object)"El CN obtenido no es de tipo String");
                }
            }
            if ((retorno == "" || retorno == null) && (indexO = commonNameOIDs.indexOf(X509Name.O)) != -1) {
                elemento = commonName.get(indexO);
                if (elemento instanceof String) {
                    retorno = (String)elemento;
                } else {
                    log.error((Object)"El CN obtenido no es de tipo String");
                }
            }
        } else {
            log.error((Object)"El certificado no contiene valores");
        }
        return retorno;
    }

    public static String convertDate(Date date) {
        SimpleDateFormat formatoFecha = new SimpleDateFormat("dd/MM/yyyy");
        String fecha = formatoFecha.format(date);
        return fecha.replace("/", "-");
    }

    public static final String giveMeDNINumber(String subjectDN) {
        if (subjectDN == null) {
            return null;
        }
        String[] tokens = subjectDN.split(",");
        int a = 0;
        while (a < tokens.length) {
            String[] nDNI = null;
            if (tokens[a].trim().startsWith("N\u00famero de serie")) {
                nDNI = tokens[a].trim().split("=");
                return nDNI[1].trim();
            }
            if (tokens[a].trim().startsWith("OID.2.5.4.5")) {
                nDNI = tokens[a].trim().split("=");
                return nDNI[1].trim();
            }
            if (tokens[a].trim().startsWith("serialNumber")) {
                nDNI = tokens[a].trim().split("=");
                return nDNI[1].trim();
            }
            ++a;
        }
        return null;
    }

    public static final boolean isCertDNIe(String emisorDN) {
        return emisorDN.indexOf("OU=DNIE") >= 0 && emisorDN.indexOf("O=DIRECCION GENERAL DE LA POLICIA") >= 0;
    }

    public static enum SUBJECT_OR_ISSUER {
        SUBJECT,
        ISSUER;

    }
}

