/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.libreria.utilidades;

import adsi.org.apache.xml.security.c14n.CanonicalizationException;
import adsi.org.apache.xml.security.signature.XMLSignatureInput;
import adsi.org.apache.xml.security.transforms.TransformationException;
import adsi.org.apache.xml.security.transforms.Transforms;
import es.mityc.firmaJava.libreria.utilidades.I18n;
import es.mityc.firmaJava.libreria.utilidades.NombreNodo;
import es.mityc.firmaJava.libreria.utilidades.UtilidadFicheros;
import es.mityc.firmaJava.libreria.xades.CanonicalizationEnum;
import es.mityc.firmaJava.libreria.xades.errores.FirmaXMLError;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UtilidadTratarNodo {
    private static Log log = LogFactory.getLog(UtilidadTratarNodo.class);
    private static final String[] IDs = new String[]{"Id", "id", "ID"};
    private static Random rnd = new Random(new Date().getTime());
    private static final int RND_MAX_SIZE = 0x100000;
    public static final String XPOINTER_ID = "#xpointer(id('";
    public static final String XPOINTER_ROOT = "#xpointer(/)";

    public static byte[] obtenerByteNodo(Document doc, String ns, String nombreHijos, CanonicalizationEnum canonicalization) throws FirmaXMLError {
        return UtilidadTratarNodo.obtenerByteNodo(doc.getDocumentElement(), ns, nombreHijos, canonicalization, 0);
    }

    public static byte[] obtenerByteNodo(Element padre, String ns, String nombreHijos, CanonicalizationEnum canonicalization, int tope) throws FirmaXMLError {
        return UtilidadTratarNodo.obtenerByteNodo(padre, ns, nombreHijos, true, canonicalization, tope);
    }

    public static byte[] obtenerByteNodo(Element padre, String ns, String nombreHijos, boolean requerido, CanonicalizationEnum canonicalization, int tope) throws FirmaXMLError {
        if (canonicalization == null || canonicalization.equals((Object)CanonicalizationEnum.UNKNOWN)) {
            throw new FirmaXMLError("Canonicalization Method desconocido");
        }
        ArrayList<Object> nodesHijos = new ArrayList();
        if (ns == null) {
            ns = padre.getNamespaceURI();
        }
        if (tope <= 0) {
            NodeList nodosSinTope = padre.getElementsByTagNameNS(ns, nombreHijos);
            int i = 0;
            while (i < nodosSinTope.getLength()) {
                nodesHijos.add((Element)nodosSinTope.item(i));
                ++i;
            }
        } else {
            nodesHijos = UtilidadTratarNodo.obtenerNodos(padre, tope, new NombreNodo(ns, nombreHijos));
        }
        log.debug((Object)("N\u00famero de firmas en el documento: " + nodesHijos.size()));
        if (nodesHijos.size() == 0 && requerido) {
            log.error((Object)(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error8")) + " " + I18n.getResource("libreriaxades.firmaxml.error33") + " " + nombreHijos));
            throw new FirmaXMLError(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error8")) + " " + I18n.getResource("libreriaxades.firmaxml.error33") + " " + nombreHijos);
        }
        if (nodesHijos.size() > 0) {
            Transforms t = new Transforms(padre.getOwnerDocument());
            try {
                t.addTransform(canonicalization.toString());
            }
            catch (TransformationException e) {
                log.error((Object)e);
                throw new FirmaXMLError(I18n.getResource("libreriaxades.firmaxml.error8"));
            }
            ByteArrayOutputStream bais = new ByteArrayOutputStream();
            int i = 0;
            while (i < nodesHijos.size()) {
                XMLSignatureInput xmlSignatureInput = new XMLSignatureInput((Node)nodesHijos.get(i));
                try {
                    XMLSignatureInput resultado = null;
                    resultado = t.performTransforms(xmlSignatureInput);
                    bais.write(resultado.getBytes());
                }
                catch (TransformationException ex) {
                    log.error((Object)I18n.getResource("libreriaxades.firmaxml.error34"), (Throwable)ex);
                    throw new FirmaXMLError(I18n.getResource("libreriaxades.firmaxml.error8"));
                }
                catch (CanonicalizationException ex) {
                    log.error((Object)I18n.getResource("libreriaxades.firmaxml.error34"), (Throwable)ex);
                    throw new FirmaXMLError(I18n.getResource("libreriaxades.firmaxml.error8"));
                }
                catch (IOException ex) {
                    log.error((Object)I18n.getResource("libreriaxades.firmaxml.error34"), (Throwable)ex);
                    throw new FirmaXMLError(I18n.getResource("libreriaxades.firmaxml.error8"));
                }
                ++i;
            }
            if (bais.size() > 0) {
                return bais.toByteArray();
            }
        }
        return null;
    }

    public static byte[] obtenerByteNodo(Element padre, String ns, String nombreHijos, Element tope) throws FirmaXMLError {
        NodeList nodesHijos = null;
        if (ns == null) {
            ns = padre.getNamespaceURI();
        }
        if ((nodesHijos = padre.getChildNodes()).getLength() > 0) {
            Transforms t = new Transforms(padre.getOwnerDocument());
            try {
                t.addTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
            }
            catch (TransformationException e) {
                log.error((Object)e);
                throw new FirmaXMLError(I18n.getResource("libreriaxades.firmaxml.error8"));
            }
            ByteArrayOutputStream bais = new ByteArrayOutputStream();
            int i = 0;
            while (i < nodesHijos.getLength()) {
                Node nodo = nodesHijos.item(i);
                if (nodo.getNodeType() == 1) {
                    if (tope != null && tope.isEqualNode(nodo)) break;
                    if (nodo.getLocalName().equals(nombreHijos) && !(ns == null ? nodo.getNamespaceURI() != null : !ns.equals(nodo.getNamespaceURI()))) {
                        XMLSignatureInput xmlSignatureInput = new XMLSignatureInput(nodo);
                        try {
                            XMLSignatureInput resultado = null;
                            resultado = t.performTransforms(xmlSignatureInput);
                            bais.write(resultado.getBytes());
                        }
                        catch (TransformationException ex) {
                            log.error((Object)I18n.getResource("libreriaxades.firmaxml.error34"), (Throwable)ex);
                            throw new FirmaXMLError(I18n.getResource("libreriaxades.firmaxml.error8"));
                        }
                        catch (CanonicalizationException ex) {
                            log.error((Object)I18n.getResource("libreriaxades.firmaxml.error34"), (Throwable)ex);
                            throw new FirmaXMLError(I18n.getResource("libreriaxades.firmaxml.error8"));
                        }
                        catch (IOException ex) {
                            log.error((Object)I18n.getResource("libreriaxades.firmaxml.error34"), (Throwable)ex);
                            throw new FirmaXMLError(I18n.getResource("libreriaxades.firmaxml.error8"));
                        }
                    }
                }
                ++i;
            }
            if (bais.size() > 0) {
                return bais.toByteArray();
            }
        }
        return null;
    }

    public static byte[] obtenerByteNodo(Element padre, ArrayList<NombreNodo> nombreHijos, Element tope) throws FirmaXMLError {
        NodeList nodesHijos = null;
        nodesHijos = padre.getChildNodes();
        if (nodesHijos.getLength() > 0) {
            Transforms t = new Transforms(padre.getOwnerDocument());
            try {
                t.addTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
            }
            catch (TransformationException e) {
                log.error((Object)e);
                throw new FirmaXMLError(I18n.getResource("libreriaxades.firmaxml.error8"));
            }
            ByteArrayOutputStream bais = new ByteArrayOutputStream();
            int i = 0;
            while (i < nodesHijos.getLength()) {
                Node nodo = nodesHijos.item(i);
                if (nodo.getNodeType() == 1) {
                    if (tope != null && tope.isEqualNode(nodo)) break;
                    NombreNodo nombreNodo = new NombreNodo(nodo.getNamespaceURI(), nodo.getLocalName());
                    if (nombreHijos.indexOf(nombreNodo) != -1) {
                        XMLSignatureInput xmlSignatureInput = new XMLSignatureInput(nodo);
                        try {
                            XMLSignatureInput resultado = null;
                            resultado = t.performTransforms(xmlSignatureInput);
                            bais.write(resultado.getBytes());
                        }
                        catch (TransformationException ex) {
                            log.error((Object)I18n.getResource("libreriaxades.firmaxml.error34"), (Throwable)ex);
                            throw new FirmaXMLError(I18n.getResource("libreriaxades.firmaxml.error8"));
                        }
                        catch (CanonicalizationException ex) {
                            log.error((Object)I18n.getResource("libreriaxades.firmaxml.error34"), (Throwable)ex);
                            throw new FirmaXMLError(I18n.getResource("libreriaxades.firmaxml.error8"));
                        }
                        catch (IOException ex) {
                            log.error((Object)I18n.getResource("libreriaxades.firmaxml.error34"), (Throwable)ex);
                            throw new FirmaXMLError(I18n.getResource("libreriaxades.firmaxml.error8"));
                        }
                    }
                }
                ++i;
            }
            if (bais.size() > 0) {
                return bais.toByteArray();
            }
        }
        return null;
    }

    public static ArrayList<Element> obtenerNodos(Element padre, Element tope, NombreNodo nombreHijo) {
        if (padre == null) {
            return null;
        }
        ArrayList<Element> resultado = new ArrayList<Element>();
        NodeList nodesHijos = padre.getChildNodes();
        int i = 0;
        while (i < nodesHijos.getLength()) {
            Node nodo = nodesHijos.item(i);
            if (nodo.getNodeType() == 1) {
                if (tope != null && tope.isEqualNode(nodo)) break;
                if (new NombreNodo(nodo.getNamespaceURI(), nodo.getLocalName()).equals(nombreHijo)) {
                    resultado.add((Element)nodo);
                }
            }
            ++i;
        }
        return resultado;
    }

    public static ArrayList<Element> obtenerNodos(Element padre, Element tope, ArrayList<NombreNodo> nombreHijos) throws FirmaXMLError {
        ArrayList<Element> resultado = new ArrayList<Element>();
        NodeList nodesHijos = padre.getChildNodes();
        int i = 0;
        while (i < nodesHijos.getLength()) {
            Node nodo = nodesHijos.item(i);
            if (nodo.getNodeType() == 1) {
                if (tope != null && tope.isEqualNode(nodo)) break;
                if (nombreHijos.indexOf(new NombreNodo(nodo.getNamespaceURI(), nodo.getLocalName())) != -1) {
                    resultado.add((Element)nodo);
                }
            }
            ++i;
        }
        return resultado;
    }

    public static byte[] obtenerByteNuevo(ArrayList<Element> nodos, CanonicalizationEnum canonicalization) throws FirmaXMLError {
        if (nodos == null || nodos.size() == 0) {
            return null;
        }
        if (canonicalization == null || canonicalization.equals((Object)CanonicalizationEnum.UNKNOWN)) {
            return null;
        }
        ByteArrayOutputStream bais = new ByteArrayOutputStream();
        for (Element nodo : nodos) {
            try {
                bais.write(UtilidadTratarNodo.obtenerByte(nodo, canonicalization));
            }
            catch (IOException ex) {
                log.error((Object)I18n.getResource("libreriaxades.firmaxml.error34"), (Throwable)ex);
                throw new FirmaXMLError(I18n.getResource("libreriaxades.firmaxml.error8"));
            }
        }
        if (bais.size() > 0) {
            return bais.toByteArray();
        }
        return null;
    }

    public static byte[] obtenerByte(Element nodo, CanonicalizationEnum canonicalization) throws FirmaXMLError {
        if (nodo == null) {
            return null;
        }
        if (canonicalization == null || canonicalization.equals((Object)CanonicalizationEnum.UNKNOWN)) {
            return null;
        }
        Transforms t = new Transforms(nodo.getOwnerDocument());
        try {
            t.addTransform(canonicalization.toString());
        }
        catch (TransformationException e) {
            log.error((Object)e);
            throw new FirmaXMLError(I18n.getResource("libreriaxades.firmaxml.error8"));
        }
        XMLSignatureInput xmlSignatureInput = new XMLSignatureInput((Node)nodo);
        try {
            XMLSignatureInput resultado = null;
            resultado = t.performTransforms(xmlSignatureInput);
            return resultado.getBytes();
        }
        catch (TransformationException ex) {
            log.error((Object)I18n.getResource("libreriaxades.firmaxml.error34"), (Throwable)ex);
            throw new FirmaXMLError(I18n.getResource("libreriaxades.firmaxml.error8"));
        }
        catch (CanonicalizationException ex) {
            log.error((Object)I18n.getResource("libreriaxades.firmaxml.error34"), (Throwable)ex);
            throw new FirmaXMLError(I18n.getResource("libreriaxades.firmaxml.error8"));
        }
        catch (IOException ex) {
            log.error((Object)I18n.getResource("libreriaxades.firmaxml.error34"), (Throwable)ex);
            throw new FirmaXMLError(I18n.getResource("libreriaxades.firmaxml.error8"));
        }
    }

    public static byte[] obtenerByte(ArrayList<Element> nodos, CanonicalizationEnum canonicalization) throws FirmaXMLError {
        if (nodos == null || nodos.size() == 0) {
            return null;
        }
        if (canonicalization == null || canonicalization.equals((Object)CanonicalizationEnum.UNKNOWN)) {
            return null;
        }
        Transforms t = new Transforms(nodos.get(0).getOwnerDocument());
        try {
            t.addTransform(canonicalization.toString());
        }
        catch (TransformationException e) {
            log.error((Object)e);
            throw new FirmaXMLError(I18n.getResource("libreriaxades.firmaxml.error8"));
        }
        ByteArrayOutputStream bais = new ByteArrayOutputStream();
        for (Element nodo : nodos) {
            XMLSignatureInput xmlSignatureInput = new XMLSignatureInput((Node)nodo);
            try {
                XMLSignatureInput resultado = null;
                resultado = t.performTransforms(xmlSignatureInput);
                bais.write(resultado.getBytes());
            }
            catch (TransformationException ex) {
                log.error((Object)I18n.getResource("libreriaxades.firmaxml.error34"), (Throwable)ex);
                throw new FirmaXMLError(I18n.getResource("libreriaxades.firmaxml.error8"));
            }
            catch (CanonicalizationException ex) {
                log.error((Object)I18n.getResource("libreriaxades.firmaxml.error34"), (Throwable)ex);
                throw new FirmaXMLError(I18n.getResource("libreriaxades.firmaxml.error8"));
            }
            catch (IOException ex) {
                log.error((Object)I18n.getResource("libreriaxades.firmaxml.error34"), (Throwable)ex);
                throw new FirmaXMLError(I18n.getResource("libreriaxades.firmaxml.error8"));
            }
        }
        if (bais.size() > 0) {
            return bais.toByteArray();
        }
        return null;
    }

    public static String obtenerNombreNodo(Node node) {
        String nombreNodoConNS = node.getNodeName();
        int iPosNombreNodo = nombreNodoConNS.lastIndexOf(":") + 1;
        String nombreNodo = nombreNodoConNS.substring(iPosNombreNodo);
        return nombreNodo;
    }

    public static ArrayList<String> obtenerIDs(ArrayList<Element> elementos) {
        if (elementos == null) {
            return null;
        }
        ArrayList<String> resultado = new ArrayList<String>();
        block0: for (Element elemento : elementos) {
            boolean encontrado = false;
            NamedNodeMap map = elemento.getAttributes();
            int i = 0;
            while (i < map.getLength()) {
                Attr attr = (Attr)map.item(i);
                if (attr.isId()) {
                    resultado.add(attr.getValue());
                    encontrado = true;
                    break;
                }
                ++i;
            }
            if (encontrado) continue;
            i = 0;
            while (i < IDs.length) {
                if (elemento.hasAttribute(IDs[i])) {
                    resultado.add(elemento.getAttribute(IDs[i]));
                    continue block0;
                }
                ++i;
            }
        }
        return resultado;
    }

    public static String getId(Element element) {
        String id = element.getAttribute("Id");
        if (id == null) {
            NamedNodeMap map = element.getAttributes();
            int i = 0;
            while (i < map.getLength()) {
                Attr attr = (Attr)map.item(i);
                if (attr.isId()) {
                    id = attr.getValue();
                    break;
                }
                ++i;
            }
        }
        return id;
    }

    public static Element getElementById(NodeList list, String id) {
        Element resultado = null;
        if (list != null) {
            int length = list.getLength();
            int i = 0;
            while (i < length) {
                Element el;
                Node node = list.item(i);
                if (node.getNodeType() == 1 && id.equals((el = (Element)node).getAttribute("Id"))) {
                    resultado = el;
                    break;
                }
                ++i;
            }
        }
        return resultado;
    }

    private static Element exploreElementById(Element el, String id) {
        if (el != null) {
            int i = 0;
            while (i < IDs.length) {
                if (id.equals(el.getAttribute(IDs[i]))) {
                    return el;
                }
                ++i;
            }
            NodeList nodes = el.getChildNodes();
            int i2 = 0;
            while (i2 < nodes.getLength()) {
                Element temp;
                Node nodo = nodes.item(i2);
                if (nodo.getNodeType() == 1 && (temp = UtilidadTratarNodo.exploreElementById((Element)nodo, id)) != null) {
                    return temp;
                }
                ++i2;
            }
        }
        return null;
    }

    public static Element getElementById(Document doc, String id) {
        if (doc == null || id == null) {
            return null;
        }
        if (id.length() == 0) {
            return doc.getDocumentElement();
        }
        id = id != null ? (id.startsWith("#") ? (id.startsWith(XPOINTER_ID) ? id.substring(XPOINTER_ID.length(), id.length() - 2) : id.substring(1)) : id) : null;
        Element el = doc.getElementById(id);
        if (el == null) {
            el = UtilidadTratarNodo.exploreElementById(doc.getDocumentElement(), id);
        }
        return el;
    }

    public static Element getElementById(Element padre, String id) {
        Element el = UtilidadTratarNodo.getElementById(padre.getOwnerDocument(), id);
        if (el != null) {
            Node temp = el;
            while (temp != null && !temp.isSameNode(padre)) {
                temp = temp.getParentNode();
            }
            if (temp != null) {
                return el;
            }
        }
        return null;
    }

    public static boolean isChildNode(Element child, Element parent) {
        Node temp = child;
        while (temp != null && !temp.isSameNode(parent)) {
            temp = temp.getParentNode();
        }
        return temp != null;
    }

    public static boolean isChildNode(Element child, NombreNodo parent, Element top) {
        Node temp = child;
        while (temp != null && !temp.isSameNode(top)) {
            if (parent.equals(temp)) break;
            temp = temp.getParentNode();
        }
        return parent.equals(temp);
    }

    public static String newID(Document doc, String prefix) {
        String newID = String.valueOf(prefix) + rnd.nextInt(0x100000);
        while (UtilidadTratarNodo.getElementById(doc, newID) != null) {
            newID = String.valueOf(prefix) + rnd.nextInt(0x100000);
        }
        return newID;
    }

    public static Element getFirstElementChild(Node node, boolean strict) {
        Node nodeTemp = node.getFirstChild();
        while (nodeTemp != null && nodeTemp.getNodeType() != 1) {
            if (strict && nodeTemp.getNodeType() == 3) {
                String text = nodeTemp.getNodeValue().trim();
                text = text.replaceAll("/n", "");
                text = text.replaceAll("/r", "");
                if (!(text = text.replaceAll(" ", "")).equals("")) {
                    return null;
                }
            }
            nodeTemp = nodeTemp.getNextSibling();
        }
        return (Element)nodeTemp;
    }

    public static Element getNextElementSibling(Node node, boolean strict) {
        Node nodeTemp = node.getNextSibling();
        while (nodeTemp != null && nodeTemp.getNodeType() != 1) {
            if (strict && nodeTemp.getNodeType() == 3) {
                String text = nodeTemp.getNodeValue().trim();
                text = text.replaceAll("/n", "");
                text = text.replaceAll("/r", "");
                if (!(text = text.replaceAll(" ", "")).equals("")) {
                    return null;
                }
            }
            nodeTemp = nodeTemp.getNextSibling();
        }
        return (Element)nodeTemp;
    }

    public static ArrayList<Element> getElementChildNodes(Element nodo, boolean strict) {
        ArrayList<Element> retorno = new ArrayList<Element>();
        Element hijo = UtilidadTratarNodo.getFirstElementChild(nodo, strict);
        int tope = nodo.getChildNodes().getLength();
        int i = 0;
        while (i < tope) {
            if (hijo == null) break;
            retorno.add(hijo);
            hijo = UtilidadTratarNodo.getNextElementSibling(hijo, strict);
            ++i;
        }
        return retorno;
    }

    public static ArrayList<Element> obtenerNodos(Element padre, int tope, NombreNodo nombreHijos) throws FirmaXMLError {
        ArrayList<Element> resultado = new ArrayList<Element>();
        NodeList nodesHijos = padre.getChildNodes();
        if (tope < 1) {
            tope = 1;
        }
        int i = 0;
        while (i < nodesHijos.getLength()) {
            Node nodo = nodesHijos.item(i);
            if (nodo.getNodeType() == 1) {
                ArrayList<Element> hijos;
                if (nombreHijos.equals(new NombreNodo(nodo.getNamespaceURI(), nodo.getLocalName()))) {
                    resultado.add((Element)nodo);
                }
                if (tope > 1 && (hijos = UtilidadTratarNodo.obtenerNodos((Element)nodo, tope - 1, nombreHijos)).size() > 0) {
                    resultado.addAll(hijos);
                }
            }
            ++i;
        }
        return resultado;
    }

    public static ArrayList<Element> obtenerNodos(Element padre, int tope, String nombreHijos) throws FirmaXMLError {
        ArrayList<Element> resultado = new ArrayList<Element>();
        NodeList nodesHijos = padre.getChildNodes();
        if (tope < 1) {
            tope = 1;
        }
        int i = 0;
        while (i < nodesHijos.getLength()) {
            Node nodo = nodesHijos.item(i);
            if (nodo.getNodeType() == 1) {
                if (nombreHijos.equals(nodo.getLocalName())) {
                    resultado.add((Element)nodo);
                }
                if (tope > 1) {
                    NodeList nodosHijos2 = nodo.getChildNodes();
                    int j = 0;
                    while (j < nodosHijos2.getLength()) {
                        Node nodo2 = nodosHijos2.item(j);
                        if (nodo2.getNodeType() == 1) {
                            if (nombreHijos.equals(nodo2.getLocalName())) {
                                resultado.add((Element)nodo2);
                            }
                            if (tope > 2) {
                                NodeList nodosHijos3 = nodo2.getChildNodes();
                                int k = 0;
                                while (k < nodosHijos3.getLength()) {
                                    Node nodo3 = nodosHijos3.item(k);
                                    if (nodo3.getNodeType() == 1) {
                                        if (nombreHijos.equals(nodo3.getLocalName())) {
                                            resultado.add((Element)nodo3);
                                        }
                                        if (tope > 3) {
                                            NodeList nodosHijos4 = nodo3.getChildNodes();
                                            int l = 0;
                                            while (l < nodosHijos4.getLength()) {
                                                Node nodo4 = nodosHijos4.item(l);
                                                if (nodo4.getNodeType() == 1) {
                                                    if (nombreHijos.equals(nodo4.getLocalName())) {
                                                        resultado.add((Element)nodo4);
                                                    }
                                                    if (tope > 4) {
                                                        NodeList nodosHijos5 = nodo4.getChildNodes();
                                                        int m = 0;
                                                        while (m < nodosHijos5.getLength()) {
                                                            Node nodo5 = nodosHijos5.item(m);
                                                            if (nodo5.getNodeType() == 1 && nombreHijos.equals(nodo5.getLocalName())) {
                                                                resultado.add((Element)nodo5);
                                                            }
                                                            ++m;
                                                        }
                                                    }
                                                }
                                                ++l;
                                            }
                                        }
                                    }
                                    ++k;
                                }
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        return resultado;
    }

    public static void saveDocumentToOutputStream(Document document, OutputStream outputStream) {
        UtilidadFicheros.writeXML(document, outputStream);
    }

    public static void saveDocumentToOutputStream(Document document, OutputStream outputStream, boolean addPreamble) {
        UtilidadFicheros.writeXML(document, outputStream);
    }
}

