/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.libreria.xades;

import adsi.org.apache.xml.security.Init;
import adsi.org.apache.xml.security.algorithms.MessageDigestAlgorithm;
import adsi.org.apache.xml.security.exceptions.XMLSecurityException;
import adsi.org.apache.xml.security.signature.Reference;
import adsi.org.apache.xml.security.signature.SignedInfo;
import adsi.org.apache.xml.security.signature.XMLSignature;
import adsi.org.apache.xml.security.signature.XMLSignatureException;
import adsi.org.apache.xml.security.signature.XMLSignatureInput;
import adsi.org.apache.xml.security.transforms.Transforms;
import adsi.org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import com.sun.org.apache.xerces.internal.impl.io.MalformedByteSequenceException;
import es.mityc.firmaJava.libreria.utilidades.Base64;
import es.mityc.firmaJava.libreria.utilidades.Base64Coder;
import es.mityc.firmaJava.libreria.utilidades.I18n;
import es.mityc.firmaJava.libreria.utilidades.NombreNodo;
import es.mityc.firmaJava.libreria.utilidades.URIEncoder;
import es.mityc.firmaJava.libreria.utilidades.UtilidadCertificados;
import es.mityc.firmaJava.libreria.utilidades.UtilidadFechas;
import es.mityc.firmaJava.libreria.utilidades.UtilidadFicheros;
import es.mityc.firmaJava.libreria.utilidades.UtilidadFirmaElectronica;
import es.mityc.firmaJava.libreria.utilidades.UtilidadTratarNodo;
import es.mityc.firmaJava.libreria.utilidades.Utilidades;
import es.mityc.firmaJava.libreria.xades.CanonicalizationEnum;
import es.mityc.firmaJava.libreria.xades.DatosCRL;
import es.mityc.firmaJava.libreria.xades.DatosFirma;
import es.mityc.firmaJava.libreria.xades.DatosNodosFirmados;
import es.mityc.firmaJava.libreria.xades.DatosOCSP;
import es.mityc.firmaJava.libreria.xades.DatosSelloTiempo;
import es.mityc.firmaJava.libreria.xades.DatosTipoFirma;
import es.mityc.firmaJava.libreria.xades.DatosX509;
import es.mityc.firmaJava.libreria.xades.ExtraValidators;
import es.mityc.firmaJava.libreria.xades.ResultadoEnum;
import es.mityc.firmaJava.libreria.xades.ResultadoValidacion;
import es.mityc.firmaJava.libreria.xades.TipoSellosTiempo;
import es.mityc.firmaJava.libreria.xades.UtilidadXadesA;
import es.mityc.firmaJava.libreria.xades.UtilidadXadesX;
import es.mityc.firmaJava.libreria.xades.XAdESSchemas;
import es.mityc.firmaJava.libreria.xades.elementos.xades.Cert;
import es.mityc.firmaJava.libreria.xades.elementos.xades.CertificateValues;
import es.mityc.firmaJava.libreria.xades.elementos.xades.DataObjectFormat;
import es.mityc.firmaJava.libreria.xades.elementos.xades.EncapsulatedX509Certificate;
import es.mityc.firmaJava.libreria.xades.elementos.xades.EncodingEnum;
import es.mityc.firmaJava.libreria.xades.elementos.xades.SignaturePolicyIdentifier;
import es.mityc.firmaJava.libreria.xades.elementos.xades.SigningTime;
import es.mityc.firmaJava.libreria.xades.errores.BadFormedSignatureException;
import es.mityc.firmaJava.libreria.xades.errores.FirmaXMLError;
import es.mityc.firmaJava.libreria.xades.errores.InvalidInfoNodeException;
import es.mityc.firmaJava.libreria.xades.logv;
import es.mityc.firmaJava.ocsp.RespuestaOCSP;
import es.mityc.firmaJava.trust.ConfianzaEnum;
import es.mityc.javasign.EnumFormatoFirma;
import es.mityc.javasign.asn1.ASN1Utils;
import es.mityc.javasign.certificate.CertStatusException;
import es.mityc.javasign.certificate.ElementNotFoundException;
import es.mityc.javasign.certificate.ICertStatus;
import es.mityc.javasign.certificate.ICertStatusRecoverer;
import es.mityc.javasign.certificate.IOCSPCertStatus;
import es.mityc.javasign.certificate.IRecoverElements;
import es.mityc.javasign.certificate.OCSPResponderID;
import es.mityc.javasign.certificate.RevokedInfo;
import es.mityc.javasign.certificate.UnknownElementClassException;
import es.mityc.javasign.certificate.ocsp.OCSPStatus;
import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.trust.NotTrustedException;
import es.mityc.javasign.trust.TrustAbstract;
import es.mityc.javasign.trust.TrustException;
import es.mityc.javasign.trust.UnknownTrustException;
import es.mityc.javasign.ts.TSPAlgoritmos;
import es.mityc.javasign.ts.TimeStampValidator;
import es.mityc.javasign.tsa.ITimeStampValidator;
import es.mityc.javasign.tsa.TSValidationResult;
import es.mityc.javasign.tsa.TimeStampException;
import es.mityc.javasign.utils.Utils;
import es.mityc.javasign.xml.resolvers.IPrivateData;
import es.mityc.javasign.xml.resolvers.IResourceData;
import es.mityc.javasign.xml.resolvers.MITyCResourceResolver;
import es.mityc.javasign.xml.resolvers.ResolverPrivateData;
import es.mityc.javasign.xml.resolvers.XAdESResourceResolverSpi;
import es.mityc.javasign.xml.xades.LocalFileStoreElements;
import es.mityc.javasign.xml.xades.ReferenceProxy;
import es.mityc.javasign.xml.xades.policy.IValidacionPolicy;
import es.mityc.javasign.xml.xades.policy.PoliciesManager;
import es.mityc.javasign.xml.xades.policy.PolicyResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.security.NoSuchProviderException;
import java.security.Security;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.ResponderID;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.ocsp.BasicOCSPResp;
import org.bouncycastle.ocsp.CertificateID;
import org.bouncycastle.ocsp.CertificateStatus;
import org.bouncycastle.ocsp.OCSPException;
import org.bouncycastle.ocsp.OCSPResp;
import org.bouncycastle.ocsp.RevokedStatus;
import org.bouncycastle.ocsp.SingleResp;
import org.bouncycastle.ocsp.UnknownStatus;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampToken;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ValidarFirmaXML {
    private List<String> esquemasParaValidar = new LinkedList<String>();
    private boolean esValido = false;
    private ResultadoValidacion resultado = new ResultadoValidacion();
    private DatosFirma datosFirma = null;
    private ArrayList<DatosSelloTiempo> arrayDatosSello = null;
    private ArrayList<DatosCRL> arrayDatosCRL = null;
    private ArrayList<DatosOCSP> arrayDatosOCSP = null;
    private ArrayList<PolicyResult> politicas = new ArrayList();
    private ArrayList<X509Certificate> cadenaCertificados = new ArrayList();
    private ArrayList<String> firmados = null;
    private DatosTipoFirma tipoDocFirma = null;
    private String uriXmlNS = null;
    private String nombreNodoUri = "Include";
    private String tipoUri = "URI";
    private static final Log LOGGER = LogFactory.getLog(ValidarFirmaXML.class);
    private static final II18nManager i18n = I18nFactory.getI18nManager((String)"MITyCLibXAdES");
    private IRecoverElements recoverManager = null;
    private ArrayList<ResourceResolverSpi> resolvers = null;
    private ITimeStampValidator tsValidator = null;
    private TrustAbstract truster = null;
    private static final String TSA_REVOCKED = "i18n.mityc.xades.validate.tsa.error.1";
    private static final String TSA_REVOCKED_NO_DATE = "i18n.mityc.xades.validate.tsa.error.2";
    private static final String OCSP_REVOCKED = "i18n.mityc.xades.validate.ocsp.error.1";
    private static final String OCSP_REVOCKED_NO_DATE = "i18n.mityc.xades.validate.ocsp.error.2";

    public ValidarFirmaXML() {
        this.setXAdESSchema(XAdESSchemas.XAdES_111, true);
        this.setXAdESSchema(XAdESSchemas.XAdES_122, true);
        this.setXAdESSchema(XAdESSchemas.XAdES_132, true);
        this.setXAdESSchema(XAdESSchemas.XMLDSIG, true);
    }

    public void setRecoverElements(IRecoverElements recoverManager) {
        this.recoverManager = recoverManager;
    }

    public void addResolver(IPrivateData resolver) {
        this.addResolver(new ResolverPrivateData(resolver));
    }

    public void addResolver(MITyCResourceResolver resolver) {
        if (this.resolvers == null) {
            this.resolvers = new ArrayList();
        }
        this.resolvers.add(resolver);
    }

    public void addResolver(IResourceData resolver) {
        this.addResolver(new XAdESResourceResolverSpi(resolver));
    }

    public List<ResultadoValidacion> validar(File firmaParaValidar, ExtraValidators validators, ITimeStampValidator tsValidator) throws FirmaXMLError {
        List<ResultadoValidacion> rs;
        FirmaXMLError excepcion;
        block14: {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(firmaParaValidar);
            }
            catch (FileNotFoundException e) {
                LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error58"));
                return null;
            }
            excepcion = null;
            rs = null;
            try {
                try {
                    rs = this.validar(fis, firmaParaValidar.getParentFile().toURI().toString(), validators, tsValidator);
                }
                catch (FirmaXMLError ex) {
                    excepcion = ex;
                    try {
                        fis.close();
                    }
                    catch (Exception exception) {}
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    fis.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                fis.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (excepcion != null) {
            throw excepcion;
        }
        return rs;
    }

    public List<ResultadoValidacion> validar(byte[] bFirmaParaValidar, ExtraValidators validators, ITimeStampValidator tsValidator) throws FirmaXMLError {
        LOGGER.debug((Object)(String.valueOf(I18n.getResource("libreriaxades.validarfirmaxml.info2")) + " " + System.getProperty("user.dir")));
        File dir = new File(System.getProperty("user.dir"));
        return this.validar(bFirmaParaValidar, dir.toURI().toString(), validators, tsValidator);
    }

    public List<ResultadoValidacion> validar(byte[] bFirmaParaValidar, String baseUri, ExtraValidators validators, ITimeStampValidator tsValidator) throws FirmaXMLError {
        ByteArrayInputStream bis = null;
        bis = new ByteArrayInputStream(bFirmaParaValidar);
        return this.validar(bis, baseUri, validators, tsValidator);
    }

    public List<ResultadoValidacion> validar(InputStream inputFirmaParaValidar, String baseUri, ExtraValidators validators, ITimeStampValidator tsValidator) throws FirmaXMLError {
        ICertStatusRecoverer certStatus;
        Document doc;
        InputSource isour;
        DocumentBuilder db;
        DocumentBuilderFactory dbf;
        block75: {
            if (this.recoverManager == null) {
                this.recoverManager = new LocalFileStoreElements(baseUri);
            }
            dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            db = null;
            try {
                db = dbf.newDocumentBuilder();
            }
            catch (ParserConfigurationException e1) {
                this.mostrarErrorValidacion(e1);
            }
            isour = null;
            doc = null;
            ByteArrayOutputStream baosLeido = null;
            byte[] cabecera = new byte[10];
            int length = 0;
            try {
                length = inputFirmaParaValidar.available();
                baosLeido = new ByteArrayOutputStream(length);
                int j = inputFirmaParaValidar.read(cabecera);
                baosLeido.write(cabecera, 0, j);
                baosLeido.flush();
                int i = j;
                byte[] buffer = new byte[4096];
                while (i < length) {
                    j = inputFirmaParaValidar.read(buffer);
                    baosLeido.write(buffer, 0, j);
                    baosLeido.flush();
                    i += j;
                }
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.debug((Object)baosLeido);
                }
                isour = new InputSource(new ByteArrayInputStream(baosLeido.toByteArray()));
                doc = db.parse(isour);
            }
            catch (FileNotFoundException e1) {
                this.mostrarErrorValidacion(e1);
            }
            catch (SAXException e1) {
                block76: {
                    try {
                        byte[] utf8BOM = new byte[]{-17, -69, -65};
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)("Buscando BOM de XML. Buffer le\u00eddo = " + cabecera[0] + " " + cabecera[1] + " " + cabecera[2]));
                        }
                        if (cabecera != null && cabecera.length > 0 && cabecera[0] == utf8BOM[0] && cabecera[1] == utf8BOM[1] && cabecera[2] == utf8BOM[2]) {
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug((Object)"Encontrado BOM de XML. Parseando documento...");
                            }
                            doc = db.parse(new ByteArrayInputStream(baosLeido.toByteArray(), 3, length));
                        } else {
                            byte[] utf8BOMNotUTF8 = new byte[]{-61, -81, -62, -69, -62, -65};
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug((Object)("Buscando BOM no UTF8 de XML. Buffer = " + new String(cabecera) + "\n Buffer le\u00eddo = " + cabecera[0] + " " + cabecera[1] + " " + cabecera[2] + " " + cabecera[3] + " " + cabecera[4] + " " + cabecera[5]));
                            }
                            if (cabecera != null && cabecera.length > 0 && (cabecera[0] == utf8BOMNotUTF8[0] && cabecera[1] == utf8BOMNotUTF8[1] && cabecera[2] == utf8BOMNotUTF8[2] && cabecera[3] == utf8BOMNotUTF8[3] && cabecera[4] == utf8BOMNotUTF8[4] && cabecera[5] == utf8BOMNotUTF8[5] || new String(cabecera).startsWith(new String(utf8BOMNotUTF8)))) {
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug((Object)"Encontrado BOM no UTF8 de XML. Parseando documento...");
                                }
                                doc = db.parse(new ByteArrayInputStream(baosLeido.toByteArray(), 6, length));
                            } else {
                                this.mostrarErrorValidacion(e1);
                            }
                        }
                    }
                    catch (IOException e) {
                        this.mostrarErrorValidacion(e1);
                        if (inputFirmaParaValidar != null) {
                            try {
                                inputFirmaParaValidar.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        if (baosLeido != null) {
                            try {
                                baosLeido.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block75;
                    }
                    catch (SAXException e) {
                        try {
                            this.mostrarErrorValidacion(e1);
                            break block75;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            if (inputFirmaParaValidar != null) {
                                try {
                                    inputFirmaParaValidar.close();
                                }
                                catch (IOException iOException) {}
                            }
                            if (baosLeido != null) {
                                try {
                                    baosLeido.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                    }
                    if (inputFirmaParaValidar == null) break block76;
                    try {
                        inputFirmaParaValidar.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (baosLeido != null) {
                    try {
                        baosLeido.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (MalformedByteSequenceException me) {
                LOGGER.debug((Object)(String.valueOf(I18n.getResource("libreriaxades.validarfirmaxml.error28")) + " - " + me.getMessage()));
            }
            catch (IOException e1) {
                this.mostrarErrorValidacion(e1);
            }
        }
        dbf = null;
        isour = null;
        db = null;
        ArrayList<ResultadoValidacion> res = this.validar(doc, baseUri, validators, tsValidator);
        ICertStatusRecoverer iCertStatusRecoverer = certStatus = validators != null ? validators.getCertStatus() : null;
        if (res != null && res.size() > 0 && validators != null) {
            TrustAbstract trusterCerts = validators.getTrusterCerts();
            TrustAbstract trusterOCSP = validators.getTrusterOCSP();
            TrustAbstract trusterCRL = validators.getTrusterCRL();
            TrustAbstract trusterTSA = validators.getTrusterTSA();
            ICertStatus status = null;
            ICertStatus.CERT_STATUS statusRes = ICertStatus.CERT_STATUS.unknown;
            if (trusterCerts != null || trusterOCSP != null || trusterCRL != null || trusterTSA != null) {
                for (ResultadoValidacion rv : res) {
                    ArrayList<DatosSelloTiempo> tsas;
                    ArrayList<DatosOCSP> ocsps;
                    DatosFirma df;
                    if (rv == null || (df = rv.getDatosFirma()) == null) continue;
                    if (trusterCerts != null) {
                        status = rv.getCertStatus();
                        if (status != null) {
                            statusRes = status.getStatus();
                        }
                        if (!ICertStatus.CERT_STATUS.unknown.equals((Object)statusRes)) {
                            df.setEsCadenaConfianza(ConfianzaEnum.CON_CONFIANZA);
                        } else {
                            this.validateTrustCerts(trusterCerts, df);
                        }
                    }
                    if (trusterOCSP != null && (ocsps = df.getDatosOCSP()) != null && ocsps.size() > 0) {
                        if (df.getTipoFirma().getTipoXAdES().compareTo((Enum)EnumFormatoFirma.XAdES_X) >= 0) {
                            this.validateTrustOCSP(trusterOCSP, df);
                        } else {
                            for (DatosOCSP docsp : ocsps) {
                                OCSPResp ocspr = docsp.getRespuestaOCSP();
                                if (ocspr == null) continue;
                                try {
                                    status = certStatus.getCertStatus(docsp.getCertOCSPResponder()[0]);
                                    if (status != null) {
                                        statusRes = status.getStatus();
                                    }
                                }
                                catch (Exception e) {
                                    statusRes = ICertStatus.CERT_STATUS.unknown;
                                }
                                docsp.setRevockedStatus(statusRes);
                                docsp.setStatus(status);
                                if (ICertStatus.CERT_STATUS.unknown.equals((Object)statusRes)) {
                                    this.validateTrustOCSP(trusterOCSP, df);
                                    continue;
                                }
                                if (ICertStatus.CERT_STATUS.revoked.equals((Object)statusRes)) {
                                    docsp.setEsCertConfianza(ConfianzaEnum.CON_CONFIANZA);
                                    rv.setValidate(false);
                                    rv.setResultado(ResultadoEnum.INVALID);
                                    RevokedInfo ri = status.getRevokedInfo();
                                    Date revoked = null;
                                    if (ri != null) {
                                        revoked = ri.getRevokedDate();
                                    }
                                    if (revoked != null) {
                                        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
                                        rv.setLog(i18n.getLocalMessage(OCSP_REVOCKED, new Object[]{formatter.format(revoked)}));
                                        LOGGER.info((Object)i18n.getLocalMessage(OCSP_REVOCKED, new Object[]{formatter.format(revoked)}));
                                        logv.error(i18n.getLocalMessage(OCSP_REVOCKED, new Object[]{formatter.format(revoked)}));
                                        continue;
                                    }
                                    rv.setLog(i18n.getLocalMessage(OCSP_REVOCKED_NO_DATE));
                                    LOGGER.info((Object)i18n.getLocalMessage(OCSP_REVOCKED_NO_DATE));
                                    logv.error(i18n.getLocalMessage(OCSP_REVOCKED_NO_DATE));
                                    continue;
                                }
                                docsp.setEsCertConfianza(ConfianzaEnum.CON_CONFIANZA);
                            }
                        }
                    }
                    if (trusterCRL != null) {
                        this.validateTrustCRL(trusterCRL, df);
                    }
                    if (trusterTSA == null || (tsas = df.getDatosSelloTiempo()) == null || tsas.size() <= 0) continue;
                    Iterator<DatosSelloTiempo> itTsas = tsas.iterator();
                    this.validateTrustTSA(trusterTSA, df);
                    while (itTsas.hasNext()) {
                        DatosSelloTiempo dst = itTsas.next();
                        if (df.getTipoFirma().getTipoXAdES().compareTo((Enum)EnumFormatoFirma.XAdES_X) >= 0 && itTsas.hasNext() || dst.esCertConfianza().equals((Object)ConfianzaEnum.SIN_CONFIANZA)) continue;
                        byte[] rawTimestamp = dst.getRawTimestamp();
                        X509Certificate tsaCert = null;
                        try {
                            Certificate cert;
                            TimeStampToken tst = new TimeStampToken(new CMSSignedData(rawTimestamp));
                            CertStore cs = tst.getCertificatesAndCRLs("Collection", null);
                            Collection<? extends Certificate> certs = cs.getCertificates(null);
                            if (certs.size() > 0 && (cert = certs.iterator().next()) instanceof X509Certificate) {
                                tsaCert = (X509Certificate)cert;
                            }
                        }
                        catch (Exception tst) {
                            // empty catch block
                        }
                        try {
                            status = certStatus.getCertStatus(tsaCert);
                            if (status != null) {
                                statusRes = status.getStatus();
                            }
                        }
                        catch (Exception e) {
                            statusRes = ICertStatus.CERT_STATUS.unknown;
                        }
                        dst.setRevockedStatus(statusRes);
                        if (ICertStatus.CERT_STATUS.unknown.equals((Object)statusRes)) continue;
                        if (ICertStatus.CERT_STATUS.revoked.equals((Object)statusRes)) {
                            dst.setEsCertConfianza(ConfianzaEnum.CON_CONFIANZA);
                            rv.setValidate(false);
                            rv.setResultado(ResultadoEnum.UNKNOWN);
                            RevokedInfo ri = status.getRevokedInfo();
                            Date revoked = null;
                            if (ri != null) {
                                revoked = ri.getRevokedDate();
                            }
                            if (revoked != null) {
                                SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
                                rv.setLog(i18n.getLocalMessage(TSA_REVOCKED, new Object[]{formatter.format(revoked)}));
                                LOGGER.info((Object)i18n.getLocalMessage(TSA_REVOCKED, new Object[]{formatter.format(revoked)}));
                                logv.error(i18n.getLocalMessage(TSA_REVOCKED, new Object[]{formatter.format(revoked)}));
                                continue;
                            }
                            rv.setLog(i18n.getLocalMessage(TSA_REVOCKED_NO_DATE));
                            LOGGER.info((Object)i18n.getLocalMessage(TSA_REVOCKED_NO_DATE));
                            logv.error(i18n.getLocalMessage(TSA_REVOCKED_NO_DATE));
                            continue;
                        }
                        dst.setEsCertConfianza(ConfianzaEnum.CON_CONFIANZA);
                    }
                }
            }
        }
        return res;
    }

    private void validateTrustCerts(TrustAbstract truster, DatosFirma df) {
        block4: {
            try {
                truster.isTrusted((Object)df.getCadenaFirma());
                df.setEsCadenaConfianza(ConfianzaEnum.CON_CONFIANZA);
            }
            catch (NotTrustedException ex) {
                df.setEsCadenaConfianza(ConfianzaEnum.SIN_CONFIANZA);
            }
            catch (UnknownTrustException ex) {
                df.setEsCadenaConfianza(ConfianzaEnum.NO_REVISADO);
            }
            catch (TrustException ex) {
                df.setEsCadenaConfianza(ConfianzaEnum.NO_REVISADO);
                LOGGER.error((Object)i18n.getLocalMessage("i18n.mityc.xades.validate.trust.1", new Object[]{ex.getMessage()}));
                if (!LOGGER.isDebugEnabled()) break block4;
                LOGGER.debug((Object)"", (Throwable)ex);
            }
        }
    }

    private void validateTrustOCSP(TrustAbstract truster, DatosFirma df) {
        ArrayList<DatosOCSP> ocsps = df.getDatosOCSP();
        if (ocsps != null && ocsps.size() > 0) {
            for (DatosOCSP docsp : ocsps) {
                OCSPResp ocspr = docsp.getRespuestaOCSP();
                if (ocspr == null) continue;
                try {
                    truster.isTrusted((Object)ocspr);
                    docsp.setEsCertConfianza(ConfianzaEnum.CON_CONFIANZA);
                }
                catch (NotTrustedException ex) {
                    docsp.setEsCertConfianza(ConfianzaEnum.SIN_CONFIANZA);
                }
                catch (UnknownTrustException ex) {
                    docsp.setEsCertConfianza(ConfianzaEnum.NO_REVISADO);
                }
                catch (TrustException ex) {
                    docsp.setEsCertConfianza(ConfianzaEnum.NO_REVISADO);
                    LOGGER.error((Object)i18n.getLocalMessage("i18n.mityc.xades.validate.trust.2", new Object[]{ex.getMessage()}));
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug((Object)"", (Throwable)ex);
                }
            }
        }
    }

    private void validateTrustCRL(TrustAbstract truster, DatosFirma df) {
        ArrayList<DatosCRL> crls = df.getDatosCRL();
        if (crls != null && crls.size() > 0) {
            for (DatosCRL dcrl : crls) {
                X509CRL crl = dcrl.getX509CRL();
                if (crl == null) continue;
                try {
                    truster.isTrusted((Object)crl);
                    dcrl.setEsCertConfianza(ConfianzaEnum.CON_CONFIANZA);
                }
                catch (NotTrustedException ex) {
                    dcrl.setEsCertConfianza(ConfianzaEnum.SIN_CONFIANZA);
                }
                catch (UnknownTrustException ex) {
                    dcrl.setEsCertConfianza(ConfianzaEnum.NO_REVISADO);
                }
                catch (TrustException ex) {
                    dcrl.setEsCertConfianza(ConfianzaEnum.NO_REVISADO);
                    LOGGER.error((Object)i18n.getLocalMessage("i18n.mityc.xades.validate.trust.3", new Object[]{ex.getMessage()}));
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug((Object)"", (Throwable)ex);
                }
            }
        }
    }

    private void validateTrustTSA(TrustAbstract truster, DatosFirma df) {
        ArrayList<DatosSelloTiempo> tsts = df.getDatosSelloTiempo();
        if (tsts != null && tsts.size() > 0) {
            for (DatosSelloTiempo dst : tsts) {
                byte[] rawTimestamp = dst.getRawTimestamp();
                try {
                    TimeStampToken tst = new TimeStampToken(new CMSSignedData(rawTimestamp));
                    try {
                        truster.isTrusted((Object)tst);
                        dst.setEsCertConfianza(ConfianzaEnum.CON_CONFIANZA);
                    }
                    catch (NotTrustedException ex) {
                        dst.setEsCertConfianza(ConfianzaEnum.SIN_CONFIANZA);
                    }
                    catch (UnknownTrustException ex) {
                        dst.setEsCertConfianza(ConfianzaEnum.NO_REVISADO);
                    }
                    catch (TrustException ex) {
                        dst.setEsCertConfianza(ConfianzaEnum.NO_REVISADO);
                        LOGGER.error((Object)i18n.getLocalMessage("i18n.mityc.xades.validate.trust.4", new Object[]{ex.getMessage()}));
                        if (!LOGGER.isDebugEnabled()) continue;
                        LOGGER.debug((Object)"", (Throwable)ex);
                    }
                }
                catch (TSPException e) {
                    dst.setEsCertConfianza(ConfianzaEnum.NO_REVISADO);
                    LOGGER.error((Object)i18n.getLocalMessage("i18n.mityc.xades.validate.trust.4", new Object[]{e.getMessage()}));
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug((Object)"", (Throwable)e);
                }
                catch (IOException e) {
                    dst.setEsCertConfianza(ConfianzaEnum.NO_REVISADO);
                    LOGGER.error((Object)i18n.getLocalMessage("i18n.mityc.xades.validate.trust.4", new Object[]{e.getMessage()}));
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug((Object)"", (Throwable)e);
                }
                catch (CMSException e) {
                    dst.setEsCertConfianza(ConfianzaEnum.NO_REVISADO);
                    LOGGER.error((Object)i18n.getLocalMessage("i18n.mityc.xades.validate.trust.4", new Object[]{e.getMessage()}));
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug((Object)"", (Throwable)e);
                }
            }
        }
    }

    public void setLocale(String locale) {
        I18n.setLocale(locale, locale.toUpperCase());
    }

    public void setXAdESSchema(XAdESSchemas schema, boolean activate) {
        if (schema != null) {
            if (activate) {
                this.esquemasParaValidar.add(schema.getSchemaUri());
            } else {
                this.esquemasParaValidar.remove(schema.getSchemaUri());
            }
        }
    }

    public ArrayList<ResultadoValidacion> validar(Document doc, String baseUri, ExtraValidators validators, ITimeStampValidator timeStampValidator) throws FirmaXMLError {
        ArrayList<ResultadoValidacion> resultados = new ArrayList<ResultadoValidacion>();
        Utils.addBCProvider();
        try {
            ICertStatusRecoverer certStatus;
            if (this.tsValidator == null) {
                this.tsValidator = timeStampValidator;
            }
            this.uriXmlNS = "http://www.w3.org/2000/09/xmldsig#";
            if (this.esquemasParaValidar.isEmpty()) {
                LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error1"));
                throw new FirmaXMLError(I18n.getResource("libreriaxades.validarfirmaxml.error1"));
            }
            Init.init();
            NodeList listaFirmas = doc.getElementsByTagNameNS(this.uriXmlNS, "Signature");
            if (listaFirmas.getLength() == 0) {
                LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error2"));
                throw new FirmaXMLError(I18n.getResource("libreriaxades.validarfirmaxml.error2"));
            }
            int longitud = listaFirmas.getLength();
            LOGGER.debug((Object)(String.valueOf(I18n.getResource("libreriaxades.validarfirmaxml.info1")) + " " + longitud));
            this.truster = validators != null ? validators.getTrusterCerts() : null;
            List<IValidacionPolicy> policies = validators != null ? validators.getPolicies() : null;
            int i = 0;
            while (i < longitud) {
                resultados.add(this.validaFirma(listaFirmas.item(i), baseUri, policies));
                ++i;
            }
            for (ResultadoValidacion rv : resultados) {
                String id;
                DatosFirma datos = rv.getDatosFirma();
                rv.setContrafirmadoPor(new ArrayList<ResultadoValidacion>());
                if (datos == null || (id = datos.getSigValueId()) == null) continue;
                for (ResultadoValidacion rv2 : resultados) {
                    ArrayList<String> contrafirmaA;
                    DatosFirma datos2 = rv2.getDatosFirma();
                    if (datos2 == null || id.equals(datos2.getSigValueId()) || (contrafirmaA = datos2.getContraFirma()) == null || !contrafirmaA.contains(id)) continue;
                    rv.addContrafirmadoPor(rv2);
                }
            }
            ICertStatusRecoverer iCertStatusRecoverer = certStatus = validators != null ? validators.getCertStatus() : null;
            if (certStatus != null) {
                for (ResultadoValidacion rv : resultados) {
                    ArrayList<DatosSelloTiempo> listTS;
                    if (!rv.isValidate()) continue;
                    Date firstTimestamp = null;
                    if (EnumFormatoFirma.XAdES_T.compareTo((Enum)rv.getEnumNivel()) <= 0 && (listTS = rv.getDatosFirma().getDatosSelloTiempo()) != null) {
                        for (DatosSelloTiempo dst : listTS) {
                            if (firstTimestamp == null) {
                                firstTimestamp = dst.getFecha();
                                continue;
                            }
                            if (!firstTimestamp.after(dst.getFecha())) continue;
                            firstTimestamp = dst.getFecha();
                        }
                    }
                    CertPath cp = rv.getDatosFirma().getCadenaFirma();
                    X509Certificate certificate = (X509Certificate)cp.getCertificates().get(0);
                    if (EnumFormatoFirma.XAdES_X.compareTo((Enum)rv.getEnumNivel()) > 0) {
                        try {
                            SimpleDateFormat f;
                            Object status;
                            SingleResp resp;
                            SingleResp[] responses;
                            BasicOCSPResp basicResponse;
                            ICertStatus respYCerts = certStatus.getCertStatus(certificate);
                            if (respYCerts != null) {
                                rv.setCertStatus(respYCerts);
                                if (ICertStatus.CERT_STATUS.revoked.equals((Object)respYCerts.getStatus())) {
                                    Date revoked;
                                    RevokedInfo ri;
                                    if (firstTimestamp != null) {
                                        ri = respYCerts.getRevokedInfo();
                                        Date date = revoked = ri != null ? ri.getRevokedDate() : null;
                                        if (revoked != null && firstTimestamp.before(revoked)) {
                                            rv.setValidate(false);
                                            rv.setResultado(ResultadoEnum.UNKNOWN);
                                            rv.setLog(null);
                                            continue;
                                        }
                                    } else {
                                        ri = respYCerts.getRevokedInfo();
                                        revoked = ri != null ? ri.getRevokedDate() : null;
                                        Date signingTime = rv.getDatosFirma().getFechaFirma();
                                        if (revoked != null && signingTime.before(revoked)) {
                                            rv.setValidate(false);
                                            rv.setResultado(ResultadoEnum.UNKNOWN);
                                            rv.setLog(String.valueOf(i18n.getLocalMessage("i18n.mityc.xades.validate.15", new Object[]{revoked})) + "\n" + i18n.getLocalMessage("i18n.mityc.xades.validate.17", new Object[]{signingTime}));
                                            continue;
                                        }
                                    }
                                    if ((ri = respYCerts.getRevokedInfo()) != null) {
                                        revoked = ri.getRevokedDate();
                                        if (revoked != null) {
                                            SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
                                            rv.setLog(i18n.getLocalMessage("i18n.mityc.xades.validate.15", new Object[]{formatter.format(revoked)}));
                                            LOGGER.info((Object)i18n.getLocalMessage("i18n.mityc.xades.validate.15", new Object[]{formatter.format(revoked)}));
                                        } else {
                                            LOGGER.info((Object)I18n.getResource("libreriaxades.validarfirmaxml.error165"));
                                        }
                                    } else {
                                        LOGGER.info((Object)I18n.getResource("libreriaxades.validarfirmaxml.error165"));
                                    }
                                    if (EnumFormatoFirma.XAdES_C.compareTo((Enum)rv.getEnumNivel()) <= 0) {
                                        BasicOCSPResp basicResponse2 = this.getOCSPResponseFromSignature(rv, certificate);
                                        if (basicResponse2 != null) {
                                            SingleResp[] responses2 = basicResponse2.getResponses();
                                            if (responses2.length == 1) {
                                                SingleResp resp2 = responses2[0];
                                                Object status2 = resp2.getCertStatus();
                                                if (status2 == CertificateStatus.GOOD) {
                                                    SimpleDateFormat f2 = new SimpleDateFormat("dd/MM/yyyy H:mm:ss");
                                                    String log = rv.getLog();
                                                    log = log != null && log.length() > 0 ? String.valueOf(log) + "\nSe adjuntan respuestas OCSP con fecha: " + f2.format(basicResponse2.getProducedAt()) : "El certificado firmante esta revocado.\nSe adjuntan respuestas OCSP con fecha: " + f2.format(basicResponse2.getProducedAt());
                                                    rv.setLog(log);
                                                    rv.setValidate(true);
                                                    rv.setResultado(ResultadoEnum.VALID);
                                                } else {
                                                    rv.setValidate(false);
                                                    rv.setResultado(ResultadoEnum.INVALID);
                                                    rv.setLog(null);
                                                }
                                            }
                                        } else {
                                            rv.setValidate(false);
                                            rv.setResultado(ResultadoEnum.INVALID);
                                            rv.setLog(null);
                                        }
                                    } else {
                                        rv.setValidate(false);
                                        rv.setResultado(ResultadoEnum.INVALID);
                                        rv.setLog(null);
                                    }
                                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error165"));
                                    continue;
                                }
                                if (ICertStatus.CERT_STATUS.unknown.equals((Object)respYCerts.getStatus())) {
                                    if (EnumFormatoFirma.XAdES_C.compareTo((Enum)rv.getEnumNivel()) <= 0) {
                                        basicResponse = this.getOCSPResponseFromSignature(rv, certificate);
                                        if (basicResponse != null) {
                                            responses = basicResponse.getResponses();
                                            if (responses.length == 1) {
                                                resp = responses[0];
                                                status = resp.getCertStatus();
                                                if (status == CertificateStatus.GOOD) {
                                                    f = new SimpleDateFormat("dd/MM/yyyy H:mm:ss");
                                                    rv.setLog("El certificado firmante tiene un estado de revocaci\u00f3n desconocido.\nSe adjuntan respuestas OCSP con fecha: " + f.format(basicResponse.getProducedAt()));
                                                    rv.setValidate(true);
                                                    rv.setResultado(ResultadoEnum.VALID);
                                                } else {
                                                    rv.setValidate(false);
                                                    rv.setResultado(ResultadoEnum.UNKNOWN);
                                                    rv.setLog(null);
                                                }
                                            }
                                        } else {
                                            rv.setValidate(false);
                                            rv.setResultado(ResultadoEnum.UNKNOWN);
                                            rv.setLog(null);
                                        }
                                    } else {
                                        rv.setValidate(false);
                                        rv.setResultado(ResultadoEnum.UNKNOWN);
                                        rv.setLog(null);
                                    }
                                    LOGGER.info((Object)I18n.getResource("libreriaxades.validarfirmaxml.error166"));
                                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error166"));
                                    continue;
                                }
                                if (LOGGER.isTraceEnabled()) {
                                    LOGGER.trace((Object)I18n.getResource("libreriaxades.validarfirmaxml.error167"));
                                }
                                logv.info(I18n.getResource("libreriaxades.validarfirmaxml.error167"));
                                continue;
                            }
                            if (EnumFormatoFirma.XAdES_C.compareTo((Enum)rv.getEnumNivel()) <= 0) {
                                basicResponse = this.getOCSPResponseFromSignature(rv, certificate);
                                if (basicResponse != null) {
                                    responses = basicResponse.getResponses();
                                    if (responses.length != 1) continue;
                                    resp = responses[0];
                                    status = resp.getCertStatus();
                                    if (status == CertificateStatus.GOOD) {
                                        f = new SimpleDateFormat("dd/MM/yyyy H:mm:ss");
                                        rv.setLog("El certificado firmante tiene un estado de revocaci\u00f3n desconocido.\nSe adjuntan respuestas OCSP con fecha: " + f.format(basicResponse.getProducedAt()));
                                        rv.setValidate(true);
                                        rv.setResultado(ResultadoEnum.VALID);
                                        continue;
                                    }
                                    rv.setValidate(false);
                                    rv.setResultado(ResultadoEnum.UNKNOWN);
                                    rv.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error166"));
                                    continue;
                                }
                                rv.setValidate(false);
                                rv.setResultado(ResultadoEnum.UNKNOWN);
                                rv.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error166"));
                                continue;
                            }
                            rv.setValidate(false);
                            rv.setResultado(ResultadoEnum.UNKNOWN);
                            rv.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error166"));
                            LOGGER.info((Object)I18n.getResource("libreriaxades.validarfirmaxml.error166"));
                            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error166"));
                        }
                        catch (CertStatusException ex) {
                            rv.setResultado(ResultadoEnum.UNKNOWN);
                            rv.setLog(i18n.getLocalMessage("i18n.mityc.xades.validate.14"));
                            LOGGER.info((Object)ex.getMessage(), (Throwable)ex);
                            logv.error(ex.getMessage());
                        }
                        continue;
                    }
                    if (this.arrayDatosOCSP != null) {
                        for (DatosOCSP currentOCSP : this.arrayDatosOCSP) {
                            if (currentOCSP.getRevockedStatus().equals((Object)ICertStatus.CERT_STATUS.revoked)) {
                                rv.setValidate(false);
                                rv.setResultado(ResultadoEnum.INVALID);
                                rv.setLog(i18n.getLocalMessage("i18n.mityc.xades.validate.19", new Object[]{currentOCSP.getCertConsultado()}));
                                continue;
                            }
                            if (!currentOCSP.getRevockedStatus().equals((Object)ICertStatus.CERT_STATUS.unknown)) continue;
                            rv.setValidate(false);
                            rv.setResultado(ResultadoEnum.UNKNOWN);
                            rv.setLog(i18n.getLocalMessage("i18n.mityc.xades.validate.20", new Object[]{currentOCSP.getCertConsultado()}));
                        }
                    } else {
                        rv.setValidate(false);
                        rv.setResultado(ResultadoEnum.INVALID);
                        rv.setLog(i18n.getLocalMessage("i18n.mityc.xades.validate.21"));
                    }
                    BasicOCSPResp basicResponse = this.getOCSPResponseFromSignature(rv, certificate);
                    if (basicResponse != null) {
                        SingleResp[] responses = basicResponse.getResponses();
                        if (responses.length != 1) continue;
                        SingleResp resp = responses[0];
                        Object status = resp.getCertStatus();
                        if (status == CertificateStatus.GOOD) {
                            rv.setValidate(true);
                            rv.setResultado(ResultadoEnum.VALID);
                            continue;
                        }
                        rv.setValidate(false);
                        rv.setResultado(ResultadoEnum.INVALID);
                        rv.setLog(null);
                        continue;
                    }
                    rv.setValidate(false);
                    rv.setResultado(ResultadoEnum.INVALID);
                    rv.setLog(null);
                }
            }
            doc = null;
            ArrayList<ResultadoValidacion> arrayList = resultados;
            return arrayList;
        }
        finally {
            block56: {
                try {
                    Security.removeProvider("BC");
                }
                catch (Exception e) {
                    if (!LOGGER.isDebugEnabled()) break block56;
                    LOGGER.debug((Object)e);
                }
            }
        }
    }

    private BasicOCSPResp getOCSPResponseFromSignature(ResultadoValidacion rv, X509Certificate certificate) {
        BasicOCSPResp basicResponse = null;
        try {
            ArrayList<DatosOCSP> datos = rv.getDatosFirma().getDatosOCSP();
            int i = 0;
            while (i < datos.size()) {
                if (datos.get(i).getCertConsultado().equals(certificate.getSubjectX500Principal().toString())) {
                    basicResponse = (BasicOCSPResp)datos.get(i).getRespuestaOCSP().getResponseObject();
                    break;
                }
                ++i;
            }
        }
        catch (Throwable e) {
            LOGGER.debug((Object)"Error al acceder a las datos OCSP", e);
        }
        return basicResponse;
    }

    public ArrayList<ResultadoValidacion> validar(Document doc, String baseUri, ExtraValidators validators) throws FirmaXMLError {
        return this.validar(doc, baseUri, validators, null);
    }

    public ResultadoValidacion validar(Node firma, String baseUri, List<IValidacionPolicy> policies) {
        Utils.addBCProvider();
        try {
            if (this.uriXmlNS == null) {
                this.uriXmlNS = "http://www.w3.org/2000/09/xmldsig#";
            }
            Init.init();
            ResultadoValidacion resultadoValidacion = this.validaFirma(firma, baseUri, policies);
            return resultadoValidacion;
        }
        finally {
            block8: {
                try {
                    Security.removeProvider("BC");
                }
                catch (Exception e) {
                    if (!LOGGER.isDebugEnabled()) break block8;
                    LOGGER.debug((Object)e);
                }
            }
        }
    }

    private ResultadoValidacion validaFirma(Node firma, String baseUri, List<IValidacionPolicy> policies) {
        block123: {
            String uri;
            Node padre;
            String id;
            if (baseUri == null) {
                baseUri = new File("./").getAbsolutePath();
            }
            this.politicas = new ArrayList();
            if (policies != null && policies.size() > 0) {
                for (IValidacionPolicy valPol : policies) {
                    if (valPol == null) continue;
                    PolicyResult pr = new PolicyResult();
                    pr.setPolicyVal(valPol);
                    this.politicas.add(pr);
                }
            }
            this.resultado = new ResultadoValidacion();
            X509Certificate cert = null;
            XMLSignature firmaDocumento = null;
            String uriDS = null;
            try {
                firmaDocumento = new XMLSignature((Element)firma, baseUri);
                if (this.resolvers != null) {
                    Iterator<ResourceResolverSpi> it = this.resolvers.iterator();
                    while (it.hasNext()) {
                        firmaDocumento.addResourceResolver(it.next());
                    }
                }
                uriDS = firmaDocumento.getBaseNamespace();
            }
            catch (XMLSignatureException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                this.resultado.setDatosFirma(new DatosFirma());
                this.resultado.setDoc(firma.getOwnerDocument());
                this.resultado.setFirmados(new ArrayList<String>());
                this.resultado.setLog(String.valueOf(I18n.getResource("libreriaxades.validarfirmaxml.error7")) + ": " + e.getMessage());
                this.resultado.setValidate(false);
                this.resultado.setResultado(ResultadoEnum.INVALID);
                return this.resultado;
            }
            catch (XMLSecurityException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                this.resultado.setDatosFirma(new DatosFirma());
                this.resultado.setDoc(firma.getOwnerDocument());
                this.resultado.setFirmados(new ArrayList<String>());
                this.resultado.setLog(String.valueOf(I18n.getResource("libreriaxades.validarfirmaxml.error7")) + ": " + e.getMessage());
                this.resultado.setValidate(false);
                return this.resultado;
            }
            try {
                this.resultado.setBaseURI(new URI(URIEncoder.encode(baseUri, "UTF-8")));
            }
            catch (URISyntaxException ex) {
                LOGGER.error((Object)ex.getMessage(), (Throwable)ex);
            }
            catch (UnsupportedEncodingException ex) {
                LOGGER.error((Object)ex.getMessage(), (Throwable)ex);
            }
            this.datosFirma = new DatosFirma();
            this.firmados = new ArrayList();
            this.arrayDatosSello = new ArrayList();
            this.arrayDatosCRL = new ArrayList();
            this.arrayDatosOCSP = new ArrayList();
            ArrayList<String> cfA = new ArrayList<String>();
            this.resultado.setDatosFirma(this.datosFirma);
            this.resultado.setDoc(firma.getOwnerDocument());
            this.resultado.setFirmados(this.firmados);
            EstructuraFirma estructuraFirma = this.obtenerEsquema((Element)firma);
            if (estructuraFirma == null || estructuraFirma.esquema == null) {
                LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error1"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error1"));
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error1"));
                this.resultado.setValidate(false);
                this.resultado.setResultado(ResultadoEnum.UNKNOWN);
            } else {
                estructuraFirma.xmlSig = firmaDocumento;
                this.datosFirma.setEsquema(estructuraFirma.esquema);
                logv.info("Xml Schema: " + estructuraFirma.esquema);
            }
            ArrayList<Element> signatureValues = null;
            try {
                signatureValues = UtilidadTratarNodo.obtenerNodos((Element)firma, 2, new NombreNodo(this.uriXmlNS, "SignatureValue"));
            }
            catch (FirmaXMLError e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                logv.error(e.getMessage());
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error5"));
                this.resultado.setValidate(false);
                this.resultado.setResultado(ResultadoEnum.INVALID);
                return this.resultado;
            }
            if (signatureValues != null && signatureValues.size() > 0 && (id = signatureValues.get(0).getAttribute("Id")) != null && !"".equals(id)) {
                this.datosFirma.setSigValueId(id);
            }
            this.getConstantesEsquema(estructuraFirma.esquema);
            if (estructuraFirma != null && estructuraFirma.esquema != null) {
                this.obtenerCadenaCertificados(estructuraFirma);
            }
            ArrayList<Element> nodosReference = new ArrayList<Element>();
            SignedInfo si = firmaDocumento.getSignedInfo();
            int i = 0;
            while (i < si.getLength()) {
                try {
                    Reference ref = si.item(i);
                    nodosReference.add(si.item(i).getElement());
                    DatosNodosFirmados dnf = new DatosNodosFirmados();
                    dnf.setReference(new ReferenceProxy(ref));
                    this.datosFirma.addDatosNodoFirmado(dnf);
                }
                catch (XMLSecurityException ex) {
                    LOGGER.warn((Object)i18n.getLocalMessage("i18n.mityc.xades.validate.7", new Object[]{ex.getMessage()}));
                }
                ++i;
            }
            int nodeFileReferenceLength = nodosReference.size();
            int f = 0;
            while (f < nodeFileReferenceLength) {
                Element nodo;
                Element elementReference = (Element)nodosReference.get(f);
                String referenceUri = elementReference.getAttribute("URI");
                if (referenceUri != null) {
                    this.firmados.add(referenceUri);
                }
                if (referenceUri != "" && referenceUri.startsWith("#") && (nodo = UtilidadTratarNodo.getElementById(firma.getOwnerDocument(), referenceUri.substring(1))) != null && nodo.getLocalName().equals("SignatureValue") && !referenceUri.substring(1).equals(this.datosFirma.getSigValueId())) {
                    Node cs = firma.getParentNode();
                    if (cs.getNodeType() == 1 && ((Element)cs).getLocalName().equals("CounterSignature") && (cs.getChildNodes() == null || cs.getChildNodes().getLength() != 1)) {
                        LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error172"));
                        logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error173"));
                        this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error173"));
                        this.resultado.setValidate(false);
                        this.resultado.setResultado(ResultadoEnum.INVALID);
                        return this.resultado;
                    }
                    cfA.add(referenceUri.substring(1));
                }
                ++f;
            }
            if (cfA != null && cfA.size() > 0) {
                this.datosFirma.setContraFirma(cfA);
            }
            if ((padre = firma.getParentNode()) != null && "CounterSignature".equals(padre.getLocalName())) {
                boolean hayReferencia = false;
                Node sigNode = padre.getParentNode().getParentNode().getParentNode().getParentNode().getParentNode();
                NodeList hijosSigNode = sigNode.getChildNodes();
                Element sigValueNode = null;
                int i2 = 0;
                while (i2 < hijosSigNode.getLength()) {
                    if ("SignatureValue".equals(hijosSigNode.item(i2).getLocalName())) {
                        sigValueNode = (Element)hijosSigNode.item(i2);
                    }
                    ++i2;
                }
                if (sigValueNode == null) {
                    LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                    this.resultado.setValidate(false);
                    this.resultado.setResultado(ResultadoEnum.INVALID);
                    return this.resultado;
                }
                int f2 = 0;
                while (f2 < nodeFileReferenceLength) {
                    Element nodoSigValue;
                    Element elementReference = (Element)nodosReference.get(f2);
                    uri = elementReference.getAttribute("URI");
                    if (uri != null && uri != "" && uri.startsWith("#") && (nodoSigValue = UtilidadTratarNodo.getElementById(firma.getOwnerDocument(), uri.substring(1))) != null && nodoSigValue.equals(sigValueNode)) {
                        String tipo;
                        hayReferencia = true;
                        if (XAdESSchemas.XAdES_132.equals(estructuraFirma.esquema) && !"http://uri.etsi.org/01903#CountersignedSignature".equals(tipo = elementReference.getAttribute("Type"))) {
                            LOGGER.warn((Object)"Atenci\u00f3n. Nodo Reference no est\u00e1 incluyendo tipo Contrafirma (ETSI TS 101 903 v1.3.2 7.2.4.1");
                        }
                    }
                    ++f2;
                }
                if (!hayReferencia) {
                    LOGGER.error((Object)("Contrafirma mal formada: No se encuentra una referencia bien formada al nodo \"" + sigValueNode.getAttribute("Id") + "\""));
                    logv.error("La contrafirma no esta firmando el nodo SignatureValue de la firma que lo contiene");
                    this.resultado.setLog("Contrafirma inv\u00e1lida. La firma validada no contrafirma a la firma que lo contiene");
                    this.resultado.setValidate(false);
                    this.resultado.setResultado(ResultadoEnum.INVALID);
                    return this.resultado;
                }
            }
            if (this.cadenaCertificados == null || this.cadenaCertificados.size() == 0) {
                if (estructuraFirma.esquema != null) {
                    LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                    this.resultado.setValidate(false);
                    this.resultado.setResultado(ResultadoEnum.INVALID);
                    return this.resultado;
                }
                return this.resultado;
            }
            cert = this.cadenaCertificados.get(0);
            logv.info("Signing Certificate: " + cert.getSubjectDN().toString());
            if (cert != null) {
                try {
                    this.esValido = firmaDocumento.checkSignatureValue(cert);
                }
                catch (XMLSignatureException ex) {
                    LOGGER.error((Object)ex, (Throwable)ex);
                    LOGGER.info((Object)I18n.getResource("libreriaxades.validarfirmaxml.error105"));
                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error105"));
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error105"));
                    this.resultado.setValidate(false);
                    this.resultado.setResultado(ResultadoEnum.INVALID);
                    return this.resultado;
                }
                if (this.esValido) {
                    logv.info("XMLDSig Core Validation: Passed");
                    this.resultado.setIntegrity(true);
                } else {
                    int i3 = 0;
                    while (i3 < nodosReference.size()) {
                        Element elementReference = (Element)nodosReference.get(i3);
                        NodeList childs = elementReference.getElementsByTagName("*");
                        String method = null;
                        String digest = null;
                        int j = 0;
                        while (j < childs.getLength()) {
                            if (childs.item(j).getLocalName().contains("DigestValue")) {
                                digest = childs.item(j).getFirstChild().getNodeValue();
                            } else if (childs.item(j).getLocalName().contains("DigestMethod")) {
                                NamedNodeMap attribs = childs.item(j).getAttributes();
                                int k = 0;
                                while (k < attribs.getLength()) {
                                    if (attribs.item(k).getLocalName().contains("Algorithm")) {
                                        method = attribs.item(k).getNodeValue();
                                    }
                                    ++k;
                                }
                            }
                            ++j;
                        }
                        byte[] abyte0 = Base64.decode(digest);
                        uri = elementReference.getAttribute("URI");
                        byte[] abyte1 = null;
                        if (uri != null && uri != "") {
                            if (uri.startsWith("#")) {
                                uri = uri.substring(1);
                            }
                            Element nodoReferenciado = UtilidadTratarNodo.getElementById(firma.getOwnerDocument(), uri);
                            try {
                                if (nodoReferenciado != null) {
                                    Element nodoCanonicalizationMethod;
                                    String meth;
                                    MessageDigestAlgorithm alg = MessageDigestAlgorithm.getInstance((Document)nodoReferenciado.getOwnerDocument(), method);
                                    alg.reset();
                                    NodeList nodosCanonicalizationMethod = ((Element)elementReference.getParentNode()).getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "CanonicalizationMethod");
                                    int numNodosCanonicalization = nodosCanonicalizationMethod.getLength();
                                    CanonicalizationEnum canonicalization = null;
                                    if (numNodosCanonicalization > 0 && (canonicalization = CanonicalizationEnum.getCanonicalization(meth = (nodoCanonicalizationMethod = (Element)nodosCanonicalizationMethod.item(0)).getAttribute("Algorithm"))).equals((Object)CanonicalizationEnum.UNKNOWN)) {
                                        canonicalization = CanonicalizationEnum.C14N_OMIT_COMMENTS;
                                    }
                                    if (uri.equals("")) {
                                        Transforms tr = new Transforms(firma.getOwnerDocument());
                                        tr.addTransform(canonicalization.toString());
                                        XMLSignatureInput xmlSignatureInput = new XMLSignatureInput((Node)nodoReferenciado);
                                        xmlSignatureInput.setExcludeNode(firma);
                                        XMLSignatureInput resultado = tr.performTransforms(xmlSignatureInput);
                                        alg.update(resultado.getBytes());
                                    } else {
                                        alg.update(UtilidadTratarNodo.obtenerByte(nodoReferenciado, canonicalization));
                                    }
                                    abyte1 = alg.digest();
                                } else {
                                    byte[] file = UtilidadFicheros.readFile(new File(String.valueOf(new File(new URI(baseUri)).getAbsolutePath()) + File.separator + uri));
                                    MessageDigest md = UtilidadFirmaElectronica.getMessageDigest(method);
                                    md.reset();
                                    md.update(file);
                                    abyte1 = md.digest();
                                }
                            }
                            catch (Exception e) {
                                LOGGER.debug((Object)"Error al comprobar la integridad", (Throwable)e);
                            }
                            boolean flag = MessageDigestAlgorithm.isEqual((byte[])abyte0, abyte1);
                            this.resultado.setIntegrity(flag);
                            if (flag) {
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug((Object)("La referencia que apunta a \"" + uri + "\" pasa el chequeo de integridad"));
                                }
                            } else {
                                if (!LOGGER.isDebugEnabled()) break;
                                LOGGER.debug((Object)("La referencia que apunta a \"" + uri + "\" NO pasa el chequeo de integridad"));
                                LOGGER.debug((Object)("Le\u00eddo: " + Base64.encodeBytes(abyte0)));
                                LOGGER.debug((Object)("Calculado: " + Base64.encodeBytes(abyte1)));
                                break;
                            }
                        }
                        ++i3;
                    }
                    LOGGER.debug((Object)"XMLDSig Core Validation: Not passed");
                    logv.error("XMLDSig Core Validation: Not passed");
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error105"));
                    this.resultado.setValidate(false);
                    this.resultado.setResultado(ResultadoEnum.INVALID);
                }
            } else {
                LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error5"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error5"));
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error5"));
                this.resultado.setValidate(false);
                this.resultado.setResultado(ResultadoEnum.INVALID);
                return this.resultado;
            }
            this.getDataObjectFormat(firma.getOwnerDocument(), estructuraFirma);
            try {
                this.tipoDocFirma = this.tipoFirma(estructuraFirma);
                logv.info("XAdES type: " + this.tipoDocFirma.getTipoXAdES().name());
                this.datosFirma.setTipoFirma(this.tipoDocFirma);
            }
            catch (BadFormedSignatureException e) {
                LOGGER.error((Object)e.getMessage());
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error4"));
                this.resultado.setValidate(false);
                this.resultado.setResultado(ResultadoEnum.INVALID);
                logv.error("Bad XAdES format. Invalid Signature: " + e.getMessage());
                this.esValido = false;
                this.tipoDocFirma = new DatosTipoFirma(EnumFormatoFirma.XMLSignature, false, false);
            }
            if (this.esValido) {
                block121: {
                    if (this.tipoDocFirma.getTipoXAdES().equals((Object)EnumFormatoFirma.XMLSignature)) {
                        this.resultado.setValidate(true);
                        this.resultado.setResultado(ResultadoEnum.VALID);
                        this.resultado.setEnumNivel(EnumFormatoFirma.XMLSignature);
                        return this.resultado;
                    }
                    if (this.validarXadesBes(estructuraFirma)) {
                        if (this.tipoDocFirma.esXAdES_EPES()) {
                            LOGGER.info((Object)I18n.getResource("libreriaxades.validarfirmaxml.texto5"));
                            logv.info("XAdES-EPES validation: Valid");
                            this.resultado.setNivelValido(I18n.getResource("libreriaxades.validarfirmaxml.texto5"));
                        } else {
                            LOGGER.info((Object)I18n.getResource("libreriaxades.validarfirmaxml.texto1"));
                            logv.info("XAdES-BES validation: Valid");
                            this.resultado.setNivelValido(I18n.getResource("libreriaxades.validarfirmaxml.texto1"));
                        }
                        this.resultado.setEnumNivel(EnumFormatoFirma.XAdES_BES);
                        this.resultado.setLog(i18n.getLocalMessage("i18n.mityc.xades.validate.14"));
                        this.datosFirma.setRoles(this.obtenerRoles(estructuraFirma));
                        if (this.tipoDocFirma.getTipoXAdES().compareTo((Enum)EnumFormatoFirma.XAdES_BES) > 0) {
                            if (this.validarSelloTiempoXadesT(estructuraFirma)) {
                                LOGGER.info((Object)I18n.getResource("libreriaxades.validarfirmaxml.texto2"));
                                this.resultado.setEnumNivel(EnumFormatoFirma.XAdES_T);
                                this.resultado.setNivelValido(I18n.getResource("libreriaxades.validarfirmaxml.texto2"));
                                this.datosFirma.setDatosSelloTiempo(this.arrayDatosSello);
                                if (this.tipoDocFirma.getTipoXAdES().compareTo((Enum)EnumFormatoFirma.XAdES_T) > 0) {
                                    if (this.validarXadesC(uriDS, cert, estructuraFirma)) {
                                        LOGGER.info((Object)I18n.getResource("libreriaxades.validarfirmaxml.texto4"));
                                        logv.info("XAdES-C validation: Valid");
                                        this.resultado.setEnumNivel(EnumFormatoFirma.XAdES_C);
                                        this.resultado.setNivelValido(I18n.getResource("libreriaxades.validarfirmaxml.texto4"));
                                        this.resultado.setLog("");
                                        this.datosFirma.setDatosOCSP(this.arrayDatosOCSP);
                                        this.datosFirma.setDatosCRL(this.arrayDatosCRL);
                                        if (this.tipoDocFirma.getTipoXAdES().compareTo((Enum)EnumFormatoFirma.XAdES_X) >= 0 && (this.validarSelloTiempoXadesX(estructuraFirma, "SigAndRefsTimeStamp") || this.validarSelloTiempoXadesX(estructuraFirma, "RefsOnlyTimeStamp"))) {
                                            this.resultado.setEnumNivel(this.tipoDocFirma.getTipoXAdES());
                                            if (EnumFormatoFirma.XAdES_X.compareTo((Enum)this.tipoDocFirma.getTipoXAdES()) == 0) {
                                                this.resultado.setNivelValido(I18n.getResource("libreriaxades.validarfirmaxml.texto7"));
                                                LOGGER.info((Object)I18n.getResource("libreriaxades.validarfirmaxml.texto7"));
                                                logv.info("XAdES-X validation: Valid");
                                            } else {
                                                this.resultado.setNivelValido(I18n.getResource("libreriaxades.validarfirmaxml.texto3"));
                                                LOGGER.info((Object)I18n.getResource("libreriaxades.validarfirmaxml.texto3"));
                                                logv.info("XAdES-XL validation: Valid");
                                            }
                                            this.datosFirma.setDatosSelloTiempo(this.arrayDatosSello);
                                            this.datosFirma.setDatosOCSP(this.arrayDatosOCSP);
                                        }
                                    } else {
                                        this.datosFirma.setDatosOCSP(this.arrayDatosOCSP);
                                    }
                                }
                            } else {
                                String sello = "";
                                if (this.tipoDocFirma.getTipoXAdES().compareTo((Enum)EnumFormatoFirma.XAdES_XL) == 0) {
                                    sello = "XAdES T ";
                                }
                                LOGGER.info((Object)(String.valueOf(I18n.getResource("libreriaxades.validarfirmaxml.error8")) + " " + sello + " " + I18n.getResource("libreriaxades.validarfirmaxml.error9") + " " + this.tipoDocFirma.getTipoXAdES() + " " + I18n.getResource("libreriaxades.validarfirmaxml.error10")));
                                if (i18n.getLocalMessage("i18n.mityc.xades.validate.14").equals(this.resultado.getLog())) {
                                    this.resultado.setLog(String.valueOf(I18n.getResource("libreriaxades.validarfirmaxml.error8")) + " " + sello + " " + I18n.getResource("libreriaxades.validarfirmaxml.error9") + " " + this.tipoDocFirma.getTipoXAdES().name() + " " + I18n.getResource("libreriaxades.validarfirmaxml.error10"));
                                }
                                this.esValido = false;
                            }
                        } else {
                            try {
                                cert.checkValidity(new Date(System.currentTimeMillis()));
                            }
                            catch (CertificateExpiredException e) {
                                LOGGER.info((Object)"El certificado firmante ha caducado");
                                logv.info("El certificado firmante ha caducado");
                                this.resultado.appendLog("El certificado firmante ha caducado");
                                this.resultado.setValidate(false);
                                this.resultado.setResultado(ResultadoEnum.INVALID);
                                this.esValido = false;
                            }
                            catch (CertificateNotYetValidException e) {
                                LOGGER.info((Object)"El certificado firmante a\u00fan no es v\u00e1lido");
                                logv.info("El certificado firmante a\u00fan no es v\u00e1lido");
                                this.resultado.appendLog("El certificado firmante a\u00fan no es v\u00e1lido");
                                this.resultado.setValidate(false);
                                this.resultado.setResultado(ResultadoEnum.INVALID);
                                this.esValido = false;
                            }
                        }
                    }
                    this.resultado.setValidate(this.esValido);
                    if (!ResultadoEnum.UNKNOWN.equals((Object)this.resultado.getResultado())) {
                        this.resultado.setResultado(this.esValido ? ResultadoEnum.VALID : ResultadoEnum.INVALID);
                    }
                    if (this.tipoDocFirma.esXAdES_A()) {
                        try {
                            if (this.validaXadesA(estructuraFirma)) {
                                LOGGER.info((Object)"La firma contiene un sello de tiempo XAdES-A v\u00e1lido");
                                break block121;
                            }
                            LOGGER.info((Object)"La firma contiene un sello de tiempo XAdES-A NO v\u00e1lido");
                            logv.info("La firma contiene un sello de tiempo del tipo XAdES-A NO v\u00e1lido");
                            if (this.resultado.getLog() != null) {
                                this.resultado.setLog("Un sello de tiempo de tipo A es inv\u00e1lido - " + this.resultado.getLog());
                            } else {
                                this.resultado.setLog("Un sello de tiempo de tipo A es inv\u00e1lido");
                            }
                            this.resultado.setValidate(false);
                            this.resultado.setResultado(ResultadoEnum.INVALID);
                            return this.resultado;
                        }
                        catch (Exception e) {
                            LOGGER.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                }
                if (this.esValido) {
                    Date fechaFirma = this.datosFirma.getFechaFirma();
                    if (EnumFormatoFirma.XAdES_BES.compareTo((Enum)this.datosFirma.getTipoFirma().getTipoXAdES()) > 0) {
                        fechaFirma = this.datosFirma.getDatosSelloTiempo().get(0).getFecha();
                    }
                    if (fechaFirma != null) {
                        if (fechaFirma.after(new Date())) {
                            this.esValido = false;
                            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error170"));
                            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error170"));
                            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error170"));
                        }
                        Date notAfter = cert.getNotAfter();
                        Date notBefore = cert.getNotBefore();
                        if (fechaFirma.after(notAfter) || fechaFirma.before(notBefore)) {
                            this.esValido = false;
                            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error159"));
                            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error159"));
                            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error159"));
                        }
                    }
                }
                this.buscaXadesEpes(estructuraFirma);
            }
            if (this.politicas.size() <= 0) break block123;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Se validan " + this.politicas.size() + " pol\u00edticas"));
            }
            for (PolicyResult pr : this.politicas) {
                if (pr.getPolicyVal() != null) {
                    block122: {
                        try {
                            IValidacionPolicy valPol = pr.getPolicyVal();
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug((Object)("Manager de pol\u00edtica empleado: " + valPol.getIdentidadPolicy()));
                            }
                            if (this.truster != null) {
                                valPol.setTruster(this.truster);
                            }
                            PolicyResult prTemp = valPol.validaPolicy((Element)firma, this.resultado);
                            pr.copy(prTemp);
                            if (!LOGGER.isDebugEnabled()) break block122;
                            LOGGER.debug((Object)("Pol\u00edtica validada con \u00e9xito: " + (Object)((Object)pr.getResult())));
                        }
                        catch (Throwable th) {
                            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error109"), th);
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug((Object)("Error al validar la pol\u00edtica: " + th.getMessage()));
                            }
                            this.resultado.setValidate(false);
                            this.resultado.setResultado(ResultadoEnum.INVALID);
                            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error71"));
                            pr.setResult(PolicyResult.StatusValidation.unknown);
                            pr.setDescriptionResult(th.getMessage());
                            break;
                        }
                    }
                    if (PolicyResult.StatusValidation.invalid.equals((Object)pr.getResult())) {
                        this.resultado.setValidate(false);
                        this.resultado.setResultado(ResultadoEnum.INVALID);
                        this.resultado.setLog(pr.getDescriptionResult());
                    } else if (PolicyResult.StatusValidation.unknown.equals((Object)pr.getResult())) {
                        this.resultado.setValidate(false);
                        this.resultado.setResultado(ResultadoEnum.UNKNOWN);
                        this.resultado.setLog(pr.getDescriptionResult());
                    }
                } else if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("No se encontr\u00f3 validador para " + pr.getPolicyID()));
                }
                PolicyResult.StatusValidation sv = pr.getResult();
                String policyDescResult = pr.getDescriptionResult();
                PolicyResult.DownloadPolicy[] policyDownload = pr.getDownloable();
                String[] policyNotices = pr.getNotices();
                boolean valido = false;
                String policyID = null;
                if (PolicyResult.StatusValidation.valid.equals((Object)sv)) {
                    policyID = "Accomplished policy: " + pr.getPolicyID();
                    valido = true;
                } else if (PolicyResult.StatusValidation.invalid.equals((Object)sv)) {
                    policyID = "Unaccomplished policy: " + pr.getPolicyID();
                } else if (PolicyResult.StatusValidation.unknown.equals((Object)sv)) {
                    policyID = pr.getPolicyID() == null ? "Implied policy" : "Unkown policy";
                    valido = true;
                }
                logv.abreTag(valido);
                logv.info(policyID, 2);
                if (!valido && policyDescResult != null) {
                    logv.info(policyDescResult, 2);
                }
                int i4 = 0;
                while (policyDownload != null && i4 < policyDownload.length) {
                    block126: {
                        String value;
                        block125: {
                            block124: {
                                value = policyDownload[i4].uri.toString();
                                if (!PolicyResult.StatusValidation.unknown.equals((Object)policyDownload[i4].status)) break block124;
                                value = "(Unknown integrity): ".concat(value);
                                break block125;
                            }
                            if (!PolicyResult.StatusValidation.valid.equals((Object)policyDownload[i4].status)) break block126;
                            value = "(Checked integrity): ".concat(value);
                        }
                        logv.info("Download URI " + value, 2);
                    }
                    ++i4;
                }
                i4 = 0;
                while (policyNotices != null && i4 < policyNotices.length) {
                    logv.info("Notice: " + policyNotices[i4].toString(), 2);
                    ++i4;
                }
                logv.cierraTag(valido);
            }
        }
        if (this.politicas.size() > 0) {
            this.datosFirma.setPoliticas(this.politicas);
        }
        return this.resultado;
    }

    private void buscaXadesEpes(EstructuraFirma estructuraFirma) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Buscando nodos de pol\u00edticas");
        }
        Element firma = estructuraFirma.firma;
        String esquemaURI = estructuraFirma.esquema.getSchemaUri();
        ArrayList<Element> signaturePolicyList = null;
        try {
            signaturePolicyList = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "SignaturePolicyIdentifier"));
        }
        catch (FirmaXMLError e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            logv.error(e.getMessage());
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error5"));
            this.resultado.setValidate(false);
            this.resultado.setResultado(ResultadoEnum.INVALID);
            return;
        }
        int numNodosSigPolicy = 0;
        if (signaturePolicyList != null) {
            numNodosSigPolicy = signaturePolicyList.size();
        }
        if (numNodosSigPolicy == 0 && "http://uri.etsi.org/01903/v1.1.1#".equals(esquemaURI)) {
            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error110"));
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error111"));
            this.esValido = false;
            this.resultado.setValidate(false);
            this.resultado.setResultado(ResultadoEnum.INVALID);
            return;
        }
        if (numNodosSigPolicy == 1) {
            IValidacionPolicy valPol;
            SignaturePolicyIdentifier spi;
            Element signaturePolicyIdentifierNode = signaturePolicyList.get(0);
            try {
                spi = new SignaturePolicyIdentifier(estructuraFirma.esquema);
                if (!spi.isThisNode(signaturePolicyIdentifierNode)) {
                    throw new InvalidInfoNodeException(I18n.getResource("libreriaxades.validarfirmaxml.error112"));
                }
                spi.load(signaturePolicyIdentifierNode);
            }
            catch (InvalidInfoNodeException ex) {
                LOGGER.error((Object)(String.valueOf(I18n.getResource("libreriaxades.validarfirmaxml.error164")) + " " + ex.getMessage()), (Throwable)ex);
                logv.error(String.valueOf(I18n.getResource("libreriaxades.validarfirmaxml.error164")) + " " + ex.getMessage());
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error114"));
                this.esValido = false;
                this.resultado.setValidate(false);
                this.resultado.setResultado(ResultadoEnum.INVALID);
                return;
            }
            PoliciesManager policiesManager = PoliciesManager.getInstance();
            PoliciesManager.PolicyKey clave = policiesManager.newPolicyKey(null, "implied");
            if (!spi.isImplied()) {
                clave.hash = Utilidades.binary2String(Base64Coder.decode(spi.getSignaturePolicyId().getSigPolicyHash().getDigestValue().getValue()));
                clave.uri = spi.getSignaturePolicyId().getSigPolicyId().getIdentifier().getUri();
            }
            if ((valPol = policiesManager.getValidadorPolicy(clave)) == null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("No se pudo encontrar validador para la pol\u00edtica " + clave.uri));
                    LOGGER.debug((Object)("Hash obtenido " + clave.hash));
                    LOGGER.debug((Object)("Pol\u00edticas disponibles: " + this.politicas.size()));
                }
                PolicyResult pr = new PolicyResult();
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error104"));
                pr.setResult(PolicyResult.StatusValidation.unknown);
                pr.setPolicyID(clave.uri);
                this.politicas.add(pr);
            } else if (!this.politicas.contains(valPol)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Validador de pol\u00edtica nuevo: " + valPol.getIdentidadPolicy()));
                    LOGGER.debug((Object)("Para la pol\u00edtica " + clave.uri));
                    LOGGER.debug((Object)("Hash obtenido " + clave.hash));
                    LOGGER.debug((Object)("Pol\u00edticas disponibles: " + this.politicas.size()));
                }
                PolicyResult pr = new PolicyResult();
                pr.setPolicyVal(valPol);
                this.politicas.add(pr);
            }
        } else if (numNodosSigPolicy > 1) {
            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error115"));
            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error115"));
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error116"));
            this.esValido = false;
            this.resultado.setValidate(false);
            this.resultado.setResultado(ResultadoEnum.INVALID);
            return;
        }
    }

    private void mostrarErrorValidacion(Exception ex) throws FirmaXMLError {
        LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error28"), (Throwable)ex);
        throw new FirmaXMLError(I18n.getResource("libreriaxades.validarfirmaxml.error28"));
    }

    private void getDataObjectFormat(Document doc, EstructuraFirma estructuraFirma) {
        DatosNodosFirmados datos = null;
        ArrayList<Element> signedDataObjectProperties = null;
        DataObjectFormat dof = null;
        Element dataOF = null;
        Node attId = null;
        try {
            signedDataObjectProperties = UtilidadTratarNodo.obtenerNodos(estructuraFirma.firma, 4, new NombreNodo(estructuraFirma.esquema.getSchemaUri(), "SignedDataObjectProperties"));
        }
        catch (FirmaXMLError e) {
            LOGGER.debug((Object)"No se pudo recoger el nodo SignedDataObjectProperties", (Throwable)e);
        }
        if (signedDataObjectProperties != null && signedDataObjectProperties.size() == 1) {
            Element signedDOP = signedDataObjectProperties.get(0);
            NodeList dataOFs = signedDOP.getChildNodes();
            int dofLength = dataOFs.getLength();
            Node item = null;
            int i = 0;
            while (i < dofLength) {
                block17: {
                    item = dataOFs.item(i);
                    if (item instanceof Element) {
                        dataOF = (Element)item;
                        dof = new DataObjectFormat(estructuraFirma.esquema);
                        try {
                            dof.load(dataOF);
                        }
                        catch (InvalidInfoNodeException e) {
                            LOGGER.error((Object)e.getMessage(), (Throwable)e);
                            break block17;
                        }
                        if (dataOF.getAttributes() != null && dataOF.getAttributes().getLength() > 0) {
                            String uri;
                            if (dataOF.getAttributes() != null) {
                                attId = dataOF.getAttributes().getNamedItem("ObjectReference");
                            }
                            if (attId != null && (uri = attId.getTextContent()) != null && uri.startsWith("#")) {
                                datos = this.datosFirma.getDatosNodoFimadoByReferenceId(uri.substring(1));
                                if (datos != null) {
                                    if (dof.getObjectIdentifier() != null) {
                                        datos.setObjectIdentifier(dof.getObjectIdentifier());
                                    }
                                    if (dof.getDescription() != null) {
                                        datos.setDescription(dof.getDescription().getValue());
                                    }
                                    if (dof.getMimeType() != null) {
                                        datos.setMimeType(dof.getMimeType().getValue());
                                    }
                                    if (dof.getEnconding() != null) {
                                        datos.setEncoding(dof.getEnconding().getValue());
                                    }
                                } else {
                                    LOGGER.warn((Object)i18n.getLocalMessage("i18n.mityc.xades.validate.8", new Object[]{uri}));
                                }
                            }
                        }
                    }
                }
                ++i;
            }
        } else {
            LOGGER.debug((Object)"El nodo SignedDataObjectProperties no existe o no es \u00fanico");
        }
    }

    private boolean validarXadesBes(EstructuraFirma estructuraFirma) {
        int i;
        if (estructuraFirma.firma == null) {
            this.esValido = false;
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error76"));
            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error76"));
            return false;
        }
        Element firma = estructuraFirma.firma;
        String esquemaURI = estructuraFirma.esquema.getSchemaUri();
        Date fechaFirma = this.obtenerFechaFirma(estructuraFirma);
        this.datosFirma.setFechaFirma(fechaFirma);
        ArrayList<DatosX509> certificadosSigning = new ArrayList<DatosX509>();
        DatosX509 datos = new DatosX509();
        ArrayList<Element> nodosSigningCertificate = UtilidadTratarNodo.obtenerNodos(estructuraFirma.signedSignatureProperties, null, new NombreNodo(esquemaURI, "SigningCertificate"));
        if (nodosSigningCertificate != null && nodosSigningCertificate.size() > 0) {
            Node nodoSigningCertificate = nodosSigningCertificate.get(0);
            ArrayList<Element> nodosCert = UtilidadTratarNodo.getElementChildNodes((Element)nodoSigningCertificate, false);
            if (nodosCert == null) {
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                return false;
            }
            int nodosCertSize = nodosCert.size();
            Element nodoCert = null;
            i = 0;
            while (i < nodosCertSize) {
                nodoCert = nodosCert.get(i);
                Cert cert = new Cert(estructuraFirma.esquema);
                try {
                    cert.load(nodoCert);
                }
                catch (InvalidInfoNodeException ex) {
                    this.esValido = false;
                    this.resultado.setLog(i18n.getLocalMessage("i18n.mityc.xades.validate.13"));
                    LOGGER.error((Object)i18n.getLocalMessage("i18n.mityc.xades.validate.11", new Object[]{ex.getMessage()}));
                    logv.error(String.valueOf(i18n.getLocalMessage("i18n.mityc.xades.validate.13")) + ex.getMessage());
                    return false;
                }
                datos.setAlgMethod(cert.getCertDigest().getDigestMethod().getAlgorithm());
                datos.setDigestValue(cert.getCertDigest().getDigestValue().getValue());
                try {
                    datos.setIssuer(new X500Principal(cert.getIssuerSerial().getIssuerName()));
                }
                catch (IllegalArgumentException ex) {
                    this.esValido = false;
                    this.resultado.setLog(i18n.getLocalMessage("i18n.mityc.xades.validate.13"));
                    LOGGER.error((Object)i18n.getLocalMessage("i18n.mityc.xades.validate.12", new Object[]{ex.getMessage()}));
                    logv.error(String.valueOf(i18n.getLocalMessage("i18n.mityc.xades.validate.13")) + ex.getMessage());
                    return false;
                }
                datos.setSerial(cert.getIssuerSerial().getSerialNumber());
                certificadosSigning.add(datos);
                ++i;
            }
        }
        if (certificadosSigning.size() > 0) {
            X509Certificate certFirmante = this.cadenaCertificados.get(0);
            X500Principal certFirmIssuer = certFirmante.getIssuerX500Principal();
            BigInteger certFirmSerial = certFirmante.getSerialNumber();
            boolean coincidencia = false;
            i = 0;
            while (i < certificadosSigning.size()) {
                DatosX509 certAComparar = (DatosX509)certificadosSigning.get(i);
                if (UtilidadCertificados.isSameName(certFirmIssuer, certAComparar.getIssuer()) && certFirmSerial.equals(certAComparar.getSerial())) {
                    Element nodoKeyInfo;
                    Element primerNodoX509Data;
                    NodeList nodosIssuerSerial;
                    ArrayList<Object> nodosKeyInfo = new ArrayList();
                    try {
                        nodosKeyInfo = UtilidadTratarNodo.obtenerNodos(firma, 2, new NombreNodo(this.uriXmlNS, "KeyInfo"));
                    }
                    catch (FirmaXMLError e) {
                        this.esValido = false;
                        this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                        LOGGER.error((Object)e.getMessage(), (Throwable)e);
                        logv.error(String.valueOf(I18n.getResource("libreriaxades.validarfirmaxml.error3")) + e.getMessage());
                        return false;
                    }
                    if (nodosKeyInfo.size() > 0 && (nodosIssuerSerial = (primerNodoX509Data = (Element)(nodoKeyInfo = (Element)nodosKeyInfo.get(0)).getElementsByTagNameNS(this.uriXmlNS, "X509Data").item(0)).getElementsByTagNameNS(this.uriXmlNS, "X509IssuerSerial")).getLength() > 0) {
                        NodeList serialVals;
                        X500Principal issuer = null;
                        BigInteger serial = null;
                        Element nodoIssuerSerial = (Element)nodosIssuerSerial.item(0);
                        NodeList issuerVals = nodoIssuerSerial.getElementsByTagNameNS(this.uriXmlNS, "X509IssuerName");
                        if (issuerVals != null) {
                            Element issuerValElement = (Element)issuerVals.item(0);
                            String issuerName = issuerValElement.getFirstChild().getNodeValue();
                            try {
                                issuer = new X500Principal(issuerName);
                            }
                            catch (IllegalArgumentException ex) {
                                this.esValido = false;
                                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                                LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error23"), (Throwable)ex);
                                logv.error(String.valueOf(I18n.getResource("libreriaxades.validarfirmaxml.error3")) + ex.getMessage());
                                return false;
                            }
                            catch (NullPointerException ex) {
                                this.esValido = false;
                                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                                LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error23"), (Throwable)ex);
                                logv.error(String.valueOf(I18n.getResource("libreriaxades.validarfirmaxml.error3")) + ex.getMessage());
                                return false;
                            }
                        }
                        if ((serialVals = nodoIssuerSerial.getElementsByTagNameNS(this.uriXmlNS, "X509SerialNumber")) != null) {
                            Element serialValElement = (Element)serialVals.item(0);
                            serial = new BigInteger(serialValElement.getFirstChild().getNodeValue());
                        }
                        if (!UtilidadCertificados.isSameName(certAComparar.getIssuer(), issuer) || !certAComparar.getSerial().equals(serial)) {
                            this.esValido = false;
                            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error85"));
                            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error85"));
                            return false;
                        }
                    }
                    MessageDigest haseador = UtilidadFirmaElectronica.getMessageDigest(certAComparar.getAlgMethod());
                    byte[] digestCertFirmante = null;
                    try {
                        digestCertFirmante = haseador.digest(certFirmante.getEncoded());
                    }
                    catch (CertificateEncodingException e) {
                        this.esValido = false;
                        this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                        LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error52"));
                        logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error52"));
                        return false;
                    }
                    if (Utilidades.isEqual(digestCertFirmante, Base64Coder.decode(certAComparar.getDigestValue()))) {
                        coincidencia = true;
                        certificadosSigning.remove(i);
                        logv.info("Signing certificate is valid");
                        break;
                    }
                    this.esValido = false;
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error136"));
                    LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error86"));
                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error86"));
                    return false;
                }
                ++i;
            }
            if (!coincidencia) {
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error136"));
                LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error87"));
                logv.error(String.valueOf(I18n.getResource("libreriaxades.validarfirmaxml.error87")) + " because it not match the information contained in the SigningCertificate node.");
                return false;
            }
            int validos = 0;
            int i2 = 0;
            while (i2 < certificadosSigning.size()) {
                DatosX509 certAComparar = (DatosX509)certificadosSigning.get(i2);
                int x = 0;
                while (x < this.cadenaCertificados.size()) {
                    X509Certificate certContenidos = this.cadenaCertificados.get(x);
                    X500Principal certContIssuer = certContenidos.getIssuerX500Principal();
                    BigInteger certContSerial = certContenidos.getSerialNumber();
                    if (UtilidadCertificados.isSameName(certContIssuer, certAComparar.getIssuer()) && certContSerial.equals(certAComparar.getSerial())) {
                        MessageDigest haseador = UtilidadFirmaElectronica.getMessageDigest(certAComparar.getAlgMethod());
                        byte[] digestCertContenidos = null;
                        try {
                            digestCertContenidos = haseador.digest(certContenidos.getEncoded());
                        }
                        catch (CertificateEncodingException e) {
                            this.esValido = false;
                            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error52"));
                            LOGGER.error((Object)I18n.getResource("libreriaxades.firmaxml.error8"), (Throwable)e);
                            logv.error(String.valueOf(I18n.getResource("libreriaxades.validarfirmaxml.error52")) + e.getMessage());
                            return false;
                        }
                        if (Utilidades.isEqual(digestCertContenidos, Base64Coder.decode(certAComparar.getDigestValue()))) {
                            ++validos;
                        } else {
                            this.esValido = false;
                            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error136"));
                            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error88"));
                            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error88"));
                            return false;
                        }
                    }
                    ++x;
                }
                ++i2;
            }
            if (validos < certificadosSigning.size()) {
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error89"));
                LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error89"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error89"));
                return false;
            }
        }
        ArrayList<Object> nodosSignedProperties = new ArrayList();
        try {
            nodosSignedProperties = UtilidadTratarNodo.obtenerNodos(firma, 3, new NombreNodo(esquemaURI, "SignedProperties"));
        }
        catch (FirmaXMLError e) {
            this.esValido = false;
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error139"));
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error77"));
            return false;
        }
        if (nodosSignedProperties.size() == 0) {
            this.esValido = false;
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error139"));
            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error77"));
            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error77"));
            return false;
        }
        Element nodoSignedProperties = (Element)nodosSignedProperties.get(0);
        Node signedPropertiesId = nodoSignedProperties.getAttributes().getNamedItem("Id");
        if (signedPropertiesId == null) {
            this.esValido = false;
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error140"));
            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error78"));
            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error78"));
            return false;
        }
        String nodoId = signedPropertiesId.getNodeValue();
        List<DatosNodosFirmados> references = this.datosFirma.getDatosNodosFirmados();
        if (references.size() == 0) {
            this.esValido = false;
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error141"));
            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error79"));
            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error79"));
            return false;
        }
        String tipoEsperado = UtilidadFirmaElectronica.obtenerTipoReference(esquemaURI);
        for (DatosNodosFirmados dnf : references) {
            Node referenceType;
            Element reference;
            String id = dnf.getId();
            if (id == null || !id.equals(nodoId) || (reference = dnf.getElementReference()) == null || (referenceType = reference.getAttributes().getNamedItem("Type")) == null || !tipoEsperado.equals(referenceType.getNodeValue()) || dnf.canBeModifiedByTransforms()) continue;
            return true;
        }
        this.esValido = false;
        this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error142"));
        LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error80"));
        logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error80"));
        return false;
    }

    private boolean validarSelloTiempoXadesT(EstructuraFirma estructuraFirma) {
        if (this.tsValidator == null) {
            this.tsValidator = new TimeStampValidator();
        }
        Element firma = estructuraFirma.firma;
        String esquemaURI = estructuraFirma.esquema.getSchemaUri();
        ArrayList<Object> nodosSignatureTimeStamp = new ArrayList();
        NodeList nodesEncapsulatedTimeStamp = null;
        Element encapsulatedTimeStampElement = null;
        try {
            String sello;
            NodeList nodosTransforms;
            int transformsLenght;
            try {
                nodosSignatureTimeStamp = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "SignatureTimeStamp"));
            }
            catch (FirmaXMLError e) {
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error143"));
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error91"));
                boolean bl = this.esValido;
                nodesEncapsulatedTimeStamp = null;
                encapsulatedTimeStampElement = null;
                return bl;
            }
            if (nodosSignatureTimeStamp.size() <= 0) {
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error143"));
                LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error91"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error91"));
                boolean bl = this.esValido;
                return bl;
            }
            Element nodoSigTimeStamp = (Element)nodosSignatureTimeStamp.get(0);
            NodeList nodosUri = nodoSigTimeStamp.getElementsByTagNameNS(esquemaURI, this.nombreNodoUri);
            int nodosLenght = nodosUri.getLength();
            if (nodosLenght == 0 && !esquemaURI.equals("http://uri.etsi.org/01903/v1.3.2#") || nodosLenght > 1) {
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error144"));
                LOGGER.error((Object)(String.valueOf(I18n.getResource("libreriaxades.validarfirmaxml.error94")) + " " + nodosLenght));
                logv.error(String.valueOf(I18n.getResource("libreriaxades.validarfirmaxml.error94")) + " " + nodosLenght);
                boolean bl = this.esValido;
                return bl;
            }
            if (esquemaURI.equals("http://uri.etsi.org/01903/v1.1.1#") && (transformsLenght = (nodosTransforms = ((Element)nodosUri.item(0)).getElementsByTagNameNS(this.uriXmlNS, "Transforms")).getLength()) > 0) {
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error145"));
                LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error93"));
                boolean bl = this.esValido;
                return bl;
            }
            if (nodosLenght != 0 || !esquemaURI.equals("http://uri.etsi.org/01903/v1.3.2#")) {
                NamedNodeMap nodosUriAttrb = nodosUri.item(0).getAttributes();
                if (nodosUriAttrb == null || nodosUriAttrb.getNamedItem(this.tipoUri) == null) {
                    this.esValido = false;
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error146"));
                    LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error92"));
                    boolean bl = this.esValido;
                    return bl;
                }
                String timeStampUri = null;
                try {
                    timeStampUri = URLDecoder.decode(nodosUriAttrb.getNamedItem(this.tipoUri).getNodeValue(), "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    this.esValido = false;
                    LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error30"), (Throwable)ex);
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error146"));
                    boolean bl = this.esValido;
                    nodesEncapsulatedTimeStamp = null;
                    encapsulatedTimeStampElement = null;
                    return bl;
                }
                Element nodoReferenciado = UtilidadTratarNodo.getElementById(firma, timeStampUri.substring(1));
                if (nodoReferenciado == null || !"SignatureValue".equals(nodoReferenciado.getLocalName()) || !nodoReferenciado.getParentNode().equals(firma)) {
                    this.esValido = false;
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error147"));
                    LOGGER.error((Object)(String.valueOf(I18n.getResource("libreriaxades.validarfirmaxml.error95")) + " " + "SignatureValue" + " " + I18n.getResource("libreriaxades.validarfirmaxml.error100")));
                    boolean bl = this.esValido;
                    return bl;
                }
            }
            CanonicalizationEnum canonicalization = this.getCanonicalizationMethodTS(esquemaURI, nodoSigTimeStamp);
            if (!this.esValido) {
                boolean bl = this.esValido;
                return bl;
            }
            nodesEncapsulatedTimeStamp = nodoSigTimeStamp.getElementsByTagNameNS(esquemaURI, "EncapsulatedTimeStamp");
            encapsulatedTimeStampElement = (Element)nodesEncapsulatedTimeStamp.item(0);
            this.esValido = this.validateEncodingTS(esquemaURI, encapsulatedTimeStampElement);
            if (!this.esValido) {
                boolean bl = this.esValido;
                return bl;
            }
            try {
                byte[] nodeSignatureValue = UtilidadTratarNodo.obtenerByteNodo(firma, this.uriXmlNS, "SignatureValue", canonicalization, 5);
                this.addDatosSelloFromBytes(encapsulatedTimeStampElement, nodeSignatureValue, TipoSellosTiempo.CLASE_T);
            }
            catch (FirmaXMLError e) {
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error12"));
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                logv.error(e.getMessage());
            }
            catch (TimeStampException e) {
                sello = "";
                if (this.tipoDocFirma.getTipoXAdES().compareTo((Enum)EnumFormatoFirma.XAdES_XL) == 0) {
                    sello = "XAdES T ";
                }
                this.esValido = false;
                this.resultado.setLog(String.valueOf(I18n.getResource("libreriaxades.validarfirmaxml.error8")) + " " + sello + I18n.getResource("libreriaxades.validarfirmaxml.error9") + " " + this.tipoDocFirma.getTipoXAdES() + " " + I18n.getResource("libreriaxades.validarfirmaxml.error13"));
                LOGGER.error((Object)e.getMessage());
                logv.error(e.getMessage());
            }
            catch (Exception e) {
                sello = "";
                if (this.tipoDocFirma.getTipoXAdES().compareTo((Enum)EnumFormatoFirma.XAdES_XL) == 0) {
                    sello = "XAdES T ";
                }
                this.esValido = false;
                this.resultado.setLog(String.valueOf(I18n.getResource("libreriaxades.validarfirmaxml.error8")) + " " + sello + I18n.getResource("libreriaxades.validarfirmaxml.error9") + " " + this.tipoDocFirma.getTipoXAdES() + " " + I18n.getResource("libreriaxades.validarfirmaxml.error13"));
                LOGGER.error((Object)e.getMessage());
                logv.error(e.getMessage());
            }
        }
        finally {
            nodesEncapsulatedTimeStamp = null;
            encapsulatedTimeStampElement = null;
        }
        return this.esValido;
    }

    private void addDatosSelloFromBytes(Element encapsulatedTimeStampElement, byte[] nodeSignatureValue, TipoSellosTiempo tipoSello) throws TimeStampException {
        String encapsulatedTS = encapsulatedTimeStampElement.getFirstChild().getNodeValue();
        byte[] timeStampBytes = Base64.decode(encapsulatedTS);
        DatosSelloTiempo datosSelloTiempo = new DatosSelloTiempo();
        TSValidationResult tsv = this.tsValidator.validateTimeStamp(nodeSignatureValue, timeStampBytes);
        Date fechaSello = tsv.getDate();
        if (fechaSello != null) {
            long now = System.currentTimeMillis();
            if (tsv.getTimeAccurracy() > 0L) {
                now += tsv.getTimeAccurracy();
            }
            if (fechaSello.after(new Date(now))) {
                this.resultado.setResultado(ResultadoEnum.UNKNOWN);
                LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error81"));
                this.resultado.setLog(i18n.getLocalMessage("i18n.mityc.xades.validate.16", new Object[]{fechaSello, tsv.getTimeAccurracy(), new Date(System.currentTimeMillis())}));
                LOGGER.error((Object)i18n.getLocalMessage("i18n.mityc.xades.validate.16", new Object[]{fechaSello, tsv.getTimeAccurracy(), new Date(System.currentTimeMillis())}));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error81"));
            }
        }
        if (this.esValido) {
            try {
                datosSelloTiempo.setFecha(fechaSello);
                datosSelloTiempo.setEmisor(tsv.getTimeStampIssuer());
                datosSelloTiempo.setAlgoritmo(TSPAlgoritmos.getAlgName((String)tsv.getStampAlg()));
                datosSelloTiempo.setPrecision(tsv.getTimeAccurracy());
                datosSelloTiempo.setTipoSello(tipoSello);
                datosSelloTiempo.setRawTimestamp(tsv.getTimeStampRawToken());
                CertPath tsaCerts = tsv.getCadena();
                if (tsaCerts != null) {
                    if (this.truster != null && tsaCerts.getCertificates().size() == 1) {
                        try {
                            tsaCerts = this.truster.getCertPath((X509Certificate)tsaCerts.getCertificates().get(0));
                            datosSelloTiempo.setCadena(UtilidadCertificados.orderCertPath(tsaCerts.getCertificates()));
                            datosSelloTiempo.setEsCertConfianza(ConfianzaEnum.CON_CONFIANZA);
                        }
                        catch (Exception e) {
                            LOGGER.debug((Object)"No se pudo ordenar la cadena de certificados del sello de tiempo");
                            datosSelloTiempo.setCadena(tsaCerts);
                        }
                    } else {
                        LOGGER.debug((Object)"No se pudo recuperar la cadena de certificaci\u00f3n");
                        datosSelloTiempo.setCadena(tsaCerts);
                    }
                }
                logv.abreTag(true);
                logv.info("XAdES-T TimeStamp validation: VALID", 2);
                logv.info("Date: " + fechaSello, 2);
                logv.info("Issuer: " + tsv.getTimeStampIssuer(), 2);
                logv.cierraTag(true);
            }
            catch (Exception e) {
                this.esValido = false;
                LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error64"), (Throwable)e);
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error64"));
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error64"));
            }
            this.arrayDatosSello.add(datosSelloTiempo);
        } else {
            logv.abreTag(false);
            logv.info("XAdES-T TimeStamp validation: INVALID", 2);
            logv.info("Date: " + fechaSello, 2);
            logv.info("Issuer: " + tsv.getTimeStampIssuer(), 2);
            logv.cierraTag(false);
        }
    }

    private CanonicalizationEnum getCanonicalizationMethodTS(String esquemaURI, Element nodoSigTimeStamp) {
        NodeList nodosCanonicalizationMethod = nodoSigTimeStamp.getElementsByTagNameNS(this.uriXmlNS, "CanonicalizationMethod");
        int numNodosCanonicalization = nodosCanonicalizationMethod.getLength();
        CanonicalizationEnum canonicalization = CanonicalizationEnum.C14N_OMIT_COMMENTS;
        if (numNodosCanonicalization > 0) {
            if ("http://uri.etsi.org/01903/v1.1.1#".equals(esquemaURI)) {
                this.esValido = false;
                LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error102"));
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error102"));
                return null;
            }
            Element nodoCanonicalizationMethod = (Element)nodosCanonicalizationMethod.item(0);
            String method = nodoCanonicalizationMethod.getAttribute("Algorithm");
            canonicalization = CanonicalizationEnum.getCanonicalization(method);
            if (canonicalization.equals((Object)CanonicalizationEnum.UNKNOWN)) {
                this.esValido = false;
                LOGGER.error((Object)(String.valueOf(I18n.getResource("libreriaxades.validarfirmaxml.error103")) + " " + method));
                logv.error(String.valueOf(I18n.getResource("libreriaxades.validarfirmaxml.error103")) + " " + method);
                this.resultado.setLog(String.valueOf(I18n.getResource("libreriaxades.validarfirmaxml.error103")) + " " + method);
                return null;
            }
        }
        return canonicalization;
    }

    private boolean validarSelloTiempoXadesX(EstructuraFirma estructuraFirma, String nombreNodo) {
        ArrayList<Object> nodesTimeStamp = new ArrayList();
        try {
            nodesTimeStamp = UtilidadTratarNodo.obtenerNodos(estructuraFirma.firma, 5, new NombreNodo(estructuraFirma.esquema.getSchemaUri(), nombreNodo));
        }
        catch (FirmaXMLError e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        int numNodos = nodesTimeStamp.size();
        if (numNodos == 0) {
            return false;
        }
        int i = 0;
        while (i < numNodos) {
            this.esValido = this.validarSegundoSelloTiempo((Element)nodesTimeStamp.get(i), estructuraFirma);
            if (!this.esValido) break;
            ++i;
        }
        return this.esValido;
    }

    private boolean validarSegundoSelloTiempo(Element selloTiempo, EstructuraFirma estructuraFirma) {
        if (this.tsValidator == null) {
            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error64"));
            return false;
        }
        Element firma = estructuraFirma.firma;
        String esquemaURI = estructuraFirma.esquema.getSchemaUri();
        TipoSellosTiempo tipoSello = TipoSellosTiempo.CLASE_X_TIPO_1;
        if (new NombreNodo(esquemaURI, "SigAndRefsTimeStamp").equals(new NombreNodo(selloTiempo.getNamespaceURI(), selloTiempo.getLocalName()))) {
            tipoSello = TipoSellosTiempo.CLASE_X_TIPO_1;
        } else if (new NombreNodo(esquemaURI, "RefsOnlyTimeStamp").equals(new NombreNodo(selloTiempo.getNamespaceURI(), selloTiempo.getLocalName()))) {
            tipoSello = TipoSellosTiempo.CLASE_X_TIPO_2;
        } else {
            this.esValido = false;
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error15"));
            LOGGER.error((Object)(String.valueOf(I18n.getResource("libreriaxades.validarfirmaxml.error8")) + " " + I18n.getResource("libreriaxades.validarfirmaxml.error9") + " " + selloTiempo.getLocalName() + " " + I18n.getResource("libreriaxades.validarfirmaxml.error10")));
            logv.error(String.valueOf(I18n.getResource("libreriaxades.validarfirmaxml.error8")) + " " + I18n.getResource("libreriaxades.validarfirmaxml.error9") + " " + selloTiempo.getLocalName() + " " + I18n.getResource("libreriaxades.validarfirmaxml.error10"));
            return this.esValido;
        }
        ArrayList<Element> elementosSelloX = null;
        try {
            elementosSelloX = TipoSellosTiempo.CLASE_X_TIPO_1.equals((Object)tipoSello) ? UtilidadXadesX.obtenerListadoXADESX1imp(esquemaURI, firma, selloTiempo) : UtilidadXadesX.obtenerListadoXADESX2exp(esquemaURI, firma, selloTiempo);
        }
        catch (BadFormedSignatureException e) {
            this.esValido = false;
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error148"));
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            logv.error(e.getMessage());
            return this.esValido;
        }
        catch (FirmaXMLError e) {
            this.esValido = false;
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error148"));
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            logv.error(e.getMessage());
            return this.esValido;
        }
        if (elementosSelloX.size() <= 0) {
            this.esValido = false;
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error143"));
            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error91"));
            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error91"));
            return this.esValido;
        }
        if ("http://uri.etsi.org/01903/v1.1.1#".equals(esquemaURI) || "http://uri.etsi.org/01903/v1.2.2#".equals(esquemaURI)) {
            ArrayList<String> elementosIdSelloX = UtilidadTratarNodo.obtenerIDs(elementosSelloX);
            NodeList nodosUriRef = selloTiempo.getElementsByTagNameNS(esquemaURI, this.nombreNodoUri);
            int numNodosUriRef = nodosUriRef.getLength();
            if (numNodosUriRef == 0) {
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error144"));
                LOGGER.error((Object)(String.valueOf(I18n.getResource("libreriaxades.validarfirmaxml.error94")) + " " + numNodosUriRef));
                logv.error(String.valueOf(I18n.getResource("libreriaxades.validarfirmaxml.error94")) + " " + numNodosUriRef);
                return this.esValido;
            }
            ArrayList<String> urisRef = new ArrayList<String>(numNodosUriRef);
            Node nodoUriRef = null;
            int j = 0;
            while (j < numNodosUriRef) {
                NodeList nodosTransforms;
                int transformsLenght;
                nodoUriRef = j == 0 ? (Element)selloTiempo.getFirstChild() : (Element)nodoUriRef.getNextSibling();
                if (nodoUriRef == null || !this.nombreNodoUri.equals(nodoUriRef.getLocalName())) {
                    this.esValido = false;
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error146"));
                    LOGGER.error((Object)(String.valueOf(I18n.getResource("libreriaxades.validarfirmaxml.error95")) + " " + this.nombreNodoUri));
                    return this.esValido;
                }
                if ("http://uri.etsi.org/01903/v1.1.1#".equals(esquemaURI) && (transformsLenght = (nodosTransforms = nodoUriRef.getElementsByTagNameNS(this.uriXmlNS, "Transforms")).getLength()) > 0) {
                    this.esValido = false;
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error145"));
                    LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error93"));
                    return this.esValido;
                }
                NamedNodeMap atributosNodo = nodoUriRef.getAttributes();
                if (atributosNodo == null || atributosNodo.getNamedItem(this.tipoUri) == null) {
                    this.esValido = false;
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error143"));
                    LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error92"));
                    return this.esValido;
                }
                String uriReferencia = atributosNodo.getNamedItem(this.tipoUri).getNodeValue();
                urisRef.add(uriReferencia);
                ++j;
            }
            j = 0;
            while (j < numNodosUriRef) {
                String idUri = ((String)urisRef.get(j)).substring(1);
                if (!idUri.equals(elementosIdSelloX.get(j))) {
                    this.esValido = false;
                    this.resultado.setLog(String.valueOf(I18n.getResource("libreriaxades.validarfirmaxml.error97")) + " " + idUri + " " + I18n.getResource("libreriaxades.validarfirmaxml.error98"));
                    LOGGER.error((Object)(String.valueOf(I18n.getResource("libreriaxades.validarfirmaxml.error97")) + " " + idUri + " " + I18n.getResource("libreriaxades.validarfirmaxml.error98")));
                    return this.esValido;
                }
                ++j;
            }
        }
        CanonicalizationEnum canonicalization = this.getCanonicalizationMethodTS(esquemaURI, selloTiempo);
        if (!this.esValido) {
            return this.esValido;
        }
        byte[] byteData = null;
        try {
            byteData = UtilidadTratarNodo.obtenerByte(elementosSelloX, canonicalization);
        }
        catch (FirmaXMLError e) {
            this.esValido = false;
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error14"));
            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error14"));
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        NodeList nodesEncapsulatedTimeStamp = selloTiempo.getElementsByTagNameNS(esquemaURI, "EncapsulatedTimeStamp");
        if (nodesEncapsulatedTimeStamp.getLength() != 1) {
            this.esValido = false;
            LOGGER.error((Object)(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "EncapsulatedTimeStamp" + I18n.getResource("libreriaxades.firmaxml.error37") + " " + nodesEncapsulatedTimeStamp.getLength()));
            logv.error(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "EncapsulatedTimeStamp" + I18n.getResource("libreriaxades.firmaxml.error37") + " " + nodesEncapsulatedTimeStamp.getLength());
            this.resultado.setLog(I18n.getResource("libreriaxades.firmaxml.error15"));
            return this.esValido;
        }
        Element encapsulatedTimeStampElement = (Element)nodesEncapsulatedTimeStamp.item(0);
        this.esValido = this.validateEncodingTS(esquemaURI, encapsulatedTimeStampElement);
        if (!this.esValido) {
            return this.esValido;
        }
        try {
            this.addDatosSelloFromBytes(encapsulatedTimeStampElement, byteData, tipoSello);
        }
        catch (TimeStampException e) {
            String sello = "";
            if (this.tipoDocFirma.getTipoXAdES().compareTo((Enum)EnumFormatoFirma.XAdES_XL) == 0) {
                sello = "XAdES T ";
            }
            this.esValido = false;
            this.resultado.setLog(String.valueOf(I18n.getResource("libreriaxades.validarfirmaxml.error8")) + " " + sello + I18n.getResource("libreriaxades.validarfirmaxml.error9") + " " + this.tipoDocFirma.getTipoXAdES() + " " + I18n.getResource("libreriaxades.validarfirmaxml.error13"));
            LOGGER.error((Object)e.getMessage());
            logv.error(e.getMessage());
        }
        return true;
    }

    private boolean validateEncodingTS(String esquemaURI, Element encapsulatedTimeStampElement) {
        String enc;
        EncodingEnum encoding;
        if (("http://uri.etsi.org/01903/v1.2.2#".equals(esquemaURI) || "http://uri.etsi.org/01903/v1.3.2#".equals(esquemaURI)) && (encoding = EncodingEnum.getEncoding(enc = encapsulatedTimeStampElement.getAttribute("Encoding"))) == null) {
            this.esValido = false;
            LOGGER.error((Object)("Encoding del sello de tiempo X desconocido: " + enc));
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error148"));
        }
        return this.esValido;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean validarXadesC(String uriDS, X509Certificate certFirma, EstructuraFirma estructuraFirma) {
        byte[] resumenMensajeByte;
        MessageDigest resumenCertificadoTemp;
        HashMap<String, Object> props;
        String uri;
        Element firma = estructuraFirma.firma;
        String esquemaURI = estructuraFirma.esquema.getSchemaUri();
        ArrayList<Object> completeCertificateRefs = new ArrayList();
        ArrayList<Object> completeRevocationRefs = new ArrayList();
        ArrayList<String> certURI = null;
        ArrayList<String> digestAlg = null;
        ArrayList<String> digestValue = null;
        ArrayList<X500Principal> issuerName = null;
        ArrayList<String> issuerSerial = null;
        ArrayList<String> ocspURI = null;
        ArrayList<OCSPResponderID> identifierOCSP = null;
        ArrayList<Date> identifierTime = null;
        ArrayList<String> ocspDigestAlg = null;
        ArrayList<String> ocspDigestValue = null;
        ArrayList<OCSPResp> respuestasOCSP = null;
        ArrayList<String> crlURI = null;
        ArrayList<String> crlDigestAlg = null;
        ArrayList<String> crlDigestValue = null;
        ArrayList<String> crlIssuer = null;
        ArrayList<Date> crlIssuerTime = null;
        ArrayList<BigInteger> crlNumber = null;
        ArrayList<X509CRL> crlList = null;
        try {
            completeCertificateRefs = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "CompleteCertificateRefs"));
            completeRevocationRefs = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "CompleteRevocationRefs"));
        }
        catch (FirmaXMLError e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            logv.error(I18n.getResource("libreriaxades.firmaxml.error29"));
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error135"));
            this.esValido = false;
        }
        if (completeCertificateRefs.size() == 0 || completeRevocationRefs.size() == 0) {
            LOGGER.error((Object)I18n.getResource("libreriaxades.firmaxml.error29"));
            logv.error(I18n.getResource("libreriaxades.firmaxml.error29"));
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error135"));
            this.esValido = false;
            return this.esValido;
        }
        Node certRefs = ((Element)completeCertificateRefs.get(0)).getElementsByTagNameNS(esquemaURI, "CertRefs").item(0);
        if (certRefs == null) {
            this.esValido = false;
            this.resultado.setLog(String.valueOf(I18n.getResource("libreriaxades.validarfirmaxml.error95")) + " " + "CertRefs");
            logv.error(String.valueOf(I18n.getResource("libreriaxades.validarfirmaxml.error95")) + " " + "CertRefs");
            return false;
        }
        ArrayList<Element> certs = UtilidadTratarNodo.getElementChildNodes((Element)certRefs, false);
        if (certs == null) {
            this.esValido = false;
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error3"));
            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error3"));
            return false;
        }
        int l = certs.size();
        certURI = new ArrayList<String>(l);
        digestAlg = new ArrayList<String>(l);
        digestValue = new ArrayList<String>(l);
        issuerName = new ArrayList<X500Principal>(l);
        issuerSerial = new ArrayList<String>(l);
        int i = 0;
        while (i < l && this.esValido) {
            Element certificate = certs.get(i);
            if (certificate != null) {
                String uri2 = null;
                try {
                    uri2 = URLDecoder.decode(certificate.getAttributes().getNamedItem(this.tipoUri).getNodeValue(), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error30"));
                    this.esValido = false;
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error31"));
                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error31"));
                }
                catch (Exception e) {
                    LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error65"));
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error65"));
                }
                if (uri2 != null) {
                    certURI.add(uri2);
                }
                Element certDigest = (Element)certificate.getElementsByTagNameNS(esquemaURI, "CertDigest").item(0);
                Node algorithm = certDigest.getElementsByTagNameNS(uriDS, "DigestMethod").item(0);
                Node value = certDigest.getElementsByTagNameNS(uriDS, "DigestValue").item(0);
                digestAlg.add(algorithm.getAttributes().getNamedItem("Algorithm").getNodeValue());
                digestValue.add(value.getFirstChild().getNodeValue());
                Element issuer = (Element)certificate.getElementsByTagNameNS(esquemaURI, "IssuerSerial").item(0);
                Node name = issuer.getElementsByTagNameNS(uriDS, "X509IssuerName").item(0);
                Node serial = issuer.getElementsByTagNameNS(uriDS, "X509SerialNumber").item(0);
                String issuerRef = name.getFirstChild().getNodeValue();
                if (issuerRef == null) {
                    LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error169"));
                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error169"));
                    this.esValido = false;
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error36"));
                } else {
                    try {
                        issuerName.add(new X500Principal(issuerRef));
                    }
                    catch (IllegalArgumentException e) {
                        LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error169"));
                        logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error169"));
                        this.esValido = false;
                        this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error29"));
                    }
                }
                issuerSerial.add(serial.getFirstChild().getNodeValue());
            }
            ++i;
        }
        Node ocspRefs = ((Element)completeRevocationRefs.get(0)).getElementsByTagNameNS(esquemaURI, "OCSPRefs").item(0);
        if (ocspRefs != null && this.esValido) {
            ArrayList<Element> refs = UtilidadTratarNodo.getElementChildNodes((Element)ocspRefs, false);
            if (refs == null) {
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error95 OCSPRefs"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error95 OCSPRefs"));
                return false;
            }
            int l2 = refs.size();
            ocspURI = new ArrayList<String>(l2);
            identifierOCSP = new ArrayList<OCSPResponderID>(l2);
            OCSPResponderID responderData = null;
            identifierTime = new ArrayList<Date>(l2);
            ocspDigestAlg = new ArrayList<String>(l2);
            ocspDigestValue = new ArrayList<String>(l2);
            String noURIOCSPidentifier = String.valueOf(I18n.getResource("libreriaxades.validarfirmaxml.error32")) + " " + I18n.getResource("libreriaxades.validarfirmaxml.error62");
            int i2 = 0;
            while (i2 < l2 && this.esValido) {
                Element ocspRef = refs.get(i2);
                if (ocspRef != null) {
                    NodeList list = ocspRef.getElementsByTagNameNS(esquemaURI, "OCSPIdentifier");
                    if (list.getLength() != 0) {
                        try {
                            ocspURI.add(URLDecoder.decode(((Element)list.item(0)).getAttributes().getNamedItem(this.tipoUri).getNodeValue(), "UTF-8"));
                        }
                        catch (UnsupportedEncodingException e) {
                            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error30"));
                            this.esValido = false;
                            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error32"));
                            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error32"));
                        }
                        catch (NullPointerException e) {
                            LOGGER.warn((Object)I18n.getResource("libreriaxades.validarfirmaxml.error160"));
                        }
                        catch (Exception e) {
                            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error30"));
                            this.esValido = false;
                            this.resultado.setLog(noURIOCSPidentifier);
                            logv.error(noURIOCSPidentifier);
                        }
                        try {
                            Element certDigest = (Element)ocspRef.getElementsByTagNameNS(esquemaURI, "OCSPIdentifier").item(0);
                            Node responder = certDigest.getElementsByTagNameNS(esquemaURI, "ResponderID").item(0);
                            Node time = certDigest.getElementsByTagNameNS(esquemaURI, "ProducedAt").item(0);
                            responderData = null;
                            if ("http://uri.etsi.org/01903/v1.1.1#".equals(esquemaURI) || "http://uri.etsi.org/01903/v1.2.2#".equals(esquemaURI)) {
                                X500Principal prin = new X500Principal(responder.getFirstChild().getNodeValue());
                                responderData = OCSPResponderID.getOCSPResponderID((X500Principal)prin);
                            } else {
                                Node responderBy = responder.getFirstChild();
                                if ("ByName".equals(responderBy.getLocalName())) {
                                    try {
                                        X500Principal prin = new X500Principal(responderBy.getFirstChild().getNodeValue());
                                        responderData = OCSPResponderID.getOCSPResponderID((X500Principal)prin);
                                    }
                                    catch (IllegalArgumentException ex) {
                                        this.esValido = false;
                                        LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error23"), (Throwable)ex);
                                        this.resultado.setLog(I18n.getResource("libreriaxades.firmaxml.error27"));
                                        logv.error(I18n.getResource("libreriaxades.firmaxml.error27"));
                                        return false;
                                    }
                                    catch (NullPointerException ex) {
                                        this.esValido = false;
                                        this.resultado.setLog(I18n.getResource("libreriaxades.firmaxml.error27"));
                                        logv.error(I18n.getResource("libreriaxades.firmaxml.error27"));
                                        LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error23"), (Throwable)ex);
                                        return false;
                                    }
                                }
                                if ("ByKey".equals(responderBy.getLocalName())) {
                                    String hash = responderBy.getFirstChild().getNodeValue();
                                    try {
                                        responderData = OCSPResponderID.getOCSPResponderID((byte[])es.mityc.javasign.utils.Base64Coder.decode((String)hash));
                                    }
                                    catch (IllegalArgumentException ex) {
                                        LOGGER.error((Object)i18n.getLocalMessage("i18n.mityc.xades.validate.5", new Object[]{hash}));
                                    }
                                }
                                if (responderData == null) {
                                    this.esValido = false;
                                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error101"));
                                    LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error101"));
                                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error101"));
                                    return false;
                                }
                            }
                            identifierOCSP.add(responderData);
                            Date fecha = UtilidadFechas.parseaFechaXML(time.getFirstChild().getNodeValue());
                            if (fecha != null) {
                                identifierTime.add(fecha);
                            } else {
                                this.esValido = false;
                                LOGGER.info((Object)I18n.getResource("libreriaxades.validarfirmaxml.error63"));
                                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error63"));
                                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error40"));
                                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error40"));
                            }
                            Element ocspDigest = (Element)ocspRef.getElementsByTagNameNS(esquemaURI, "DigestAlgAndValue").item(0);
                            Node algorithm = ocspDigest.getElementsByTagNameNS(uriDS, "DigestMethod").item(0);
                            Node value = ocspDigest.getElementsByTagNameNS(uriDS, "DigestValue").item(0);
                            ocspDigestAlg.add(algorithm.getAttributes().getNamedItem("Algorithm").getNodeValue());
                            ocspDigestValue.add(value.getFirstChild().getNodeValue());
                        }
                        catch (Exception ex) {
                            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error66"));
                            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error66"));
                            this.esValido = false;
                            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error66"));
                        }
                    } else {
                        LOGGER.debug((Object)I18n.getResource("libreriaxades.validarfirmaxml.error72"));
                    }
                }
                ++i2;
            }
        }
        Node crlRefs = null;
        NodeList crlRefsList = ((Element)completeRevocationRefs.get(0)).getElementsByTagNameNS(esquemaURI, "CRLRefs");
        if (crlRefsList != null) {
            crlRefs = crlRefsList.item(0);
        }
        if (crlRefs != null && this.esValido) {
            ArrayList<Element> crls = UtilidadTratarNodo.getElementChildNodes((Element)crlRefs, false);
            if (crls == null) {
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error95 CRLRefs"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error95 CRLRefs"));
                return false;
            }
            int l3 = crls.size();
            crlURI = new ArrayList<String>(l3);
            crlDigestAlg = new ArrayList<String>(l3);
            crlDigestValue = new ArrayList<String>(l3);
            crlIssuer = new ArrayList<String>(l3);
            crlIssuerTime = new ArrayList<Date>(l3);
            crlNumber = new ArrayList<BigInteger>(l3);
            int i3 = 0;
            while (i3 < l3) {
                Element crl = crls.get(i3);
                if (crl != null) {
                    Element crlDigest = (Element)crl.getElementsByTagNameNS(esquemaURI, "DigestAlgAndValue").item(0);
                    Node algorithm = crlDigest.getElementsByTagNameNS(uriDS, "DigestMethod").item(0);
                    Node value = crlDigest.getElementsByTagNameNS(uriDS, "DigestValue").item(0);
                    crlDigestAlg.add(algorithm.getAttributes().getNamedItem("Algorithm").getNodeValue());
                    crlDigestValue.add(value.getFirstChild().getNodeValue());
                    Element identifier = (Element)crl.getElementsByTagNameNS(esquemaURI, "CRLIdentifier").item(0);
                    try {
                        crlURI.add(URLDecoder.decode(identifier.getAttributes().getNamedItem(this.tipoUri).getNodeValue(), "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error30"), (Throwable)e);
                        this.esValido = false;
                        this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error33"));
                        logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error33"));
                    }
                    catch (NullPointerException e) {
                        LOGGER.warn((Object)I18n.getResource("libreriaxades.validarfirmaxml.error161"));
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error30"), (Throwable)e);
                        this.esValido = false;
                        this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error33"));
                        logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error33"));
                    }
                    try {
                        Node issuer = identifier.getElementsByTagNameNS(esquemaURI, "Issuer").item(0);
                        Node issuerTime = identifier.getElementsByTagNameNS(esquemaURI, "IssueTime").item(0);
                        Node number = identifier.getElementsByTagNameNS(esquemaURI, "Number").item(0);
                        String crlIssuerName = issuer.getFirstChild().getNodeValue();
                        try {
                            X500Principal prin = new X500Principal(crlIssuerName);
                            crlIssuer.add(prin.getName());
                        }
                        catch (IllegalArgumentException ex) {
                            this.esValido = false;
                            this.resultado.setLog(I18n.getResource("libreriaxades.firmaxml.error44"));
                            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error23"), (Throwable)ex);
                            logv.error(I18n.getResource("libreriaxades.firmaxml.error44"));
                            return false;
                        }
                        catch (NullPointerException ex) {
                            this.esValido = false;
                            this.resultado.setLog(I18n.getResource("libreriaxades.firmaxml.error44"));
                            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error23"), (Throwable)ex);
                            logv.error(I18n.getResource("libreriaxades.firmaxml.error44"));
                            return false;
                        }
                        Date fecha = UtilidadFechas.parseaFechaXML(issuerTime.getFirstChild().getNodeValue());
                        if (fecha != null) {
                            crlIssuerTime.add(fecha);
                        } else {
                            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error63"));
                            this.esValido = false;
                            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error40"));
                            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error63"));
                            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error40"));
                        }
                        if (number != null) {
                            crlNumber.add(new BigInteger(number.getFirstChild().getNodeValue()));
                        } else {
                            crlNumber.add(null);
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error66"), (Throwable)ex);
                        this.esValido = false;
                        this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error66"));
                        logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error66"));
                    }
                }
                ++i3;
            }
        }
        ArrayList<Object> certificateValues = new ArrayList();
        ArrayList<Object> revocationValues = new ArrayList();
        try {
            certificateValues = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "CertificateValues"));
            revocationValues = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "RevocationValues"));
        }
        catch (FirmaXMLError e) {
            LOGGER.debug((Object)e.getMessage(), (Throwable)e);
        }
        boolean certsYOcspInterno = false;
        if (certificateValues.size() != 0 && revocationValues.size() != 0) {
            certsYOcspInterno = true;
        }
        if (ocspDigestValue != null && ocspDigestValue.size() != 0 && this.esValido) {
            int ocspNum = ocspDigestValue.size();
            OCSPResponderID responderData = null;
            byte[] respuesta = null;
            respuestasOCSP = new ArrayList<OCSPResp>(ocspNum);
            int x = 0;
            while (x < ocspNum && this.esValido) {
                block216: {
                    if (certsYOcspInterno) {
                        Node ocsp = null;
                        if (ocspURI != null && ocspURI.size() == ocspNum && (uri = (String)ocspURI.get(x)).startsWith("#")) {
                            ocsp = UtilidadTratarNodo.getElementById(firma.getElementsByTagNameNS(esquemaURI, "EncapsulatedOCSPValue"), uri.substring(1));
                        }
                        if (ocsp == null) {
                            ocsp = this.buscarRevocationValueOCSP((String)ocspDigestValue.get(x), (String)ocspDigestAlg.get(x), estructuraFirma);
                            if (ocsp == null) {
                                LOGGER.info((Object)(String.valueOf(I18n.getResource("libreriaxades.validarfirmaxml.error95")) + " " + "RevocationValues"));
                                this.esValido = false;
                                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error34"));
                                logv.error(String.valueOf(I18n.getResource("libreriaxades.validarfirmaxml.error95")) + " " + "RevocationValues");
                                return this.esValido;
                            }
                            respuesta = Base64.decode(ocsp.getFirstChild().getNodeValue());
                        } else {
                            respuesta = Base64.decode(ocsp.getFirstChild().getNodeValue());
                        }
                    } else if (this.recoverManager != null) {
                        props = new HashMap();
                        if (ocspURI != null && ocspURI.size() == ocspNum && ocspURI.get(x) != null) {
                            props.put("uri", ocspURI.get(x));
                        } else {
                            props.put("emission.date", identifierTime.get(x));
                            props.put("digest.algorithm", ocspDigestAlg.get(x));
                            props.put("digest.value", Base64.decode((String)ocspDigestValue.get(x)));
                            OCSPResponderID ocspData = (OCSPResponderID)identifierOCSP.get(x);
                            IOCSPCertStatus.TYPE_RESPONDER typeResponder = ocspData.getTypeResponderID();
                            if (typeResponder != null) {
                                switch (typeResponder) {
                                    case BY_NAME: {
                                        props.put("issuer.name", (X500Principal)ocspData.getIdentifierData());
                                        break;
                                    }
                                    case BY_KEY: {
                                        props.put("issuer.hash", (byte[])ocspData.getIdentifierData());
                                    }
                                }
                            } else {
                                try {
                                    props.put("issuer.name", new X500Principal((String)ocspData.getIdentifierData()));
                                }
                                catch (IllegalArgumentException ex) {
                                    try {
                                        props.put("issuer.hash", Base64.decode((String)ocspData.getIdentifierData()));
                                    }
                                    catch (IllegalArgumentException ex1) {
                                        LOGGER.warn((Object)i18n.getLocalMessage("i18n.mityc.xades.validate.6"));
                                    }
                                }
                            }
                        }
                        IOCSPCertStatus ocsp = null;
                        try {
                            ocsp = (IOCSPCertStatus)this.recoverManager.getElement(props, IOCSPCertStatus.class);
                        }
                        catch (ElementNotFoundException ex) {
                            LOGGER.warn((Object)i18n.getLocalMessage("i18n.mityc.xades.validate.2"), (Throwable)ex);
                            if (LOGGER.isTraceEnabled()) {
                                LOGGER.trace(props);
                            }
                        }
                        catch (UnknownElementClassException ex) {
                            LOGGER.error((Object)i18n.getLocalMessage("i18n.mityc.xades.validate.3", new Object[]{"IOCSP"}), (Throwable)ex);
                        }
                        if (ocsp == null) {
                            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error34"));
                            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error34"));
                            this.esValido = false;
                            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error36"));
                        } else {
                            respuesta = ocsp.getEncoded();
                        }
                    }
                    String digestOCSPResponse = null;
                    if (this.esValido) {
                        resumenCertificadoTemp = UtilidadFirmaElectronica.getMessageDigest((String)ocspDigestAlg.get(x));
                        resumenMensajeByte = resumenCertificadoTemp.digest(respuesta);
                        digestOCSPResponse = new String(Base64Coder.encode(resumenMensajeByte));
                        if (!((String)ocspDigestValue.get(x)).equals(digestOCSPResponse)) {
                            this.esValido = false;
                            LOGGER.info((Object)I18n.getResource("libreriaxades.validarfirmaxml.error38"));
                            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error38"));
                            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error38"));
                        }
                    }
                    OCSPResp resp = null;
                    if (this.esValido) {
                        Date tiempoRespuesta;
                        block217: {
                            try {
                                resp = new OCSPResp(respuesta);
                            }
                            catch (IOException e) {
                                LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error150"), (Throwable)e);
                                this.esValido = false;
                                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error18"));
                                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error18"));
                            }
                            BasicOCSPResp respuestaBasica = null;
                            OCSPResponderID respuestaOCSP = null;
                            tiempoRespuesta = null;
                            try {
                                try {
                                    respuestaBasica = (BasicOCSPResp)resp.getResponseObject();
                                }
                                catch (ClassCastException e) {
                                    break block216;
                                }
                                tiempoRespuesta = respuestaBasica.getProducedAt();
                                ResponderID respID = respuestaBasica.getResponderId().toASN1Object();
                                respuestaOCSP = ASN1Utils.getResponderID(respID);
                            }
                            catch (OCSPException e) {
                                LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error150"), (Throwable)e);
                                this.esValido = false;
                                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error18"));
                                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error18"));
                            }
                            responderData = (OCSPResponderID)identifierOCSP.get(x);
                            try {
                                X500Principal prin1 = null;
                                byte[] bprin1 = null;
                                if (responderData.getIdentifierData() instanceof String) {
                                    prin1 = new X500Principal((String)responderData.getIdentifierData());
                                } else if (responderData.getIdentifierData() instanceof X500Principal) {
                                    prin1 = (X500Principal)responderData.getIdentifierData();
                                } else {
                                    bprin1 = (byte[])responderData.getIdentifierData();
                                }
                                if (prin1 != null) {
                                    X500Principal prin2 = (X500Principal)respuestaOCSP.getIdentifierData();
                                    if (!prin2.equals(prin1)) {
                                        this.esValido = false;
                                        this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error39"));
                                        LOGGER.info((Object)I18n.getResource("libreriaxades.validarfirmaxml.error39"));
                                        logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error39"));
                                    }
                                    break block217;
                                }
                                byte[] bprin2 = (byte[])respuestaOCSP.getIdentifierData();
                                if (!Arrays.equals(bprin2, bprin1)) {
                                    this.esValido = false;
                                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error39"));
                                    LOGGER.info((Object)I18n.getResource("libreriaxades.validarfirmaxml.error39"));
                                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error39"));
                                }
                            }
                            catch (IllegalArgumentException e) {
                                LOGGER.error((Object)("OCSP-ResponderID problem: " + e.getMessage()));
                                if (responderData.equals(respuestaOCSP)) break block217;
                                this.esValido = false;
                                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error39"));
                                LOGGER.info((Object)I18n.getResource("libreriaxades.validarfirmaxml.error39"));
                                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error39"));
                            }
                        }
                        if (!((Date)identifierTime.get(x)).equals(tiempoRespuesta)) {
                            this.esValido = false;
                            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error40"));
                            LOGGER.info((Object)I18n.getResource("libreriaxades.validarfirmaxml.error40"));
                            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error40"));
                        }
                        if (this.esValido) {
                            respuestasOCSP.add(resp);
                        }
                    }
                }
                ++x;
            }
        }
        if (crlDigestValue != null && crlDigestValue.size() != 0 && this.esValido) {
            int crlNum = crlDigestValue.size();
            X509CRL x509CRL = null;
            crlList = new ArrayList<X509CRL>(crlNum);
            int x = 0;
            while (x < crlNum && this.esValido) {
                if (certsYOcspInterno) {
                    byte[] crl = null;
                    Node crlValue = null;
                    if (crlURI != null && crlURI.size() == crlNum && (uri = (String)crlURI.get(x)).startsWith("#")) {
                        crlValue = UtilidadTratarNodo.getElementById(firma.getElementsByTagNameNS(esquemaURI, "EncapsulatedCRLValue"), uri.substring(1));
                    }
                    if (crlValue == null) {
                        crlValue = this.buscarRevocationValueCRL((String)crlDigestValue.get(x), (String)crlDigestAlg.get(x), estructuraFirma);
                        if (crlValue == null) {
                            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error151"));
                            this.esValido = false;
                            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error41"));
                            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error41"));
                            return this.esValido;
                        }
                        crl = Base64.decode(crlValue.getFirstChild().getNodeValue());
                    } else {
                        crl = Base64.decode(crlValue.getFirstChild().getNodeValue());
                    }
                    if (crl != null) {
                        try {
                            ByteArrayInputStream bais = new ByteArrayInputStream(crl);
                            CertificateFactory certificatefactory = CertificateFactory.getInstance("X.509");
                            x509CRL = (X509CRL)certificatefactory.generateCRL(bais);
                        }
                        catch (CertificateException e) {
                            LOGGER.error((Object)I18n.getResource("libreriaxades.firmaxml.error23"), (Throwable)e);
                            this.esValido = false;
                            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error154"));
                            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error154"));
                        }
                        catch (CRLException e) {
                            LOGGER.error((Object)I18n.getResource("libreriaxades.firmaxml.error44"), (Throwable)e);
                            this.esValido = false;
                            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error154"));
                            logv.error(I18n.getResource("libreriaxades.firmaxml.error44"));
                        }
                    } else {
                        LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error151"));
                        this.esValido = false;
                        this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error41"));
                        logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error41"));
                    }
                } else if (this.recoverManager != null) {
                    HashMap props2 = new HashMap();
                    if (crlURI != null && crlURI.size() == crlNum && crlURI.get(x) != null) {
                        props2.put("uri", crlURI.get(x));
                    }
                    X509CRL x509crl = null;
                    try {
                        x509crl = (X509CRL)this.recoverManager.getElement(props2, X509CRL.class);
                    }
                    catch (ElementNotFoundException ex) {
                        LOGGER.warn((Object)i18n.getLocalMessage("i18n.mityc.xades.validate.2"));
                        if (LOGGER.isTraceEnabled()) {
                            LOGGER.trace(props2);
                        }
                    }
                    catch (UnknownElementClassException ex) {
                        LOGGER.error((Object)i18n.getLocalMessage("i18n.mityc.xades.validate.3", new Object[]{"X509CRL"}), (Throwable)ex);
                    }
                    if (x509crl == null) {
                        LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error152"));
                        this.esValido = false;
                        this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error42"));
                        logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error152"));
                    } else {
                        x509CRL = x509crl;
                    }
                }
                String digestCRLResponse = null;
                if (this.esValido) {
                    MessageDigest resumenCRLTemp = UtilidadFirmaElectronica.getMessageDigest((String)crlDigestAlg.get(x));
                    try {
                        byte[] resumenMensajeByte2 = resumenCRLTemp.digest(x509CRL.getEncoded());
                        digestCRLResponse = new String(Base64Coder.encode(resumenMensajeByte2));
                        if (!((String)crlDigestValue.get(x)).equals(digestCRLResponse)) {
                            this.esValido = false;
                            LOGGER.info((Object)I18n.getResource("libreriaxades.validarfirmaxml.error43"));
                            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error43"));
                            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error43"));
                        }
                    }
                    catch (CRLException ex) {
                        this.esValido = false;
                        LOGGER.info((Object)I18n.getResource("libreriaxades.validarfirmaxml.error43"));
                        this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error43"));
                        logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error43"));
                    }
                }
                if (this.esValido && x509CRL != null) {
                    BigInteger numeroNodo;
                    X509Principal prin2;
                    X509Principal prin1 = new X509Principal((String)crlIssuer.get(x));
                    if (!prin1.equals((Object)(prin2 = new X509Principal(x509CRL.getIssuerX500Principal().getName())))) {
                        this.esValido = false;
                        this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error45"));
                        LOGGER.info((Object)I18n.getResource("libreriaxades.validarfirmaxml.error45"));
                        logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error45"));
                    }
                    Date time = x509CRL.getThisUpdate();
                    if (!((Date)crlIssuerTime.get(x)).equals(time)) {
                        this.esValido = false;
                        this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error46"));
                        LOGGER.info((Object)I18n.getResource("libreriaxades.validarfirmaxml.error46"));
                        logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error46"));
                    }
                    if ((numeroNodo = (BigInteger)crlNumber.get(x)) != null) {
                        BigInteger numeroRecuperado = null;
                        DERInteger derInt = null;
                        ASN1InputStream ais = new ASN1InputStream(x509CRL.getExtensionValue("2.5.29.20"));
                        try {
                            ais = new ASN1InputStream(((DEROctetString)ais.readObject()).getOctets());
                            derInt = (DERInteger)ais.readObject();
                        }
                        catch (IOException e) {
                            this.esValido = false;
                            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error47"), (Throwable)e);
                            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error47"));
                            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error47"));
                        }
                        numeroRecuperado = derInt.getValue();
                        if (!numeroNodo.equals(numeroRecuperado)) {
                            this.esValido = false;
                            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error48"));
                            LOGGER.info((Object)I18n.getResource("libreriaxades.validarfirmaxml.error48"));
                            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error48"));
                        }
                    }
                }
                if (this.esValido) {
                    crlList.add(x509CRL);
                }
                ++x;
            }
        }
        int numCert = digestValue.size();
        ArrayList<Certificate> certsDeURI = new ArrayList<Certificate>();
        Certificate certificado = null;
        int x = 0;
        while (x < numCert && this.esValido) {
            if (certsYOcspInterno) {
                Node certValue = null;
                if (certURI != null && certURI.size() == numCert && (uri = (String)certURI.get(x)).startsWith("#")) {
                    certValue = UtilidadTratarNodo.getElementById(firma.getElementsByTagNameNS(esquemaURI, "EncapsulatedX509Certificate"), ((String)certURI.get(x)).substring(1));
                }
                if (certValue == null) {
                    certificado = this.buscarCertificateValue((X500Principal)issuerName.get(x), new BigInteger((String)issuerSerial.get(x)), estructuraFirma);
                    if (certificado == null) {
                        LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error155"));
                        this.esValido = false;
                        this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error49"));
                        logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error155"));
                        return this.esValido;
                    }
                } else {
                    try {
                        ByteArrayInputStream bais = new ByteArrayInputStream(Base64.decode(certValue.getFirstChild().getNodeValue()));
                        CertificateFactory cf = CertificateFactory.getInstance("X.509");
                        certificado = (X509Certificate)cf.generateCertificate(bais);
                    }
                    catch (CertificateException e1) {
                        LOGGER.error((Object)I18n.getResource("libreriaxades.firmaxml.error23"), (Throwable)e1);
                        this.esValido = false;
                        this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error156"));
                        logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error156"));
                    }
                }
            } else if (this.recoverManager != null) {
                props = new HashMap<String, Object>();
                if (certURI != null && certURI.size() == numCert && certURI.get(x) != null) {
                    props.put("uri", certURI.get(x));
                }
                X509Certificate x509cert = null;
                try {
                    x509cert = (X509Certificate)this.recoverManager.getElement(props, X509Certificate.class);
                }
                catch (ElementNotFoundException ex) {
                    LOGGER.warn((Object)i18n.getLocalMessage("i18n.mityc.xades.validate.2"));
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace(props);
                    }
                }
                catch (UnknownElementClassException ex) {
                    LOGGER.error((Object)i18n.getLocalMessage("i18n.mityc.xades.validate.3", new Object[]{"X509Certificate"}), (Throwable)ex);
                }
                if (x509cert == null) {
                    LOGGER.error((Object)i18n.getLocalMessage("i18n.mityc.xades.validate.4", new Object[]{certURI, x}));
                    this.esValido = false;
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error50"));
                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error50"));
                } else {
                    certificado = x509cert;
                }
            }
            String resumenCertificado = "";
            try {
                resumenCertificadoTemp = UtilidadFirmaElectronica.getMessageDigest((String)digestAlg.get(x));
                if (resumenCertificadoTemp == null) {
                    this.esValido = false;
                    this.resultado.setLog(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error16")) + ": " + (String)digestAlg.get(x));
                    LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error52"));
                    logv.error(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error16")) + ": " + (String)digestAlg.get(x));
                    return false;
                }
                resumenMensajeByte = resumenCertificadoTemp.digest(certificado.getEncoded());
                resumenCertificado = new String(Base64Coder.encode(resumenMensajeByte));
            }
            catch (CertificateEncodingException e) {
                LOGGER.error((Object)(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error23")) + ": " + e.getMessage()), (Throwable)e);
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error52"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error52"));
            }
            if (!((String)digestValue.get(x)).equals(resumenCertificado)) {
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error53"));
                LOGGER.info((Object)I18n.getResource("libreriaxades.validarfirmaxml.error53"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error53"));
            }
            if (!((String)issuerSerial.get(x)).equals(((X509Certificate)certificado).getSerialNumber().toString())) {
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error54"));
                LOGGER.info((Object)I18n.getResource("libreriaxades.validarfirmaxml.error54"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error54"));
            }
            if (this.esValido) {
                certsDeURI.add(certificado);
            }
            ++x;
        }
        X509Certificate signingCert = this.cadenaCertificados.get(0);
        this.cadenaCertificados.addAll(certsDeURI);
        ArrayList<ArrayList<X509Certificate>> certChains = UtilidadCertificados.filterCertPathsArrays(UtilidadCertificados.getCertPathsArray(this.cadenaCertificados), UtilidadCertificados.Filter.SIGN_SIGNER);
        if (certChains.size() > 1) {
            LOGGER.info((Object)(String.valueOf(I18n.getResource("libreriaxades.validarfirmaxml.error84")) + ": " + certChains.size()));
            logv.error(String.valueOf(I18n.getResource("libreriaxades.validarfirmaxml.error84")) + ": " + certChains.size());
        }
        ArrayList<X509Certificate> certificadoYaValidadoOCSP = new ArrayList<X509Certificate>();
        int z = 0;
        while (z < certChains.size()) {
            this.cadenaCertificados = certChains.get(z);
            Iterator<X509Certificate> certGenIter = this.cadenaCertificados.iterator();
            ArrayList<X509Certificate> cadenaClon = new ArrayList<X509Certificate>(this.cadenaCertificados);
            cadenaClon.remove(0);
            certGenIter.next();
            int certRefLenght = digestValue.size();
            block85: while (certGenIter.hasNext()) {
                X509Certificate certAValidar = certGenIter.next();
                int i4 = 0;
                while (i4 < certRefLenght && this.esValido) {
                    X500Principal issuer = (X500Principal)issuerName.get(i4);
                    BigInteger serial = new BigInteger((String)issuerSerial.get(i4));
                    String alg = (String)digestAlg.get(i4);
                    byte[] value = Base64Coder.decode((String)digestValue.get(i4));
                    if (issuer.equals(certAValidar.getIssuerX500Principal()) && serial.equals(certAValidar.getSerialNumber())) {
                        MessageDigest haseador = UtilidadFirmaElectronica.getMessageDigest(alg);
                        byte[] digestCert = null;
                        try {
                            digestCert = haseador.digest(certAValidar.getEncoded());
                        }
                        catch (CertificateEncodingException e) {
                            this.esValido = false;
                            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error52"));
                            LOGGER.error((Object)(String.valueOf(I18n.getResource("libreriaxades.validarfirmaxml.error23")) + ": " + e.getMessage()), (Throwable)e);
                            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error52"));
                            return false;
                        }
                        if (Utilidades.isEqual(digestCert, value)) {
                            cadenaClon.remove(certAValidar);
                            continue block85;
                        }
                    }
                    ++i4;
                }
            }
            if (cadenaClon.size() > 0) {
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error67"));
                LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error67"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error67"));
                return false;
            }
            int b = 0;
            while (b < this.cadenaCertificados.size()) {
                if (this.cadenaCertificados.get(b).equals(signingCert)) {
                    this.datosFirma.setCadenaFirma(UtilidadCertificados.convertCertPath(this.cadenaCertificados));
                    break;
                }
                ++b;
            }
            if (this.esValido) {
                boolean tieneError = false;
                int numCadenaCerts = this.cadenaCertificados.size();
                int i5 = 0;
                while (i5 < numCadenaCerts) {
                    X509Certificate certAValidar = this.cadenaCertificados.get(i5);
                    if (!certificadoYaValidadoOCSP.contains(certAValidar)) {
                        boolean hasNext;
                        X509Certificate certIssuer = null;
                        certIssuer = i5 < numCadenaCerts - 1 ? this.cadenaCertificados.get(i5 + 1) : certAValidar;
                        CertificateID certificadoId = null;
                        try {
                            certificadoId = new CertificateID("1.3.14.3.2.26", certIssuer, certAValidar.getSerialNumber());
                        }
                        catch (OCSPException ex) {
                            LOGGER.error((Object)(String.valueOf(I18n.getResource("libreriaxades.validarfirmaxml.error158")) + ": " + ex.getMessage()), (Throwable)ex);
                            this.esValido = false;
                            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error56"));
                            if (i5 == 0) {
                                logv.abreTag(false);
                                logv.info("Certificate chain status:", 2);
                                tieneError = true;
                            }
                            logv.error(String.valueOf(I18n.getResource("libreriaxades.validarfirmaxml.error158")) + ": " + ex.getMessage(), 2);
                            break;
                        }
                        int good = 0;
                        int revoked = 0;
                        DatosOCSP datosOCSP = null;
                        DatosCRL datosCRL = null;
                        BasicOCSPResp basicOcsp = null;
                        if (respuestasOCSP != null) {
                            Iterator itRespOCSP = respuestasOCSP.iterator();
                            hasNext = itRespOCSP.hasNext();
                            while (hasNext && this.esValido) {
                                OCSPResp respuestaOCSP = (OCSPResp)itRespOCSP.next();
                                try {
                                    basicOcsp = (BasicOCSPResp)respuestaOCSP.getResponseObject();
                                }
                                catch (OCSPException e) {
                                    LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error118"), (Throwable)e);
                                    if (i5 == 0) {
                                        logv.abreTag(false);
                                        logv.info("Certificate chain status:", 2);
                                        tieneError = true;
                                    }
                                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error118"), 2);
                                    break;
                                }
                                hasNext = itRespOCSP.hasNext();
                                SingleResp[] singleResps = basicOcsp.getResponses();
                                int numSingleResps = singleResps.length;
                                int j = 0;
                                while (j < numSingleResps) {
                                    if (certificadoId.equals((Object)singleResps[j].getCertID())) {
                                        datosOCSP = new DatosOCSP();
                                        datosOCSP.setResponderId(basicOcsp.getResponderId().toASN1Object());
                                        datosOCSP.setCertConsultado(certAValidar.getSubjectX500Principal().toString());
                                        datosOCSP.setFechaConsulta(basicOcsp.getProducedAt());
                                        datosOCSP.setRespuestaOCSP(respuestaOCSP);
                                        RespuestaOCSP res = null;
                                        boolean isUnknown = false;
                                        Object obj = singleResps[j].getCertStatus();
                                        if (obj == null) {
                                            ++good;
                                            if (i5 == 0) {
                                                logv.abreTag(true);
                                                logv.info("Certificate chain status:", 2);
                                            }
                                            if (i5 < identifierOCSP.size()) {
                                                logv.info("Certificate: " + certAValidar.getSubjectDN() + " is VALID (OCSP response: " + ((OCSPResponderID)identifierOCSP.get(i5)).toString() + ")", 2);
                                            }
                                        } else if (obj instanceof RevokedStatus) {
                                            ++revoked;
                                            if (i5 == 0) {
                                                logv.abreTag(false);
                                                logv.info("Certificate chain status:", 2);
                                                tieneError = true;
                                            }
                                            logv.error("Certificate: " + certificadoId + " is REVOKED (OCSP response: " + basicOcsp.getResponderId() + ")", 2);
                                        } else if (obj instanceof UnknownStatus) {
                                            isUnknown = true;
                                            datosOCSP.setRevockedStatus(ICertStatus.CERT_STATUS.unknown);
                                            res = new RespuestaOCSP(2, "");
                                        }
                                        if (!isUnknown) {
                                            switch (respuestaOCSP.getStatus()) {
                                                case 0: {
                                                    datosOCSP.setRevockedStatus(ICertStatus.CERT_STATUS.valid);
                                                    res = new RespuestaOCSP(0, "");
                                                    break;
                                                }
                                                case 1: {
                                                    datosOCSP.setRevockedStatus(ICertStatus.CERT_STATUS.revoked);
                                                    res = new RespuestaOCSP(1, "");
                                                    break;
                                                }
                                                default: {
                                                    datosOCSP.setRevockedStatus(ICertStatus.CERT_STATUS.unknown);
                                                    res = new RespuestaOCSP(2, "");
                                                }
                                            }
                                        }
                                        datosOCSP.setStatus((ICertStatus)new OCSPStatus(res, certAValidar));
                                        try {
                                            CertPath ocspCertChain = UtilidadCertificados.orderCertPath(Arrays.asList(basicOcsp.getCerts("SUN")));
                                            datosOCSP.setCertOCSPResponder(ocspCertChain.getCertificates().toArray(new X509Certificate[0]));
                                        }
                                        catch (NoSuchProviderException e) {
                                            LOGGER.error((Object)e.getMessage(), (Throwable)e);
                                        }
                                        catch (OCSPException e) {
                                            LOGGER.error((Object)e.getMessage(), (Throwable)e);
                                        }
                                        this.arrayDatosOCSP.add(datosOCSP);
                                        break;
                                    }
                                    ++j;
                                }
                                if (revoked > 0 || good > 0) break;
                            }
                        }
                        if (crlList != null) {
                            Iterator itCRLList = crlList.iterator();
                            hasNext = itCRLList.hasNext();
                            while (hasNext && this.esValido) {
                                X509CRL x509CRL = (X509CRL)itCRLList.next();
                                hasNext = itCRLList.hasNext();
                                if (!x509CRL.getIssuerX500Principal().getName().equals(certIssuer.getSubjectX500Principal().getName()) || certAValidar.getSubjectDN().equals(certAValidar.getIssuerDN())) continue;
                                if (x509CRL.isRevoked(certAValidar)) {
                                    ++revoked;
                                    if (i5 == 0) {
                                        logv.abreTag(false);
                                        logv.info("Certificate chain status:", 2);
                                        tieneError = true;
                                    }
                                    logv.error("Certificate: " + certAValidar.getSubjectDN() + " is REVOKED (CRL response: " + x509CRL.getIssuerX500Principal().getName() + ")", 2);
                                    break;
                                }
                                ++good;
                                if (i5 == 0) {
                                    logv.abreTag(true);
                                    logv.info("Certificate chain status:", 2);
                                }
                                logv.info("Certificate: " + certAValidar.getSubjectDN() + " is VALID (CRL response: " + x509CRL.getIssuerX500Principal().getName() + ")", 2);
                                datosCRL = new DatosCRL();
                                datosCRL.setIssuer(x509CRL.getIssuerX500Principal().getName());
                                datosCRL.setFechaEmision(x509CRL.getThisUpdate());
                                datosCRL.setFechaCaducidad(x509CRL.getNextUpdate());
                                datosCRL.setX509CRL(x509CRL);
                                this.arrayDatosCRL.add(datosCRL);
                            }
                            if (revoked > 0) break;
                        }
                        if (revoked == 0 && good == 0) {
                            if (!certAValidar.getSubjectDN().equals(certAValidar.getIssuerDN())) {
                                LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error67"));
                                if (i5 == 0) {
                                    logv.abreTag(false);
                                    logv.info("Certificate chain status:", 2);
                                    tieneError = true;
                                }
                                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error67"), 2);
                                this.esValido = false;
                                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error67"));
                                break;
                            }
                        } else if (revoked > 0 || good == 0) {
                            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error57"));
                            if (i5 == 0) {
                                logv.abreTag(false);
                                logv.info("Certificate chain status:", 2);
                                tieneError = true;
                            }
                            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error57"), 2);
                            this.esValido = false;
                            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error57"));
                            break;
                        }
                        certificadoYaValidadoOCSP.add(certAValidar);
                    }
                    ++i5;
                }
                logv.cierraTag(!tieneError);
            }
            ++z;
        }
        return this.esValido;
    }

    private boolean validaXadesA(EstructuraFirma estructuraFirma) throws Exception {
        Element firma = estructuraFirma.firma;
        String esquemaURI = estructuraFirma.esquema.getSchemaUri();
        Element archiveTimeStampNode = null;
        ArrayList<Object> nodesArchiveTimeStamp = new ArrayList();
        try {
            nodesArchiveTimeStamp = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "ArchiveTimeStamp"));
        }
        catch (FirmaXMLError e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        int numNodes = nodesArchiveTimeStamp.size();
        if (numNodes == 0) {
            this.esValido = false;
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error15"));
            LOGGER.error((Object)"El sello de tiempo del nivel XAdES-A, no es v\u00e1lido");
            logv.error(String.valueOf(I18n.getResource("libreriaxades.validarfirmaxml.error8")) + " " + I18n.getResource("libreriaxades.validarfirmaxml.error9") + " " + I18n.getResource("libreriaxades.validarfirmaxml.error10"));
            return this.esValido;
        }
        TSValidationResult tsv2 = null;
        DatosSelloTiempo datosSelloTiempo = null;
        byte[] byteData = null;
        int i = 0;
        while (i < numNodes) {
            archiveTimeStampNode = (Element)nodesArchiveTimeStamp.get(i);
            datosSelloTiempo = new DatosSelloTiempo();
            if ("http://uri.etsi.org/01903/v1.1.1#".equals(esquemaURI) || "http://uri.etsi.org/01903/v1.2.2#".equals(esquemaURI)) {
                ArrayList<String> inc = UtilidadXadesA.obtenerListadoIdsElementosXadesA(esquemaURI, estructuraFirma.xmlSig, archiveTimeStampNode);
                ArrayList<Element> incNodes = UtilidadTratarNodo.obtenerNodos(archiveTimeStampNode, 1, new NombreNodo(esquemaURI, "Include"));
                String uriIncludeObtenida = null;
                Element incNode = null;
                String uriIncludeLeida = null;
                int j = 0;
                while (j < inc.size()) {
                    uriIncludeObtenida = inc.get(j);
                    if (!uriIncludeObtenida.equals(uriIncludeLeida = (incNode = incNodes.get(j)).getAttribute("URI"))) {
                        this.esValido = false;
                        this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error15"));
                        LOGGER.error((Object)"El sello de tiempo del nivel XAdES-A, no es v\u00e1lido. Los nodos Include no coinciden con los esperados");
                        logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error15"));
                        return this.esValido;
                    }
                    ++j;
                }
            }
            try {
                byteData = UtilidadXadesA.obtenerListadoXadesA(esquemaURI, estructuraFirma.xmlSig, archiveTimeStampNode);
            }
            catch (BadFormedSignatureException e) {
                this.esValido = false;
                LOGGER.error((Object)("Firma mal formada: " + e.getMessage()));
                this.resultado.setLog(e.getMessage());
                logv.error(e.getMessage());
                return this.esValido;
            }
            NodeList nodesEncapsulatedTimeStamp = archiveTimeStampNode.getElementsByTagNameNS(esquemaURI, "EncapsulatedTimeStamp");
            if (nodesEncapsulatedTimeStamp.getLength() != 1) {
                this.esValido = false;
                LOGGER.error((Object)(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "EncapsulatedTimeStamp" + " " + I18n.getResource("libreriaxades.firmaxml.error37") + " " + nodesEncapsulatedTimeStamp.getLength()));
                logv.error(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "EncapsulatedTimeStamp" + I18n.getResource("libreriaxades.firmaxml.error37") + " " + nodesEncapsulatedTimeStamp.getLength());
                this.resultado.setLog("El sello de tiempo XAdES-A no es v\u00e1lido");
                return this.esValido;
            }
            Element encapsulatedTimeStampElement = (Element)nodesEncapsulatedTimeStamp.item(0);
            String enc = encapsulatedTimeStampElement.getAttribute("Encoding");
            EncodingEnum encoding = EncodingEnum.getEncoding(enc);
            if (encoding == null) {
                this.esValido = false;
                LOGGER.error((Object)("Encoding del sello de tiempo A desconocido: " + enc));
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error171"));
                return this.esValido;
            }
            String encapsulatedTS = encapsulatedTimeStampElement.getFirstChild().getNodeValue();
            byte[] timeStampBytes = Base64.decode(encapsulatedTS);
            try {
                tsv2 = this.tsValidator.validateTimeStamp(byteData, timeStampBytes);
            }
            catch (TimeStampException e) {
                this.esValido = false;
                LOGGER.info((Object)"El sello de tiempo XAdES-A no es v\u00e1lido");
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error15"));
                this.resultado.setLog("El sello de tiempo XAdES-A no es v\u00e1lido");
                return this.esValido;
            }
            Date fechaSello = tsv2.getDate();
            if (fechaSello != null) {
                long now = System.currentTimeMillis();
                if (tsv2.getTimeAccurracy() > 0L) {
                    now += tsv2.getTimeAccurracy();
                }
                if (fechaSello.after(new Date(now))) {
                    this.resultado.setLog(i18n.getLocalMessage("i18n.mityc.xades.validate.16", new Object[]{fechaSello, tsv2.getTimeAccurracy(), new Date(System.currentTimeMillis())}));
                    LOGGER.error((Object)i18n.getLocalMessage("i18n.mityc.xades.validate.16", new Object[]{fechaSello, tsv2.getTimeAccurracy(), new Date(System.currentTimeMillis())}));
                    this.resultado.setResultado(ResultadoEnum.UNKNOWN);
                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error82"));
                }
            }
            try {
                datosSelloTiempo.setFecha(fechaSello);
                datosSelloTiempo.setEmisor(tsv2.getTimeStampIssuer());
                datosSelloTiempo.setAlgoritmo(TSPAlgoritmos.getAlgName((String)tsv2.getStampAlg()));
                datosSelloTiempo.setPrecision(tsv2.getTimeAccurracy());
                datosSelloTiempo.setTipoSello(TipoSellosTiempo.CLASE_A);
                datosSelloTiempo.setRawTimestamp(tsv2.getTimeStampRawToken());
                CertPath tsaCerts = tsv2.getCadena();
                if (tsaCerts != null) {
                    if (this.truster != null && tsaCerts.getCertificates().size() == 1) {
                        try {
                            tsaCerts = this.truster.getCertPath((X509Certificate)tsaCerts.getCertificates().get(0));
                            datosSelloTiempo.setCadena(UtilidadCertificados.orderCertPath(tsaCerts.getCertificates()));
                        }
                        catch (Exception e) {
                            LOGGER.debug((Object)"No se pudo ordenar la cadena de certificados del sello de tiempo");
                            datosSelloTiempo.setCadena(tsaCerts);
                        }
                    } else {
                        LOGGER.debug((Object)"No se pudo recuperar la cadena de certificaci\u00f3n");
                        datosSelloTiempo.setCadena(tsaCerts);
                    }
                }
                if (this.esValido) {
                    logv.abreTag(true);
                    logv.info("XAdES-A TimeStamp validation: VALID", 2);
                    logv.info("Date: " + fechaSello, 2);
                    logv.info("Issuer: " + tsv2.getTimeStampIssuer(), 2);
                    logv.cierraTag(true);
                    this.resultado.setNivelValido(I18n.getResource("libreriaxades.validarfirmaxml.texto8"));
                } else {
                    logv.abreTag(false);
                    logv.info("XAdES-A TimeStamp validation: INVALID", 2);
                    logv.info("Date: " + fechaSello, 2);
                    logv.info("Issuer: " + tsv2.getTimeStampIssuer(), 2);
                    logv.cierraTag(false);
                }
            }
            catch (Exception e) {
                this.esValido = false;
                LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error64"), (Throwable)e);
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error64"));
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error64"));
                return this.esValido;
            }
            this.arrayDatosSello.add(datosSelloTiempo);
            ++i;
        }
        return true;
    }

    private X509Certificate buscarCertificateValue(X500Principal certIssuer, BigInteger serialNumber, EstructuraFirma estructuraFirma) {
        Element firma = estructuraFirma.firma;
        String esquemaURI = estructuraFirma.esquema.getSchemaUri();
        X509Certificate certificado = null;
        CertificateValues certificateValues = new CertificateValues(estructuraFirma.esquema);
        ArrayList<Object> certificateValuesNodeList = new ArrayList();
        try {
            certificateValuesNodeList = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "CertificateValues"));
        }
        catch (FirmaXMLError e) {
            LOGGER.debug((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        int certLength = certificateValuesNodeList.size();
        int i = 0;
        while (i < certLength) {
            try {
                certificateValues.load((Element)certificateValuesNodeList.get(i));
            }
            catch (InvalidInfoNodeException e) {
                LOGGER.debug((Object)e.getMessage(), (Throwable)e);
                return null;
            }
            ArrayList<EncapsulatedX509Certificate> certificados = certificateValues.getCertificates();
            int certificadosLength = certificados.size();
            int j = 0;
            while (j < certificadosLength) {
                EncapsulatedX509Certificate certEncapsulated = certificados.get(j);
                try {
                    certificado = certEncapsulated.getX509Certificate();
                }
                catch (CertificateException e) {
                    LOGGER.debug((Object)e.getMessage(), (Throwable)e);
                    return null;
                }
                if (certIssuer.equals(certificado.getIssuerX500Principal()) && serialNumber.equals(certificado.getSerialNumber())) {
                    return certificado;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private Element buscarRevocationValueOCSP(String digest, String method, EstructuraFirma estructuraFirma) {
        Element firma = estructuraFirma.firma;
        String esquemaURI = estructuraFirma.esquema.getSchemaUri();
        ArrayList<Object> revocationValuesNodeList = new ArrayList();
        try {
            revocationValuesNodeList = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "RevocationValues"));
        }
        catch (FirmaXMLError e) {
            LOGGER.debug((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        int revocationLength = revocationValuesNodeList.size();
        int i = 0;
        while (i < revocationLength) {
            Element revocationValuesElement = (Element)revocationValuesNodeList.get(i);
            NodeList ocspValues = revocationValuesElement.getElementsByTagNameNS(esquemaURI, "OCSPValues");
            if (ocspValues.getLength() != 1) {
                LOGGER.error((Object)(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "OCSPValues" + " " + I18n.getResource("libreriaxades.firmaxml.error37") + " " + ocspValues.getLength()));
                logv.error(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "OCSPValues" + " " + I18n.getResource("libreriaxades.firmaxml.error37") + " " + ocspValues.getLength());
                return null;
            }
            ArrayList<Element> respuestasOCSP = UtilidadTratarNodo.getElementChildNodes((Element)ocspValues.item(0), false);
            if (respuestasOCSP == null) {
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error95 OCSPValues"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error95 OCSPValues"));
                return null;
            }
            int respuestasOCSPLength = respuestasOCSP.size();
            int j = 0;
            while (j < respuestasOCSPLength) {
                byte[] data;
                Element respuestaOCSPElement;
                block11: {
                    respuestaOCSPElement = respuestasOCSP.get(j);
                    if (!new NombreNodo(esquemaURI, "EncapsulatedOCSPValue").equals(new NombreNodo(respuestaOCSPElement.getNamespaceURI(), respuestaOCSPElement.getLocalName()))) {
                        LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error119"));
                        logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error119"));
                        return null;
                    }
                    data = null;
                    String encapsulatedValue = respuestaOCSPElement.getFirstChild().getNodeValue();
                    if (encapsulatedValue != null) {
                        try {
                            data = Base64Coder.decode(encapsulatedValue);
                            break block11;
                        }
                        catch (IllegalArgumentException ex) {
                            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error120"), (Throwable)ex);
                            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error120"));
                            break;
                        }
                    }
                    LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error121"));
                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error121"));
                    return null;
                }
                MessageDigest resumenTemp = UtilidadFirmaElectronica.getMessageDigest(method);
                byte[] resumenMensajeByte = resumenTemp.digest(data);
                String digestLeido = new String(Base64Coder.encode(resumenMensajeByte));
                if (digest.equals(digestLeido)) {
                    return respuestaOCSPElement;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private Element buscarRevocationValueCRL(String digest, String method, EstructuraFirma estructuraFirma) {
        Element firma = estructuraFirma.firma;
        String esquemaURI = estructuraFirma.esquema.getSchemaUri();
        ArrayList<Object> revocationValuesNodeList = new ArrayList();
        try {
            revocationValuesNodeList = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "RevocationValues"));
        }
        catch (FirmaXMLError e) {
            LOGGER.debug((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        int revocationLength = revocationValuesNodeList.size();
        int i = 0;
        while (i < revocationLength) {
            Element revocationValuesElement = (Element)revocationValuesNodeList.get(i);
            NodeList crlValues = revocationValuesElement.getElementsByTagNameNS(esquemaURI, "CRLValues");
            if (crlValues.getLength() != 1) {
                LOGGER.error((Object)(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "CRLValues" + " " + I18n.getResource("libreriaxades.firmaxml.error37") + " " + crlValues.getLength()));
                logv.error(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "CRLValues" + " " + I18n.getResource("libreriaxades.firmaxml.error37") + " " + crlValues.getLength());
                return null;
            }
            ArrayList<Element> crls = UtilidadTratarNodo.getElementChildNodes((Element)crlValues.item(0), false);
            if (crls == null) {
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error95 CRLValues"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error95 CRLValues"));
                return null;
            }
            int crlsLength = crls.size();
            int j = 0;
            while (j < crlsLength) {
                byte[] data;
                Element crlElement;
                block11: {
                    crlElement = crls.get(j);
                    if (!new NombreNodo(esquemaURI, "EncapsulatedCRLValue").equals(new NombreNodo(crlElement.getNamespaceURI(), crlElement.getLocalName()))) {
                        LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error122"));
                        logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error122"));
                        return null;
                    }
                    data = null;
                    String encapsulatedValue = crlElement.getFirstChild().getNodeValue();
                    if (encapsulatedValue != null) {
                        try {
                            data = Base64Coder.decode(encapsulatedValue);
                            break block11;
                        }
                        catch (IllegalArgumentException ex) {
                            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error123"), (Throwable)ex);
                            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error123"));
                            break;
                        }
                    }
                    LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error124"));
                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error124"));
                    return null;
                }
                MessageDigest resumenTemp = UtilidadFirmaElectronica.getMessageDigest(method);
                byte[] resumenMensajeByte = resumenTemp.digest(data);
                String digestLeido = new String(Base64Coder.encode(resumenMensajeByte));
                if (digest.equals(digestLeido)) {
                    return crlElement;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private DatosTipoFirma tipoFirma(EstructuraFirma estructuraFirma) throws BadFormedSignatureException {
        Element firma = estructuraFirma.firma;
        String esquema = estructuraFirma.esquema.getSchemaUri();
        DatosTipoFirma datosTipoFirma = new DatosTipoFirma();
        boolean esXAdES_C = false;
        boolean esXAdES_X = false;
        datosTipoFirma.setTipoXAdES(EnumFormatoFirma.XAdES_BES);
        ArrayList<Element> nodosObject = UtilidadTratarNodo.obtenerNodos(firma, null, new NombreNodo("http://www.w3.org/2000/09/xmldsig#", "Object"));
        Iterator<Element> itObject = nodosObject.iterator();
        int numQualifyingProperties = 0;
        while (itObject.hasNext()) {
            ArrayList<Element> nodosQualifyingProperties = UtilidadTratarNodo.obtenerNodos(itObject.next(), null, new NombreNodo(esquema, "QualifyingProperties"));
            numQualifyingProperties += nodosQualifyingProperties.size();
        }
        if (numQualifyingProperties != 1) {
            LOGGER.error((Object)(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "QualifyingProperties" + " " + I18n.getResource("libreriaxades.firmaxml.error37") + " " + numQualifyingProperties));
            logv.error(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "QualifyingProperties" + " " + I18n.getResource("libreriaxades.firmaxml.error37") + " " + numQualifyingProperties);
            ArrayList<Element> nodosSigValue = UtilidadTratarNodo.obtenerNodos(firma, null, new NombreNodo("http://www.w3.org/2000/09/xmldsig#", "SignatureValue"));
            Iterator<Element> itSigVal = nodosSigValue.iterator();
            if (itSigVal.hasNext()) {
                datosTipoFirma.setTipoXAdES(EnumFormatoFirma.XMLSignature);
                return datosTipoFirma;
            }
            throw new BadFormedSignatureException(I18n.getResource("libreriaxades.validarfirmaxml.error125"));
        }
        ArrayList<Object> nodosSignaturePolicyIdentifier = new ArrayList();
        try {
            nodosSignaturePolicyIdentifier = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquema, "SignaturePolicyIdentifier"));
        }
        catch (FirmaXMLError e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new BadFormedSignatureException(I18n.getResource("libreriaxades.validarfirmaxml.error126"));
        }
        int numSignaturePolicyIdentifier = nodosSignaturePolicyIdentifier.size();
        if (numSignaturePolicyIdentifier > 1) {
            LOGGER.error((Object)(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "SignaturePolicyIdentifier" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + numSignaturePolicyIdentifier));
            logv.error(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "SignaturePolicyIdentifier" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + numSignaturePolicyIdentifier);
            throw new BadFormedSignatureException(I18n.getResource("libreriaxades.validarfirmaxml.error126"));
        }
        if ("http://uri.etsi.org/01903/v1.1.1#".equals(esquema) && numSignaturePolicyIdentifier < 1) {
            LOGGER.error((Object)(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error33")) + " " + "SignaturePolicyIdentifier"));
            throw new BadFormedSignatureException(I18n.getResource("libreriaxades.validarfirmaxml.error126"));
        }
        if (numSignaturePolicyIdentifier == 1) {
            datosTipoFirma.setEsXAdES_EPES(true);
        }
        ArrayList<Object> nodosSignatureTimeStamp = new ArrayList();
        try {
            nodosSignatureTimeStamp = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquema, "SignatureTimeStamp"));
        }
        catch (FirmaXMLError e) {
            LOGGER.debug((Object)e.getMessage(), (Throwable)e);
        }
        int numSignatureTimeStamp = nodosSignatureTimeStamp.size();
        if (numSignatureTimeStamp > 0) {
            datosTipoFirma.setTipoXAdES(EnumFormatoFirma.XAdES_T);
        }
        ArrayList<Object> nodosCompleteCertificateRefs = new ArrayList();
        ArrayList<Object> nodosCompleteRevocationRefs = new ArrayList();
        try {
            nodosCompleteCertificateRefs = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquema, "CompleteCertificateRefs"));
            nodosCompleteRevocationRefs = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquema, "CompleteRevocationRefs"));
        }
        catch (FirmaXMLError e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new BadFormedSignatureException(I18n.getResource("libreriaxades.validarfirmaxml.error127"));
        }
        int numCompleteCertificateRefs = nodosCompleteCertificateRefs.size();
        int numCompleteRevocationRefs = nodosCompleteRevocationRefs.size();
        if (numCompleteCertificateRefs > 1 || numCompleteCertificateRefs != numCompleteRevocationRefs) {
            if (numCompleteCertificateRefs > 1) {
                LOGGER.error((Object)(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "CompleteCertificateRefs" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + numCompleteCertificateRefs));
                logv.error(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "CompleteCertificateRefs" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + numCompleteCertificateRefs);
            } else {
                LOGGER.error((Object)(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "CompleteRevocationRefs" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + numCompleteRevocationRefs));
                logv.error(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error36")) + " " + "CompleteRevocationRefs" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + numCompleteRevocationRefs);
            }
            throw new BadFormedSignatureException(I18n.getResource("libreriaxades.validarfirmaxml.error127"));
        }
        if (numCompleteCertificateRefs == 1 && numCompleteCertificateRefs == numCompleteRevocationRefs) {
            if ("http://uri.etsi.org/01903/v1.1.1#".equals(esquema) && !EnumFormatoFirma.XAdES_T.equals((Object)datosTipoFirma.getTipoXAdES())) {
                LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error131"));
                throw new BadFormedSignatureException(I18n.getResource("libreriaxades.validarfirmaxml.error127"));
            }
            esXAdES_C = true;
            datosTipoFirma.setTipoXAdES(EnumFormatoFirma.XAdES_C);
        }
        ArrayList<Object> nodosArchiveTimeStamp = new ArrayList();
        ArrayList<Object> nodosCertificateValues = new ArrayList();
        ArrayList<Object> nodosRevocationValues = new ArrayList();
        try {
            nodosArchiveTimeStamp = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquema, "ArchiveTimeStamp"));
            nodosCertificateValues = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquema, "CertificateValues"));
            nodosRevocationValues = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquema, "RevocationValues"));
        }
        catch (FirmaXMLError e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        int numArchiveTimeStamp = nodosArchiveTimeStamp.size();
        int numCertificateValues = nodosCertificateValues.size();
        int numRevocationValues = nodosRevocationValues.size();
        if (numArchiveTimeStamp > 0) {
            if (numCertificateValues < 1 || numRevocationValues < 1) {
                LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error132"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error132"));
                throw new BadFormedSignatureException(I18n.getResource("libreriaxades.validarfirmaxml.error128"));
            }
            if (numCertificateValues > 1 || numRevocationValues > 1) {
                LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error133"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error133"));
                throw new BadFormedSignatureException(I18n.getResource("libreriaxades.validarfirmaxml.error128"));
            }
            if ("http://uri.etsi.org/01903/v1.1.1#".equals(esquema) && !esXAdES_C) {
                LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error134"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error134"));
                throw new BadFormedSignatureException(I18n.getResource("libreriaxades.validarfirmaxml.error128"));
            }
            datosTipoFirma.setEsXAdES_A(true);
        }
        ArrayList<Object> nodosSigAndRefTimeStamp = new ArrayList();
        ArrayList<Object> nodosRefsOnlyTimeStamp = new ArrayList();
        try {
            nodosSigAndRefTimeStamp = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquema, "SigAndRefsTimeStamp"));
            nodosRefsOnlyTimeStamp = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquema, "RefsOnlyTimeStamp"));
        }
        catch (FirmaXMLError e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        int numSigAndRefsTimeStamp = nodosSigAndRefTimeStamp.size();
        int numRefsOnlyTimeStamp = nodosRefsOnlyTimeStamp.size();
        if (numSigAndRefsTimeStamp > 0 || numRefsOnlyTimeStamp > 0) {
            if (!esXAdES_C) {
                LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error135"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error135"));
                throw new BadFormedSignatureException(I18n.getResource("libreriaxades.validarfirmaxml.error129"));
            }
            esXAdES_X = true;
            datosTipoFirma.setTipoXAdES(EnumFormatoFirma.XAdES_X);
        }
        if (numCertificateValues > 1 || numRevocationValues > 1) {
            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error133"));
            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error133"));
            throw new BadFormedSignatureException(I18n.getResource("libreriaxades.validarfirmaxml.error128"));
        }
        if (numCertificateValues == 1 && numRevocationValues == 1) {
            if (esXAdES_X) {
                datosTipoFirma.setTipoXAdES(EnumFormatoFirma.XAdES_XL);
            } else if (!datosTipoFirma.esXAdES_A()) {
                LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error137"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error137"));
                throw new BadFormedSignatureException(I18n.getResource("libreriaxades.validarfirmaxml.error130"));
            }
        }
        LOGGER.debug((Object)datosTipoFirma.getTipoXAdES());
        return datosTipoFirma;
    }

    private Date obtenerFechaFirma(EstructuraFirma estructuraFirma) {
        ArrayList<Object> nodesSignTimeValue = new ArrayList();
        Date fechaFirma = null;
        SigningTime momentoFirma = new SigningTime(estructuraFirma.esquema);
        try {
            nodesSignTimeValue = UtilidadTratarNodo.obtenerNodos(estructuraFirma.firma, 5, new NombreNodo(estructuraFirma.esquema.getSchemaUri(), "SigningTime"));
        }
        catch (FirmaXMLError e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        if (nodesSignTimeValue.size() != 0) {
            try {
                momentoFirma.load((Element)nodesSignTimeValue.get(0));
            }
            catch (InvalidInfoNodeException e) {
                LOGGER.warn((Object)I18n.getResource("libreriaxades.validarfirmaxml.error63"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error63"));
                return null;
            }
            fechaFirma = momentoFirma.getValue();
        }
        if (fechaFirma == null) {
            if (nodesSignTimeValue.size() != 0) {
                LOGGER.warn((Object)I18n.getResource("libreriaxades.validarfirmaxml.error63"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error63"));
            } else {
                LOGGER.warn((Object)I18n.getResource("libreriaxades.validarfirmaxml.error163"));
                logv.info(I18n.getResource("libreriaxades.validarfirmaxml.error163"));
            }
        }
        return fechaFirma;
    }

    private ArrayList<String> obtenerRoles(EstructuraFirma estructuraFirma) {
        String esquemaURI = estructuraFirma.esquema.getSchemaUri();
        ArrayList<String> roles = new ArrayList<String>();
        ArrayList<Element> lst = UtilidadTratarNodo.obtenerNodos(estructuraFirma.signedSignatureProperties, null, new NombreNodo(esquemaURI, "SignerRole"));
        Iterator<Element> it = lst.iterator();
        while (it.hasNext()) {
            NodeList nodesClaimedRoles = it.next().getElementsByTagNameNS(esquemaURI, "ClaimedRole");
            int nodesClaimedRolesLength = nodesClaimedRoles.getLength();
            int i = 0;
            while (i < nodesClaimedRolesLength) {
                Element stElement = (Element)nodesClaimedRoles.item(i);
                roles.add(stElement.getTextContent());
                ++i;
            }
        }
        return roles.size() > 0 ? roles : null;
    }

    private EstructuraFirma obtenerEsquema(Element firma) {
        String esquema = null;
        Iterator<String> it = this.esquemasParaValidar.iterator();
        while (it.hasNext()) {
            esquema = it.next().trim();
            Element qualifyingElement = null;
            ArrayList<Element> nodosObject = UtilidadTratarNodo.obtenerNodos(firma, null, new NombreNodo("http://www.w3.org/2000/09/xmldsig#", "Object"));
            Iterator<Element> itObject = nodosObject.iterator();
            while (itObject.hasNext()) {
                ArrayList<Element> nodosQualifyingProperties = UtilidadTratarNodo.obtenerNodos(itObject.next(), null, new NombreNodo(esquema, "QualifyingProperties"));
                if (nodosQualifyingProperties.size() <= 0) continue;
                qualifyingElement = nodosQualifyingProperties.get(0);
                break;
            }
            if (qualifyingElement != null) {
                ArrayList<Element> unsignedSignatureProperties;
                EstructuraFirma ef = new EstructuraFirma();
                ef.firma = firma;
                ArrayList<Element> signedProperties = UtilidadTratarNodo.obtenerNodos(qualifyingElement, null, new NombreNodo(esquema, "SignedProperties"));
                if (signedProperties.size() != 1) {
                    return null;
                }
                ArrayList<Element> signedSignatureProperties = UtilidadTratarNodo.obtenerNodos(signedProperties.get(0), null, new NombreNodo(esquema, "SignedSignatureProperties"));
                if (signedSignatureProperties.size() != 1) {
                    return null;
                }
                ef.signedSignatureProperties = signedSignatureProperties.get(0);
                ArrayList<Element> unsignedProperties = UtilidadTratarNodo.obtenerNodos(qualifyingElement, null, new NombreNodo(esquema, "UnsignedProperties"));
                ef.unsignedSignatureProperties = unsignedProperties.size() != 1 ? null : ((unsignedSignatureProperties = UtilidadTratarNodo.obtenerNodos(unsignedProperties.get(0), null, new NombreNodo(esquema, "UnsignedSignatureProperties"))).size() != 1 ? null : unsignedSignatureProperties.get(0));
                ef.esquema = XAdESSchemas.getXAdESSchema(esquema);
                return ef;
            }
            if (!esquema.equals("http://www.w3.org/2000/09/xmldsig#")) continue;
            Element sigValElement = null;
            ArrayList<Element> nodosSigValue = UtilidadTratarNodo.obtenerNodos(firma, null, new NombreNodo("http://www.w3.org/2000/09/xmldsig#", "SignatureValue"));
            Iterator<Element> itSigVal = nodosSigValue.iterator();
            if (!itSigVal.hasNext() || !esquema.equals((sigValElement = itSigVal.next()).getNamespaceURI())) continue;
            EstructuraFirma ef = new EstructuraFirma();
            ef.firma = firma;
            ef.esquema = XAdESSchemas.getXAdESSchema(esquema);
            return ef;
        }
        EstructuraFirma ef = new EstructuraFirma();
        ef.firma = firma;
        return ef;
    }

    /*
     * Unable to fully structure code
     */
    private boolean obtenerCadenaCertificados(EstructuraFirma estructuraFirma) {
        block57: {
            block56: {
                firma = estructuraFirma.firma;
                esquemaURI = estructuraFirma.esquema.getSchemaUri();
                if (firma == null) {
                    this.esValido = false;
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error76"));
                    ValidarFirmaXML.LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error76"));
                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error76"));
                    return false;
                }
                certificadoFirma = null;
                certificadosKeyInfo = new ArrayList<X509Certificate>();
                nodosKeyInfo = new ArrayList<E>();
                try {
                    nodosKeyInfo = UtilidadTratarNodo.obtenerNodos(firma, 2, new NombreNodo(this.uriXmlNS, "KeyInfo"));
                }
                catch (FirmaXMLError e) {
                    ValidarFirmaXML.LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
                if (nodosKeyInfo.size() > 0) {
                    nodoKeyInfo = (Element)nodosKeyInfo.get(0);
                    nodosX509Data = nodoKeyInfo.getElementsByTagNameNS(this.uriXmlNS, "X509Data");
                    nodosX509DataLenght = nodosX509Data.getLength();
                    i = 0;
                    while (i < nodosX509DataLenght) {
                        nodoX509Data = (Element)nodosX509Data.item(i);
                        x509Cert = nodoX509Data.getElementsByTagNameNS(this.uriXmlNS, "X509Certificate");
                        x509CertLenght = x509Cert.getLength();
                        x = 0;
                        while (x < x509CertLenght) {
                            nodoX509Certificate = x509Cert.item(x);
                            try {
                                bais = new ByteArrayInputStream(Base64.decode(nodoX509Certificate.getFirstChild().getNodeValue()));
                                cf = CertificateFactory.getInstance("X.509");
                                certificadosKeyInfo.add((X509Certificate)cf.generateCertificate(bais));
                            }
                            catch (CertificateException e1) {
                                this.esValido = false;
                                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                                ValidarFirmaXML.LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error23"), (Throwable)e1);
                                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                                return false;
                            }
                            ++x;
                        }
                        ++i;
                    }
                } else {
                    certificadoFirma = new DatosX509();
                    nodosSigningCertificate = new ArrayList<E>();
                    try {
                        nodosSigningCertificate = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "SigningCertificate"));
                    }
                    catch (FirmaXMLError e) {
                        ValidarFirmaXML.LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    }
                    if (nodosSigningCertificate.size() == 1) {
                        nodoSigningCertificate = (Node)nodosSigningCertificate.get(0);
                        nodosCert = UtilidadTratarNodo.getElementChildNodes((Element)nodoSigningCertificate, false);
                        if (nodosCert == null) {
                            this.esValido = false;
                            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error95 Cert"));
                            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error95 Cert"));
                            return false;
                        }
                        algoritmo = null;
                        digest = null;
                        nodoCert = nodosCert.get(0);
                        certDigest = (Element)nodoCert.getElementsByTagNameNS(esquemaURI, "CertDigest").item(0);
                        if (certDigest != null) {
                            digAlgs = certDigest.getElementsByTagNameNS(this.uriXmlNS, "DigestMethod");
                            if (digAlgs != null) {
                                certDigestAlgElement = (Element)digAlgs.item(0);
                                algoritmo = certDigestAlgElement.getAttributes().getNamedItem("Algorithm").getNodeValue();
                            }
                            if ((digValues = certDigest.getElementsByTagNameNS(this.uriXmlNS, "DigestValue")) != null) {
                                certDigestValElement = (Element)digValues.item(0);
                                digest = certDigestValElement.getFirstChild().getNodeValue();
                            }
                            certificadoFirma.setAlgMethod(algoritmo);
                            certificadoFirma.setDigestValue(digest);
                        }
                    } else {
                        ValidarFirmaXML.LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error138"));
                        logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error138"));
                        this.esValido = false;
                        this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                        return false;
                    }
                }
                certificadosRef = new ArrayList<X509Certificate>();
                nodosCertValue = new ArrayList<E>();
                try {
                    nodosCertValue = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "CertificateValues"));
                }
                catch (FirmaXMLError e) {
                    ValidarFirmaXML.LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
                if (nodosCertValue.size() <= 0) break block56;
                nodoCertValue = (Element)nodosCertValue.get(0);
                nodosX509Cert = nodoCertValue.getElementsByTagNameNS(esquemaURI, "EncapsulatedX509Certificate");
                nodosX509DataLenght = nodosX509Cert.getLength();
                i = 0;
                while (i < nodosX509DataLenght) {
                    nodoX509Cert = (Element)nodosX509Cert.item(i);
                    try {
                        bais = new ByteArrayInputStream(Base64.decode(nodoX509Cert.getFirstChild().getNodeValue()));
                        cf = CertificateFactory.getInstance("X.509");
                        certificadosRef.add((X509Certificate)cf.generateCertificate(bais));
                    }
                    catch (CertificateException e1) {
                        this.esValido = false;
                        this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                        ValidarFirmaXML.LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error23"), (Throwable)e1);
                        logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                        return false;
                    }
                    ++i;
                }
                break block57;
            }
            nodosCompCertRef = new ArrayList<E>();
            try {
                nodosCompCertRef = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "CompleteCertificateRefs"));
            }
            catch (FirmaXMLError e) {
                ValidarFirmaXML.LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
            if (nodosCompCertRef.size() <= 0) break block57;
            nodoCertRefs = UtilidadTratarNodo.getFirstElementChild((Element)nodosCompCertRef.get(0), false);
            if (nodoCertRefs == null) {
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error95 CertRefs"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error95 CertRefs"));
                return false;
            }
            nodosCert = UtilidadTratarNodo.getElementChildNodes(nodoCertRefs, false);
            if (nodosCert == null) {
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error95 Cert"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error95 Cert"));
                return false;
            }
            nodosCertSize = nodosCert.size();
            i = 0;
            while (i < nodosCertSize) {
                nodoCert = nodosCert.get(i);
                uri = null;
                try {
                    uri = URLDecoder.decode(nodoCert.getAttributes().getNamedItem(this.tipoUri).getNodeValue(), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    ValidarFirmaXML.LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error30"), (Throwable)e);
                    this.esValido = false;
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                }
                catch (Exception e) {
                    ValidarFirmaXML.LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error65"), (Throwable)e);
                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error65"));
                    this.esValido = false;
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                }
                if (uri == null || uri.startsWith("#")) ** GOTO lbl212
                certFile = null;
                if (this.recoverManager != null) {
                    props = new HashMap<String, String>();
                    props.put("uri", uri);
                    try {
                        certFile = (X509Certificate)this.recoverManager.getElement(props, X509Certificate.class);
                    }
                    catch (ElementNotFoundException ex) {
                        ValidarFirmaXML.LOGGER.warn((Object)ValidarFirmaXML.i18n.getLocalMessage("i18n.mityc.xades.validate.2"));
                        if (ValidarFirmaXML.LOGGER.isTraceEnabled()) {
                            ValidarFirmaXML.LOGGER.trace(props);
                        }
                    }
                    catch (UnknownElementClassException ex) {
                        ValidarFirmaXML.LOGGER.error((Object)ValidarFirmaXML.i18n.getLocalMessage("i18n.mityc.xades.validate.3", new Object[]{"X509Certificate"}), (Throwable)ex);
                    }
                }
                if (certFile == null) {
                    ValidarFirmaXML.LOGGER.error((Object)ValidarFirmaXML.i18n.getLocalMessage("i18n.mityc.xades.validate.1", new Object[]{uri}));
                    this.esValido = false;
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                    logv.error(ValidarFirmaXML.i18n.getLocalMessage("i18n.mityc.xades.validate.1", new Object[]{uri}));
                    return false;
                }
                certElement = (Element)nodoCert;
                certDigest = (Element)certElement.getElementsByTagNameNS(esquemaURI, "CertDigest").item(0);
                alg = null;
                digest = null;
                resumenCertificado = "";
                if (certDigest != null) {
                    block55: {
                        algorithm = certDigest.getElementsByTagNameNS(this.uriXmlNS, "DigestMethod").item(0);
                        value = certDigest.getElementsByTagNameNS(this.uriXmlNS, "DigestValue").item(0);
                        alg = algorithm.getAttributes().getNamedItem("Algorithm").getNodeValue();
                        digest = value.getFirstChild().getNodeValue();
                        try {
                            haseador = UtilidadFirmaElectronica.getMessageDigest(alg);
                            if (haseador != null) break block55;
                            this.esValido = false;
                            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error52"));
                            ValidarFirmaXML.LOGGER.error((Object)I18n.getResource("libreriaxades.firmaxml.error16"));
                            logv.error(I18n.getResource("libreriaxades.firmaxml.error16"));
                            return false;
                        }
                        catch (CertificateEncodingException e) {
                            ValidarFirmaXML.LOGGER.error((Object)(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error23")) + " " + e.getMessage()), (Throwable)e);
                            this.esValido = false;
                            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error52"));
                            logv.error(String.valueOf(I18n.getResource("libreriaxades.validarfirmaxml.error52")) + "\n" + I18n.getResource("libreriaxades.firmaxml.error23") + " " + e.getMessage());
                            return false;
                        }
                    }
                    resumenMensajeByte = haseador.digest(certFile.getEncoded());
                    resumenCertificado = new String(Base64Coder.encode(resumenMensajeByte));
                    if (!digest.equals(resumenCertificado)) {
                        this.esValido = false;
                        this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error53"));
                        ValidarFirmaXML.LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error53"));
                        logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error53"));
                        return false;
                    }
                } else {
                    ValidarFirmaXML.LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error66"));
                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error66"));
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                    this.esValido = false;
                    return false;
lbl212:
                    // 1 sources

                    ValidarFirmaXML.LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error83"));
                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error83"));
                    this.esValido = false;
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                    return false;
                }
                certificadosRef.add(certFile);
                ++i;
            }
        }
        certificadosRef.addAll(certificadosKeyInfo);
        certChains = UtilidadCertificados.filterCertPathsArrays(UtilidadCertificados.getCertPathsArray(certificadosRef), UtilidadCertificados.Filter.SIGN_SIGNER);
        certChainsSize = certChains.size();
        if (certChainsSize > 1) {
            encontrado = false;
            if (certificadosKeyInfo.size() != 0) {
                i = 0;
                while (i < certChainsSize) {
                    cadena = certChains.get(i);
                    cert = cadena.get(0);
                    if (cert.equals(certificadosKeyInfo.get(0))) {
                        this.cadenaCertificados = cadena;
                        this.datosFirma.setCadenaFirma(UtilidadCertificados.convertCertPath(this.cadenaCertificados));
                        encontrado = true;
                    }
                    ++i;
                }
            } else if (certificadoFirma != null) {
                haseador = null;
                haseador = UtilidadFirmaElectronica.getMessageDigest(certificadoFirma.getAlgMethod());
                i = 0;
                while (i < certChainsSize && haseador != null) {
                    cadena = certChains.get(i);
                    cert = cadena.get(0);
                    digest = null;
                    try {
                        resumenMensajeByte = haseador.digest(cert.getEncoded());
                        digest = new String(Base64Coder.encode(resumenMensajeByte));
                    }
                    catch (CertificateEncodingException e) {
                        ValidarFirmaXML.LOGGER.error((Object)I18n.getResource("libreriaxades.firmaxml.error23"), (Throwable)e);
                        logv.error(String.valueOf(I18n.getResource("libreriaxades.firmaxml.error23")) + " " + e.getMessage());
                    }
                    if (certificadoFirma.getDigestValue().equals(digest)) {
                        this.cadenaCertificados = cadena;
                        this.datosFirma.setCadenaFirma(UtilidadCertificados.convertCertPath(this.cadenaCertificados));
                        encontrado = true;
                    }
                    ++i;
                }
            }
            if (!encontrado) {
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error84"));
                ValidarFirmaXML.LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error84"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error84"));
                return false;
            }
        } else {
            if (certChainsSize == 0) {
                this.esValido = false;
                this.resultado.setLog(ValidarFirmaXML.i18n.getLocalMessage("i18n.mityc.xades.validate.10"));
                ValidarFirmaXML.LOGGER.error((Object)ValidarFirmaXML.i18n.getLocalMessage("i18n.mityc.xades.validate.10"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error84"));
                return false;
            }
            this.cadenaCertificados = certChains.get(0);
            this.datosFirma.setCadenaFirma(UtilidadCertificados.convertCertPath(this.cadenaCertificados));
        }
        return true;
    }

    private void getConstantesEsquema(XAdESSchemas esquema) {
        if (esquema != null && "http://uri.etsi.org/01903/v1.1.1#".equals(esquema.getSchemaUri())) {
            this.nombreNodoUri = "HashDataInfo";
            this.tipoUri = "uri";
        } else {
            this.nombreNodoUri = "Include";
            this.tipoUri = "URI";
        }
    }

    protected class EstructuraFirma {
        XAdESSchemas esquema;
        Element firma;
        Element signedSignatureProperties;
        Element unsignedSignatureProperties;
        XMLSignature xmlSig;

        protected EstructuraFirma() {
        }
    }
}

