/*
 * Decompiled with CFR 0.152.
 */
package adsi.org.apache.xml.security.utils;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.List;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class IdResolver {
    private static Log log = LogFactory.getLog(IdResolver.class.getName());
    private static WeakHashMap docMap = new WeakHashMap();
    private static List names;
    private static int namesLength;

    static {
        String[] namespaces = new String[]{"http://www.w3.org/2000/09/xmldsig#", "http://www.w3.org/2001/04/xmlenc#", "http://schemas.xmlsoap.org/soap/security/2000-12", "http://www.w3.org/2002/03/xkms#", "urn:oasis:names:tc:SAML:1.0:assertion", "urn:oasis:names:tc:SAML:1.0:protocol"};
        names = Arrays.asList(namespaces);
        namesLength = names.size();
    }

    private IdResolver() {
    }

    public static void registerElementById(Element element, String idValue) {
        Document doc = element.getOwnerDocument();
        WeakHashMap<String, WeakReference<Element>> elementMap = (WeakHashMap<String, WeakReference<Element>>)docMap.get(doc);
        if (elementMap == null) {
            elementMap = new WeakHashMap<String, WeakReference<Element>>();
            docMap.put(doc, elementMap);
        }
        elementMap.put(idValue, new WeakReference<Element>(element));
    }

    public static void registerElementById(Element element, Attr id) {
        IdResolver.registerElementById(element, id.getNodeValue());
    }

    public static Element getElementById(Document doc, String id) {
        Element result = IdResolver.getElementByIdType(doc, id);
        if (result != null) {
            log.debug("I could find an Element using the simple getElementByIdType method: " + result.getTagName());
            return result;
        }
        result = IdResolver.getElementByIdUsingDOM(doc, id);
        if (result != null) {
            log.debug("I could find an Element using the simple getElementByIdUsingDOM method: " + result.getTagName());
            return result;
        }
        result = IdResolver.getElementBySearching(doc, id);
        if (result != null) {
            IdResolver.registerElementById(result, id);
            return result;
        }
        return null;
    }

    private static Element getElementByIdUsingDOM(Document doc, String id) {
        if (log.isDebugEnabled()) {
            log.debug("getElementByIdUsingDOM() Search for ID " + id);
        }
        return doc.getElementById(id);
    }

    private static Element getElementByIdType(Document doc, String id) {
        WeakReference weakReference;
        WeakHashMap elementMap;
        if (log.isDebugEnabled()) {
            log.debug("getElementByIdType() Search for ID " + id);
        }
        if ((elementMap = (WeakHashMap)docMap.get(doc)) != null && (weakReference = (WeakReference)elementMap.get(id)) != null) {
            return (Element)weakReference.get();
        }
        return null;
    }

    private static Element getElementBySearching(Node root, String id) {
        Element[] els = new Element[namesLength + 1];
        IdResolver.getEl(root, id, els);
        int i = 0;
        while (i < els.length) {
            if (els[i] != null) {
                return els[i];
            }
            ++i;
        }
        return null;
    }

    private static int getEl(Node currentNode, String id, Element[] els) {
        Node sibling = null;
        Node parentNode = null;
        while (true) {
            switch (currentNode.getNodeType()) {
                case 9: 
                case 11: {
                    sibling = currentNode.getFirstChild();
                    break;
                }
                case 1: {
                    Element currentElement = (Element)currentNode;
                    if (IdResolver.isElement(currentElement, id, els) == 1) {
                        return 1;
                    }
                    sibling = currentNode.getFirstChild();
                    if (sibling == null) {
                        if (parentNode == null) break;
                        sibling = currentNode.getNextSibling();
                        break;
                    }
                    parentNode = currentElement;
                }
            }
            while (sibling == null && parentNode != null) {
                sibling = parentNode.getNextSibling();
                if ((parentNode = parentNode.getParentNode()) instanceof Element) continue;
                parentNode = null;
            }
            if (sibling == null) {
                return 1;
            }
            currentNode = sibling;
            sibling = currentNode.getNextSibling();
        }
    }

    public static int isElement(Element el, String id, Element[] els) {
        if (!el.hasAttributes()) {
            return 0;
        }
        NamedNodeMap ns = el.getAttributes();
        int elementIndex = names.indexOf(el.getNamespaceURI());
        elementIndex = elementIndex < 0 ? namesLength : elementIndex;
        int length = ns.getLength();
        int i = 0;
        while (i < length) {
            Attr n = (Attr)ns.item(i);
            String s = n.getNamespaceURI();
            int index = s == null ? elementIndex : names.indexOf(n.getNamespaceURI());
            index = index < 0 ? namesLength : index;
            String name = n.getLocalName();
            if (name.length() <= 2) {
                String value = n.getNodeValue();
                if (name.charAt(0) == 'I') {
                    char ch = name.charAt(1);
                    if (ch == 'd' && value.equals(id)) {
                        els[index] = el;
                        if (index == 0) {
                            return 1;
                        }
                    } else if (ch == 'D' && value.endsWith(id)) {
                        if (index != 3) {
                            index = namesLength;
                        }
                        els[index] = el;
                    }
                } else if ("id".equals(name) && value.equals(id)) {
                    if (index != 2) {
                        index = namesLength;
                    }
                    els[index] = el;
                }
            }
            ++i;
        }
        if (elementIndex == 3 && (el.getAttribute("OriginalRequestID").equals(id) || el.getAttribute("RequestID").equals(id) || el.getAttribute("ResponseID").equals(id))) {
            els[3] = el;
        } else if (elementIndex == 4 && el.getAttribute("AssertionID").equals(id)) {
            els[4] = el;
        } else if (elementIndex == 5 && (el.getAttribute("RequestID").equals(id) || el.getAttribute("ResponseID").equals(id))) {
            els[5] = el;
        }
        return 0;
    }
}

