/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.i18n;

import es.mityc.javasign.i18n.DictionaryUnknownException;
import es.mityc.javasign.i18n.II18nManager;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class I18nDefaultManager
implements II18nManager {
    static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(I18nDefaultManager.class);
    protected static final String BASE_PATH = "i18n/dictionaries/";
    private static final String ILLFORMED_KEY = "Clave malformada: {0}";
    private static final String NOT_AVALAIBLE_KEY = "No existe clave {0}";
    protected ResourceBundle rb = null;
    protected Locale locale = null;

    @Override
    public void init(String dictionary, Locale specificLocale) throws DictionaryUnknownException {
        try {
            this.locale = specificLocale == null ? Locale.getDefault() : (Locale)specificLocale.clone();
            this.rb = ResourceBundle.getBundle(BASE_PATH + dictionary, this.locale);
        }
        catch (MissingResourceException ex) {
            throw new DictionaryUnknownException(ex);
        }
    }

    @Override
    public String getLocalMessage(String message) {
        try {
            return this.findMessage(message);
        }
        catch (MissingResourceException ex) {
            LOG.warn(I18nDefaultManager.getFormatedMessage(NOT_AVALAIBLE_KEY, message));
            return null;
        }
    }

    protected String findMessage(String key) {
        if (this.rb != null) {
            return this.rb.getString(key);
        }
        return null;
    }

    private static String getFormatedMessage(String message, Object ... varargs) {
        MessageFormat mf = new MessageFormat(message);
        return mf.format(varargs, new StringBuffer(), (FieldPosition)null).toString();
    }

    @Override
    public String getLocalMessage(String message, Object ... varargs) {
        try {
            String res = this.findMessage(message);
            if (res != null) {
                MessageFormat mf = new MessageFormat(res, this.locale);
                return mf.format(varargs, new StringBuffer(), (FieldPosition)null).toString();
            }
        }
        catch (MissingResourceException ex) {
            LOG.warn(I18nDefaultManager.getFormatedMessage(NOT_AVALAIBLE_KEY, message));
        }
        catch (IllegalArgumentException ex) {
            LOG.warn(I18nDefaultManager.getFormatedMessage(ILLFORMED_KEY, message));
        }
        return null;
    }
}

