/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.pkstore.mitycstore.PKHandlers;

import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public class VirtualQwerty {
    private static final II18nManager I18N = I18nFactory.getI18nManager("MITyCLibCert");
    private static final String NOT_VISIBLE = "NoVisible";
    private static final String UNIR_SUPERIOR = "UnirSuperior";
    private static final String UNIR_IZQUIERDA = "UnirIzquierda";
    private static final String[] keyMatrixUpperCase = new String[]{"Esc", "1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "'", "\u00a1", "Retroceso", "/", "Tab", "Q", "W", "E", "R", "T", "Y", "U", "I", "O", "P", "`", "+", "Intro", ".", "Mayus", "A", "S", "D", "F", "G", "H", "J", "K", "L", "\u00d1", "\u00b4", "\u00c7", "UnirSuperior", "NoVisible", "Shift", "<", "Z", "X", "C", "V", "B", "N", "M", ",", ".", "-", "Shift", "NoVisible", "NoVisible", "Ctrl", "Alt", "NoVisible", "Espacio", "UnirIzquierda", "UnirIzquierda", "UnirIzquierda", "UnirIzquierda", "UnirIzquierda", "UnirIzquierda", "NoVisible", "Alt", "NoVisible", "NoVisible", "NoVisible", "NoVisible", "NoVisible", "NoVisible"};
    private static final String[] keyMatrixLowerCase = new String[]{"Esc", "1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "'", "\u00a1", "Retroceso", "/", "Tab", "q", "w", "e", "r", "t", "y", "u", "i", "o", "p", "`", "+", "Intro", ".", "Mayus", "a", "s", "d", "f", "g", "h", "j", "k", "l", "\u00f1", "\u00b4", "\u00c7", "UnirSuperior", "NoVisible", "Shift", "<", "z", "x", "c", "v", "b", "n", "m", ",", ".", "-", "Shift", "NoVisible", "NoVisible", "Ctrl", "Alt", "NoVisible", "Espacio", "UnirIzquierda", "UnirIzquierda", "UnirIzquierda", "UnirIzquierda", "UnirIzquierda", "UnirIzquierda", "NoVisible", "Alt", "NoVisible", "NoVisible", "NoVisible", "NoVisible", "NoVisible", "NoVisible"};
    private static final String[] keyMatrixShiftCase = new String[]{"Esc", "!", "\"", "\u00b7", "$", "%", "&", "/", "(", ")", "=", "?", "\u00bf", "Retroceso", "/", "Tab", "", "", "", "", "", "", "", "", "", "", "^", "*", "Intro", ".", "Mayus", "", "", "", "", "", "", "", "", "", "", "\u00a8", "\u00c7", "UnirSuperior", "NoVisible", "Shift", ">", "", "", "", "", "", "", "", ";", ":", "_", "Shift", "NoVisible", "NoVisible", "Ctrl", "Alt", "NoVisible", "Espacio", "UnirIzquierda", "UnirIzquierda", "UnirIzquierda", "UnirIzquierda", "UnirIzquierda", "UnirIzquierda", "NoVisible", "Alt", "NoVisible", "NoVisible", "NoVisible", "NoVisible", "NoVisible", "NoVisible"};
    private static final String[] keyMatrixAltCase = new String[]{"Esc", "|", "@", "#", "~", "\u20ac", "\u00ac", "7", "8", "9", "0", "'", "\u00a1", "Retroceso", "/", "Tab", "", "", "", "", "", "", "", "", "", "", "[", "]", "Intro", ".", "Mayus", "", "", "", "", "", "", "", "", "", "", "{", "}", "UnirSuperior", "NoVisible", "Shift", "<", "", "", "", "", "", "", "", ",", ".", "-", "Shift", "NoVisible", "NoVisible", "Ctrl", "Alt", "NoVisible", "Espacio", "UnirIzquierda", "UnirIzquierda", "UnirIzquierda", "UnirIzquierda", "UnirIzquierda", "UnirIzquierda", "NoVisible", "Alt", "NoVisible", "NoVisible", "NoVisible", "NoVisible", "NoVisible", "NoVisible"};
    private Frame owner = null;
    private HotKey[] teclado = null;
    protected JPanel mainPanel = null;
    protected JDialog dialog = null;
    protected JLabel lblMessage = null;
    private JPasswordField pass = null;
    private static final String STR_OK = "OK";
    private static final String STR_CLOSE = "CLOSE";
    private boolean cancelado = false;

    public VirtualQwerty(Frame owner) {
        this.dialog = new JDialog(owner, I18N.getLocalMessage("i18n.mityc.cert.smartcards.GUI.title"), true);
        this.owner = owner;
        this.init();
    }

    private void init() {
        this.teclado = new HotKey[75];
        this.mainPanel = new JPanel();
        JButton aceptar = new JButton(I18N.getLocalMessage("i18n.mityc.cert.smartcards.GUI.accept"));
        JButton cancelar = new JButton(I18N.getLocalMessage("i18n.mityc.cert.smartcards.GUI.cancel"));
        aceptar.setActionCommand(STR_OK);
        cancelar.setActionCommand(STR_CLOSE);
        this.pass = new JPasswordField(15);
        GridBagConstraints g = new GridBagConstraints();
        this.mainPanel.setLayout(new GridBagLayout());
        g.insets = new Insets(5, 15, 3, 15);
        g.gridx = 0;
        g.gridy = 2;
        g.gridwidth = 1;
        g.fill = 0;
        g.weightx = 0.0;
        this.lblMessage = new JLabel(I18N.getLocalMessage("i18n.mityc.cert.smartcards.GUI.pin"));
        this.mainPanel.add(this.lblMessage, g, 0);
        g.gridy = 2;
        g.gridx = -1;
        g.gridwidth = 0;
        g.fill = 2;
        g.weightx = 1.0;
        this.mainPanel.add(this.pass, g, 1);
        g.gridy = 3;
        g.gridx = 0;
        g.fill = 1;
        g.weightx = 1.0;
        this.mainPanel.add(this.paintKeyBoard(keyMatrixLowerCase), g, 2);
        g.gridx = 0;
        g.gridy = 4;
        g.fill = 0;
        g.weightx = 0.0;
        g.gridwidth = 6;
        g.anchor = 17;
        this.mainPanel.add(aceptar, g, 3);
        g.gridx = -1;
        g.gridy = 4;
        g.fill = 0;
        g.weightx = 0.0;
        g.gridwidth = 0;
        g.anchor = 13;
        this.mainPanel.add(cancelar, g, 4);
        this.mainPanel.doLayout();
        this.dialog.add(this.mainPanel);
        this.dialog.setResizable(true);
        this.dialog.getRootPane().setDefaultButton(aceptar);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.dialog.setBounds((screenSize.width - 660) / 2, (screenSize.height - 500) / 2, 660, 500);
        aceptar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals(VirtualQwerty.STR_OK)) {
                    VirtualQwerty.this.dialog.setVisible(false);
                }
            }
        });
        cancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals(VirtualQwerty.STR_CLOSE)) {
                    VirtualQwerty.this.cancelado = true;
                    VirtualQwerty.this.dialog.setVisible(false);
                    System.exit(0);
                }
            }
        });
        this.dialog.setSize(new Dimension(900, 300));
    }

    private JPanel paintKeyBoard(String[] value) {
        HotKey tecla = null;
        Dimension teclaSize = new Dimension(40, 30);
        JPanel tecladoPanel = new JPanel();
        tecladoPanel.setLayout(new GridBagLayout());
        int y = 1;
        int x = 1;
        while (y < 6) {
            String valueToShow = value[x - 1 + (y - 1) * 15];
            if (valueToShow.equals(NOT_VISIBLE)) {
                if (x > 14) {
                    x = 0;
                    ++y;
                }
            } else if (!valueToShow.equals(UNIR_SUPERIOR)) {
                int width = (int)teclaSize.getWidth();
                int celdasUnidas = 0;
                String nextElement = null;
                int neXt = x;
                while (neXt < 14) {
                    nextElement = value[neXt + (y - 1) * 15];
                    if (!nextElement.equals(UNIR_IZQUIERDA)) break;
                    width += (int)teclaSize.getWidth();
                    ++celdasUnidas;
                    ++neXt;
                }
                int height = (int)teclaSize.getHeight();
                int columnasUnidas = 0;
                int down = y;
                while (down < 5) {
                    nextElement = value[x - 1 + down * 15];
                    if (!nextElement.equals(UNIR_SUPERIOR)) break;
                    height += (int)teclaSize.getHeight();
                    ++columnasUnidas;
                    ++down;
                }
                this.teclado[x - 1 + (y - 1) * 15] = tecla = new HotKey(x, y, valueToShow, width, height);
                GridBagConstraints g = new GridBagConstraints();
                g.insets = new Insets(1, 1, 0, 0);
                g.gridx = x;
                g.gridy = y;
                if (celdasUnidas > 0) {
                    g.gridwidth = celdasUnidas + 1;
                }
                if (columnasUnidas > 0) {
                    g.gridheight = columnasUnidas + 1;
                }
                tecladoPanel.add((Component)tecla.tecla, g);
                x += celdasUnidas;
            }
            if (x > 14) {
                x = 0;
                ++y;
            }
            ++x;
        }
        return tecladoPanel;
    }

    public void setTitle(String newTitle) {
        this.dialog.setTitle(newTitle);
    }

    public void setPINMessage(String newMessage) {
        this.lblMessage.setText(newMessage);
    }

    public void pack() {
        this.dialog.pack();
    }

    public void setVisible(boolean flag) {
        if (flag) {
            this.cancelado = false;
            this.pass.setText("");
        }
        this.dialog.setVisible(flag);
    }

    public char[] getPassword() {
        return this.pass.getPassword();
    }

    public void dispose() {
        this.dialog.dispose();
    }

    public boolean isCancelado() {
        return this.cancelado;
    }

    public static void main(String[] args) {
        VirtualQwerty vq = new VirtualQwerty(new JFrame());
        vq.setVisible(true);
    }

    private class HotKey {
        public int[] posicion = new int[2];
        public JButton tecla = null;

        public HotKey(int x, int y, String text, int width, int height) {
            this.posicion[0] = x;
            this.posicion[1] = y;
            this.tecla = new JButton(text);
            this.tecla.setMargin(new Insets(0, 1, 1, 0));
            this.tecla.setBackground(new Color(150, 217, 250));
            this.tecla.setContentAreaFilled(false);
            this.tecla.setSize(new Dimension(width, height));
            this.tecla.setPreferredSize(new Dimension(width, height));
            this.tecla.setMaximumSize(new Dimension(width, height));
            this.tecla.setMinimumSize(new Dimension(width, height));
            this.tecla.addMouseListener(new MouseListener(){

                @Override
                public void mousePressed(MouseEvent e) {
                    JButton boton = (JButton)e.getSource();
                    String buttonText = boton.getText();
                    if (buttonText != null && buttonText.equalsIgnoreCase("SHIFT")) {
                        if (boton.isContentAreaFilled()) {
                            boton.setContentAreaFilled(false);
                            HotKey.this.changeKeyBoard(keyMatrixLowerCase);
                        } else {
                            boton.setContentAreaFilled(true);
                            HotKey.this.changeKeyBoard(keyMatrixShiftCase);
                        }
                    } else if (buttonText != null && buttonText.equalsIgnoreCase("Mayus")) {
                        if (boton.isContentAreaFilled()) {
                            boton.setContentAreaFilled(false);
                            HotKey.this.changeKeyBoard(keyMatrixLowerCase);
                        } else {
                            boton.setContentAreaFilled(true);
                            HotKey.this.changeKeyBoard(keyMatrixUpperCase);
                        }
                    } else if (buttonText != null && buttonText.equalsIgnoreCase("Retroceso")) {
                        String password = new String(VirtualQwerty.this.pass.getPassword());
                        int size = password.length() - 1;
                        if (size >= 0) {
                            VirtualQwerty.this.pass.setText(password.substring(0, size));
                            System.out.println(new String(VirtualQwerty.this.pass.getPassword()));
                        }
                    } else if (buttonText != null && buttonText.equalsIgnoreCase("Alt")) {
                        if (boton.isContentAreaFilled()) {
                            boton.setContentAreaFilled(false);
                            HotKey.this.changeKeyBoard(keyMatrixLowerCase);
                        } else {
                            boton.setContentAreaFilled(true);
                            HotKey.this.changeKeyBoard(keyMatrixAltCase);
                        }
                    } else {
                        VirtualQwerty.this.pass.setText(String.valueOf(new String(VirtualQwerty.this.pass.getPassword())) + boton.getText());
                        System.out.println(new String(VirtualQwerty.this.pass.getPassword()));
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    ((HotKey)HotKey.this).VirtualQwerty.this.mainPanel.setCursor(new Cursor(0));
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    ((HotKey)HotKey.this).VirtualQwerty.this.mainPanel.setCursor(new Cursor(12));
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }
            });
        }

        public void changeKeyBoard(String[] newValue) {
            int y = 1;
            HotKey teclaItem = null;
            int x = 1;
            while (y < 6) {
                String valueToShow = newValue[x - 1 + (y - 1) * 15];
                teclaItem = VirtualQwerty.this.teclado[x - 1 + (y - 1) * 15];
                String before = null;
                if (teclaItem == null) {
                    if (x > 14) {
                        x = 0;
                        ++y;
                    }
                } else {
                    before = teclaItem.tecla.getText();
                    if (before == null || before.equals(VirtualQwerty.NOT_VISIBLE) || before.equals(VirtualQwerty.UNIR_SUPERIOR) || before.equals(VirtualQwerty.UNIR_IZQUIERDA)) {
                        if (x > 14) {
                            x = 0;
                            ++y;
                        }
                    } else {
                        teclaItem.tecla.setText(valueToShow);
                        if (x > 14) {
                            x = 0;
                            ++y;
                        }
                    }
                }
                ++x;
            }
        }
    }
}

