/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.pkstore.mozilla;

import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public class PINDialog {
    private static final II18nManager I18N = I18nFactory.getI18nManager("MITyCLibCert");
    private static final String STR_OK = "OK";
    private static final String STR_CLOSE = "CLOSE";
    private boolean cancelado = false;
    protected JDialog dialog = null;
    protected JLabel lblMessage = null;
    private JPasswordField pass = null;

    public PINDialog(Frame owner) {
        this.dialog = new JDialog(owner, I18N.getLocalMessage("i18n.mityc.cert.smartcards.GUI.title"), true);
        this.dialogInit();
    }

    protected void dialogInit() {
        try {
            JPanel distr = new JPanel();
            JButton aceptar = new JButton(I18N.getLocalMessage("i18n.mityc.cert.smartcards.GUI.accept"));
            JButton cancelar = new JButton(I18N.getLocalMessage("i18n.mityc.cert.smartcards.GUI.cancel"));
            aceptar.setActionCommand(STR_OK);
            cancelar.setActionCommand(STR_CLOSE);
            this.pass = new JPasswordField(15);
            GridBagConstraints g = new GridBagConstraints();
            distr.setLayout(new GridBagLayout());
            this.dialog.setResizable(false);
            g.insets = new Insets(5, 15, 3, 15);
            g.gridx = 0;
            g.gridy = 2;
            g.gridwidth = 1;
            g.fill = 0;
            g.weightx = 0.0;
            this.lblMessage = new JLabel(I18N.getLocalMessage("i18n.mityc.cert.smartcards.GUI.pin"));
            distr.add((Component)this.lblMessage, g);
            g.gridy = 2;
            g.gridx = -1;
            g.gridwidth = 0;
            g.fill = 2;
            g.weightx = 1.0;
            distr.add((Component)this.pass, g);
            g.gridx = 0;
            g.gridy = 3;
            g.fill = 0;
            g.weightx = 0.0;
            g.gridwidth = 6;
            g.anchor = 17;
            distr.add((Component)aceptar, g);
            g.gridx = -1;
            g.gridy = 3;
            g.fill = 0;
            g.weightx = 0.0;
            g.gridwidth = 0;
            g.anchor = 13;
            distr.add((Component)cancelar, g);
            distr.doLayout();
            this.dialog.add(distr);
            this.dialog.setResizable(false);
            this.dialog.setDefaultCloseOperation(0);
            this.dialog.getRootPane().setDefaultButton(aceptar);
            this.dialog.setLocationRelativeTo(null);
            aceptar.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equals(PINDialog.STR_OK)) {
                        PINDialog.this.dialog.setVisible(false);
                    }
                }
            });
            cancelar.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equals(PINDialog.STR_CLOSE)) {
                        PINDialog.this.cancelado = true;
                        PINDialog.this.dialog.setVisible(false);
                    }
                }
            });
            this.dialog.setSize(new Dimension(300, 300));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setTitle(String newTitle) {
        this.dialog.setTitle(newTitle);
    }

    public void setPINMessage(String newMessage) {
        this.lblMessage.setText(newMessage);
    }

    public void pack() {
        this.dialog.pack();
    }

    public void setVisible(boolean flag) {
        if (flag) {
            this.cancelado = false;
            this.pass.setText("");
        }
        this.dialog.setVisible(flag);
    }

    public char[] getPassword() {
        return this.pass.getPassword();
    }

    public void dispose() {
        this.dialog.dispose();
    }

    public boolean isCancelado() {
        return this.cancelado;
    }
}

