/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.utils;

import es.mityc.javasign.exception.CopyFileException;
import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.trust.TrustFactory;
import es.mityc.javasign.utils.OSTool;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.Adler32;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CopyFilesTool {
    private static final Log LOG = LogFactory.getLog(CopyFilesTool.class);
    private static final II18nManager I18N = I18nFactory.getI18nManager("MITyCLibAPI");
    private static final int BUFFER_IN_SIZE = 32000;
    private static final int BUFFER_OUT_SIZE = 4096;
    private static final String DIGEST_SHA_256 = "SHA-256";
    private static final String FIELD_SYS_PATHS = "sys_paths";
    private static final String STR_FILE_DOT = "file.";
    private static final String STR_DOT_NAME = ".name";
    private static final String STR_DOT_RES = ".res";
    private static final String STR_DOT_ADLER32 = ".Adler32";
    private static final String STR_DOT_SHA2 = ".SHA2";
    private static final String STR_DOT_SIZE = ".size";
    private static final String STR_FILE_SEPARATOR = ",";
    private static final String STR_OS_NAME_WIN = "windows";
    private static final String STR_OS_NAME_LIN = "linux";
    private static final String STR_OS_NAME_MACOSX = "macosx";
    private static final String STR_OS_64BITS = "_64";
    private Properties props = null;
    private ClassLoader internalClassLoader = null;
    private Vector<String> vCopiedLibraries = new Vector();

    public CopyFilesTool(String fileProperties) {
        this(fileProperties, CopyFilesTool.getClassLoader());
    }

    public CopyFilesTool(String fileProperties, ClassLoader cl) {
        this.internalClassLoader = cl;
        this.loadProperties(fileProperties);
    }

    private void loadProperties(String fileProperties) {
        try {
            ArrayList<URL> resources = new ArrayList<URL>();
            Enumeration<URL> en = this.internalClassLoader.getResources(fileProperties);
            while (en.hasMoreElements()) {
                resources.add(0, en.nextElement());
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace(I18N.getLocalMessage("i18n.mityc.api.tools.cp.17", resources.size(), fileProperties));
            }
            Properties base = null;
            for (URL url : resources) {
                try {
                    InputStream is = url.openStream();
                    Properties properties = new Properties(base);
                    properties.load(is);
                    base = properties;
                }
                catch (IOException ex) {
                    LOG.error(I18N.getLocalMessage("i18n.mityc.api.tools.cp.1", url, ex.getMessage()));
                }
            }
            this.props = base;
        }
        catch (IOException ex) {
            LOG.error(I18N.getLocalMessage("i18n.mityc.api.tools.cp.1", fileProperties, ex.getMessage()));
        }
    }

    private static ClassLoader getClassLoader() {
        try {
            ClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    ClassLoader classLoader = null;
                    try {
                        classLoader = Thread.currentThread().getContextClassLoader();
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    return classLoader;
                }
            });
            if (cl != null) {
                return cl;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return TrustFactory.class.getClassLoader();
    }

    private String getKeyOS(String so, String version, String arch, String addendum) {
        String res = this.addStrings(so, version, arch, addendum);
        if (!(this.hasProp(res) || this.hasProp(res = this.addStrings(so, arch, addendum)) || this.hasProp(res = this.addStrings(so, version, addendum)))) {
            res = this.addStrings(String.valueOf(so) + addendum);
        }
        return res;
    }

    private String addStrings(String ... varargs) {
        StringBuffer sb = new StringBuffer("");
        String[] stringArray = varargs;
        int n = varargs.length;
        int n2 = 0;
        while (n2 < n) {
            String phrase = stringArray[n2];
            if (phrase != null) {
                sb.append(phrase);
            }
            ++n2;
        }
        return sb.toString();
    }

    public String copyFilesOS(String dir, String addendum, boolean updateLibraryPath) throws CopyFileException {
        return this.copyFilesOS(dir, addendum, updateLibraryPath, null);
    }

    public String copyFilesOS(String dir, String addendum, boolean updateLibraryPath, String suffix) throws CopyFileException {
        String key;
        OSTool.OS so = OSTool.getSO();
        if (LOG.isTraceEnabled()) {
            LOG.trace(I18N.getLocalMessage("i18n.mityc.api.tools.cp.14", so.toString()));
            LOG.trace("Arquitectura 64b?" + OSTool.isSun64bits());
        }
        if (so.isWindows()) {
            key = this.getKeyOS(STR_OS_NAME_WIN, so.getVersion(), OSTool.isSun64bits() ? STR_OS_64BITS : null, addendum != null ? "." + addendum : null);
        } else if (so.isLinux()) {
            key = this.getKeyOS(STR_OS_NAME_LIN, so.getVersion(), OSTool.isSun64bits() ? STR_OS_64BITS : null, addendum != null ? "." + addendum : null);
        } else if (so.isMacOsX()) {
            key = this.getKeyOS(STR_OS_NAME_MACOSX, so.getVersion(), OSTool.isSun64bits() ? STR_OS_64BITS : null, addendum != null ? "." + addendum : null);
        } else {
            throw new CopyFileException(I18N.getLocalMessage("i18n.mityc.api.tools.cp.2"));
        }
        String newDir = null;
        try {
            newDir = dir != null && !dir.trim().equals("") ? dir : new File(OSTool.getTempDir()).getCanonicalPath();
        }
        catch (IOException e) {
            LOG.error("No se puede canonicalizar la ruta: " + OSTool.getTempDir());
            String string = newDir = dir != null && !dir.trim().equals("") ? dir : new File(OSTool.getTempDir()).getAbsolutePath();
        }
        if (updateLibraryPath) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(I18N.getLocalMessage("i18n.mityc.api.tools.cp.16", newDir));
            }
            this.updateLibraryPath(newDir);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace(I18N.getLocalMessage("i18n.mityc.api.tools.cp.10", key, newDir));
        }
        if (suffix == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Se carga la librer\u00eda " + key);
            }
            try {
                this.copyFiles(newDir, key);
            }
            catch (CopyFileException e) {
                if (dir != null) {
                    return this.copyFilesOS(null, addendum, updateLibraryPath, suffix);
                }
                throw e;
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Se carga la librer\u00eda alternativa con el sufijo " + suffix);
            }
            this.copyFiles(newDir, key, suffix);
        }
        return newDir;
    }

    private boolean hasProp(String prop) {
        if (this.props != null && prop != null) {
            return this.props.getProperty(prop) != null;
        }
        return false;
    }

    public void updateLibraryPath(String path) {
        File fileDir;
        String libPath = System.getProperty("java.library.path");
        if (!libPath.contains((fileDir = new File(path)).getAbsolutePath())) {
            libPath = String.valueOf(fileDir.getAbsolutePath()) + File.pathSeparator + libPath;
            System.setProperty("java.library.path", libPath);
            try {
                Field fieldSysPath = ClassLoader.class.getDeclaredField(FIELD_SYS_PATHS);
                fieldSysPath.setAccessible(true);
                if (fieldSysPath != null) {
                    fieldSysPath.set(System.class.getClassLoader(), null);
                }
            }
            catch (NoSuchFieldException ex) {
                LOG.error(I18N.getLocalMessage("i18n.mityc.api.tools.cp.3"), ex);
            }
            catch (IllegalAccessException ex) {
                LOG.error(I18N.getLocalMessage("i18n.mityc.api.tools.cp.3"), ex);
            }
        }
    }

    public void copyFiles(String dir, String clave) throws CopyFileException {
        this.copyFiles(dir, clave, null);
    }

    public void copyFiles(String dir, String clave, String sufijo) throws CopyFileException {
        if (this.props != null) {
            try {
                String conjunto = this.props.getProperty(clave);
                if (LOG.isTraceEnabled()) {
                    LOG.trace(I18N.getLocalMessage("i18n.mityc.api.tools.cp.15", conjunto));
                }
                if (conjunto == null) {
                    LOG.error(I18N.getLocalMessage("i18n.mityc.api.tools.cp.4", clave));
                    throw new CopyFileException(I18N.getLocalMessage("i18n.mityc.api.tools.cp.4", clave));
                }
                StringTokenizer st = new StringTokenizer(conjunto, STR_FILE_SEPARATOR);
                boolean hasMore = st.hasMoreTokens();
                String finalFicheroDestino = "";
                while (hasMore) {
                    String fichero = st.nextToken();
                    hasMore = st.hasMoreTokens();
                    if (fichero == null) continue;
                    String nombreFichero = this.props.getProperty(STR_FILE_DOT + fichero + STR_DOT_NAME);
                    String resname = this.props.getProperty(STR_FILE_DOT + fichero + STR_DOT_RES);
                    CRCInfo crcInfo = this.getCRC(fichero);
                    try {
                        long size = Long.parseLong(this.props.getProperty(STR_FILE_DOT + fichero + STR_DOT_SIZE));
                        finalFicheroDestino = sufijo != null ? String.valueOf(nombreFichero.substring(0, nombreFichero.indexOf(46))) + sufijo + nombreFichero.substring(nombreFichero.indexOf(46)) : nombreFichero;
                        LOG.trace("*********DATOS COPIA. nombreFichero=" + nombreFichero + ",sufijo=" + sufijo + ",ficheroDestino=" + finalFicheroDestino + ",dir=" + dir);
                        this.copyRes(dir, nombreFichero, finalFicheroDestino, resname, crcInfo, size);
                        this.vCopiedLibraries.add(finalFicheroDestino);
                    }
                    catch (NumberFormatException e) {
                        LOG.error(I18N.getLocalMessage("i18n.mityc.api.tools.cp.4", STR_FILE_DOT + fichero + STR_DOT_SIZE));
                        throw new CopyFileException(I18N.getLocalMessage("i18n.mityc.api.tools.cp.4", STR_FILE_DOT + fichero + STR_DOT_SIZE));
                    }
                }
            }
            catch (MissingResourceException ex) {
                LOG.error(I18N.getLocalMessage("i18n.mityc.api.tools.cp.4", clave));
                throw new CopyFileException(I18N.getLocalMessage("i18n.mityc.api.tools.cp.4", clave));
            }
        } else {
            LOG.error(I18N.getLocalMessage("i18n.mityc.api.tools.cp.6"));
            throw new CopyFileException(I18N.getLocalMessage("i18n.mityc.api.tools.cp.6"));
        }
    }

    private CRCInfo getCRC(String fichero) throws CopyFileException {
        try {
            String value = this.props.getProperty(STR_FILE_DOT + fichero + STR_DOT_ADLER32);
            if (value == null) {
                throw new CopyFileException(I18N.getLocalMessage("i18n.mityc.api.tools.cp.5"));
            }
            Adler32Info crc = new Adler32Info();
            crc.processValue(value);
            return crc;
        }
        catch (MissingResourceException crc) {
            try {
                String value = this.props.getProperty(STR_FILE_DOT + fichero + STR_DOT_SHA2);
                if (value == null) {
                    throw new CopyFileException(I18N.getLocalMessage("i18n.mityc.api.tools.cp.5"));
                }
                SHA2Info crc2 = new SHA2Info();
                crc2.processValue(value);
                return crc2;
            }
            catch (MissingResourceException missingResourceException) {
                throw new CopyFileException(I18N.getLocalMessage("i18n.mityc.api.tools.cp.4"));
            }
        }
    }

    private void copyRes(String dir, String fichero, String ficheroDestino, String resname, CRCInfo crcValue, long size) throws CopyFileException {
        InputStream entrada = null;
        OutputStream salida = null;
        try {
            try {
                File dirFile = new File(dir);
                if (!dirFile.exists()) {
                    LOG.warn(I18N.getLocalMessage("i18n.mityc.api.tools.cp.21", dir));
                    dirFile.mkdirs();
                }
                File file = new File(dir, fichero);
                File fileDestino = new File(dir, ficheroDestino);
                if (!(file.exists() && this.checkIntegrityFile(file, crcValue, size) && fichero.equals(ficheroDestino))) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace(I18N.getLocalMessage("i18n.mityc.api.tools.cp.11", file.getAbsolutePath()));
                    }
                    entrada = new BufferedInputStream(this.internalClassLoader.getResourceAsStream(resname), 32000);
                    salida = new BufferedOutputStream(new FileOutputStream(fileDestino));
                    LOG.trace(I18N.getLocalMessage("i18n.mityc.api.tools.cp.22", resname, fileDestino));
                    byte[] buffer = new byte[4096];
                    int readed = entrada.read(buffer);
                    while (readed > 0) {
                        salida.write(buffer, 0, readed);
                        readed = entrada.read(buffer);
                    }
                    salida.flush();
                    if (fileDestino.exists() && dir.contains(OSTool.getTempDir())) {
                        fileDestino.deleteOnExit();
                    }
                }
            }
            catch (FileNotFoundException ex) {
                LOG.error(I18N.getLocalMessage("i18n.mityc.api.tools.cp.7"), ex);
                throw new CopyFileException(ex);
            }
            catch (IOException ex) {
                LOG.error(I18N.getLocalMessage("i18n.mityc.api.tools.cp.8", fichero, dir), ex);
                throw new CopyFileException(ex);
            }
        }
        finally {
            if (entrada != null) {
                try {
                    entrada.close();
                }
                catch (IOException e) {
                    LOG.error(e.getMessage());
                }
            }
            if (salida != null) {
                try {
                    salida.close();
                }
                catch (IOException e) {
                    LOG.error(e.getMessage());
                }
            }
        }
    }

    private boolean checkIntegrityFile(File file, CRCInfo crcValue, long size) throws IOException, CopyFileException {
        if (LOG.isTraceEnabled()) {
            LOG.trace(I18N.getLocalMessage("i18n.mityc.api.tools.cp.12", file.getAbsolutePath()));
        }
        if (!file.exists()) {
            return false;
        }
        if (file.length() != size) {
            return false;
        }
        return crcValue.checkFile(file);
    }

    private String toHexString(byte[] data) {
        StringBuffer sb = new StringBuffer();
        int pos = data.length;
        while (pos > 0) {
            sb.append(Integer.toHexString(data[--pos]));
        }
        return sb.toString();
    }

    public Vector<String> getCopiedLibraries() {
        return this.vCopiedLibraries;
    }

    private class Adler32Info
    extends CRCInfo {
        private long crc;

        private Adler32Info() {
        }

        @Override
        public void processValue(String value) throws CopyFileException {
            try {
                this.crc = Long.parseLong(value);
            }
            catch (NumberFormatException ex) {
                LOG.error(I18N.getLocalMessage("i18n.mityc.api.tools.cp.5"), ex);
                throw new CopyFileException(I18N.getLocalMessage("i18n.mityc.api.tools.cp.5"));
            }
        }

        @Override
        public CrcIntegrityEnum getCrcType() {
            return CrcIntegrityEnum.ADLER32;
        }

        public long getCrcValue() {
            return this.crc;
        }

        @Override
        public boolean checkFile(File file) throws CopyFileException {
            try {
                Adler32 crcAdler = new Adler32();
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(file), 32000);
                byte[] buffer = new byte[4096];
                int readed = ((InputStream)in).read(buffer);
                while (readed > 0) {
                    crcAdler.update(buffer, 0, readed);
                    readed = ((InputStream)in).read(buffer);
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace(I18N.getLocalMessage("i18n.mityc.api.tools.cp.13", crcAdler.getValue(), this.getCrcValue()));
                }
                return crcAdler.getValue() == this.getCrcValue();
            }
            catch (IOException ex) {
                throw new CopyFileException(ex);
            }
        }
    }

    private abstract class CRCInfo {
        private CRCInfo() {
        }

        protected abstract void processValue(String var1) throws CopyFileException;

        protected abstract CrcIntegrityEnum getCrcType();

        public abstract boolean checkFile(File var1) throws CopyFileException;
    }

    public static enum CrcIntegrityEnum {
        ADLER32,
        SHA2;

    }

    private class SHA2Info
    extends CRCInfo {
        private String crc;

        private SHA2Info() {
        }

        @Override
        public void processValue(String value) throws CopyFileException {
            this.crc = new String(value);
        }

        @Override
        public CrcIntegrityEnum getCrcType() {
            return CrcIntegrityEnum.SHA2;
        }

        public String getCrcValue() {
            return this.crc;
        }

        @Override
        public boolean checkFile(File file) throws CopyFileException {
            try {
                MessageDigest md = MessageDigest.getInstance(CopyFilesTool.DIGEST_SHA_256);
                BufferedInputStream entrada = new BufferedInputStream(new FileInputStream(file), 32000);
                byte[] buffer = new byte[4096];
                int readed = ((InputStream)entrada).read(buffer);
                while (readed > 0) {
                    md.update(buffer, 0, readed);
                    readed = ((InputStream)entrada).read(buffer);
                }
                String crcRes = CopyFilesTool.this.toHexString(md.digest());
                if (LOG.isTraceEnabled()) {
                    LOG.trace(I18N.getLocalMessage("i18n.mityc.api.tools.cp.13", crcRes, this.getCrcValue()));
                }
                return crcRes.equalsIgnoreCase(this.getCrcValue());
            }
            catch (IOException ex) {
                throw new CopyFileException(ex);
            }
            catch (NoSuchAlgorithmException ex) {
                throw new CopyFileException(ex);
            }
        }
    }
}

