/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.utils;

public final class HexUtils {
    private static final char[] NIBBLE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private HexUtils() {
    }

    public static String convert(byte[] data) {
        return HexUtils.hexString(data);
    }

    public static byte[] convert(String hex) {
        return HexUtils.fromHexString(hex);
    }

    private static String hexString(byte[] buf, int i, int longitud) {
        StringBuffer sb = new StringBuffer();
        int j = i;
        while (j < i + longitud) {
            sb.append(NIBBLE[buf[j] >>> 4 & 0xF]);
            sb.append(NIBBLE[buf[j] & 0xF]);
            ++j;
        }
        return String.valueOf(sb);
    }

    private static String hexString(byte[] buf) {
        return HexUtils.hexString(buf, 0, buf.length);
    }

    private static byte fromHexNibble(char n) {
        if (n <= '9') {
            return (byte)(n - 48);
        }
        if (n <= 'G') {
            return (byte)(n - 55);
        }
        return (byte)(n - 87);
    }

    private static byte[] fromHexString(String hex) {
        int l = hex.length() + 1 >>> 1;
        byte[] r = new byte[l];
        int i = 0;
        int j = 0;
        if (hex.length() % 2 != 0) {
            r[0] = HexUtils.fromHexNibble(hex.charAt(0));
            i = 1;
            j = 1;
        }
        while (i < l) {
            r[i++] = (byte)(HexUtils.fromHexNibble(hex.charAt(j++)) << 4 | HexUtils.fromHexNibble(hex.charAt(j++)));
        }
        return r;
    }
}

