/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.xml.xades.policy;

import adsi.org.apache.xml.security.c14n.CanonicalizationException;
import adsi.org.apache.xml.security.signature.XMLSignatureInput;
import adsi.org.apache.xml.security.transforms.TransformationException;
import adsi.org.apache.xml.security.transforms.Transforms;
import es.mityc.firmaJava.libreria.utilidades.Base64Coder;
import es.mityc.firmaJava.libreria.utilidades.NombreNodo;
import es.mityc.firmaJava.libreria.utilidades.UtilidadFicheros;
import es.mityc.firmaJava.libreria.utilidades.UtilidadFirmaElectronica;
import es.mityc.firmaJava.libreria.utilidades.UtilidadTratarNodo;
import es.mityc.firmaJava.libreria.xades.ResultadoValidacion;
import es.mityc.firmaJava.libreria.xades.XAdESSchemas;
import es.mityc.firmaJava.libreria.xades.elementos.xades.DocumentationReference;
import es.mityc.firmaJava.libreria.xades.elementos.xades.IPolicyQualifier;
import es.mityc.firmaJava.libreria.xades.elementos.xades.Int;
import es.mityc.firmaJava.libreria.xades.elementos.xades.NoticeRef;
import es.mityc.firmaJava.libreria.xades.elementos.xades.SPURI;
import es.mityc.firmaJava.libreria.xades.elementos.xades.SPUserNotice;
import es.mityc.firmaJava.libreria.xades.elementos.xades.SigPolicyQualifier;
import es.mityc.firmaJava.libreria.xades.elementos.xades.SignaturePolicyId;
import es.mityc.firmaJava.libreria.xades.elementos.xades.SignaturePolicyIdentifier;
import es.mityc.firmaJava.libreria.xades.elementos.xmldsig.Transform;
import es.mityc.firmaJava.libreria.xades.errores.FirmaXMLError;
import es.mityc.firmaJava.libreria.xades.errores.InvalidInfoNodeException;
import es.mityc.javasign.trust.TrustAbstract;
import es.mityc.javasign.xml.xades.policy.IValidacionPolicy;
import es.mityc.javasign.xml.xades.policy.PolicyException;
import es.mityc.javasign.xml.xades.policy.PolicyResult;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GeneralPolicyManager
implements IValidacionPolicy {
    private static final Log logger = LogFactory.getLog(GeneralPolicyManager.class);
    private static final String GENERAL_ID = "self:policy/general";

    @Override
    public String getIdentidadPolicy() {
        return GENERAL_ID;
    }

    @Override
    public PolicyResult validaPolicy(Element nodoFirma, ResultadoValidacion resultadoValidacion) {
        PolicyResult pr = new PolicyResult();
        pr.setResult(PolicyResult.StatusValidation.unknown);
        try {
            SignaturePolicyIdentifier signaturePolicyIdentifier = this.extractInfo(nodoFirma, resultadoValidacion);
            if (!signaturePolicyIdentifier.isImplied()) {
                ArrayList<SigPolicyQualifier> list;
                ArrayList<DocumentationReference> references;
                SignaturePolicyId spi = signaturePolicyIdentifier.getSignaturePolicyId();
                pr.setPolicyID(spi.getSigPolicyId().getIdentifier().getUri());
                if (spi.getSigPolicyId().getDescription() != null) {
                    pr.setDescription(spi.getSigPolicyId().getDescription().getValue());
                }
                if (spi.getSigPolicyId().getReferences() != null && (references = spi.getSigPolicyId().getReferences().getList()) != null && references.size() > 0) {
                    ArrayList<URI> uris = new ArrayList<URI>(references.size());
                    Iterator<DocumentationReference> it = references.iterator();
                    while (it.hasNext()) {
                        uris.add(it.next().getValue());
                    }
                    pr.setDocumentation(uris.toArray(new URI[0]));
                }
                if (spi.getSigPolicyQualifiers() != null && (list = spi.getSigPolicyQualifiers().getList()) != null && list.size() > 0) {
                    MessageDigest md = UtilidadFirmaElectronica.getMessageDigest(spi.getSigPolicyHash().getDigestMethod().getAlgorithm());
                    String digestValue = spi.getSigPolicyHash().getDigestValue().getValue();
                    ArrayList<PolicyResult.DownloadPolicy> downloadbles = new ArrayList<PolicyResult.DownloadPolicy>();
                    ArrayList<String> notices = new ArrayList<String>();
                    for (SigPolicyQualifier spq : list) {
                        NoticeRef nr;
                        IPolicyQualifier obj = spq.getQualifier();
                        if (obj instanceof SPURI) {
                            downloadbles.add(this.checkIntegrity(pr, ((SPURI)obj).getValue(), spi, resultadoValidacion.getBaseURI(), md, digestValue, nodoFirma.getOwnerDocument()));
                            continue;
                        }
                        if (!(obj instanceof SPUserNotice)) continue;
                        StringBuffer notice = new StringBuffer("");
                        String expl = ((SPUserNotice)obj).getExplicitText();
                        if (expl != null) {
                            notice.append(expl).append(" ");
                        }
                        if ((nr = ((SPUserNotice)obj).getNoticeRef()) != null) {
                            notice.append("(").append(nr.getOrganization().getValue());
                            Iterator<Int> itInt = nr.getNoticeNumbers().getInts().iterator();
                            if (itInt.hasNext()) {
                                notice.append(" ");
                            }
                            while (itInt.hasNext()) {
                                notice.append(itInt.next().getValue().toString());
                                if (!itInt.hasNext()) continue;
                                notice.append(".");
                            }
                            notice.append(")");
                        }
                        notices.add(notice.toString());
                    }
                    if (downloadbles.size() > 0) {
                        pr.setDownloable(downloadbles.toArray(new PolicyResult.DownloadPolicy[0]));
                    }
                    if (notices.size() > 0) {
                        pr.setNotices(notices.toArray(new String[0]));
                    }
                }
            }
        }
        catch (PolicyException ex) {
            pr.setResult(PolicyResult.StatusValidation.invalid);
            pr.setDescriptionResult(ex.getMessage());
        }
        return pr;
    }

    private PolicyResult.DownloadPolicy checkIntegrity(PolicyResult pr, URI uri, SignaturePolicyId spi, URI baseUri, MessageDigest md, String digestValue, Document doc) {
        PolicyResult.StatusValidation status = PolicyResult.StatusValidation.unknown;
        if (md != null) {
            URI descarga = uri;
            if (!uri.isAbsolute() && baseUri != null) {
                descarga = baseUri.resolve(uri);
            }
            if ("file".equals(descarga.getScheme())) {
                byte[] data = UtilidadFicheros.readFile(new File(descarga.getSchemeSpecificPart()));
                if (data == null) {
                    logger.warn("No se puede obtener el contenido referenciado");
                } else {
                    if (spi.getTransforms() != null) {
                        data = this.transform(data, spi.getTransforms(), doc);
                    }
                    md.update(data);
                    byte[] resData = md.digest();
                    String res = new String(Base64Coder.encode(resData));
                    status = res.equals(digestValue) ? PolicyResult.StatusValidation.valid : PolicyResult.StatusValidation.invalid;
                }
            } else {
                logger.warn("No se puede obtener el contenido referenciado en: " + descarga);
            }
        } else {
            logger.warn("Algoritmo desconocido");
        }
        return pr.newDownloadPolicy(uri, status);
    }

    private byte[] transform(byte[] in, es.mityc.firmaJava.libreria.xades.elementos.xmldsig.Transforms transforms, Document doc) {
        Transforms t = new Transforms(doc);
        ArrayList<Transform> list = transforms.getList();
        if (list != null) {
            for (Transform tr : list) {
                try {
                    if ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(tr.getAlgorithm())) {
                        t.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
                        continue;
                    }
                    if ("http://www.w3.org/2001/10/xml-exc-c14n#WithComments".equals(tr.getAlgorithm())) {
                        t.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
                        continue;
                    }
                    if ("http://www.w3.org/TR/2001/REC-xml-c14n-20010315".equals(tr.getAlgorithm())) {
                        t.addTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
                        continue;
                    }
                    if ("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments".equals(tr.getAlgorithm())) {
                        t.addTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
                        continue;
                    }
                    if (!"http://www.w3.org/TR/1999/REC-xpath-19991116".equals(tr.getAlgorithm())) continue;
                    t.addTransform("http://www.w3.org/TR/1999/REC-xpath-19991116", tr.getExtraNodes());
                }
                catch (TransformationException ex) {
                    logger.error("Error incluyendo transformada", ex);
                    return in;
                }
            }
        } else {
            return in;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLSignatureInput xmlSignatureInput = new XMLSignatureInput(in);
        try {
            XMLSignatureInput resultado = null;
            resultado = t.performTransforms(xmlSignatureInput);
            baos.write(resultado.getBytes());
        }
        catch (TransformationException ex) {
            logger.error("Error calculando transformada de pol\u00edtica", ex);
            return in;
        }
        catch (CanonicalizationException ex) {
            logger.error("Error calculando transformada de pol\u00edtica", ex);
            return in;
        }
        catch (IOException ex) {
            logger.error("Error calculando transformada de pol\u00edtica", ex);
            return in;
        }
        return baos.toByteArray();
    }

    private SignaturePolicyIdentifier extractInfo(Element nodoFirma, ResultadoValidacion resultadoValidacion) throws PolicyException {
        XAdESSchemas schema = resultadoValidacion.getDatosFirma().getEsquema();
        if (schema == null) {
            throw new PolicyException("Error obteniendo esquema de firma");
        }
        String esquema = schema.getSchemaUri();
        ArrayList<Element> signaturePolicyList = null;
        try {
            signaturePolicyList = UtilidadTratarNodo.obtenerNodos(nodoFirma, 5, new NombreNodo(esquema, "SignaturePolicyIdentifier"));
        }
        catch (FirmaXMLError e) {
            logger.error(e.getMessage(), e);
            throw new PolicyException("Error obteniendo el nodo de pol\u00edtica: " + e.getMessage());
        }
        if (signaturePolicyList.size() != 1) {
            throw new PolicyException("Error obteniendo nodo de pol\u00edtica (no hay nodo, o hay m\u00e1s de uno)");
        }
        if (signaturePolicyList.get(0).getNodeType() != 1) {
            throw new PolicyException("Error obteniendo nodo de pol\u00edtica (no es del tipo elemento)");
        }
        try {
            SignaturePolicyIdentifier signaturePolicyIdentifier = new SignaturePolicyIdentifier(schema);
            if (!signaturePolicyIdentifier.isThisNode(signaturePolicyList.get(0))) {
                throw new InvalidInfoNodeException("No se ha encontrado pol\u00edtica");
            }
            signaturePolicyIdentifier.load(signaturePolicyList.get(0));
            return signaturePolicyIdentifier;
        }
        catch (InvalidInfoNodeException ex) {
            throw new PolicyException(ex.getMessage(), ex);
        }
    }

    @Override
    public void setTruster(TrustAbstract truster) {
    }
}

