/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.pkstore.iexplorer;

import es.mityc.javasign.exception.CopyFileException;
import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.pkstore.iexplorer.IECSPJNI;
import es.mityc.javasign.pkstore.iexplorer.PKProxyIE;
import es.mityc.javasign.utils.CopyFilesTool;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.cert.CertificateEncodingException;
import java.security.spec.AlgorithmParameterSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class IESignEngine
extends SignatureSpi {
    private static final Log LOG = LogFactory.getLog(IESignEngine.class);
    private static final II18nManager I18N = I18nFactory.getI18nManager((String)"MITyCLibCert");
    private static IECSPJNI cspBridge = null;
    private byte[] paraFirmar = null;
    private byte[] certificadoBinario = null;

    public IESignEngine() {
        this.loadLibrary();
    }

    @Override
    public Object engineGetParameter(String parametro) throws InvalidParameterException {
        throw new InvalidParameterException(I18N.getLocalMessage("i18n.mityc.cert.ie.3"));
    }

    @Override
    public void engineInitSign(PrivateKey clavePrivada) throws InvalidKeyException {
        try {
            this.certificadoBinario = ((PKProxyIE)clavePrivada).getCertificate().getEncoded();
        }
        catch (CertificateEncodingException ex) {
            LOG.error((Object)"Error al obtener certificado de firma en codificaci\u00f3n DER", (Throwable)ex);
        }
    }

    @Override
    public void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        byte[] copia = new byte[len];
        System.arraycopy(b, off, copia, 0, len);
        this.setToSign(copia);
    }

    @Override
    public void engineSetParameter(String param, Object value) throws InvalidParameterException {
        throw new InvalidParameterException(I18N.getLocalMessage("i18n.mityc.cert.ie.2"));
    }

    @Override
    public void engineSetParameter(AlgorithmParameterSpec paramSpec) throws InvalidParameterException {
    }

    @Override
    public void engineUpdate(byte b) throws SignatureException {
        throw new UnsupportedOperationException(I18N.getLocalMessage("i18n.mityc.cert.ie.2"));
    }

    @Override
    public boolean engineVerify(byte[] firmaBytes) throws SignatureException {
        throw new SignatureException(I18N.getLocalMessage("i18n.mityc.cert.ie.4"));
    }

    @Override
    public void engineInitVerify(PublicKey clavePublica) throws InvalidKeyException {
        throw new InvalidKeyException(I18N.getLocalMessage("i18n.mityc.cert.ie.4"));
    }

    private void copyLibrary() throws CopyFileException {
        CopyFilesTool cft = new CopyFilesTool("libs/iexplorer/MITyCLibCertJNI_iexplorer.properties", this.getClass().getClassLoader());
        cft.copyFilesOS(null, "explorer", true);
    }

    private synchronized void loadLibrary() {
        block3: {
            try {
                if (cspBridge == null) {
                    this.copyLibrary();
                    cspBridge = new IECSPJNI();
                }
            }
            catch (Exception ex) {
                LOG.fatal((Object)I18N.getLocalMessage("i18n.mityc.cert.ie.1", new Object[]{ex.getMessage()}));
                if (!LOG.isDebugEnabled()) break block3;
                LOG.error((Object)ex);
            }
        }
    }

    @Override
    public byte[] engineSign() throws SignatureException {
        if (this.certificadoBinario == null) {
            throw new SignatureException(I18N.getLocalMessage("i18n.mityc.cert.ie.5"));
        }
        if (this.getToSign() == null) {
            throw new SignatureException(I18N.getLocalMessage("i18n.mityc.cert.ie.6"));
        }
        byte[] firma = cspBridge.signHash(this.getToSign(), this.certificadoBinario);
        if (firma == null) {
            LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.ie.7", new Object[]{cspBridge.getLastErrorCode()}));
            throw new SignatureException(I18N.getLocalMessage("i18n.mityc.cert.ie.7", new Object[]{cspBridge.getLastErrorCode()}));
        }
        byte[] copia = new byte[firma.length];
        System.arraycopy(firma, 0, copia, 0, firma.length);
        return copia;
    }

    @Override
    protected boolean engineVerify(byte[] firmaBytes, int offset, int longitud) throws SignatureException {
        throw new SignatureException(I18N.getLocalMessage("i18n.mityc.cert.ie.4"));
    }

    @Override
    protected void engineInitSign(PrivateKey clavePrivada, SecureRandom random) throws InvalidKeyException {
        this.engineInitSign(clavePrivada);
    }

    public byte[] getToSign() {
        return (byte[])this.paraFirmar.clone();
    }

    public void setToSign(byte[] paraFirmar) {
        this.paraFirmar = (byte[])paraFirmar.clone();
    }

    public byte[] getBinaryCertificate() {
        return (byte[])this.certificadoBinario.clone();
    }

    public void setBinaryCertificate(byte[] certificadoBinario) {
        this.certificadoBinario = (byte[])certificadoBinario.clone();
    }
}

