/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.pkstore.mitycstore.mantainer;

import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.pkstore.CertStoreException;
import es.mityc.javasign.pkstore.IPKStoreMaintainer;
import es.mityc.javasign.pkstore.IPKStoreManager;
import es.mityc.javasign.pkstore.mitycstore.PKHandlers.PlainPassHandler;
import es.mityc.javasign.pkstore.mitycstore.mantainer.CertCellRenderer;
import es.mityc.javasign.pkstore.mitycstore.mantainer.CertTblModel;
import es.mityc.javasign.pkstore.mitycstore.mantainer.CertsFilter;
import es.mityc.javasign.pkstore.mitycstore.mantainer.DialogoCert;
import es.mityc.javasign.pkstore.mitycstore.mantainer.KSManagerDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KSManagerPanel
extends JPanel {
    private static final Log LOG = LogFactory.getLog(KSManagerDialog.class);
    private static final II18nManager I18N = I18nFactory.getI18nManager((String)"MITyCLibCert");
    private IPKStoreManager pksm = null;
    private IPKStoreMaintainer pksma = null;
    private List<X509Certificate> signCerts = new ArrayList<X509Certificate>();
    private List<X509Certificate> authCerts = new ArrayList<X509Certificate>();
    private JPanel signPanel = null;
    private JPanel authPanel = null;
    private JPanel prefPanel = null;
    private JTabbedPane tabs = null;
    private JScrollPane scrollPaneSign = null;
    private JScrollPane scrollPaneAuth = null;
    private JTable signCrtTbl = null;
    private JTable authCrtTbl = null;
    private JButton updateSignBtn = null;
    private JButton deleteSignBtn = null;
    private JButton addSignBtn = null;
    private JButton updateAuthBtn = null;
    private JButton deleteAuthBtn = null;
    private JButton addAuthBtn = null;
    private JButton showPreferences = null;
    private DialogoCert dc = null;
    private Frame ownerFrame = null;
    private KSManagerPanel ksmp = null;

    public KSManagerPanel(Frame owner, IPKStoreManager pksManager, IPKStoreMaintainer pksMaintainer) {
        this.ownerFrame = owner;
        this.pksm = pksManager;
        this.pksma = pksMaintainer;
        this.loadKeyStore();
        this.panelInit();
    }

    public void setSignCertificates(List<X509Certificate> certs) {
        this.signCerts = certs;
        this.signCrtTbl.setModel(new CertTblModel(certs));
        this.repaint();
        this.ksmp = this;
    }

    public void setAuthCertificates(List<X509Certificate> certs) {
        this.authCerts = certs;
        this.authCrtTbl.setModel(new CertTblModel(certs));
        this.repaint();
    }

    protected void panelInit() {
        AbstractAction cancelAction = new AbstractAction("cancel"){

            @Override
            public void actionPerformed(ActionEvent e) {
                KSManagerPanel.this.signCrtTbl.clearSelection();
                KSManagerPanel.this.authCrtTbl.clearSelection();
            }
        };
        AbstractAction showInfo = new AbstractAction("showInfo"){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTable source = (JTable)e.getSource();
                X509Certificate cert = ((CertTblModel)source.getModel()).getCertificate(source.getSelectedRow());
                KSManagerPanel.this.dc.muestraInfo(cert);
            }
        };
        this.dc = new DialogoCert(this.ownerFrame);
        this.signPanel = new JPanel();
        this.authPanel = new JPanel();
        this.prefPanel = new JPanel();
        this.tabs = new JTabbedPane();
        this.tabs.addTab(I18N.getLocalMessage("i18n.mityc.cert.mityc.67"), this.signPanel);
        this.tabs.addTab(I18N.getLocalMessage("i18n.mityc.cert.mityc.68"), this.authPanel);
        this.signCrtTbl = new JTable();
        this.signCrtTbl.setDefaultRenderer(Object.class, new CertCellRenderer());
        this.signCrtTbl.setSelectionMode(0);
        this.signCrtTbl.setPreferredScrollableViewportSize(new Dimension(500, 200));
        this.signCrtTbl.setModel(new CertTblModel(this.signCerts));
        this.signCrtTbl.setAutoResizeMode(4);
        this.signCrtTbl.getColumnModel().getColumn(2).setPreferredWidth(100);
        this.signCrtTbl.getColumnModel().getColumn(2).setMaxWidth(100);
        this.signCrtTbl.getColumnModel().getColumn(2).setMinWidth(100);
        this.signCrtTbl.getColumnModel().getColumn(2).setWidth(100);
        this.scrollPaneSign = new JScrollPane(this.signCrtTbl);
        this.signCrtTbl.getActionMap().put(showInfo.getValue("Name"), showInfo);
        this.signCrtTbl.getActionMap().put(cancelAction.getValue("Name"), cancelAction);
        this.signCrtTbl.getInputMap().put(KeyStroke.getKeyStroke(10, 0), showInfo.getValue("Name"));
        this.signCrtTbl.getInputMap().put(KeyStroke.getKeyStroke(27, 0), cancelAction.getValue("Name"));
        this.signCrtTbl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    X509Certificate cert = ((CertTblModel)KSManagerPanel.this.signCrtTbl.getModel()).getCertificate(KSManagerPanel.this.signCrtTbl.getSelectedRow());
                    KSManagerPanel.this.dc.muestraInfo(cert);
                }
            }
        });
        this.signCrtTbl.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                X509Certificate cert = ((CertTblModel)KSManagerPanel.this.signCrtTbl.getModel()).getCertificate(KSManagerPanel.this.signCrtTbl.getSelectedRow());
                KSManagerPanel.this.deleteSignBtn.setEnabled(KSManagerPanel.this.pksma.isDeletable(cert));
            }
        });
        this.authCrtTbl = new JTable();
        this.authCrtTbl.setDefaultRenderer(Object.class, new CertCellRenderer());
        this.authCrtTbl.setSelectionMode(0);
        this.authCrtTbl.setPreferredScrollableViewportSize(new Dimension(500, 200));
        this.authCrtTbl.setModel(new CertTblModel(this.authCerts));
        this.authCrtTbl.setAutoResizeMode(4);
        this.authCrtTbl.getColumnModel().getColumn(2).setPreferredWidth(100);
        this.authCrtTbl.getColumnModel().getColumn(2).setMaxWidth(100);
        this.authCrtTbl.getColumnModel().getColumn(2).setMinWidth(100);
        this.authCrtTbl.getColumnModel().getColumn(2).setWidth(100);
        this.scrollPaneAuth = new JScrollPane(this.authCrtTbl);
        this.authCrtTbl.getActionMap().put(showInfo.getValue("Name"), showInfo);
        this.authCrtTbl.getActionMap().put(cancelAction.getValue("Name"), cancelAction);
        this.authCrtTbl.getInputMap().put(KeyStroke.getKeyStroke(10, 0), showInfo.getValue("Name"));
        this.authCrtTbl.getInputMap().put(KeyStroke.getKeyStroke(10, 0), showInfo.getValue("Name"));
        this.authCrtTbl.getInputMap().put(KeyStroke.getKeyStroke(27, 0), cancelAction.getValue("Name"));
        this.authCrtTbl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    X509Certificate cert = ((CertTblModel)KSManagerPanel.this.authCrtTbl.getModel()).getCertificate(KSManagerPanel.this.authCrtTbl.getSelectedRow());
                    KSManagerPanel.this.dc.muestraInfo(cert);
                }
            }
        });
        this.authCrtTbl.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                X509Certificate cert = ((CertTblModel)KSManagerPanel.this.authCrtTbl.getModel()).getCertificate(KSManagerPanel.this.authCrtTbl.getSelectedRow());
                KSManagerPanel.this.deleteAuthBtn.setEnabled(KSManagerPanel.this.pksma.isDeletable(cert));
            }
        });
        this.updateSignBtn = new JButton(I18N.getLocalMessage("i18n.mityc.cert.mityc.69"));
        this.updateSignBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KSManagerPanel.this.jButtonUpdateActionPerformed(ACTION_FOR.SIGN);
            }
        });
        this.deleteSignBtn = new JButton(I18N.getLocalMessage("i18n.mityc.cert.mityc.70"));
        this.deleteSignBtn.setEnabled(false);
        this.deleteSignBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KSManagerPanel.this.jButtonDelActionPerformed(ACTION_FOR.SIGN);
            }
        });
        this.addSignBtn = new JButton(I18N.getLocalMessage("i18n.mityc.cert.mityc.71"));
        this.addSignBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KSManagerPanel.this.jButtonAddActionPerformed(ACTION_FOR.SIGN);
            }
        });
        this.updateAuthBtn = new JButton(I18N.getLocalMessage("i18n.mityc.cert.mityc.69"));
        this.updateAuthBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KSManagerPanel.this.jButtonUpdateActionPerformed(ACTION_FOR.AUTH);
            }
        });
        this.updateAuthBtn.setEnabled(false);
        this.deleteAuthBtn = new JButton(I18N.getLocalMessage("i18n.mityc.cert.mityc.70"));
        this.deleteAuthBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KSManagerPanel.this.jButtonDelActionPerformed(ACTION_FOR.AUTH);
            }
        });
        this.addAuthBtn = new JButton(I18N.getLocalMessage("i18n.mityc.cert.mityc.71"));
        this.addAuthBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KSManagerPanel.this.jButtonAddActionPerformed(ACTION_FOR.AUTH);
            }
        });
        this.showPreferences = new JButton(I18N.getLocalMessage("i18n.mityc.cert.mityc.84"));
        this.showPreferences.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KSManagerPanel.this.jButtonShowPrefActionPerformed();
            }
        });
        this.signPanel.setTransferHandler(new DragDropHandler());
        this.signCrtTbl.setDragEnabled(false);
        this.authPanel.setTransferHandler(new DragDropHandler());
        this.authCrtTbl.setDragEnabled(false);
        this.signPanel.setLayout(new GridBagLayout());
        GridBagConstraints signTblGrid = new GridBagConstraints();
        signTblGrid.gridx = 0;
        signTblGrid.gridy = 0;
        signTblGrid.gridwidth = 6;
        signTblGrid.fill = 1;
        signTblGrid.weightx = 1.0;
        signTblGrid.weighty = 0.8;
        this.signPanel.add((Component)this.scrollPaneSign, signTblGrid);
        GridBagConstraints signAddBtnGrid = new GridBagConstraints();
        signAddBtnGrid.gridx = 1;
        signAddBtnGrid.gridy = 1;
        signAddBtnGrid.insets = new Insets(10, 80, 10, 75);
        this.signPanel.add((Component)this.addSignBtn, signAddBtnGrid);
        GridBagConstraints signDelBtnGrid = new GridBagConstraints();
        signDelBtnGrid.gridx = 2;
        signDelBtnGrid.gridy = 1;
        signDelBtnGrid.insets = new Insets(10, 0, 10, 75);
        this.signPanel.add((Component)this.deleteSignBtn, signDelBtnGrid);
        GridBagConstraints signUpdBtnGrid = new GridBagConstraints();
        signUpdBtnGrid.gridx = 3;
        signUpdBtnGrid.gridy = 1;
        signUpdBtnGrid.insets = new Insets(10, 0, 10, 50);
        this.signPanel.add((Component)this.updateSignBtn, signUpdBtnGrid);
        this.authPanel.setLayout(new GridBagLayout());
        GridBagConstraints authTblGrid = new GridBagConstraints();
        authTblGrid.gridx = 0;
        authTblGrid.gridy = 0;
        authTblGrid.gridwidth = 6;
        authTblGrid.fill = 1;
        authTblGrid.weightx = 1.0;
        authTblGrid.weighty = 0.8;
        this.authPanel.add((Component)this.scrollPaneAuth, authTblGrid);
        GridBagConstraints authAddBtnGrid = new GridBagConstraints();
        authAddBtnGrid.gridx = 1;
        authAddBtnGrid.gridy = 1;
        authAddBtnGrid.insets = new Insets(10, 80, 10, 75);
        this.authPanel.add((Component)this.addAuthBtn, authAddBtnGrid);
        GridBagConstraints authDelBtnGrid = new GridBagConstraints();
        authDelBtnGrid.gridx = 2;
        authDelBtnGrid.gridy = 1;
        authDelBtnGrid.insets = new Insets(10, 0, 10, 75);
        this.authPanel.add((Component)this.deleteAuthBtn, authDelBtnGrid);
        GridBagConstraints authUpdBtnGrid = new GridBagConstraints();
        authUpdBtnGrid.gridx = 3;
        authUpdBtnGrid.gridy = 1;
        authUpdBtnGrid.insets = new Insets(10, 0, 10, 50);
        this.authPanel.add((Component)this.updateAuthBtn, authUpdBtnGrid);
        this.prefPanel.setLayout(new GridBagLayout());
        GridBagConstraints prefGrid = new GridBagConstraints();
        prefGrid.gridx = 0;
        prefGrid.gridy = 0;
        prefGrid.gridwidth = 4;
        prefGrid.insets = new Insets(3, 20, 3, 20);
        prefGrid.anchor = 10;
        this.prefPanel.add((Component)this.showPreferences, prefGrid);
        this.prefPanel.setBorder(new TitledBorder(I18N.getLocalMessage("i18n.mityc.cert.mityc.84")));
        this.setLayout(new GridBagLayout());
        GridBagConstraints tabsGrid = new GridBagConstraints();
        tabsGrid.gridx = 0;
        tabsGrid.gridy = 0;
        tabsGrid.gridwidth = 4;
        tabsGrid.insets = new Insets(3, 3, 0, 3);
        tabsGrid.fill = 1;
        tabsGrid.weightx = 1.0;
        tabsGrid.weighty = 1.0;
        this.add((Component)this.tabs, tabsGrid);
        GridBagConstraints prefPanelGrid = new GridBagConstraints();
        prefPanelGrid.gridx = 0;
        prefPanelGrid.gridy = 1;
        prefPanelGrid.gridwidth = 4;
        prefPanelGrid.insets = new Insets(3, 3, 10, 3);
        prefPanelGrid.fill = 2;
        prefPanelGrid.weightx = 1.0;
        prefPanelGrid.ipady = 5;
        this.add((Component)this.prefPanel, prefPanelGrid);
        this.setBorder(new TitledBorder(I18N.getLocalMessage("i18n.mityc.cert.mityc.72")));
    }

    protected void jButtonAddActionPerformed(final ACTION_FOR action) {
        Thread th = new Thread(new Runnable(){

            @Override
            public void run() {
                JFileChooser chooser = new JFileChooser();
                chooser.setDialogTitle(I18N.getLocalMessage("i18n.mityc.cert.mityc.73"));
                chooser.setDialogType(0);
                chooser.setFileFilter(new CertsFilter(ACTION_FOR.SIGN.equals((Object)action)));
                int returnVal = chooser.showOpenDialog(KSManagerPanel.this.ksmp);
                if (returnVal != 0) {
                    return;
                }
                KSManagerPanel.this.addCertFromPath(chooser.getSelectedFile().getAbsolutePath(), action);
            }
        });
        th.run();
    }

    protected void jButtonDelActionPerformed(final ACTION_FOR action) {
        Thread th = new Thread(new Runnable(){

            @Override
            public void run() {
                int row = 0;
                if (action.equals((Object)ACTION_FOR.SIGN)) {
                    row = KSManagerPanel.this.signCrtTbl.getSelectedRow();
                    KSManagerPanel.this.deleteSignCert(row);
                    if (KSManagerPanel.this.signCrtTbl.getModel().getRowCount() > 0) {
                        KSManagerPanel.this.signCrtTbl.setRowSelectionInterval(0, 0);
                    }
                } else {
                    row = KSManagerPanel.this.authCrtTbl.getSelectedRow();
                    KSManagerPanel.this.deleteTrustCert(row);
                    if (KSManagerPanel.this.authCrtTbl.getModel().getRowCount() > 0) {
                        KSManagerPanel.this.authCrtTbl.setRowSelectionInterval(0, 0);
                    }
                }
            }
        });
        th.run();
    }

    protected void jButtonUpdateActionPerformed(ACTION_FOR action) {
        if (action.equals((Object)ACTION_FOR.AUTH)) {
            return;
        }
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(I18N.getLocalMessage("i18n.mityc.cert.mityc.73"));
        chooser.setDialogType(0);
        chooser.setFileFilter(new CertsFilter(true));
        int returnVal = chooser.showOpenDialog(this.ksmp);
        if (returnVal == 0) {
            this.addCertFromPath(chooser.getSelectedFile().getAbsolutePath(), null);
            this.deleteSignCert(this.signCrtTbl.getSelectedRow());
            if (this.signCrtTbl.getModel().getRowCount() > 0) {
                this.signCrtTbl.setRowSelectionInterval(0, 0);
            }
        } else {
            return;
        }
    }

    protected void jButtonShowPrefActionPerformed() {
        JDialog pref = new JDialog(this.ownerFrame);
        JPanel panel = this.pksma.getPreferencesPanel();
        pref.add(panel);
        pref.setSize(panel.getSize());
        pref.setTitle(I18N.getLocalMessage("i18n.mityc.cert.mityc.90"));
        pref.setLocationRelativeTo(this.ownerFrame);
        if (this.ownerFrame == null) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            pref.setLocation(screenSize.width / 2 - pref.getWidth() / 2, screenSize.height / 2 - pref.getHeight() / 2);
        }
        pref.setModal(true);
        pref.setResizable(false);
        pref.setVisible(true);
    }

    protected void loadKeyStore() {
        try {
            if (this.pksm == null) {
                JOptionPane.showMessageDialog(this, I18N.getLocalMessage("i18n.mityc.cert.mityc.59"), I18N.getLocalMessage("i18n.mityc.cert.mityc.15"), 0);
                return;
            }
            this.signCerts = this.pksm.getSignCertificates();
            this.authCerts = this.pksm.getTrustCertificates();
        }
        catch (CertStoreException e) {
            e.printStackTrace();
        }
    }

    private void addSignCert(PrivateKey pk, X509Certificate cert, char[] password) {
        if (this.pksm == null) {
            return;
        }
        try {
            this.pksma.importSignCert(pk, cert, password);
            this.refreshTbl();
        }
        catch (CertStoreException e) {
            LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mityc.74"), (Throwable)e);
            return;
        }
    }

    public void addTrustCert(X509Certificate cert) {
        if (this.pksm == null) {
            return;
        }
        try {
            this.pksma.addTrustCert(cert);
            this.refreshTbl();
        }
        catch (CertStoreException e) {
            LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mityc.74"), (Throwable)e);
            return;
        }
    }

    private void deleteSignCert(int row) {
        if (this.pksm == null) {
            return;
        }
        if (row != -1) {
            try {
                this.pksma.removeSignCert(((CertTblModel)this.signCrtTbl.getModel()).getCertificate(row));
                this.refreshTbl();
            }
            catch (CertStoreException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), I18N.getLocalMessage("i18n.mityc.cert.mityc.19"), 2);
            }
        } else {
            LOG.debug((Object)"No se puede borrar, no hay certificado seleccionado.");
        }
    }

    private void deleteTrustCert(int row) {
        if (this.pksm == null) {
            return;
        }
        if (row != -1) {
            try {
                this.pksma.removeTrustCert(((CertTblModel)this.authCrtTbl.getModel()).getCertificate(row));
                this.refreshTbl();
            }
            catch (CertStoreException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), I18N.getLocalMessage("i18n.mityc.cert.mityc.19"), 2);
            }
        } else {
            LOG.debug((Object)"No se puede borrar, no hay certificado seleccionado.");
        }
    }

    private void updateSignCert(X509Certificate cert) {
        if (this.pksm == null) {
            return;
        }
        try {
            this.pksma.updateSignCert(cert);
            this.refreshTbl();
        }
        catch (CertStoreException e) {
            e.printStackTrace();
        }
    }

    private void refreshTbl() {
        try {
            this.signCerts = this.pksm.getSignCertificates();
            this.authCerts = this.pksm.getTrustCertificates();
        }
        catch (CertStoreException e) {
            e.printStackTrace();
        }
        this.signCrtTbl.setModel(new CertTblModel(this.signCerts));
        this.authCrtTbl.setModel(new CertTblModel(this.authCerts));
        this.signCrtTbl.repaint();
        this.authCrtTbl.repaint();
    }

    public X509Certificate getSignCertificate() {
        int sel = this.signCrtTbl.getSelectedRow();
        if (sel > -1 && sel < this.signCerts.size()) {
            return this.signCerts.get(sel);
        }
        return null;
    }

    public X509Certificate getAuthCertificate() {
        int sel = this.authCrtTbl.getSelectedRow();
        if (sel > -1 && sel < this.authCerts.size()) {
            return this.authCerts.get(sel);
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addCertFromPath(String path, ACTION_FOR action) {
        char[] passwordP12;
        PrivateKey pk12;
        X509Certificate cert;
        block52: {
            if (!new File(path).exists()) {
                LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mityc.75"));
                return;
            }
            FileInputStream fis = null;
            cert = null;
            pk12 = null;
            passwordP12 = null;
            if (path.endsWith("p12")) {
                try {
                    KeyStore ks12 = KeyStore.getInstance("PKCS12");
                    passwordP12 = null;
                    try {
                        fis = new FileInputStream(path);
                        PlainPassHandler passHandler = new PlainPassHandler();
                        passwordP12 = passHandler.getPassword(null, path.substring(path.lastIndexOf(File.separator) + 1));
                        try {
                            ks12.load(fis, passwordP12);
                        }
                        catch (IOException e) {
                            LOG.error((Object)I18N.getLocalMessage("i18n.mityc.cert.mityc.76"));
                            JOptionPane.showMessageDialog(this, I18N.getLocalMessage("i18n.mityc.cert.mityc.76"), I18N.getLocalMessage("i18n.mityc.cert.mityc.77"), 2);
                            if (fis == null) return;
                            try {
                                fis.close();
                                return;
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            return;
                        }
                        Enumeration<String> contenidoP12 = ks12.aliases();
                        String alias = null;
                        if (ks12.size() != 1) {
                            JOptionPane.showMessageDialog(this, I18N.getLocalMessage("i18n.mityc.cert.mityc.78"), I18N.getLocalMessage("i18n.mityc.cert.mityc.77"), 2);
                            return;
                        }
                        alias = contenidoP12.nextElement();
                        LOG.debug((Object)("P12.- Alias del certificado: " + alias));
                        try {
                            cert = (X509Certificate)ks12.getCertificate(alias);
                        }
                        catch (KeyStoreException e1) {
                            e1.printStackTrace();
                            if (fis == null) return;
                            try {
                                fis.close();
                                return;
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            return;
                        }
                        if (!ks12.isKeyEntry(alias)) break block52;
                        passwordP12 = passHandler.getPassword(null, I18N.getLocalMessage("i18n.mityc.cert.mityc.80"));
                        KeyStore.PasswordProtection kpp12 = new KeyStore.PasswordProtection(passwordP12);
                        KeyStore.PrivateKeyEntry pkEntry12 = null;
                        try {
                            pkEntry12 = (KeyStore.PrivateKeyEntry)ks12.getEntry(alias, kpp12);
                        }
                        catch (NoSuchAlgorithmException e1) {
                            e1.printStackTrace();
                        }
                        catch (UnrecoverableEntryException e) {
                            JOptionPane.showMessageDialog(this, I18N.getLocalMessage("i18n.mityc.cert.mityc.79"), I18N.getLocalMessage("i18n.mityc.cert.mityc.77"), 2);
                            if (fis == null) return;
                            try {
                                fis.close();
                                return;
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            return;
                        }
                        if (pkEntry12 != null) {
                            pk12 = pkEntry12.getPrivateKey();
                            break block52;
                        } else {
                            LOG.debug((Object)"P12.- No se encontr\u00f3 la clave privada");
                        }
                        break block52;
                    }
                    catch (NoSuchAlgorithmException e) {
                        e.printStackTrace();
                        return;
                    }
                    catch (CertificateException e) {
                        e.printStackTrace();
                        return;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        catch (FileNotFoundException e2) {
                            e2.printStackTrace();
                            return;
                        }
                    }
                    finally {
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                catch (KeyStoreException e1) {
                    e1.printStackTrace();
                    return;
                }
            }
            if (path.endsWith("cer") || path.endsWith("crt")) {
                try {
                    CertificateFactory cfTemporal = CertificateFactory.getInstance("X.509");
                    cert = (X509Certificate)cfTemporal.generateCertificate(new FileInputStream(new File(path)));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
                catch (CertificateException e) {
                    e.printStackTrace();
                    return;
                }
            }
        }
        if (action == null) {
            this.updateSignCert(cert);
            return;
        }
        if (action.equals((Object)ACTION_FOR.SIGN)) {
            this.addSignCert(pk12, cert, passwordP12);
            return;
        }
        this.addTrustCert(cert);
    }

    public static enum ACTION_FOR {
        SIGN,
        AUTH;

    }

    private class DragDropHandler
    extends TransferHandler {
        private DragDropHandler() {
        }

        @Override
        public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
            boolean res = false;
            DataFlavor[] dataFlavorArray = transferFlavors;
            int n = transferFlavors.length;
            int n2 = 0;
            while (n2 < n) {
                DataFlavor dataFlavor = dataFlavorArray[n2];
                if (dataFlavor.isFlavorJavaFileListType()) {
                    res = true;
                    break;
                }
                ++n2;
            }
            return res ? true : super.canImport(comp, transferFlavors);
        }

        @Override
        public boolean importData(JComponent comp, Transferable t) {
            boolean res = false;
            DataFlavor[] trasnferFlavors = t.getTransferDataFlavors();
            File file = null;
            DataFlavor[] dataFlavorArray = trasnferFlavors;
            int n = trasnferFlavors.length;
            int n2 = 0;
            while (n2 < n) {
                DataFlavor dataFlavor = dataFlavorArray[n2];
                if (dataFlavor.isFlavorJavaFileListType()) {
                    try {
                        List files = (List)t.getTransferData(dataFlavor);
                        if (files.size() > 0) {
                            file = (File)files.get(0);
                            if (file.exists()) {
                                if (file.getName().endsWith("cer") || file.getName().endsWith("crt") || file.getName().endsWith("p12")) {
                                    if (KSManagerPanel.this.signPanel.equals(comp)) {
                                        KSManagerPanel.this.addCertFromPath(file.getAbsolutePath(), ACTION_FOR.SIGN);
                                    } else {
                                        KSManagerPanel.this.addCertFromPath(file.getAbsolutePath(), ACTION_FOR.AUTH);
                                    }
                                } else {
                                    EventQueue.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            JOptionPane.showMessageDialog(KSManagerPanel.this.tabs, I18N.getLocalMessage("i18n.mityc.cert.mityc.56"), I18N.getLocalMessage("i18n.mityc.cert.mityc.77"), 0);
                                        }
                                    });
                                }
                            } else {
                                EventQueue.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        JOptionPane.showMessageDialog(KSManagerPanel.this.tabs, I18N.getLocalMessage("i18n.mityc.cert.mityc.75"), I18N.getLocalMessage("i18n.mityc.cert.mityc.77"), 0);
                                    }
                                });
                            }
                            res = true;
                            break;
                        }
                    }
                    catch (UnsupportedFlavorException unsupportedFlavorException) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
            return res ? true : super.importData(comp, t);
        }

        @Override
        public void exportAsDrag(JComponent comp, InputEvent e, int action) {
            LOG.warn((Object)"Not implemented yet.");
        }
    }
}

