<?php

namespace App\Http\Controllers\API;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller as Controller;
use DB;


class BaseController extends Controller
{
    /**
     * success response method.
     *
     * @return \Illuminate\Http\Response
     */
    public function sendResponse($result, $message)
    {
    	$response = [
            'success' => true,
            'data'    => $result,
            'message' => $message,
        ];


        return response()->json($response, 200);
    }


    /**
     * return error response.
     *
     * @return \Illuminate\Http\Response
     */
    public function sendError($error, $errorMessages = [], $code = 404)
    {
    	$response = [
            'success' => false,
            'message' => $error,
        ];


        if(!empty($errorMessages)){
            $response['data'] = $errorMessages;
        }


        return response()->json($response, $code);
    }

    public function claveElectronica($fecha,$documento,$codigoDocumentoElectronico,$ambiente,$emision,$ruc){

        $fechaEn = $fecha;
        $fechaEs = \Carbon\Carbon::parse($fechaEn)->format('d-m-Y');
        $arrayDocumento = explode('-',$documento);
        $secuencia = $arrayDocumento[2];
        $serie = $arrayDocumento[0].'-'.$arrayDocumento[1];
        $codigoSri = $codigoDocumentoElectronico;
        $tipoAmbiente = $ambiente;        
        $tipoEmision = $emision;
        $estatico = '12345678';        
        $ruc = $ruc;

        $result = str_pad($secuencia,9,"0",STR_PAD_LEFT);
        $nro = '';
        $documento =  $serie.'-'.$result;
        $clave = '';
        
        $fecha = str_replace('-', '', $fechaEs);            
        $codigoSri = str_pad($codigoSri,2,"0",STR_PAD_LEFT);
        $documentoLine = str_replace('-', '', $documento);
        //$fecha = this.info.fecha.replace("-", "");
        $nro = $fecha.$codigoSri.$ruc.$tipoAmbiente.$documento.$estatico.$tipoEmision;
        $nroLine = str_replace('-', '', $nro);
        $codeVerificate = $this->codeVerificate($nroLine);
        $clave = $nroLine.$codeVerificate;  

        return [
            'nro' => $nro,
            'doc' => $documento,
            'clave' => $clave
        ];                    
    }

    public function codeVerificate($nro){
        $vtcontador;
        $vtsuma = 0;
        $vtres;
        $vtretval;
        //let vti;

        $vtcontador = 1;
        //console.log('vcontador -->');
        for($vti = strlen($nro)-1; $vti >= 0; $vti--){
            //console.log('vti -->',vti);
            $vtsuma = $vtsuma + substr($nro,$vti,1) * ($vtcontador +1);
            //console.log('nro.substring -->',nro.substr(vti,1));
            //console.log('vtsuma -->',vtsuma);

            if($vtcontador > 5 ){
                $vtcontador = 1;
            }else{
                $vtcontador = $vtcontador + 1;
            }
        }
        
        $vtres = 11 - ($vtsuma % 11);
        //console.log('vtres -->',vtres);

        if ($vtres == 10){
            $vtretval = 1;
        }else if($vtres == 11){
            $vtretval = 0;
        }else{
            $vtretval = $vtres;
        }
        //console.log('vtres -->',vtres);

        return $vtretval;
    }
    

    
}