<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\API\BaseController as BaseController;
use Illuminate\Support\Facades\Storage;

class FileController extends BaseController
{
    public function showFile($ruc,$folder,$type,$filePath)
    {
        //dd(1);
        // Ruta completa dentro del almacenamiento
        $path = $ruc.'/'.$folder.'/'.$type.'/'.$filePath;

        //dd($path);

        // Verificar si el archivo existe
        if (Storage::disk('custom')->exists($path)) {
            // Obtener la URL del archivo (necesita el enlace simbólico creado)
            $url = Storage::disk('custom')->url($path);

            return response()->json(['url' => $url]);
        }

        return response()->json(['message' => 'Archivo no encontrado'], 404);
    }
    
    public function showFileDoc($ruc, $folder, $type, $filePath)
    {
        // Construir la ruta completa dentro del almacenamiento
        $path = $ruc . '/' . $folder . '/' . $type . '/' . $filePath;
    
        // Verificar si el archivo existe en el disco especificado
        if (Storage::disk('custom')->exists($path)) {
            // Obtener el contenido del archivo
            $fileContent = Storage::disk('custom')->get($path);
    
            // Obtener el tipo MIME del archivo
            $mimeType = Storage::disk('custom')->mimeType($path);
    
            // Retornar el archivo con el tipo MIME correcto
            return response($fileContent, 200, [
                'Content-Type' => $mimeType,
                'Content-Disposition' => 'inline; filename="' . basename($filePath) . '"',
            ]);
        }
    
        // Retornar un error si el archivo no existe
        return response()->json(['message' => 'Archivo no encontrado'], 404);
    }
}