<?php

namespace App\Http\Controllers\API;

use Illuminate\Http\Request;
use App\Http\Controllers\API\BaseController as BaseController;
use Validator;
use DOMDocument;
use SimpleXMLElement;
use DOMXPath;
use SoapClient;
use SoapFault;
use GuzzleHttp\Client;
use TCPDF;
use Illuminate\Support\Facades\Http;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7;
use Spatie\ArrayToXml\ArrayToXml;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;

class NotaCreditoController extends BaseController
{

    public function create(Request $request){   


        $validator = Validator::make($request->all(),[
            /***** dataEmpresa *****/
            'dataEmpresa.id'                            => 'required|integer',
            'dataEmpresa.ambiente'                      => 'required|integer',
            'dataEmpresa.emision'                       => 'required|integer',
            'dataEmpresa.razonSocial'                   => 'required|string',
            'dataEmpresa.nombreComercial'               => 'required|string',
            'dataEmpresa.ruc'                           => 'required',
            'dataEmpresa.direccion'                     => 'required|string',
            'dataEmpresa.obligadoContabilidad'          => 'required',
            'dataEmpresa.agenteRetenedor'               => 'required',
            'dataEmpresa.resolucionAgenteRetenedor'     => 'nullable|string',
            'dataEmpresa.contribuyenteRimpe'            => 'required',
            'dataEmpresa.contribuyenteRimpeNegocioPopular' => 'required',
            'dataEmpresa.contribuyenteEspecial'         => 'required',
            'dataEmpresa.idContribuyenteEspecial'       => 'nullable',
            'dataEmpresa.email'                         => 'required|email',
            'dataEmpresa.rutaLogo'                      => 'required',
            'dataEmpresa.logoGeneral'                   => 'required',
            /***** dataInfo *****/
            'dataInfo.numeroDocumento'                 => 'required|string',
            'dataInfo.direccionBodega'                 => 'required|string',
            'dataInfo.fecha'                           => 'required|date_format:d-m-Y',
            'dataInfo.email1'                          => 'required|email',
            'dataInfo.email2'                          => 'nullable|email',
            'dataInfo.email3'                          => 'nullable|email',
            'dataInfo.codigoCliente'                   => 'required|string',
            'dataInfo.direccion'                       => 'nullable|string',
            'dataInfo.telefono'                        => 'nullable|string',
            'dataInfo.idTipoIdentificacion'            => 'required|string',
            'dataInfo.razonSocial'                     => 'required|string',
            'dataInfo.identificacion'                  => 'required|string',
            'dataInfo.direccion'                       => 'required|string',
            'dataInfo.subtotal'                        => 'required|numeric',
            'dataInfo.descuento'                       => 'required|numeric',
            'dataInfo.baseGravableIva'                 => 'required|numeric',
            'dataInfo.baseNoGravableIva'               => 'required|numeric',
            'dataInfo.montoIva'                        => 'required|numeric',
            'dataInfo.montoNeto'                       => 'required|numeric',
            'dataInfo.moneda'                          => 'required|string',
            'dataInfo.clave'                           => 'required|string',
            'dataInfo.codDocModificado'                => 'required|string',
            'dataInfo.numDocModificado'                => 'required|string',
            'dataInfo.motivo'                          => 'required|string',
            'dataInfo.fechaEmisionDocSustento'                  => 'required|date_format:d-m-Y',
            /***** dataTipoImpuesto *****/
            'dataTipoImpuesto.codigoSriAts'                         => 'required|string',
            'dataTipoImpuesto.codigoSriDocumentoElectronico'        => 'required|string',
            'dataTipoImpuesto.porcentaje'                           => 'required|numeric',
            'dataTipoImpuesto_0.codigoSriAts'                       => 'required|string',
            'dataTipoImpuesto_0.codigoSriDocumentoElectronico'      => 'required|string',
            'dataTipoImpuesto_0.porcentaje'                         => 'required|numeric',
            /***** dataPago *****/
            //'dataPago'                                              => 'required|array|min:1',
            //'dataPago.*.codigoSriDocumentoElectronico'              => 'required|string',
            //'dataPago.*.monto'                                      => 'required|numeric',
            //'dataPago.*.cantidadDias'                               => 'required|numeric',
            /***** dataTipoImpuesto *****/
            'dataItem'                                              => 'required|array|min:1',
            'dataItem.*.codigoPrincipal'                            => 'required|string',
            'dataItem.*.codigoAuxiliar'                             => 'required|string',
            'dataItem.*.descripcionProducto'                        => 'required|string',
            'dataItem.*.notaProducto'                               => 'nullable|string',
            'dataItem.*.cantidad'                                   => 'required|numeric',
            'dataItem.*.precioUnitario'                             => 'required|numeric',
            'dataItem.*.subtotalProducto'                           => 'required|numeric',
            'dataItem.*.descuentoProducto'                          => 'required|numeric',
            'dataItem.*.montoIvaProducto'                           => 'required|numeric',
            /***** dataItemAdicional *****/
            'dataItemAdicional'                                     => 'nullable|array',
            'dataItemAdicional.*.campo'                             => 'required|string',
            /***** dataInfoAdicional *****/
            'dataInfoAdicional'                                     => 'nullable|array',
            'dataInfoAdicional.*.campo'                             => 'required|string',
            'dataInfoAdicional.*.contenido'                         => 'required|string',
        ]);

        if($validator->fails()){
            return $this->sendError('Validation Error.', $validator->errors(),422);
        }

        ini_set('max_execution_time', 9000);

        //$VFIRMA = $dataEmpresa['firma'];
        //$VCLAVEFIRMA =  $dataEmpresa['claveFirma'];

        $dataEmpresa = $request->dataEmpresa;
        $info = (object) $request->dataInfo;
        $info_tipo_impuesto = (object) $request->dataTipoImpuesto;
        $info_tipo_impuesto_0 = (object) $request->dataTipoImpuesto_0;
        $info_items = $request->dataItem;
        $item_adicional = $request->dataItemAdicional;
        $info_adicional = $request->dataInfoAdicional;

        

        //$VGEMPRESA = $dataEmpresa['nombre'];
        $VLID = $dataEmpresa['id'];
        $VLAMBIENTE = $dataEmpresa['ambiente'];
        $VLEMISION = $dataEmpresa['emision'];
        $VLRAZONSOCIAL =  str_replace("\n", ' ', $dataEmpresa['razonSocial']);
        $VLNOMBRECOMERCIAL = $dataEmpresa['nombreComercial'];
        $VLRUC = $dataEmpresa['ruc'];
        $VLDIRMATRIZ = str_replace("\n", ' ',$dataEmpresa['direccion']);
        $VLCONTABILIDAD = $dataEmpresa['obligadoContabilidad'] == 'S' ? 'SI' : 'NO'; 
        $VLAGENTERETENEDOR = $dataEmpresa['agenteRetenedor'] == 'S' ? 'SI' : 'NO';
        $VLRESOLUCIONAGENTERETENEDOR = $dataEmpresa['resolucionAgenteRetenedor']; 
        $VLCONTRIBUYENTERIMPE = $dataEmpresa['contribuyenteRimpe'] == 'S' ? 'SI' : 'NO';
        $VLCONTRIBUYENTERIMPENEGOCIOPOPULAR = $dataEmpresa['contribuyenteRimpeNegocioPopular'] == 'S' ? 'SI' : 'NO';
        $VLCONTRIBUYENTEESPECIAL = $dataEmpresa['contribuyenteEspecial'] == 'S' ? 'SI' : 'NO';
        $VLIDCONTRIBUYENTEESPECIAL = $dataEmpresa['idContribuyenteEspecial'];

        $decimalesPrecio = 2;
        $codigoDocumentoElectronico = 4;

        //dd(1);        

        $numeroDocumento = $info->numeroDocumento; 
        $direccionBodega = $info->direccionBodega; 

        $VTDIRESTAB = $direccionBodega;
        $arrayNumDocument = explode('-',$numeroDocumento);
        $VTCODDOC = $numeroDocumento;                
        $VTESTAB = $arrayNumDocument[0];
        $VTPTOEMI = $arrayNumDocument[1];

        $VTSECUENCIAL = $arrayNumDocument[2];
        $ArrayFecha = explode('-',$info->fecha);
        $VTANIO = $ArrayFecha[2];
        $VTMES = $ArrayFecha[1];
        $VTFECHA = $info->fecha;
        $VTEMISION = $ArrayFecha[0].'/'.$ArrayFecha[1].'/'.$ArrayFecha[2];
        $VTMAIL =  str_replace("\n", '', $info->email1);
        $VTCODIGOCLIENTE = $info->codigoCliente;
        $VTMAIL =  str_replace("\n", '', $info->email1);
        $VTMAIL1 = str_replace("\n", '', $info->email2);
        $VTMAIL2 = str_replace("\n", '', $info->email3);

        $claveElectronica = $this->claveElectronica(
            $VTFECHA,$VTCODDOC,$codigoDocumentoElectronico,
            $VLAMBIENTE,$VLEMISION,$VLRUC
        );

        //return $claveElectronica;

        $VTDIRECCION1 = str_replace("\n", ' ',$info->direccion);
        $VTDIRECCION2 = '';
        $VTTELEFONO = $info->telefono;
        //$VTATENCION = $info->contacto;

        $VTTPIDCOMPRADOR = '0'. $info->idTipoIdentificacion;
        $VTGUIAREMISION = '';
        $VTRAZONSOCCOMPRADOR = str_replace("\n", ' ',$info->razonSocial);
        $VTIDCOMPRADOR = $info->identificacion;
        $VTTOTALSINIMPTO = $info->subtotal - $info->descuento;
        $VTTOTALDESCTO = $info->descuento;

        //dd(2);

        //$VTCODIMPUESTO = $info_tipo_impuesto->id;
        $VTCODIVA = $info_tipo_impuesto->codigoSriAts;
        $VTCODPORCIVA = $info_tipo_impuesto->codigoSriDocumentoElectronico;

        $VTCODIVA0 = $info_tipo_impuesto_0->codigoSriAts;
        $VTCODPORCIVA0 = $info_tipo_impuesto_0->codigoSriDocumentoElectronico;

        //$VTTARIFAIVA = $info->porcentajeIva;

        $VTBASEIVA = $info->baseGravableIva;
        $VTBASEIVA0 = $info->baseNoGravableIva;
        $VTIVA0 = 0;
        $VTIVA = $info->montoIva;
        $VTIMPORTE = $info->montoNeto;
        $VTMONEDA = $info->moneda;

        $VTCLAVEACCESO = $info->clave;
        $VTCLAVEACCESO = $claveElectronica['clave'];

        $VTUSUARIO = $VTIDCOMPRADOR;
        $VTNOMBREUSR = $VTRAZONSOCCOMPRADOR;
        $VTMAILUSR = $VTMAIL;
        $VTDOCUMENTO = $VTESTAB . "-" . $VTPTOEMI . "-" . $VTSECUENCIAL;
        $VTMONTO = $VTIMPORTE;

        $VTCODMODIFICADO = $info->codDocModificado;
        $VTNUMDOCMODIFICADO = $info->numDocModificado;
        $VTVALORMODIFICACION = $info->montoNeto;
        $VTMONEDA = $info->moneda;
        $VTMOTIVO = $info->motivo;
        $VTMONTO = $info->montoNeto;
        $VTFECHAEMISIONDOCSUSTENTO = \Carbon\Carbon::parse($info->fechaEmisionDocSustento)->format('d/m/Y');
                

        $VTDTCODIVA = $VTCODIVA;

        $arrayTotalImpuesto = [];

        if($VTBASEIVA > 0){
            $arrayTotalImpuesto[]=[
                'codigo'=> $VTCODIVA,
                'codigoPorcentaje'=> $VTCODPORCIVA,
                'baseImponible'=> $VTBASEIVA,
                'valor'=> $VTIVA
            ];
        }

        if($VTBASEIVA0 > 0){
            $arrayTotalImpuesto[]=[
                'codigo'=> $VTCODIVA0,
                'codigoPorcentaje'=> $VTCODPORCIVA0,
                'baseImponible'=> $VTBASEIVA0,
                'valor'=> $VTIVA0 
            ];
        }

        $detalles = [];

        foreach($info_items as $item){
            
            $item = (object) $item;
                    
            //dd($item);
            $VTSUBTOTAL = $item->subtotalProducto - $item->descuentoProducto;
            
            $VTDTCODIVA = '';
            $VTDTTARIFAIVA = '';
            $VTDTCODPORCIVA = '';
            
            if($item->montoIvaProducto > 0){
                $VTDTCODIVA = $VTCODIVA;
                $VTDTTARIFAIVA = $info_tipo_impuesto->porcentaje;
                $VTDTCODPORCIVA = $info_tipo_impuesto->codigoSriDocumentoElectronico;
            }else{
                $VTDTCODIVA = $VTCODIVA0;
                $VTDTTARIFAIVA = $info_tipo_impuesto_0->porcentaje;
                $VTDTCODPORCIVA = $info_tipo_impuesto_0->codigoSriDocumentoElectronico;
            }

            $descripcionProducto = $item->descripcionProducto.' - '.$item->notaProducto;

            $descripcionProductoLimit = Str::limit($descripcionProducto,300);

            $detalles[]=[
                //'codigoPrincipal' => $item->codigoPrincipal,
                //'codigoAuxiliar' => $item->codigoAuxiliar,
                'codigoInterno' => $item->codigoPrincipal,
                'codigoAdicional' => $item->codigoAuxiliar,
                'descripcion' => $descripcionProductoLimit,
                'cantidad' => number_format($item->cantidad, 2, '.', ''),
                'precioUnitario' => number_format($item->precioUnitario, $decimalesPrecio, '.', ''),
                'descuento' => number_format($item->descuentoProducto, 2, '.', ''),
                'precioTotalSinImpuesto' =>number_format($VTSUBTOTAL, 2, '.', ''),
                'impuestos'=>[
                    'impuesto'=>[
                        'codigo'=> $VTDTCODIVA,
                        'codigoPorcentaje'=> $VTDTCODPORCIVA,
                        'tarifa' => $VTDTTARIFAIVA,
                        'baseImponible' => number_format($VTSUBTOTAL, 2, '.', ''),
                        'valor' => number_format($item->montoIvaProducto, 2, '.', ''),
                    ]
                ]
            ];

        }


        $arrayGeneral =[
            'notaCredito'=>[
                '_attributes' => ['id'=>'comprobante', 'version'=>'1.1.0'],
                'infoTributaria' => [
                    'ambiente'=> $VLAMBIENTE,
                    'tipoEmision'=> $VLEMISION,
                    'razonSocial'=> $VLRAZONSOCIAL,
                    'nombreComercial'=> $VLNOMBRECOMERCIAL,
                    'ruc'=> $VLRUC,
                    'claveAcceso'=> $VTCLAVEACCESO,
                    'codDoc'=> '04',
                    'estab'=> $VTESTAB,
                    'ptoEmi'=> $VTPTOEMI,
                    'secuencial'=> $VTSECUENCIAL,
                    'dirMatriz'=> $VLDIRMATRIZ
                ],
                'infoNotaCredito' =>[
                    'fechaEmision'=> $VTEMISION,
                    'dirEstablecimiento'=> $VTDIRESTAB,                            
                    'tipoIdentificacionComprador'=> $VTTPIDCOMPRADOR,
                    'razonSocialComprador'=> $VTRAZONSOCCOMPRADOR,
                    'identificacionComprador'=> $VTIDCOMPRADOR,
                    'obligadoContabilidad'=> $VLCONTABILIDAD,
                    'codDocModificado'=> $VTCODMODIFICADO,
                    'numDocModificado'=> $VTNUMDOCMODIFICADO,
                    'fechaEmisionDocSustento'=> $VTFECHAEMISIONDOCSUSTENTO,
                    'totalSinImpuestos'=> $VTTOTALSINIMPTO,
                    'valorModificacion'=> $VTVALORMODIFICACION,
                    'moneda'=> $VTMONEDA,
                    'totalConImpuestos'=> [
                        'totalImpuesto' => $arrayTotalImpuesto
                    ],
                    'motivo'=> $VTMOTIVO
                ],
                'detalles'=> [
                    'detalle' => $detalles
                ]
            ]
        ];

            

            //dd($arrayGeneral);
            //dd(5);

            if($VLCONTRIBUYENTERIMPE == 'SI'){
                $arrayGeneral['notaCredito']['infoTributaria']['contribuyenteRimpe']= "CONTRIBUYENTE RÉGIMEN RIMPE";
            }

            if($VLCONTRIBUYENTERIMPENEGOCIOPOPULAR == 'SI'){
                $arrayGeneral['notaCredito']['infoTributaria']['contribuyenteRimpe']= "CONTRIBUYENTE NEGOCIO POPULAR - RÉGIMEN RIMPE";
            }

            if($VLAGENTERETENEDOR == 'SI'){
                $arrayGeneral['notaCredito']['infoTributaria']['agenteRetencion']= $VLRESOLUCIONAGENTERETENEDOR;
            } 


            if($VLCONTRIBUYENTEESPECIAL == 'SI'){
                $nuevoElemento = [
                    "contribuyenteEspecial" => $VLIDCONTRIBUYENTEESPECIAL,
                ];
                // Encontrar la posición de "obligadoContabilidad" en el arreglo
                $posicionObligadoContabilidad = array_search("obligadoContabilidad", array_keys($arrayGeneral["notaCredito"]["infoNotaCredito"]));

                if ($posicionObligadoContabilidad !== false) {
                    // Dividir el arreglo en dos partes antes y después de "obligadoContabilidad"
                    $parte1 = array_slice($arrayGeneral["notaCredito"]["infoNotaCredito"], 0, $posicionObligadoContabilidad, true);
                    $parte2 = array_slice($arrayGeneral["notaCredito"]["infoNotaCredito"], $posicionObligadoContabilidad, null, true);

                    // Combinar las partes con el nuevo elemento en el medio
                    $arrayGeneral["notaCredito"]["infoNotaCredito"] = $parte1 + $nuevoElemento + $parte2;
                }
                
            }

            //dd($arrayGeneral);
            //dd(6);

            $xml = ArrayToXml::convert($arrayGeneral['notaCredito'], 'notaCredito',false, 'UTF-8', '1.0',[],false);

            //dd(7);
            //dd($xml);

            if(count($item_adicional) > 0 || count($info_adicional) > 0){

                //$xmlstring = simplexml_load_string($xml);

                $xml3 = new SimpleXMLElement($xml);

                // crea el elemento infoAdicional
                //$factura = $xml3->addChild('factura');
                $infoAdicional = $xml3->addChild('infoAdicional');

                foreach($item_adicional as $item_adi){
                    //dd($item_adicional);
                    $item_adi = (object) $item_adi;
                    if($item_adi->campo=='codigo'){
                        $campoAdicional1 = $infoAdicional->addChild('campoAdicional', $VTCODIGOCLIENTE);
                        $campoAdicional1->addAttribute('nombre','CODIGO');
                    }
                    if($item_adi->campo=='email'){
                        $campoAdicional2 = $infoAdicional->addChild('campoAdicional', $VTMAIL);
                        $campoAdicional2->addAttribute('nombre','EMAIL');
                    }
                    if($item_adi->campo=='direccion'){
                        $campoAdicional3 = $infoAdicional->addChild('campoAdicional', $VTDIRECCION1);
                        $campoAdicional3->addAttribute('nombre','DIRECCION');
                    }
                }

                foreach($info_adicional as $key => $adicional){
                    $adicional = (object) $adicional;
                    $idkey= $key + 10;
                    $campoAdicional1000["$idkey"] = $infoAdicional->addChild('campoAdicional', $adicional->contenido);
                    $campoAdicional1000["$idkey"]->addAttribute('nombre',$adicional->campo);
                }

                $xml =  $xml3->asXML();

            }

            \Storage::disk('local')->put('public/sri/'.$VLRUC.'/'.$VTANIO.'_'.$VTMES.'/unsigned/'.$VTCLAVEACCESO.'_'.$VLRUC.'_'.$VTCODDOC.'.xml',$xml);
            \Storage::disk('local')->put('public/sri/'.$VLRUC.'/'.$VTANIO.'_'.$VTMES.'/signed/text.txt','');

            $company_id = env('FILERUC_'.$VLID);
            $VFIRMA = env('FILEP12_'.$VLID);
            $VCLAVEFIRMA = env('PASSWORDP12_'.$VLID);

            $url = storage_path('app/public/firmador/dist/QuijoteLuiFirmador-2.0.jar');

            $urlunsigned = storage_path('app/public/sri/'.$VLRUC.'/'.$VTANIO.'_'.$VTMES.'/unsigned/');

            $urlsigned = storage_path('app/public/sri/'.$VLRUC.'/'.$VTANIO.'_'.$VTMES.'/signed');

            $urlp12 = storage_path('app/public/p12/'.$company_id);

            //$namep12 = 'RICHARDOMARSOTOMAYORRONQUILLO080222110938.p12';
            $namep12 = $VFIRMA;

            //$VCLAVEFIRMA =  $dataEmpresa['claveFirma'];

            //dd($url);
            $name = $VTCLAVEACCESO.'_'.$VLRUC.'_'.$VTCODDOC.'.xml';
            $nameFile = $VTCLAVEACCESO.'_'.$VLRUC.'_'.$VTCODDOC;
            $nameTxt = $VTCLAVEACCESO.'_'.$VLRUC.'_'.$VTCODDOC.'.txt';
            $nameRide = $VTCLAVEACCESO.'_'.$VLRUC.'_'.$VTCODDOC.'.pdf';

            //$javaPath = '"C:\Program Files\Eclipse Adoptium\jdk-8.0.402.6-hotspot\bin\java"';
            $javaPath = ''.env('JAVAPATH').'';
            if(env('JAVAPATH_STATUS')==true){
                $javaPath = '"'.env('JAVAPATH').'"';
            } 
            //$comando = "C:\Program Files\Eclipse Adoptium\jdk-8.0.402.6-hotspot\bin\java -jar $url $name $urlunsigned $urlsigned $urlp12 $namep12 $VCLAVEFIRMA GEN";
            $comando = "$javaPath -jar $url $name $urlunsigned $urlsigned $urlp12 $namep12 $VCLAVEFIRMA GEN";
            $resultado = shell_exec($comando);

            // $resultado contendrá la salida del comando, si es que hay alguna
            if ($resultado) {
                //dd($resultado);
                //$this->info("Resultado del comando: $resultado");
            } else {
                //dd($resultado);
                //$this->info("El comando se ejecutó con éxito. $resultado");
            }

            $comprobanteFile = storage_path('app/public/sri/'.$VLRUC.'/'.$VTANIO.'_'.$VTMES.'/unsigned/'.$name);
            $p12File = storage_path('app/public/p12/'.$company_id.'/'.$namep12);

            //dd(9);

            $webRecepcion = '';
            if($VLAMBIENTE == 1){
                $webRecepcion = "https://celcer.sri.gob.ec/comprobantes-electronicos-ws/RecepcionComprobantesOffline?wsdl"; //Web de Pruebas
            }elseif($VLAMBIENTE == 2){
                $webRecepcion = "https://cel.sri.gob.ec/comprobantes-electronicos-ws/RecepcionComprobantesOffline?wsdl"; //Web de Produccion
            }

            $ArchivoXML = file_get_contents(storage_path('app/public/sri/'.$VLRUC.'/'.$VTANIO.'_'.$VTMES.'/signed/'.$name));
            $parametros = array("xml" => $ArchivoXML);
            $imprime = array();
            $imprimeAutoriza = array();
            $respuesta = '';
            $respuestaAutoriza = '';
            $xmlAutorizado = '';
            $fileXmlAutorizado = '';
            $fileTxtRechazado = '';
            //dd($ArchivoXML);
            //$this->info($ArchivoXML);

            //$this->info('...');

            try{

                $webServiceRecepcion = new SoapClient($webRecepcion);
                $validacion = $webServiceRecepcion->validarComprobante($parametros);
                $respuesta = isset($validacion->RespuestaRecepcionComprobante->estado) ? $validacion->RespuestaRecepcionComprobante->estado : 'NULO';
                $respuestaGeneral = $validacion->RespuestaRecepcionComprobante;

                $dataJ = (array)$validacion->RespuestaRecepcionComprobante;

                // Check if the 'autorizaciones' and 'autorizacion' fields exist
                if (isset($dataJ['autorizaciones']['autorizacion'])) {
                    // Replace the content inside the 'comprobante' field
                    $dataJ['autorizaciones']['autorizacion']['comprobante'] = "";
                }

                // Encode the modified data back to JSON
                $modifiedJsonData = json_encode($dataJ);

                $string = $modifiedJsonData;
                //$this->info(0,json_encode($validacion->RespuestaRecepcionComprobante));

                if($respuesta==='RECIBIDA')
                {
                    $imprime[0] = 1;
                    $imprime[1] = 'RECIBIDA';
                }else{
                    $imprime[0] = 1;
                    $imprime[1] = 'DEVUELTA';
                    //$imprime[2] = $validacion->RespuestaRecepcionComprobante->comprobantes->comprobante->mensajes->mensaje->mensaje;
                    $imprime[3] = isset($validacion->RespuestaRecepcionComprobante->comprobantes->comprobante->mensajes->mensaje->informacionAdicional) ? $validacion->RespuestaRecepcionComprobante->comprobantes->comprobante->mensajes->mensaje->informacionAdicional : '';
                
                    /*$this->info('***********');
                    $this->info('***********');
                    $this->info('--- DEVUELTA ---');
                    $this->info('***********');
                    $this->info('***********');*/

                    //$statusVerify = $this->verifyIntento($venta_id,$company_id,$VTCLAVEACCESO);

                    $statusMensaje = $imprime[1];

                    // Contenido del archivo de texto
                    $textoTxt = json_encode($validacion->RespuestaRecepcionComprobante);
                    

                    // Nombre del archivo
                    //$nombreArchivo = 'archivo.txt';
                    //$this->info($imprime[2]);

                    \Storage::disk('local')->put('public/sri/'.$VLRUC.'/'.$VTANIO.'_'.$VTMES.'/errors/'.$nameTxt,$textoTxt);
                    $fileTxtRechazado = $textoTxt;
                    //$statusInsert = $this->insertIntento($statusVerify,$venta_id,$company_id,$VTCLAVEACCESO,$imprime[2],$imprime[1],$string);
                }

                //$this->info(json_encode($validacion->RespuestaRecepcionComprobante));
                //$this->info('...');

                //dd($imprime,$respuestaGeneral);

                if($respuesta==='RECIBIDA'){
                    $webAutoriza = '';
                    if($VLAMBIENTE == 1){
                        $webAutoriza = 'https://celcer.sri.gob.ec/comprobantes-electronicos-ws/AutorizacionComprobantesOffline?wsdl';  //Web de prueba
                    }elseif($VLAMBIENTE == 2){
                        $webAutoriza = 'https://cel.sri.gob.ec/comprobantes-electronicos-ws/AutorizacionComprobantesOffline?wsdl'; //Web Produccion
                    }

                    $parametrosAutoriza = array("claveAccesoComprobante" => $VTCLAVEACCESO);
                    $imprimeAutoriza = array();

                    $webServiceAutorizacion = new SoapClient($webAutoriza);
                    $autoriza = $webServiceAutorizacion->autorizacionComprobante($parametrosAutoriza);
                    $respuestaAutoriza = $autoriza->RespuestaAutorizacionComprobante->autorizaciones->autorizacion->estado;
                    $imprimeAutoriza[0] = 1;

                    $respuestaGeneralAutoriza = $autoriza->RespuestaAutorizacionComprobante;

                    //$this->info(json_encode($autoriza->RespuestaAutorizacionComprobante));
                    //$this->info('...');

                    if($respuestaAutoriza === 'AUTORIZADO')
                    {
                        $imprimeAutoriza[1] = $respuesta;
                        $claveAut = $autoriza->RespuestaAutorizacionComprobante->autorizaciones->autorizacion->numeroAutorizacion;
                        $xmlAutorizado = new DOMDocument("1.0","UTF-8");
                        $xmlAutorizado->formatOutput=true;
                        $xmlAutorizado->xmlStandalone =true;
                
                        $fechaFinalAutorizacion = $autoriza->RespuestaAutorizacionComprobante->autorizaciones->autorizacion->fechaAutorizacion;

                        $etqAutoriza=$xmlAutorizado->createElement("autorizacion");
                        $xmlAutorizado->appendChild($etqAutoriza);
                        $etqEstado=$xmlAutorizado->createElement("estado",$autoriza->RespuestaAutorizacionComprobante->autorizaciones->autorizacion->estado);
                        $etqAutoriza->appendChild($etqEstado);
                        $etqNumero=$xmlAutorizado->createElement("numeroAutorizacion",$claveAut);
                        $etqAutoriza->appendChild($etqNumero);
                        $etqFecha=$xmlAutorizado->createElement("fechaAutorizacion",$autoriza->RespuestaAutorizacionComprobante->autorizaciones->autorizacion->fechaAutorizacion);
                        $etqAutoriza->appendChild($etqFecha);
                        $etqFecha=$xmlAutorizado->createElement("ambiente",$autoriza->RespuestaAutorizacionComprobante->autorizaciones->autorizacion->ambiente);
                        $etqAutoriza->appendChild($etqFecha);
                        $etqFecha=$xmlAutorizado->createElement("comprobante",$autoriza->RespuestaAutorizacionComprobante->autorizaciones->autorizacion->comprobante);
                        $etqAutoriza->appendChild($etqFecha);

                        /*$ventaCurrent = CxcVenta::find($venta_id);
                        $ventaCurrent->fechaAutorizacion =  str_replace('T',' ',substr($fechaFinalAutorizacion,0,19)); 
                        $ventaCurrent->autorizacion = $claveAut;
                        $ventaCurrent->autorizado = 'S';                           
                        $ventaCurrent->save();*/

                        //$statusVerify = $this->verifyIntento($venta_id,$company_id,$claveAut);

                        $statusMensaje = $autoriza->RespuestaAutorizacionComprobante->autorizaciones->autorizacion->estado;

                        //$statusInsert = $this->insertIntento($statusVerify,$venta_id,$company_id,$claveAut,$statusMensaje,'Autorizado');

                        \Storage::disk('local')->put('public/sri/'.$VLRUC.'/'.$VTANIO.'_'.$VTMES.'/authorized/'.$name,$xmlAutorizado->saveXML());

                        //$pdfL= $this->generatePdf($db,$venta_id,$company_id);

                        //\Storage::disk('local')->put('public/sri/'.$VLRUC.'/'.$VTANIO.'_'.$VTMES.'/ride/'.$nameRide,$pdfL);
                        
                        $xmlEmail = 'app/public/sri/'.$VLRUC.'/'.$VTANIO.'_'.$VTMES.'/authorized/'.$name;
                        $pdfEmail = 'app/public/sri/'.$VLRUC.'/'.$VTANIO.'_'.$VTMES.'/ride/'.$nameRide;   
                        $fileXmlAutorizado = file_get_contents(storage_path($xmlEmail));                     
                        $infoCompanyEmail = $dataEmpresa;

                        $infoClientEmail = [
                            'cliente'=> $VTRAZONSOCCOMPRADOR,
                            'identificacion'=> $VTIDCOMPRADOR,
                            'factura'=> $VTCODDOC,
                            'fecha'=> $VTEMISION,
                            'monto'=>  $VTMONTO,
                        ];

                        $listEmail = [];
                        $emailMain = $VTMAIL;

                        if($VTMAIL1 != '' && $VTMAIL1 != null){
                            $listEmail[] = $VTMAIL1;
                        }

                        if($VTMAIL2 != '' && $VTMAIL2 != null){
                            $listEmail[] = $VTMAIL2;
                        }   

                        if($dataEmpresa['email'] != '' && $dataEmpresa['email'] != null){
                            $listEmail[] = $dataEmpresa['email'];
                        }

                        
						$info = [
							'dataEmpresa' => $dataEmpresa,
							'show' => $info,
							'pago' => [],
							'items' => $info_items,
							'item_adicional' => $item_adicional,
							'info_adicional' => $info_adicional,
							'autorizacion'=> [
								'fechaAutorizacion' => $fechaFinalAutorizacion,
								'autorizacion' => $claveAut,
								'clave' => $VTCLAVEACCESO,
                            ],
                            "infoDocumento"=>[
                                'numDocModificado'=> $VTNUMDOCMODIFICADO,
                                'fechaEmisionDocSustento'=> $VTFECHAEMISIONDOCSUSTENTO,
                                'motivo'=> $VTMOTIVO
                            ]
						];

						$pdfL = $this->generatePdf((object)$info);
						
						$nameRide = $VTCLAVEACCESO.'_'.$VLRUC.'_'.$VTCODDOC.'.pdf';

						\Storage::disk('local')->put('public/sri/'.$VLRUC.'/'.$VTANIO.'_'.$VTMES.'/ride/'.$nameRide,$pdfL);
											
						$xmlEmail = 'app/public/sri/'.$VLRUC.'/'.$VTANIO.'_'.$VTMES.'/authorized/'.$name;
						$pdfEmail = 'app/public/sri/'.$VLRUC.'/'.$VTANIO.'_'.$VTMES.'/ride/'.$nameRide;

                        $statusEmail= $this->sendEmailInvoice($xmlEmail,$pdfEmail,(object)$infoCompanyEmail,(object)$infoClientEmail,$listEmail,$emailMain);
                        
                        //$listEmail[] = 'factura_electronica@prodquality.com';

                        //$statusEmail= $this->sendEmailInvoice($xmlEmail,$pdfEmail,$infoCompanyEmail,(object)$infoClientEmail,$listEmail,$emailMain);
                        //$xml->save("../comprobantes/autorizados/fac_".$claveAut.".xml");
                    }else{
                        $imprimeAutoriza[1] = 'RECHAZADO';
                        //$imprimeAutoriza[2] = $autoriza->RespuestaAutorizacionComprobante->autorizaciones->autorizacion->mensajes->mensaje->mensaje;
                        $claveAut = $autoriza->RespuestaAutorizacionComprobante->claveAccesoConsultada;
                        $xmlAutorizado = new DOMDocument("1.0","UTF-8");
                        $xmlAutorizado->formatOutput=true;
                        $xmlAutorizado->xmlStandalone =true;
                
                        $etqAutoriza=$xmlAutorizado->createElement("autorizacion");
                        $xmlAutorizado->appendChild($etqAutoriza);
                        $etqEstado=$xmlAutorizado->createElement("estado",$autoriza->RespuestaAutorizacionComprobante->autorizaciones->autorizacion->estado);
                        $etqAutoriza->appendChild($etqEstado);
                        $etqNumero=$xmlAutorizado->createElement("numeroAutorizacion",$claveAut);
                        $etqAutoriza->appendChild($etqNumero);
                        $etqFecha=$xmlAutorizado->createElement("fechaAutorizacion",$autoriza->RespuestaAutorizacionComprobante->autorizaciones->autorizacion->fechaAutorizacion);
                        $etqAutoriza->appendChild($etqFecha);
                        $etqFecha=$xmlAutorizado->createElement("ambiente",$autoriza->RespuestaAutorizacionComprobante->autorizaciones->autorizacion->ambiente);
                        $etqAutoriza->appendChild($etqFecha);
                        $etqFecha=$xmlAutorizado->createElement("comprobante",$autoriza->RespuestaAutorizacionComprobante->autorizaciones->autorizacion->comprobante);
                        $etqAutoriza->appendChild($etqFecha);     
                        
                        //$statusVerify = $this->verifyIntento($venta_id,$company_id,$claveAut);

                        /*$this->info('***********');
                        $this->info('***********');
                        $this->info('--- RECHAZADO ---');
                        $this->info('***********');
                        $this->info('***********');*/

                        $textoTxt = json_encode($autoriza->RespuestaAutorizacionComprobante);

                        // Nombre del archivo
                        //$nombreArchivo = 'archivo.txt';

                        \Storage::disk('local')->put('public/sri/'.$VLRUC.'/'.$VTANIO.'_'.$VTMES.'/errors/'.$nameTxt,$textoTxt);
                        $fileTxtRechazado = $textoTxt;

                        $statusMensaje = $autoriza->RespuestaAutorizacionComprobante->autorizaciones->autorizacion->estado;
                        
                        //$dataJ = (array)$autoriza->RespuestaAutorizacionComprobante;

                        //$this->info('paso1');

                        $dataJ = $autoriza->RespuestaAutorizacionComprobante;

                        $modifiedJsonData = json_encode($dataJ);

                        //$this->info('paso2');

                        $string = $modifiedJsonData;
                        
                        //$statusInsert = $this->insertIntento($statusVerify,$venta_id,$company_id,$claveAut,$statusMensaje,'Rechazado',$string);

                        \Storage::disk('local')->put('public/sri/'.$VLRUC.'/'.$VTANIO.'_'.$VTMES.'/rejected/'.$name,$xmlAutorizado->saveXML());


                    }

                    

                }   

                $dataReponse = [
                    "claveAcceso"=> $VTCLAVEACCESO,
                    "nombreFile"=> $nameFile,
                    "respuesta"=> $respuesta,
                    "estado"=> $respuestaAutoriza,
                    "unsigned"=> $name,
                    "signed"=> $name,
                    "autorized" => $fileXmlAutorizado,
                    "errors"=> $fileTxtRechazado,
                    "connection" => 'correcta',
                    "errors_connection" => ''
                ];
                
                return $this->sendResponse($dataReponse,'Estado de Proceso');
                
                
            }catch(SoapFault $e){
                //$imprime[0] = 0;
                //echo json_encode($e);

                $dataReponse = [
                    "claveAcceso"=> $VTCLAVEACCESO,
                    "nombreFile"=> $nameFile,
                    "respuesta"=> $respuesta,
                    "estado"=> $respuestaAutoriza,
                    "unsigned"=> $name,
                    "signed"=> $name,
                    "autorized" => $fileXmlAutorizado,
                    "errors"=> $fileTxtRechazado,
                    "connection" => 'errors',
                    "errors_connection" => $e
                ];
                
                return $this->sendResponse($dataReponse,'Error al procesar');
            }
            
    }

    public function generatePdf($info){
        

        $show = (object) $info->show;       

        $getCurrentCompany = (object) $info->dataEmpresa; 
        
        $getAutorizacion = (object) $info->autorizacion;

        $getItems  = (object) $info->items; 

        $getAdicional  = (object) $info->info_adicional; 
        
        $getItemAdicional  = (object) $info->item_adicional; 

        $getFormaPago  = (object) $info->pago;        
        
        $getDocumento = (object) $info->infoDocumento;
        
        //dd($getItems);

        $view = \View::make('notaCreditoRide.nota_credito_electronica',compact(
            'show','getCurrentCompany','getAutorizacion','getAdicional'
            ,'getItemAdicional','getItems','getDocumento'
        ));
        $html = $view->render();

        $pdf = new TCPDF('P', 'mm', 'A4', true, 'UTF-8', false);
        $pdf->SetAuthor('alejandrogarcia15ec@gmail.com');
        $pdf->SetTitle('Nota_Credito_Electronica');
        $pdf->AddPage();
        //$pdf->SetFont('times', '', 12);
        $pdf->writeHTML($html, true, false, true, false, '');
        //$pdf->Write(0, 'Hello World');
        return $pdf->Output('nota_credito.pdf', 'S');
    }

    public function sendEmailInvoice($xml,$pdf,$infoCompany,$infoClient,$listEmail,$emailMain){        

        
        $invoiceMail = [];

        try {
            $invoiceMail = [
                'xml' => storage_path($xml),
                'pdf' => storage_path($pdf),
                'getCurrentCompany' => [
                    'rutaLogo' => $infoCompany->rutaLogo,
                    'nombreComercial' => $infoCompany->nombreComercial,
                    'ruc' => $infoCompany->ruc,
                    'logoGeneral' => $infoCompany->logoGeneral,
                ],
                'info' => [
                    'cliente' => $infoClient->cliente,
                    'identificacion' => $infoClient->identificacion,
                    'factura' => $infoClient->factura,
                    'fecha' => $infoClient->fecha,
                    'monto' => $infoClient->monto,
                ],
                'moreUsers' => $listEmail,
                'tipo' => 4
            ];

            //dd()
        
            // Intentar enviar el correo
            \Mail::to($emailMain)->send(new \App\Mail\InvoiceSri($invoiceMail));
        
            return true;
        
        } catch (\Swift_RfcComplianceException $e) {
            //dd($e);
            return true;
        } catch (\Exception $e) {
            //dd($e);
            // Manejo de cualquier otra excepción general            
            return true;
        }
    }

    public function generateNewRide(Request $request){

        $validator = Validator::make($request->all(),[
            /***** dataEmpresa *****/
            'dataEmpresa.id'                            => 'required|integer',
            'dataEmpresa.ambiente'                      => 'required|integer',
            'dataEmpresa.emision'                       => 'required|integer',
            'dataEmpresa.razonSocial'                   => 'required|string',
            'dataEmpresa.nombreComercial'               => 'required|string',
            'dataEmpresa.ruc'                           => 'required',
            'dataEmpresa.direccion'                     => 'required|string',
            'dataEmpresa.obligadoContabilidad'          => 'required',
            'dataEmpresa.agenteRetenedor'               => 'required',
            'dataEmpresa.resolucionAgenteRetenedor'     => 'nullable|string',
            'dataEmpresa.contribuyenteRimpe'            => 'required',
            'dataEmpresa.contribuyenteRimpeNegocioPopular' => 'required',
            'dataEmpresa.contribuyenteEspecial'         => 'required',
            'dataEmpresa.idContribuyenteEspecial'       => 'nullable',
            'dataEmpresa.email'                         => 'required|email',
            'dataEmpresa.rutaLogo'                      => 'required',
            'dataEmpresa.logoGeneral'                   => 'required',
            /***** dataInfo *****/
            'dataInfo.numeroDocumento'                 => 'required|string',
            'dataInfo.direccionBodega'                 => 'required|string',
            'dataInfo.fecha'                           => 'required|date_format:d-m-Y',
            'dataInfo.email1'                          => 'required|email',
            'dataInfo.email2'                          => 'nullable|email',
            'dataInfo.email3'                          => 'nullable|email',
            'dataInfo.codigoCliente'                   => 'required|string',
            'dataInfo.direccion'                       => 'nullable|string',
            'dataInfo.telefono'                        => 'nullable|string',
            'dataInfo.idTipoIdentificacion'            => 'required|string',
            'dataInfo.razonSocial'                     => 'required|string',
            'dataInfo.identificacion'                  => 'required|string',
            'dataInfo.direccion'                       => 'required|string',
            'dataInfo.subtotal'                        => 'required|numeric',
            'dataInfo.descuento'                       => 'required|numeric',
            'dataInfo.baseGravableIva'                 => 'required|numeric',
            'dataInfo.baseNoGravableIva'               => 'required|numeric',
            'dataInfo.montoIva'                        => 'required|numeric',
            'dataInfo.montoNeto'                       => 'required|numeric',
            'dataInfo.moneda'                          => 'required|string',
            'dataInfo.clave'                           => 'required|string',
            'dataInfo.autorizacion'                    => 'required|string',
            'dataInfo.fechaAutorizacion'               => 'required|string',
            'dataInfo.codDocModificado'                => 'required|string',
            'dataInfo.numDocModificado'                => 'required|string',
            'dataInfo.motivo'                          => 'required|string',
            'dataInfo.fechaEmisionDocSustento'                  => 'required|date_format:d-m-Y',
            /***** dataTipoImpuesto *****/
            'dataTipoImpuesto.codigoSriAts'                         => 'required|string',
            'dataTipoImpuesto.codigoSriDocumentoElectronico'        => 'required|string',
            'dataTipoImpuesto.porcentaje'                           => 'required|numeric',
            'dataTipoImpuesto_0.codigoSriAts'                       => 'required|string',
            'dataTipoImpuesto_0.codigoSriDocumentoElectronico'      => 'required|string',
            'dataTipoImpuesto_0.porcentaje'                         => 'required|numeric',
            /***** dataPago *****/
            //'dataPago'                                              => 'required|array|min:1',
            //'dataPago.*.codigoSriDocumentoElectronico'              => 'required|string',
            //'dataPago.*.monto'                                      => 'required|numeric',
            //'dataPago.*.cantidadDias'                               => 'required|numeric',
            /***** dataTipoImpuesto *****/
            'dataItem'                                              => 'required|array|min:1',
            'dataItem.*.codigoPrincipal'                            => 'required|string',
            'dataItem.*.codigoAuxiliar'                             => 'required|string',
            'dataItem.*.descripcionProducto'                        => 'required|string',
            'dataItem.*.notaProducto'                               => 'nullable|string',
            'dataItem.*.cantidad'                                   => 'required|numeric',
            'dataItem.*.precioUnitario'                             => 'required|numeric',
            'dataItem.*.subtotalProducto'                           => 'required|numeric',
            'dataItem.*.descuentoProducto'                          => 'required|numeric',
            'dataItem.*.montoIvaProducto'                           => 'required|numeric',
            /***** dataItemAdicional *****/
            'dataItemAdicional'                                     => 'nullable|array',
            'dataItemAdicional.*.campo'                             => 'required|string',
            /***** dataInfoAdicional *****/
            'dataInfoAdicional'                                     => 'nullable|array',
            'dataInfoAdicional.*.campo'                             => 'required|string',
            'dataInfoAdicional.*.contenido'                         => 'required|string',
        ]);

        if($validator->fails()){
            return $this->sendError('Validation Error.', $validator->errors(),422);
        }

        ini_set('max_execution_time', 9000);

        //$VFIRMA = $dataEmpresa['firma'];
        //$VCLAVEFIRMA =  $dataEmpresa['claveFirma'];

        $dataEmpresa = $request->dataEmpresa;
        $info = (object) $request->dataInfo;
        $info_tipo_impuesto = (object) $request->dataTipoImpuesto;
        $info_tipo_impuesto_0 = (object) $request->dataTipoImpuesto_0;
        $info_items = $request->dataItem;
        $item_adicional = $request->dataItemAdicional;
        $info_adicional = $request->dataInfoAdicional;

        

        //$VGEMPRESA = $dataEmpresa['nombre'];
        $VLID = $dataEmpresa['id'];
        $VLAMBIENTE = $dataEmpresa['ambiente'];
        $VLEMISION = $dataEmpresa['emision'];
        $VLRAZONSOCIAL =  str_replace("\n", ' ', $dataEmpresa['razonSocial']);
        $VLNOMBRECOMERCIAL = $dataEmpresa['nombreComercial'];
        $VLRUC = $dataEmpresa['ruc'];
        $VLDIRMATRIZ = str_replace("\n", ' ',$dataEmpresa['direccion']);
        $VLCONTABILIDAD = $dataEmpresa['obligadoContabilidad'] == 'S' ? 'SI' : 'NO'; 
        $VLAGENTERETENEDOR = $dataEmpresa['agenteRetenedor'] == 'S' ? 'SI' : 'NO';
        $VLRESOLUCIONAGENTERETENEDOR = $dataEmpresa['resolucionAgenteRetenedor']; 
        $VLCONTRIBUYENTERIMPE = $dataEmpresa['contribuyenteRimpe'] == 'S' ? 'SI' : 'NO';
        $VLCONTRIBUYENTERIMPENEGOCIOPOPULAR = $dataEmpresa['contribuyenteRimpeNegocioPopular'] == 'S' ? 'SI' : 'NO';
        $VLCONTRIBUYENTEESPECIAL = $dataEmpresa['contribuyenteEspecial'] == 'S' ? 'SI' : 'NO';
        $VLIDCONTRIBUYENTEESPECIAL = $dataEmpresa['idContribuyenteEspecial'];

        $decimalesPrecio = 2;
        $codigoDocumentoElectronico = 4;

        //dd(1);        

        $numeroDocumento = $info->numeroDocumento; 
        $direccionBodega = $info->direccionBodega; 

        $VTDIRESTAB = $direccionBodega;
        $arrayNumDocument = explode('-',$numeroDocumento);
        $VTCODDOC = $numeroDocumento;                
        $VTESTAB = $arrayNumDocument[0];
        $VTPTOEMI = $arrayNumDocument[1];

        $VTSECUENCIAL = $arrayNumDocument[2];
        $ArrayFecha = explode('-',$info->fecha);
        $VTANIO = $ArrayFecha[2];
        $VTMES = $ArrayFecha[1];
        $VTFECHA = $info->fecha;
        $VTEMISION = $ArrayFecha[0].'/'.$ArrayFecha[1].'/'.$ArrayFecha[2];
        $VTMAIL =  str_replace("\n", '', $info->email1);
        $VTCODIGOCLIENTE = $info->codigoCliente;
        $VTMAIL =  str_replace("\n", '', $info->email1);
        $VTMAIL1 = str_replace("\n", '', $info->email2);
        $VTMAIL2 = str_replace("\n", '', $info->email3);

        //return $claveElectronica;

        $VTDIRECCION1 = str_replace("\n", ' ',$info->direccion);
        $VTDIRECCION2 = '';
        $VTTELEFONO = $info->telefono;
        //$VTATENCION = $info->contacto;

        $VTTPIDCOMPRADOR = '0'. $info->idTipoIdentificacion;
        $VTGUIAREMISION = '';
        $VTRAZONSOCCOMPRADOR = str_replace("\n", ' ',$info->razonSocial);
        $VTIDCOMPRADOR = $info->identificacion;
        $VTTOTALSINIMPTO = $info->subtotal - $info->descuento;
        $VTTOTALDESCTO = $info->descuento;

        //dd(2);

        //$VTCODIMPUESTO = $info_tipo_impuesto->id;
        $VTCODIVA = $info_tipo_impuesto->codigoSriAts;
        $VTCODPORCIVA = $info_tipo_impuesto->codigoSriDocumentoElectronico;

        $VTCODIVA0 = $info_tipo_impuesto_0->codigoSriAts;
        $VTCODPORCIVA0 = $info_tipo_impuesto_0->codigoSriDocumentoElectronico;

        //$VTTARIFAIVA = $info->porcentajeIva;

        $VTBASEIVA = $info->baseGravableIva;
        $VTBASEIVA0 = $info->baseNoGravableIva;
        $VTIVA0 = 0;
        $VTIVA = $info->montoIva;
        $VTIMPORTE = $info->montoNeto;
        $VTMONEDA = $info->moneda;

        $VTCLAVEACCESO = $info->clave;
        //$VTCLAVEACCESO = $claveElectronica['clave'];
        $VTAUTORIZACION = $info->autorizacion;
        $VTFECHAAUTORIZACION = $info->fechaAutorizacion;

        $VTUSUARIO = $VTIDCOMPRADOR;
        $VTNOMBREUSR = $VTRAZONSOCCOMPRADOR;
        $VTMAILUSR = $VTMAIL;
        $VTDOCUMENTO = $VTESTAB . "-" . $VTPTOEMI . "-" . $VTSECUENCIAL;
        $VTMONTO = $VTIMPORTE;

        $VTCODMODIFICADO = $info->codDocModificado;
        $VTNUMDOCMODIFICADO = $info->numDocModificado;
        $VTVALORMODIFICACION = $info->montoNeto;
        $VTMONEDA = $info->moneda;
        $VTMOTIVO = $info->motivo;
        $VTMONTO = $info->montoNeto;
        $VTFECHAEMISIONDOCSUSTENTO = \Carbon\Carbon::parse($info->fechaEmisionDocSustento)->format('d/m/Y');
                
        $claveElectronica = $this->claveElectronica(
            $VTFECHA,$VTCODDOC,$codigoDocumentoElectronico,
            $VLAMBIENTE,$VLEMISION,$VLRUC
        );

        $VTDTCODIVA = $VTCODIVA;

        $arrayTotalImpuesto = [];

        if($VTCLAVEACCESO != $claveElectronica['clave']){

            $dataReponse = [
                "claveAcceso"=> $VTCLAVEACCESO,
                "nombreFile"=> '',
                "respuesta"=> 'NO_PROCESADO',
                "estado"=> 'NO_COICIDE_LO_DATOS',
                "unsigned"=> '',
                "signed"=> '',
                "autorized" => '',
                "errors"=> 'Los datos no coiciden',
                "connection" => 'correcta',
                "errors_connection" => ''
            ];
                    
            return $this->sendResponse($dataReponse,'Estado de Proceso');

         }

        if($VTBASEIVA > 0){
            $arrayTotalImpuesto[]=[
                'codigo'=> $VTCODIVA,
                'codigoPorcentaje'=> $VTCODPORCIVA,
                'baseImponible'=> $VTBASEIVA,
                'valor'=> $VTIVA
            ];
        }

        if($VTBASEIVA0 > 0){
            $arrayTotalImpuesto[]=[
                'codigo'=> $VTCODIVA0,
                'codigoPorcentaje'=> $VTCODPORCIVA0,
                'baseImponible'=> $VTBASEIVA0,
                'valor'=> $VTIVA0 
            ];
        }

        $detalles = [];

        foreach($info_items as $item){
            
            $item = (object) $item;
                    
            //dd($item);
            $VTSUBTOTAL = $item->subtotalProducto - $item->descuentoProducto;
            
            $VTDTCODIVA = '';
            $VTDTTARIFAIVA = '';
            $VTDTCODPORCIVA = '';
            
            if($item->montoIvaProducto > 0){
                $VTDTCODIVA = $VTCODIVA;
                $VTDTTARIFAIVA = $info_tipo_impuesto->porcentaje;
                $VTDTCODPORCIVA = $info_tipo_impuesto->codigoSriDocumentoElectronico;
            }else{
                $VTDTCODIVA = $VTCODIVA0;
                $VTDTTARIFAIVA = $info_tipo_impuesto_0->porcentaje;
                $VTDTCODPORCIVA = $info_tipo_impuesto_0->codigoSriDocumentoElectronico;
            }

            $descripcionProducto = $item->descripcionProducto.' - '.$item->notaProducto;

            $descripcionProductoLimit = Str::limit($descripcionProducto,300);

            $detalles[]=[
                //'codigoPrincipal' => $item->codigoPrincipal,
                //'codigoAuxiliar' => $item->codigoAuxiliar,
                'codigoInterno' => $item->codigoPrincipal,
                'codigoAdicional' => $item->codigoAuxiliar,
                'descripcion' => $descripcionProductoLimit,
                'cantidad' => number_format($item->cantidad, 2, '.', ''),
                'precioUnitario' => number_format($item->precioUnitario, $decimalesPrecio, '.', ''),
                'descuento' => number_format($item->descuentoProducto, 2, '.', ''),
                'precioTotalSinImpuesto' =>number_format($VTSUBTOTAL, 2, '.', ''),
                'impuestos'=>[
                    'impuesto'=>[
                        'codigo'=> $VTDTCODIVA,
                        'codigoPorcentaje'=> $VTDTCODPORCIVA,
                        'tarifa' => $VTDTTARIFAIVA,
                        'baseImponible' => number_format($VTSUBTOTAL, 2, '.', ''),
                        'valor' => number_format($item->montoIvaProducto, 2, '.', ''),
                    ]
                ]
            ];

        }


        $arrayGeneral =[
            'notaCredito'=>[
                '_attributes' => ['id'=>'comprobante', 'version'=>'1.1.0'],
                'infoTributaria' => [
                    'ambiente'=> $VLAMBIENTE,
                    'tipoEmision'=> $VLEMISION,
                    'razonSocial'=> $VLRAZONSOCIAL,
                    'nombreComercial'=> $VLNOMBRECOMERCIAL,
                    'ruc'=> $VLRUC,
                    'claveAcceso'=> $VTCLAVEACCESO,
                    'codDoc'=> '04',
                    'estab'=> $VTESTAB,
                    'ptoEmi'=> $VTPTOEMI,
                    'secuencial'=> $VTSECUENCIAL,
                    'dirMatriz'=> $VLDIRMATRIZ
                ],
                'infoNotaCredito' =>[
                    'fechaEmision'=> $VTEMISION,
                    'dirEstablecimiento'=> $VTDIRESTAB,                            
                    'tipoIdentificacionComprador'=> $VTTPIDCOMPRADOR,
                    'razonSocialComprador'=> $VTRAZONSOCCOMPRADOR,
                    'identificacionComprador'=> $VTIDCOMPRADOR,
                    'obligadoContabilidad'=> $VLCONTABILIDAD,
                    'codDocModificado'=> $VTCODMODIFICADO,
                    'numDocModificado'=> $VTNUMDOCMODIFICADO,
                    'fechaEmisionDocSustento'=> $VTFECHAEMISIONDOCSUSTENTO,
                    'totalSinImpuestos'=> $VTTOTALSINIMPTO,
                    'valorModificacion'=> $VTVALORMODIFICACION,
                    'moneda'=> $VTMONEDA,
                    'totalConImpuestos'=> [
                        'totalImpuesto' => $arrayTotalImpuesto
                    ],
                    'motivo'=> $VTMOTIVO
                ],
                'detalles'=> [
                    'detalle' => $detalles
                ]
            ]
        ];

            

            //dd($arrayGeneral);
            //dd(5);

            if($VLCONTRIBUYENTERIMPE == 'SI'){
                $arrayGeneral['notaCredito']['infoTributaria']['contribuyenteRimpe']= "CONTRIBUYENTE RÉGIMEN RIMPE";
            }

            if($VLCONTRIBUYENTERIMPENEGOCIOPOPULAR == 'SI'){
                $arrayGeneral['notaCredito']['infoTributaria']['contribuyenteRimpe']= "CONTRIBUYENTE NEGOCIO POPULAR - RÉGIMEN RIMPE";
            }

            if($VLAGENTERETENEDOR == 'SI'){
                $arrayGeneral['notaCredito']['infoTributaria']['agenteRetencion']= $VLRESOLUCIONAGENTERETENEDOR;
            } 


            if($VLCONTRIBUYENTEESPECIAL == 'SI'){
                $nuevoElemento = [
                    "contribuyenteEspecial" => $VLIDCONTRIBUYENTEESPECIAL,
                ];
                // Encontrar la posición de "obligadoContabilidad" en el arreglo
                $posicionObligadoContabilidad = array_search("obligadoContabilidad", array_keys($arrayGeneral["notaCredito"]["infoNotaCredito"]));

                if ($posicionObligadoContabilidad !== false) {
                    // Dividir el arreglo en dos partes antes y después de "obligadoContabilidad"
                    $parte1 = array_slice($arrayGeneral["notaCredito"]["infoNotaCredito"], 0, $posicionObligadoContabilidad, true);
                    $parte2 = array_slice($arrayGeneral["notaCredito"]["infoNotaCredito"], $posicionObligadoContabilidad, null, true);

                    // Combinar las partes con el nuevo elemento en el medio
                    $arrayGeneral["notaCredito"]["infoNotaCredito"] = $parte1 + $nuevoElemento + $parte2;
                }
                
            }

            $company_id = env('FILERUC_'.$VLID);
            $VFIRMA = env('FILEP12_'.$VLID);
            $VCLAVEFIRMA = env('PASSWORDP12_'.$VLID);

            $urlunsigned = storage_path('app/public/sri/'.$VLRUC.'/'.$VTANIO.'_'.$VTMES.'/unsigned/');

            $urlsigned = storage_path('app/public/sri/'.$VLRUC.'/'.$VTANIO.'_'.$VTMES.'/signed');

            $name = $VTCLAVEACCESO.'_'.$VLRUC.'_'.$VTCODDOC.'.xml';
            $nameFile = $VTCLAVEACCESO.'_'.$VLRUC.'_'.$VTCODDOC;
            $nameTxt = $VTCLAVEACCESO.'_'.$VLRUC.'_'.$VTCODDOC.'.txt';
            $nameRide = $VTCLAVEACCESO.'_'.$VLRUC.'_'.$VTCODDOC.'.pdf';

            $ArchivoXML = file_get_contents(storage_path('app/public/sri/'.$VLRUC.'/'.$VTANIO.'_'.$VTMES.'/signed/'.$name));
            
            $xmlEmail = 'app/public/sri/'.$VLRUC.'/'.$VTANIO.'_'.$VTMES.'/authorized/'.$name;
            $pdfEmail = 'app/public/sri/'.$VLRUC.'/'.$VTANIO.'_'.$VTMES.'/ride/'.$nameRide;   
            $fileXmlAutorizado = file_get_contents(storage_path($xmlEmail));                     
            $infoCompanyEmail = $dataEmpresa;

            $infoClientEmail = [
                'cliente'=> $VTRAZONSOCCOMPRADOR,
                'identificacion'=> $VTIDCOMPRADOR,
                'factura'=> $VTCODDOC,
                'fecha'=> $VTEMISION,
                'monto'=>  $VTMONTO,
            ];

            $listEmail = [];
            $emailMain = $VTMAIL;

            if($VTMAIL1 != '' && $VTMAIL1 != null){
                $listEmail[] = $VTMAIL1;
            }

            if($VTMAIL2 != '' && $VTMAIL2 != null){
                $listEmail[] = $VTMAIL2;
            }   

            if($dataEmpresa['email'] != '' && $dataEmpresa['email'] != null){
                $listEmail[] = $dataEmpresa['email'];
            }

                        
            $info = [
                'dataEmpresa' => $dataEmpresa,
                'show' => $info,
                'pago' => [],
                'items' => $info_items,
                'item_adicional' => $item_adicional,
                'info_adicional' => $info_adicional,
                'autorizacion'=> [
                    'fechaAutorizacion' => $VTFECHAAUTORIZACION,
                    'autorizacion' => $VTAUTORIZACION,
                    'clave' => $VTCLAVEACCESO,
                ],
                "infoDocumento"=>[
                    'numDocModificado'=> $VTNUMDOCMODIFICADO,
                    'fechaEmisionDocSustento'=> $VTFECHAEMISIONDOCSUSTENTO,
                    'motivo'=> $VTMOTIVO
                ]
            ];

            $pdfL = $this->generatePdf((object)$info);
            
            $nameRide = $VTCLAVEACCESO.'_'.$VLRUC.'_'.$VTCODDOC.'.pdf';

            \Storage::disk('local')->put('public/sri/'.$VLRUC.'/'.$VTANIO.'_'.$VTMES.'/ride/'.$nameRide,$pdfL);
											
			$xmlEmail = 'app/public/sri/'.$VLRUC.'/'.$VTANIO.'_'.$VTMES.'/authorized/'.$name;
			$pdfEmail = 'app/public/sri/'.$VLRUC.'/'.$VTANIO.'_'.$VTMES.'/ride/'.$nameRide;

            $statusEmail= $this->sendEmailInvoice($xmlEmail,$pdfEmail,(object)$infoCompanyEmail,(object)$infoClientEmail,$listEmail,$emailMain);
                        
            $dataReponse = [
                "claveAcceso"=> $VTCLAVEACCESO,
                "nombreFile"=> $nameFile,
                "respuesta"=> 'ENVIADO',
                "estado"=> 'ENVIADO',
                "unsigned"=> $name,
                "signed"=> $name,
                "autorized" => $fileXmlAutorizado,
                "errors"=> '',
                "connection" => 'correcta',
                "errors_connection" => ''
            ];
                    
            return $this->sendResponse($dataReponse,'Estado de Proceso');            

    }

}