<?php

namespace App\Http\Controllers\API;

use Illuminate\Http\Request;
use App\Http\Controllers\API\BaseController as BaseController;
use Validator;
use DOMDocument;
use SimpleXMLElement;
use DOMXPath;
use SoapClient;
use SoapFault;
use GuzzleHttp\Client;
use TCPDF;
use Illuminate\Support\Facades\Http;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7;
use Spatie\ArrayToXml\ArrayToXml;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;

class VerifyDocumentController extends BaseController
{

    public function verify(Request $request){ 

        $validator = Validator::make($request->all(),[
            'claveAcceso'       => 'required|string',
            'ruc'               => 'required|string',
            'documento'         => 'required|string',
            'ambiente'          => 'required|integer',
            'fecha'             => 'required|date_format:d-m-Y',
        ]);

        if($validator->fails()){
            return $this->sendError('Validation Error.', $validator->errors(),422);
        }

        ini_set('max_execution_time', 9000);

        $VTCLAVEACCESO = $request->claveAcceso;

        $VLRUC = $request->ruc;

        $VTCODDOC = $request->documento;

        $VLAMBIENTE = $request->ambiente;

        $ArrayFecha = explode('-',$request->fecha);
        $VTANIO = $ArrayFecha[2];
        $VTMES = $ArrayFecha[1];
        $VTFECHA = $request->fecha;


        $name = $VTCLAVEACCESO.'_'.$VLRUC.'_'.$VTCODDOC.'.xml';
        $nameTxt = $VTCLAVEACCESO.'_'.$VLRUC.'_'.$VTCODDOC.'.txt';
        $nameRide = $VTCLAVEACCESO.'_'.$VLRUC.'_'.$VTCODDOC.'.pdf';
        $nameFile = $VTCLAVEACCESO.'_'.$VLRUC.'_'.$VTCODDOC;
        $respuesta = '';
        $respuestaAutoriza = '';
        
        $webAutoriza = '';
        if($VLAMBIENTE == 1){
            $webAutoriza = 'https://celcer.sri.gob.ec/comprobantes-electronicos-ws/AutorizacionComprobantesOffline?wsdl';  //Web de prueba
        }elseif($VLAMBIENTE == 2){
            $webAutoriza = 'https://cel.sri.gob.ec/comprobantes-electronicos-ws/AutorizacionComprobantesOffline?wsdl'; //Web Produccion
        }

        $parametrosAutoriza = array("claveAccesoComprobante" => $VTCLAVEACCESO);
        $imprimeAutoriza = array();

        try{

        $webServiceAutorizacion = new SoapClient($webAutoriza);
        $autoriza = $webServiceAutorizacion->autorizacionComprobante($parametrosAutoriza);
        $statusAutorizado = json_encode($autoriza->RespuestaAutorizacionComprobante);
        //dd($autoriza->RespuestaAutorizacionComprobante->numeroComprobantes);
        if(isset($autoriza->RespuestaAutorizacionComprobante)){
            if(isset($autoriza->RespuestaAutorizacionComprobante->numeroComprobantes)){
                $respuesta = 'NO_ENCONTRADA';
                if($autoriza->RespuestaAutorizacionComprobante->numeroComprobantes == 0){
                    $dataReponse = [
                        "claveAcceso"=> $VTCLAVEACCESO,
                        "nombreFile"=> $nameFile,
                        "respuesta"=> $respuesta,
                        "estado"=> 'DOCUMENTO_NO_ENCONTRADO',
                        "unsigned"=> '',
                        "signed"=> '',
                        "autorized" => '',
                        "errors"=> $statusAutorizado,
                        "connection" => 'correcta',
                        "errors_connection" => ''
                    ];
                    
                    return $this->sendResponse($dataReponse,'Estado de Proceso');
                }
            }else{
                if($autoriza->RespuestaAutorizacionComprobante->claveAccesoConsultada == ''){
                    $respuesta = 'NO_ENCONTRADA';
                    $dataReponse = [
                        "claveAcceso"=> $VTCLAVEACCESO,
                        "nombreFile"=> $nameFile,
                        "respuesta"=> $respuesta,
                        "estado"=> 'DOCUMENTO_NO_ENCONTRADO',
                        "unsigned"=> '',
                        "signed"=> '',
                        "autorized" => '',
                        "errors"=> $statusAutorizado,
                        "connection" => 'correcta',
                        "errors_connection" => ''
                    ];
                    
                    return $this->sendResponse($dataReponse,'Estado de Proceso');
                    
                }                        
            }
            
        }

        $respuestaAutoriza = $autoriza->RespuestaAutorizacionComprobante->autorizaciones->autorizacion->estado;
        $imprimeAutoriza[0] = 1;

        $respuestaGeneralAutoriza = $autoriza->RespuestaAutorizacionComprobante;

        //$this->info(json_encode($autoriza->RespuestaAutorizacionComprobante));
        //$this->info('...');

        if($respuestaAutoriza === 'AUTORIZADO')
        {
            $respuesta = "RECIBIDA";
            $imprimeAutoriza[1] = $respuestaAutoriza;
            $claveAut = $autoriza->RespuestaAutorizacionComprobante->autorizaciones->autorizacion->numeroAutorizacion;
            $xmlAutorizado = new DOMDocument("1.0","UTF-8");
            $xmlAutorizado->formatOutput=true;
            $xmlAutorizado->xmlStandalone =true;
    
            $fechaFinalAutorizacion = $autoriza->RespuestaAutorizacionComprobante->autorizaciones->autorizacion->fechaAutorizacion;

            $etqAutoriza=$xmlAutorizado->createElement("autorizacion");
            $xmlAutorizado->appendChild($etqAutoriza);
            $etqEstado=$xmlAutorizado->createElement("estado",$autoriza->RespuestaAutorizacionComprobante->autorizaciones->autorizacion->estado);
            $etqAutoriza->appendChild($etqEstado);
            $etqNumero=$xmlAutorizado->createElement("numeroAutorizacion",$claveAut);
            $etqAutoriza->appendChild($etqNumero);
            $etqFecha=$xmlAutorizado->createElement("fechaAutorizacion",$autoriza->RespuestaAutorizacionComprobante->autorizaciones->autorizacion->fechaAutorizacion);
            $etqAutoriza->appendChild($etqFecha);
            $etqFecha=$xmlAutorizado->createElement("ambiente",$autoriza->RespuestaAutorizacionComprobante->autorizaciones->autorizacion->ambiente);
            $etqAutoriza->appendChild($etqFecha);
            $etqFecha=$xmlAutorizado->createElement("comprobante",$autoriza->RespuestaAutorizacionComprobante->autorizaciones->autorizacion->comprobante);
            $etqAutoriza->appendChild($etqFecha);            

            $statusMensaje = $autoriza->RespuestaAutorizacionComprobante->autorizaciones->autorizacion->estado;


            \Storage::disk('local')->put('public/sri/'.$VLRUC.'/'.$VTANIO.'_'.$VTMES.'/authorized/'.$name,$xmlAutorizado->saveXML());
            
            $xmlEmail = 'app/public/sri/'.$VLRUC.'/'.$VTANIO.'_'.$VTMES.'/authorized/'.$name;
            $pdfEmail = 'app/public/sri/'.$VLRUC.'/'.$VTANIO.'_'.$VTMES.'/ride/'.$nameRide;

            $fileXmlAutorizado = file_get_contents(storage_path($xmlEmail));    
            

            $dataReponse = [
                "claveAcceso"=> $VTCLAVEACCESO,
                "nombreFile"=> $nameFile,
                "respuesta"=> $respuesta,
                "estado"=> $respuestaAutoriza,
                "unsigned"=> '',
                "signed"=> '',
                "autorized" => $fileXmlAutorizado,
                "errors"=> '',
                "connection" => 'correcta',
                "errors_connection" => ''
            ];

            return $this->sendResponse($dataReponse,'Estado de Proceso');
            
        }else{
            $respuesta = "ERROR";
            $respuestaAutoriza = 'RECHAZADO';
            //$imprimeAutoriza[2] = $autoriza->RespuestaAutorizacionComprobante->autorizaciones->autorizacion->mensajes->mensaje->mensaje;
            $claveAut = $autoriza->RespuestaAutorizacionComprobante->claveAccesoConsultada;
            $xmlAutorizado = new DOMDocument("1.0","UTF-8");
            $xmlAutorizado->formatOutput=true;
            $xmlAutorizado->xmlStandalone =true;
    
            $etqAutoriza=$xmlAutorizado->createElement("autorizacion");
            $xmlAutorizado->appendChild($etqAutoriza);
            $etqEstado=$xmlAutorizado->createElement("estado",$autoriza->RespuestaAutorizacionComprobante->autorizaciones->autorizacion->estado);
            $etqAutoriza->appendChild($etqEstado);
            $etqNumero=$xmlAutorizado->createElement("numeroAutorizacion",$claveAut);
            $etqAutoriza->appendChild($etqNumero);
            $etqFecha=$xmlAutorizado->createElement("fechaAutorizacion",$autoriza->RespuestaAutorizacionComprobante->autorizaciones->autorizacion->fechaAutorizacion);
            $etqAutoriza->appendChild($etqFecha);
            $etqFecha=$xmlAutorizado->createElement("ambiente",$autoriza->RespuestaAutorizacionComprobante->autorizaciones->autorizacion->ambiente);
            $etqAutoriza->appendChild($etqFecha);
            $etqFecha=$xmlAutorizado->createElement("comprobante",$autoriza->RespuestaAutorizacionComprobante->autorizaciones->autorizacion->comprobante);
            $etqAutoriza->appendChild($etqFecha);     

            $textoTxt = json_encode($autoriza->RespuestaAutorizacionComprobante);
            \Storage::disk('local')->put('public/sri/'.$VLRUC.'/'.$VTANIO.'_'.$VTMES.'/errors/'.$nameTxt,$textoTxt);

            $statusMensaje = $autoriza->RespuestaAutorizacionComprobante->autorizaciones->autorizacion->estado;

            \Storage::disk('local')->put('public/sri/'.$VLRUC.'/'.$VTANIO.'_'.$VTMES.'/rejected/'.$name,$xmlAutorizado->saveXML());


            $dataReponse = [
                "claveAcceso"=> $VTCLAVEACCESO,
                "nombreFile"=> $nameFile,
                "respuesta"=> $respuesta,
                "estado"=> $respuestaAutoriza,
                "unsigned"=> '',
                "signed"=> '',
                "autorized" => '',
                "errors"=> $textoTxt,
                "connection" => 'correcta',
                "errors_connection" => ''
            ];

            return $this->sendResponse($dataReponse,'Estado de Proceso');
        }

        }catch(SoapFault $e){
            //$imprime[0] = 0;
            //echo json_encode($e);

            $dataReponse = [
                "claveAcceso"=> $VTCLAVEACCESO,
                "nombreFile"=> $nameFile,
                "respuesta"=> $respuesta,
                "estado"=> $respuestaAutoriza,
                "unsigned"=> $name,
                "signed"=> $name,
                "autorized" => '',
                "errors"=>'',
                "connection" => 'errors',
                "errors_connection" => $e
            ];
            
            return $this->sendResponse($dataReponse,'Error al procesar');
        }


    }

}