<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class InvoiceSri extends Mailable
{
    use Queueable, SerializesModels;

    public $invoice;
    public $getCurrentCompany;
    public $info;
    public $moreUsers;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($invoice)
    {
        $this->invoice = $invoice;
        $this->getCurrentCompany = (object)$invoice['getCurrentCompany'];
        $this->info = (object)$invoice['info'];
        $this->moreUsers = $invoice['moreUsers'];
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        if(isset($this->invoice['tipo']) && $this->invoice['tipo']=='2'){

            $subject = 'Comprobante Retención '.\Carbon\Carbon::now()->format('Y-m-d H:i:s');

            return $this->markdown('emails.retencion.invoice')
            ->subject($subject)
            ->from('info@mg.midas-erp.cloud')
            ->cc($this->moreUsers)
            //->bcc($evenMoreUsers)
            ->attach($this->invoice['xml'])
            ->attach($this->invoice['pdf']);

        }elseif(isset($this->invoice['tipo']) && $this->invoice['tipo']=='3'){

            $subject = 'Comprobante Liquidacion en Compra '.\Carbon\Carbon::now()->format('Y-m-d H:i:s');

            return $this->markdown('emails.liquidacion.invoice')
            ->subject($subject)
            ->from('info@mg.midas-erp.cloud')
            ->cc($this->moreUsers)
            //->bcc($evenMoreUsers)
            ->attach($this->invoice['xml'])
            ->attach($this->invoice['pdf']);

        }elseif(isset($this->invoice['tipo']) && $this->invoice['tipo']=='4'){

            $subject = 'Comprobante Nota Credito '.\Carbon\Carbon::now()->format('Y-m-d H:i:s');

            return $this->markdown('emails.notacredito.invoice')
            ->subject($subject)
            ->from('info@mg.midas-erp.cloud')
            ->cc($this->moreUsers)
            //->bcc($evenMoreUsers)
            ->attach($this->invoice['xml'])
            ->attach($this->invoice['pdf']);

        }elseif(isset($this->invoice['tipo']) && $this->invoice['tipo']=='5'){

            $subject = 'Comprobante Nota Debito '.\Carbon\Carbon::now()->format('Y-m-d H:i:s');

            return $this->markdown('emails.notadebito01.invoice')
            ->subject($subject)
            ->from('info@mg.midas-erp.cloud')
            ->cc($this->moreUsers)
            //->bcc($evenMoreUsers)
            ->attach($this->invoice['xml'])
            ->attach($this->invoice['pdf']);

        }elseif(isset($this->invoice['tipo']) && $this->invoice['tipo']=='6'){

            $subject = 'Guia de Remision '.\Carbon\Carbon::now()->format('Y-m-d H:i:s');

            return $this->markdown('emails.guia.invoice')
            ->subject($subject)
            ->from('info@mg.midas-erp.cloud')
            ->cc($this->moreUsers)
            //->bcc($evenMoreUsers)
            ->attach($this->invoice['xml'])
            ->attach($this->invoice['pdf']);

        }elseif(isset($this->invoice['tipo']) && $this->invoice['tipo']=='1'){
            $subject = 'Comprobante Factura '.\Carbon\Carbon::now()->format('Y-m-d H:i:s');
            $from = env('MAIL_FROM_ADDRESS', 'hello@example.com');

            return $this->markdown('emails.venta.factura')
            ->subject($subject)
            ->from($from)
            ->cc($this->moreUsers)
            //->bcc($evenMoreUsers)
            ->attach($this->invoice['xml'])
            ->attach($this->invoice['pdf']);
        }else{
            $subject = 'Comprobante Factura '.\Carbon\Carbon::now()->format('Y-m-d H:i:s');
            $from = env('MAIL_FROM_ADDRESS', 'hello@example.com');

            return $this->markdown('emails.venta.factura')
            ->subject($subject)
            ->from($from)
            ->cc($this->moreUsers)
            //->bcc($evenMoreUsers)
            ->attach($this->invoice['xml'])
            ->attach($this->invoice['pdf']);
        }
        
    }
}
