<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\API\FacturaController;
use App\Http\Controllers\API\NotaCreditoController;
use App\Http\Controllers\API\RetencionController;
use App\Http\Controllers\API\VerifyDocumentController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});
 
Route::post('/factura/create', [FacturaController::class, 'create']);
Route::post('/notacredito/create', [NotaCreditoController::class, 'create']);
Route::post('/retencion/create', [RetencionController::class, 'create']);
Route::post('/verififacion-documento', [VerifyDocumentController::class, 'verify']);

Route::post('/factura/create-ride', [FacturaController::class, 'generateNewRide']);
Route::post('/notacredito/create-ride', [NotaCreditoController::class, 'generateNewRide']);
Route::post('/retencion/create-ride', [RetencionController::class, 'generateNewRide']);




