/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager.mac;

import com.oracle.tools.packager.AbstractImageBundler;
import com.oracle.tools.packager.BundlerParamInfo;
import com.oracle.tools.packager.ConfigException;
import com.oracle.tools.packager.EnumeratedBundlerParam;
import com.oracle.tools.packager.IOUtils;
import com.oracle.tools.packager.JreUtils;
import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.RelativeFileSet;
import com.oracle.tools.packager.StandardBundlerParam;
import com.oracle.tools.packager.UnsupportedPlatformException;
import com.oracle.tools.packager.mac.MacBaseInstallerBundler;
import com.oracle.tools.packager.mac.MacResources;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MacAppBundler
extends AbstractImageBundler {
    private static final ResourceBundle I18N = ResourceBundle.getBundle(MacAppBundler.class.getName());
    public static final String MAC_BUNDLER_PREFIX = "package/macosx" + File.separator;
    private static final String EXECUTABLE_NAME = "JavaAppLauncher";
    private static final String LIBRARY_NAME = "libpackager.dylib";
    private static final String TEMPLATE_BUNDLE_ICON = "GenericApp.icns";
    private static final String OS_TYPE_CODE = "APPL";
    private static final String TEMPLATE_INFO_PLIST_LEGACY = "Info.plist.template";
    private static final String TEMPLATE_INFO_PLIST_LITE = "Info-lite.plist.template";
    public static final BundlerParamInfo<Boolean> MAC_CONFIGURE_LAUNCHER_IN_PLIST = new StandardBundlerParam<Boolean>(I18N.getString("param.configure-launcher-in-plist"), I18N.getString("param.configure-launcher-in-plist.description"), "mac.configure-launcher-in-plist", Boolean.class, map -> Boolean.FALSE, (string, map) -> Boolean.valueOf(string));
    public static final EnumeratedBundlerParam<String> MAC_CATEGORY = new EnumeratedBundlerParam<String>(I18N.getString("param.category-name"), I18N.getString("param.category-name.description"), "mac.category", String.class, map -> map.containsKey(StandardBundlerParam.CATEGORY.getID()) ? (String)StandardBundlerParam.CATEGORY.fetchFrom((Map<String, Object>)map) : "Unknown", (string, map) -> string, MacAppBundler.getMacCategories(), false);
    public static final BundlerParamInfo<String> MAC_CF_BUNDLE_NAME = new StandardBundlerParam<String>(I18N.getString("param.cfbundle-name.name"), I18N.getString("param.cfbundle-name.description"), "mac.CFBundleName", String.class, map -> null, (string, map) -> string);
    public static final BundlerParamInfo<String> MAC_CF_BUNDLE_IDENTIFIER = new StandardBundlerParam<String>(I18N.getString("param.cfbundle-identifier.name"), I18N.getString("param.cfbundle-identifier.description"), "mac.CFBundleIdentifier", String.class, StandardBundlerParam.IDENTIFIER::fetchFrom, (string, map) -> string);
    public static final BundlerParamInfo<String> MAC_CF_BUNDLE_VERSION = new StandardBundlerParam<String>(I18N.getString("param.cfbundle-version.name"), I18N.getString("param.cfbundle-version.description"), "mac.CFBundleVersion", String.class, map -> {
        String string = (String)StandardBundlerParam.VERSION.fetchFrom((Map<String, Object>)map);
        if (MacAppBundler.validCFBundleVersion(string)) {
            return string;
        }
        return "100";
    }, (string, map) -> string);
    public static final BundlerParamInfo<File> CONFIG_ROOT = new StandardBundlerParam<File>(I18N.getString("param.config-root.name"), I18N.getString("param.config-root.description"), "configRoot", File.class, map -> {
        File file = new File((File)StandardBundlerParam.BUILD_ROOT.fetchFrom((Map<String, Object>)map), "macosx");
        file.mkdirs();
        return file;
    }, (string, map) -> new File((String)string));
    public static final BundlerParamInfo<URL> RAW_EXECUTABLE_URL = new StandardBundlerParam<URL>(I18N.getString("param.raw-executable-url.name"), I18N.getString("param.raw-executable-url.description"), "mac.launcher.url", URL.class, map -> MacResources.class.getResource(EXECUTABLE_NAME), (string, map) -> {
        try {
            return new URL((String)string);
        }
        catch (MalformedURLException malformedURLException) {
            Log.info(malformedURLException.toString());
            return null;
        }
    });
    public static final BundlerParamInfo<String> DEFAULT_ICNS_ICON = new StandardBundlerParam<String>(I18N.getString("param.default-icon-icns"), I18N.getString("param.default-icon-icns.description"), ".mac.default.icns", String.class, map -> "GenericApp.icns", (string, map) -> string);
    public static final BundlerParamInfo<JreUtils.Rule[]> MAC_RULES = new StandardBundlerParam<JreUtils.Rule[]>("", "", ".mac.runtime.rules", JreUtils.Rule[].class, MacAppBundler::createMacRuntimeRules, (string, map) -> null);
    public static final BundlerParamInfo<RelativeFileSet> MAC_RUNTIME = new StandardBundlerParam<RelativeFileSet>(I18N.getString("param.runtime.name"), I18N.getString("param.runtime.description"), "runtime", RelativeFileSet.class, map -> MacAppBundler.extractMacRuntime(System.getProperty("java.home"), map), MacAppBundler::extractMacRuntime);
    public static final BundlerParamInfo<String> DEVELOPER_ID_APP_SIGNING_KEY = new StandardBundlerParam<String>(I18N.getString("param.signing-key-developer-id-app.name"), I18N.getString("param.signing-key-developer-id-app.description"), "mac.signing-key-developer-id-app", String.class, map -> MacBaseInstallerBundler.findKey("Developer ID Application: " + MacBaseInstallerBundler.SIGNING_KEY_USER.fetchFrom((Map<String, Object>)map), MacBaseInstallerBundler.SIGNING_KEYCHAIN.fetchFrom((Map<String, Object>)map), (Boolean)StandardBundlerParam.VERBOSE.fetchFrom((Map<String, Object>)map)), (string, map) -> string);
    public static final BundlerParamInfo<String> BUNDLE_ID_SIGNING_PREFIX = new StandardBundlerParam<String>(I18N.getString("param.bundle-id-signing-prefix.name"), I18N.getString("param.bundle-id-signing-prefix.description"), "mac.bundle-id-signing-prefix", String.class, map -> (String)StandardBundlerParam.IDENTIFIER.fetchFrom((Map<String, Object>)map) + ".", (string, map) -> string);
    public static final BundlerParamInfo<File> ICON_ICNS = new StandardBundlerParam<File>(I18N.getString("param.icon-icns.name"), I18N.getString("param.icon-icns.description"), "icon.icns", File.class, map -> {
        File file = (File)StandardBundlerParam.ICON.fetchFrom((Map<String, Object>)map);
        if (file != null && !file.getName().toLowerCase().endsWith(".icns")) {
            Log.info(MessageFormat.format(I18N.getString("message.icon-not-icns"), file));
            return null;
        }
        return file;
    }, (string, map) -> new File((String)string));

    private static Map<String, String> getMacCategories() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Business", "public.app-category.business");
        hashMap.put("Developer Tools", "public.app-category.developer-tools");
        hashMap.put("Education", "public.app-category.education");
        hashMap.put("Entertainment", "public.app-category.entertainment");
        hashMap.put("Finance", "public.app-category.finance");
        hashMap.put("Games", "public.app-category.games");
        hashMap.put("Graphics & Design", "public.app-category.graphics-design");
        hashMap.put("Healthcare & Fitness", "public.app-category.healthcare-fitness");
        hashMap.put("Lifestyle", "public.app-category.lifestyle");
        hashMap.put("Medical", "public.app-category.medical");
        hashMap.put("Music", "public.app-category.music");
        hashMap.put("News", "public.app-category.news");
        hashMap.put("Photography", "public.app-category.photography");
        hashMap.put("Productivity", "public.app-category.productivity");
        hashMap.put("Reference", "public.app-category.reference");
        hashMap.put("Social Networking", "public.app-category.social-networking");
        hashMap.put("Sports", "public.app-category.sports");
        hashMap.put("Travel", "public.app-category.travel");
        hashMap.put("Utilities", "public.app-category.utilities");
        hashMap.put("Video", "public.app-category.video");
        hashMap.put("Weather", "public.app-category.weather");
        hashMap.put("Action Games", "public.app-category.action-games");
        hashMap.put("Adventure Games", "public.app-category.adventure-games");
        hashMap.put("Arcade Games", "public.app-category.arcade-games");
        hashMap.put("Board Games", "public.app-category.board-games");
        hashMap.put("Card Games", "public.app-category.card-games");
        hashMap.put("Casino Games", "public.app-category.casino-games");
        hashMap.put("Dice Games", "public.app-category.dice-games");
        hashMap.put("Educational Games", "public.app-category.educational-games");
        hashMap.put("Family Games", "public.app-category.family-games");
        hashMap.put("Kids Games", "public.app-category.kids-games");
        hashMap.put("Music Games", "public.app-category.music-games");
        hashMap.put("Puzzle Games", "public.app-category.puzzle-games");
        hashMap.put("Racing Games", "public.app-category.racing-games");
        hashMap.put("Role Playing Games", "public.app-category.role-playing-games");
        hashMap.put("Simulation Games", "public.app-category.simulation-games");
        hashMap.put("Sports Games", "public.app-category.sports-games");
        hashMap.put("Strategy Games", "public.app-category.strategy-games");
        hashMap.put("Trivia Games", "public.app-category.trivia-games");
        hashMap.put("Word Games", "public.app-category.word-games");
        return hashMap;
    }

    public static RelativeFileSet extractMacRuntime(String string, Map<String, ? super Object> map) {
        if (string.isEmpty()) {
            return null;
        }
        File file = new File(string);
        file = file.getAbsoluteFile();
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (file.getName().equals("jre")) {
            file = file.getParentFile();
        }
        if (file.getName().equals("Home")) {
            file = file.getParentFile();
        }
        if (file.getName().equals("Contents")) {
            file = file.getParentFile();
        }
        return JreUtils.extractJreAsRelativeFileSet(file.toString(), MAC_RULES.fetchFrom(map), true);
    }

    public MacAppBundler() {
        this.baseResourceLoader = MacResources.class;
    }

    @Override
    protected String getCacheLocation(Map<String, ? super Object> map) {
        return "$CACHEDIR/";
    }

    public static boolean validCFBundleVersion(String string) {
        if (string == null) {
            return false;
        }
        String[] stringArray = string.split("\\.");
        if (stringArray.length > 3 || stringArray.length < 1) {
            Log.verbose(I18N.getString("message.version-string-too-many-components"));
            return false;
        }
        try {
            BigInteger bigInteger = new BigInteger(stringArray[0]);
            if (BigInteger.ONE.compareTo(bigInteger) > 0) {
                Log.verbose(I18N.getString("message.version-string-first-number-not-zero"));
                return false;
            }
            if (stringArray.length > 1 && BigInteger.ZERO.compareTo(bigInteger = new BigInteger(stringArray[1])) > 0) {
                Log.verbose(I18N.getString("message.version-string-no-negative-numbers"));
                return false;
            }
            if (stringArray.length > 2 && BigInteger.ZERO.compareTo(bigInteger = new BigInteger(stringArray[2])) > 0) {
                Log.verbose(I18N.getString("message.version-string-no-negative-numbers"));
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            Log.verbose(I18N.getString("message.version-string-numbers-only"));
            Log.verbose(numberFormatException);
            return false;
        }
        return true;
    }

    @Override
    public boolean validate(Map<String, ? super Object> map) throws UnsupportedPlatformException, ConfigException {
        try {
            return this.doValidate(map);
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException.getCause() instanceof ConfigException) {
                throw (ConfigException)runtimeException.getCause();
            }
            throw new ConfigException(runtimeException);
        }
    }

    public boolean doValidate(Map<String, ? super Object> map) throws UnsupportedPlatformException, ConfigException {
        String string;
        if (!System.getProperty("os.name").toLowerCase().contains("os x")) {
            throw new UnsupportedPlatformException();
        }
        this.imageBundleValidation(map);
        if (MacBaseInstallerBundler.getPredefinedImage(map) != null) {
            return true;
        }
        RelativeFileSet relativeFileSet = MAC_RUNTIME.fetchFrom(map);
        if (relativeFileSet != null) {
            if ("jre".equals((relativeFileSet = new RelativeFileSet(relativeFileSet)).getBaseDirectory().getName())) {
                relativeFileSet.upshift();
            }
            if ("Home".equals(relativeFileSet.getBaseDirectory().getName())) {
                relativeFileSet.upshift();
            }
            if ("Contents".equals(relativeFileSet.getBaseDirectory().getName())) {
                relativeFileSet.upshift();
            }
        }
        this.testRuntime(relativeFileSet, new String[]{"Contents/Home/(jre/)?lib/[^/]+/libjvm.dylib", "Contents/Home/(jre/)?lib/rt.jar"});
        if (((Boolean)StandardBundlerParam.USE_FX_PACKAGING.fetchFrom(map)).booleanValue()) {
            this.testRuntime(relativeFileSet, new String[]{"Contents/Home/(jre/)?lib/ext/jfxrt.jar", "Contents/Home/(jre/)?lib/jfxrt.jar"});
        }
        if (!MacAppBundler.validCFBundleVersion(MAC_CF_BUNDLE_VERSION.fetchFrom(map))) {
            throw new ConfigException(I18N.getString("error.invalid-cfbundle-version"), I18N.getString("error.invalid-cfbundle-version.advice"));
        }
        if (Optional.ofNullable(StandardBundlerParam.SIGN_BUNDLE.fetchFrom(map)).orElse(Boolean.FALSE).booleanValue() && (string = DEVELOPER_ID_APP_SIGNING_KEY.fetchFrom(map)) == null) {
            throw new ConfigException(I18N.getString("error.explicit-sign-no-cert"), I18N.getString("error.explicit-sign-no-cert.advice"));
        }
        return true;
    }

    private File getConfig_InfoPlist(Map<String, ? super Object> map) {
        return new File(CONFIG_ROOT.fetchFrom(map), "Info.plist");
    }

    private File getConfig_Icon(Map<String, ? super Object> map) {
        return new File(CONFIG_ROOT.fetchFrom(map), (String)StandardBundlerParam.APP_NAME.fetchFrom(map) + ".icns");
    }

    private void prepareConfigFiles(Map<String, ? super Object> map) throws IOException {
        File file = this.getConfig_InfoPlist(map);
        file.createNewFile();
        this.writeInfoPlist(file, map);
        this.prepareIcon(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File doBundle(Map<String, ? super Object> map, File file, boolean bl) {
        File file2;
        block18: {
            HashMap<String, ? super Object> hashMap;
            block16: {
                File file3;
                block17: {
                    file2 = null;
                    hashMap = new HashMap<String, Object>(map);
                    if (!file.isDirectory() && !file.mkdirs()) {
                        throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-create-output-dir"), file.getAbsolutePath()));
                    }
                    if (!file.canWrite()) {
                        throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-write-to-output-dir"), file.getAbsolutePath()));
                    }
                    File file4 = MacBaseInstallerBundler.getPredefinedImage(map);
                    if (file4 == null) break block16;
                    file3 = file4;
                    if (((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)).booleanValue()) break block17;
                    this.cleanupConfigFiles(map);
                }
                Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), CONFIG_ROOT.fetchFrom(map).getAbsolutePath()));
                return file3;
            }
            try {
                Object object;
                Object object22;
                StandardBundlerParam.BUILD_ROOT.fetchFrom(map);
                this.prepareConfigFiles(map);
                file2 = new File(file, (String)StandardBundlerParam.APP_NAME.fetchFrom(map) + ".app");
                IOUtils.deleteRecursive(file2);
                file2.mkdirs();
                if (!bl) {
                    Log.info(MessageFormat.format(I18N.getString("message.creating-app-bundle"), file2.getAbsolutePath()));
                }
                File file5 = new File(file2, "Contents");
                file5.mkdirs();
                File file6 = new File(file5, "MacOS");
                file6.mkdirs();
                File file7 = new File(file5, "Java");
                file7.mkdirs();
                File file8 = new File(file5, "PlugIns");
                File file9 = new File(file5, "Resources");
                file9.mkdirs();
                File file10 = new File(file5, "PkgInfo");
                file10.createNewFile();
                this.writePkgInfo(file10);
                File file11 = new File(file6, this.getLauncherName(map));
                IOUtils.copyFromURL(RAW_EXECUTABLE_URL.fetchFrom(map), file11);
                IOUtils.copyFromURL(MacResources.class.getResource(LIBRARY_NAME), new File(file6, LIBRARY_NAME));
                if (!MAC_CONFIGURE_LAUNCHER_IN_PLIST.fetchFrom(map).booleanValue()) {
                    if (((String)LAUNCHER_CFG_FORMAT.fetchFrom(map)).equals("prop")) {
                        this.writeCfgFile(map, file2);
                    } else {
                        this.writeCfgFile(map, new File(file2, MacAppBundler.getLauncherCfgName(map)), this.getRuntimeLocation(map));
                    }
                }
                file11.setExecutable(true, false);
                this.copyRuntime(file8, map);
                this.copyClassPathEntries(file7, map);
                IOUtils.copyFile(this.getConfig_Icon(map), new File(file9, this.getConfig_Icon(map).getName()));
                for (Object object22 : (List)StandardBundlerParam.FILE_ASSOCIATIONS.fetchFrom(map)) {
                    object = (File)StandardBundlerParam.FA_ICON.fetchFrom((Map<String, Object>)object22);
                    if (object == null || !((File)object).exists()) continue;
                    IOUtils.copyFile((File)object, new File(file9, ((File)object).getName()));
                }
                IOUtils.copyFile(this.getConfig_InfoPlist(map), new File(file5, "Info.plist"));
                List list = (List)StandardBundlerParam.SECONDARY_LAUNCHERS.fetchFrom(map);
                object22 = list.iterator();
                while (object22.hasNext()) {
                    object = (Map)object22.next();
                    HashMap<String, ? super Object> hashMap2 = new HashMap<String, Object>(hashMap);
                    hashMap2.putAll((Map<String, ? super Object>)object);
                    this.createLauncherForEntryPoint(hashMap2, file2);
                }
                if (Optional.ofNullable(StandardBundlerParam.SIGN_BUNDLE.fetchFrom(map)).orElse(Boolean.TRUE).booleanValue() && (object22 = DEVELOPER_ID_APP_SIGNING_KEY.fetchFrom(map)) != null) {
                    MacBaseInstallerBundler.signAppBundle(map, file2, (String)object22, BUNDLE_ID_SIGNING_PREFIX.fetchFrom(map));
                }
                if (((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)).booleanValue()) break block18;
                this.cleanupConfigFiles(map);
            }
            catch (IOException iOException) {
                File file12;
                block19: {
                    try {
                        Log.info(iOException.toString());
                        Log.verbose(iOException);
                        file12 = null;
                        if (((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)).booleanValue()) break block19;
                        this.cleanupConfigFiles(map);
                    }
                    catch (Throwable throwable) {
                        if (!((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)).booleanValue()) {
                            this.cleanupConfigFiles(map);
                        } else {
                            Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), CONFIG_ROOT.fetchFrom(map).getAbsolutePath()));
                        }
                        throw throwable;
                    }
                }
                Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), CONFIG_ROOT.fetchFrom(map).getAbsolutePath()));
                return file12;
            }
        }
        Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), CONFIG_ROOT.fetchFrom(map).getAbsolutePath()));
        return file2;
    }

    public void cleanupConfigFiles(Map<String, ? super Object> map) {
        if (CONFIG_ROOT.fetchFrom(map) != null) {
            this.getConfig_Icon(map).delete();
            this.getConfig_InfoPlist(map).delete();
        }
    }

    private void copyClassPathEntries(File file, Map<String, ? super Object> map) throws IOException {
        List list = (List)StandardBundlerParam.APP_RESOURCES_LIST.fetchFrom(map);
        if (list == null) {
            throw new RuntimeException(I18N.getString("message.null-classpath"));
        }
        for (RelativeFileSet relativeFileSet : list) {
            File file2 = relativeFileSet.getBaseDirectory();
            for (String string : relativeFileSet.getIncludedFiles()) {
                IOUtils.copyFile(new File(file2, string), new File(file, string));
            }
        }
    }

    private void copyRuntime(File file, Map<String, ? super Object> map) throws IOException {
        RelativeFileSet relativeFileSet = MAC_RUNTIME.fetchFrom(map);
        if (relativeFileSet == null) {
            return;
        }
        if ("jre".equals((relativeFileSet = new RelativeFileSet(relativeFileSet)).getBaseDirectory().getName())) {
            relativeFileSet.upshift();
        }
        if ("Home".equals(relativeFileSet.getBaseDirectory().getName())) {
            relativeFileSet.upshift();
        }
        if ("Contents".equals(relativeFileSet.getBaseDirectory().getName())) {
            relativeFileSet.upshift();
        }
        file.mkdirs();
        File file2 = relativeFileSet.getBaseDirectory();
        File file3 = new File(file, "Java.runtime");
        Set<String> set = relativeFileSet.getIncludedFiles();
        for (String string : set) {
            IOUtils.copyFile(new File(file2, string), new File(file3, string));
        }
    }

    private void prepareIcon(Map<String, ? super Object> map) throws IOException {
        File file = ICON_ICNS.fetchFrom(map);
        if (file == null || !file.exists()) {
            this.fetchResource(MAC_BUNDLER_PREFIX + (String)StandardBundlerParam.APP_NAME.fetchFrom(map) + ".icns", "icon", DEFAULT_ICNS_ICON.fetchFrom(map), this.getConfig_Icon(map), (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(map));
        } else {
            this.fetchResource(MAC_BUNDLER_PREFIX + (String)StandardBundlerParam.APP_NAME.fetchFrom(map) + ".icns", "icon", file, this.getConfig_Icon(map), (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(map));
        }
    }

    private String getLauncherName(Map<String, ? super Object> map) {
        if (StandardBundlerParam.APP_NAME.fetchFrom(map) != null) {
            return (String)StandardBundlerParam.APP_NAME.fetchFrom(map);
        }
        return (String)StandardBundlerParam.MAIN_CLASS.fetchFrom(map);
    }

    private String getBundleName(Map<String, ? super Object> map) {
        if (MAC_CF_BUNDLE_NAME.fetchFrom(map) != null) {
            String string = MAC_CF_BUNDLE_NAME.fetchFrom(map);
            if (string.length() > 16) {
                Log.info(MessageFormat.format(I18N.getString("message.bundle-name-too-long-warning"), MAC_CF_BUNDLE_NAME.getID(), string));
            }
            return MAC_CF_BUNDLE_NAME.fetchFrom(map);
        }
        if (StandardBundlerParam.APP_NAME.fetchFrom(map) != null) {
            return (String)StandardBundlerParam.APP_NAME.fetchFrom(map);
        }
        String string = (String)StandardBundlerParam.MAIN_CLASS.fetchFrom(map);
        if (string.length() > 16) {
            string = string.substring(0, 16);
        }
        return string;
    }

    private String getRuntimeLocation(Map<String, ? super Object> map) {
        if (MAC_RUNTIME.fetchFrom(map) == null) {
            return "";
        }
        return "$APPDIR/PlugIns/Java.runtime";
    }

    private void writeInfoPlist(File file, Map<String, ? super Object> map) throws IOException {
        Object object2;
        Object object522;
        Log.verbose(MessageFormat.format(I18N.getString("message.preparing-info-plist"), file.getAbsolutePath()));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("DEPLOY_ICON_FILE", this.getConfig_Icon(map).getName());
        hashMap.put("DEPLOY_BUNDLE_IDENTIFIER", MAC_CF_BUNDLE_IDENTIFIER.fetchFrom(map));
        hashMap.put("DEPLOY_BUNDLE_NAME", this.getBundleName(map));
        hashMap.put("DEPLOY_BUNDLE_COPYRIGHT", StandardBundlerParam.COPYRIGHT.fetchFrom(map) != null ? (String)StandardBundlerParam.COPYRIGHT.fetchFrom(map) : "Unknown");
        hashMap.put("DEPLOY_LAUNCHER_NAME", this.getLauncherName(map));
        if (MAC_RUNTIME.fetchFrom(map) != null) {
            hashMap.put("DEPLOY_JAVA_RUNTIME_NAME", "$APPDIR/PlugIns/Java.runtime");
        } else {
            hashMap.put("DEPLOY_JAVA_RUNTIME_NAME", "");
        }
        hashMap.put("DEPLOY_BUNDLE_SHORT_VERSION", StandardBundlerParam.VERSION.fetchFrom(map) != null ? (String)StandardBundlerParam.VERSION.fetchFrom(map) : "1.0.0");
        hashMap.put("DEPLOY_BUNDLE_CFBUNDLE_VERSION", MAC_CF_BUNDLE_VERSION.fetchFrom(map) != null ? MAC_CF_BUNDLE_VERSION.fetchFrom(map) : "100");
        hashMap.put("DEPLOY_BUNDLE_CATEGORY", MAC_CATEGORY.validatedFetchFrom(map));
        hashMap.put("DEPLOY_MAIN_JAR_NAME", ((RelativeFileSet)StandardBundlerParam.MAIN_JAR.fetchFrom(map)).getIncludedFiles().iterator().next());
        hashMap.put("DEPLOY_PREFERENCES_ID", ((String)StandardBundlerParam.PREFERENCES_ID.fetchFrom(map)).toLowerCase());
        StringBuilder stringBuilder = new StringBuilder();
        List list = (List)StandardBundlerParam.JVM_OPTIONS.fetchFrom(map);
        String string = "";
        for (Object object522 : list) {
            stringBuilder.append(string).append("    <string>").append((String)object522).append("</string>");
            string = "\n";
        }
        Map map2 = (Map)StandardBundlerParam.JVM_PROPERTIES.fetchFrom(map);
        for (Map.Entry object42 : map2.entrySet()) {
            stringBuilder.append(string).append("    <string>-D").append((String)object42.getKey()).append("=").append((String)object42.getValue()).append("</string>");
            string = "\n";
        }
        object522 = (String)StandardBundlerParam.PRELOADER_CLASS.fetchFrom(map);
        if (object522 != null) {
            stringBuilder.append(string).append("    <string>-Djavafx.preloader=").append((String)object522).append("</string>");
        }
        hashMap.put("DEPLOY_JVM_OPTIONS", stringBuilder.toString());
        stringBuilder = new StringBuilder();
        List list2 = (List)StandardBundlerParam.ARGUMENTS.fetchFrom(map);
        string = "";
        for (Object object2 : list2) {
            stringBuilder.append(string).append("    <string>").append((String)object2).append("</string>");
            string = "\n";
        }
        hashMap.put("DEPLOY_ARGUMENTS", stringBuilder.toString());
        string = "";
        stringBuilder = new StringBuilder();
        Map map3 = (Map)StandardBundlerParam.USER_JVM_OPTIONS.fetchFrom(map);
        for (Map.Entry entry : map3.entrySet()) {
            stringBuilder.append(string).append("      <key>").append((String)entry.getKey()).append("</key>\n").append("      <string>").append((String)entry.getValue()).append("</string>");
            string = "\n";
        }
        hashMap.put("DEPLOY_JVM_USER_OPTIONS", stringBuilder.toString());
        hashMap.put("DEPLOY_LAUNCHER_CLASS", (String)StandardBundlerParam.MAIN_CLASS.fetchFrom(map));
        object2 = new StringBuilder();
        for (String string2 : ((String)StandardBundlerParam.CLASSPATH.fetchFrom(map)).split("[ ;:]+")) {
            ((StringBuilder)object2).append(string2);
            ((StringBuilder)object2).append(":");
        }
        ((StringBuilder)object2).deleteCharAt(((StringBuilder)object2).length() - 1);
        hashMap.put("DEPLOY_APP_CLASSPATH", ((StringBuilder)object2).toString());
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = new StringBuilder();
        for (Map map4 : (List)StandardBundlerParam.FILE_ASSOCIATIONS.fetchFrom(map)) {
            List list3 = (List)StandardBundlerParam.FA_EXTENSIONS.fetchFrom(map4);
            if (list3 == null) {
                Log.info(I18N.getString("message.creating-association-with-null-extension"));
            }
            List list4 = (List)StandardBundlerParam.FA_CONTENT_TYPE.fetchFrom(map4);
            String string3 = MAC_CF_BUNDLE_IDENTIFIER.fetchFrom(map) + "." + (list3 == null || list3.isEmpty() ? "mime" : (String)list3.get(0));
            String string4 = (String)StandardBundlerParam.FA_DESCRIPTION.fetchFrom(map4);
            File file2 = (File)StandardBundlerParam.FA_ICON.fetchFrom(map4);
            stringBuilder2.append("    <dict>\n").append("      <key>LSItemContentTypes</key>\n").append("      <array>\n").append("        <string>").append(string3).append("</string>\n").append("      </array>\n").append("\n").append("      <key>CFBundleTypeName</key>\n").append("      <string>").append(string4).append("</string>\n").append("\n").append("      <key>LSHandlerRank</key>\n").append("      <string>Owner</string>\n").append("\n").append("      <key>CFBundleTypeRole</key>\n").append("      <string>Editor</string>\n").append("\n").append("      <key>LSIsAppleDefaultForType</key>\n").append("      <true/>\n").append("\n");
            if (file2 != null && file2.exists()) {
                stringBuilder2.append("      <key>CFBundleTypeIconFile</key>\n").append("      <string>").append(file2.getName()).append("</string>\n");
            }
            stringBuilder2.append("    </dict>\n");
            stringBuilder3.append("    <dict>\n").append("      <key>UTTypeIdentifier</key>\n").append("      <string>").append(string3).append("</string>\n").append("\n").append("      <key>UTTypeDescription</key>\n").append("      <string>").append(string4).append("</string>\n").append("      <key>UTTypeConformsTo</key>\n").append("      <array>\n").append("          <string>public.data</string>\n").append("      </array>\n").append("\n");
            if (file2 != null && file2.exists()) {
                stringBuilder3.append("      <key>UTTypeIconFile</key>\n").append("      <string>").append(file2.getName()).append("</string>\n").append("\n");
            }
            stringBuilder3.append("\n").append("      <key>UTTypeTagSpecification</key>\n").append("      <dict>\n").append("\n");
            if (list3 != null && !list3.isEmpty()) {
                stringBuilder3.append("        <key>public.filename-extension</key>\n").append("        <array>\n");
                for (String string5 : list3) {
                    stringBuilder3.append("          <string>").append(string5).append("</string>\n");
                }
                stringBuilder3.append("        </array>\n");
            }
            if (list4 != null && !list4.isEmpty()) {
                stringBuilder3.append("        <key>public.mime-type</key>\n").append("        <array>\n");
                for (String string5 : list4) {
                    stringBuilder3.append("          <string>").append(string5).append("</string>\n");
                }
                stringBuilder3.append("        </array>\n");
            }
            stringBuilder3.append("      </dict>\n").append("    </dict>\n");
        }
        String string6 = stringBuilder2.length() > 0 ? "\n  <key>CFBundleDocumentTypes</key>\n  <array>\n" + stringBuilder2.toString() + "  </array>\n\n  <key>UTExportedTypeDeclarations</key>\n  <array>\n" + stringBuilder3.toString() + "  </array>\n" : "";
        hashMap.put("DEPLOY_FILE_ASSOCIATIONS", string6);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        bufferedWriter.write(this.preprocessTextResource(MAC_BUNDLER_PREFIX + this.getConfig_InfoPlist(map).getName(), I18N.getString("resource.bundle-config-file"), MAC_CONFIGURE_LAUNCHER_IN_PLIST.fetchFrom(map) != false ? TEMPLATE_INFO_PLIST_LEGACY : TEMPLATE_INFO_PLIST_LITE, hashMap, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(map)));
        ((Writer)bufferedWriter).close();
    }

    private void writePkgInfo(File file) throws IOException {
        String string = "????";
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));){
            bufferedWriter.write(OS_TYPE_CODE + string);
            ((Writer)bufferedWriter).flush();
        }
    }

    public static JreUtils.Rule[] createMacRuntimeRules(Map<String, ? super Object> map) {
        boolean bl;
        boolean bl2;
        Object object;
        if (!System.getProperty("os.name").toLowerCase().contains("os x")) {
            return null;
        }
        ArrayList<JreUtils.Rule> arrayList = new ArrayList<JreUtils.Rule>();
        File file = map.containsKey(MAC_RUNTIME.getID()) ? ((object = map.get(MAC_RUNTIME.getID())) instanceof RelativeFileSet ? ((RelativeFileSet)object).getBaseDirectory() : new File(object.toString())) : new File(System.getProperty("java.home"));
        if (!file.exists()) {
            throw new RuntimeException(I18N.getString("error.non-existent-runtime"), new ConfigException(I18N.getString("error.non-existent-runtime"), I18N.getString("error.non-existent-runtime.advice")));
        }
        try {
            String string = file.getCanonicalPath();
            if (string.endsWith("/Contents/Home/jre")) {
                file = file.getParentFile().getParentFile().getParentFile();
            } else if (string.endsWith("/Contents/Home")) {
                file = file.getParentFile().getParentFile();
            }
            bl2 = new File(file, "Contents/Home/lib/jli/libjli.dylib").exists();
            bl = new File(file, "Contents/Home/jre/lib/jli/libjli.dylib").exists();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        if (!bl2 && !bl) {
            throw new RuntimeException(I18N.getString("error.cannot-detect-runtime-in-directory"), new ConfigException(I18N.getString("error.cannot-detect-runtime-in-directory"), I18N.getString("error.cannot-detect-runtime-in-directory.advice")));
        }
        arrayList.add(JreUtils.Rule.suffix("/contents/info.plist"));
        if (bl2) {
            arrayList.add(JreUtils.Rule.suffixNeg("/contents/disabled.plist"));
            arrayList.add(JreUtils.Rule.suffixNeg("/contents/enabled.plist"));
            arrayList.add(JreUtils.Rule.substrNeg("/contents/frameworks/"));
        }
        arrayList.add(JreUtils.Rule.suffixNeg("home/bin"));
        if (bl) {
            arrayList.add(JreUtils.Rule.suffixNeg("home/jre/bin"));
        }
        if (bl2) {
            arrayList.add(JreUtils.Rule.suffixNeg("resources"));
            arrayList.add(JreUtils.Rule.suffixNeg("lib/nibs"));
            arrayList.add(JreUtils.Rule.suffixNeg("lib/libnpjp2.dylib"));
            arrayList.add(JreUtils.Rule.suffixNeg("lib/security/javaws.policy"));
            arrayList.add(JreUtils.Rule.suffixNeg("lib/shortcuts"));
            arrayList.add(JreUtils.Rule.suffixNeg("lib/deploy"));
            arrayList.add(JreUtils.Rule.suffixNeg("lib/deploy.jar"));
            arrayList.add(JreUtils.Rule.suffixNeg("lib/javaws.jar"));
            arrayList.add(JreUtils.Rule.suffixNeg("lib/libdeploy.dylib"));
            arrayList.add(JreUtils.Rule.suffixNeg("lib/plugin.jar"));
        }
        arrayList.add(JreUtils.Rule.suffixNeg("home/man"));
        if (bl) {
            arrayList.add(JreUtils.Rule.suffixNeg("home/db"));
            arrayList.add(JreUtils.Rule.suffixNeg("home/demo"));
            arrayList.add(JreUtils.Rule.suffixNeg("home/include"));
            arrayList.add(JreUtils.Rule.suffixNeg("home/lib"));
            arrayList.add(JreUtils.Rule.suffixNeg("home/sample"));
            arrayList.add(JreUtils.Rule.suffixNeg("home/src.zip"));
            arrayList.add(JreUtils.Rule.suffixNeg("home/javafx-src.zip"));
        }
        arrayList.add(JreUtils.Rule.suffixNeg("home/rt"));
        arrayList.add(JreUtils.Rule.suffixNeg("lib/jfr.jar"));
        return arrayList.toArray(new JreUtils.Rule[arrayList.size()]);
    }

    @Override
    public String getName() {
        return I18N.getString("bundler.name");
    }

    @Override
    public String getDescription() {
        return I18N.getString("bundler.description");
    }

    @Override
    public String getID() {
        return "mac.app";
    }

    @Override
    public String getBundleType() {
        return "IMAGE";
    }

    @Override
    public Collection<BundlerParamInfo<?>> getBundleParameters() {
        return MacAppBundler.getAppBundleParameters();
    }

    public static Collection<BundlerParamInfo<?>> getAppBundleParameters() {
        return Arrays.asList(StandardBundlerParam.APP_NAME, StandardBundlerParam.APP_RESOURCES, StandardBundlerParam.ARGUMENTS, BUNDLE_ID_SIGNING_PREFIX, StandardBundlerParam.CLASSPATH, DEVELOPER_ID_APP_SIGNING_KEY, ICON_ICNS, StandardBundlerParam.JVM_OPTIONS, StandardBundlerParam.JVM_PROPERTIES, MAC_CATEGORY, MAC_CF_BUNDLE_IDENTIFIER, MAC_CF_BUNDLE_NAME, MAC_CF_BUNDLE_VERSION, MAC_RUNTIME, StandardBundlerParam.MAIN_CLASS, StandardBundlerParam.MAIN_JAR, StandardBundlerParam.PREFERENCES_ID, StandardBundlerParam.PRELOADER_CLASS, MacBaseInstallerBundler.SIGNING_KEYCHAIN, StandardBundlerParam.USER_JVM_OPTIONS, StandardBundlerParam.VERSION);
    }

    @Override
    public File execute(Map<String, ? super Object> map, File file) {
        return this.doBundle(map, file, false);
    }

    private void createLauncherForEntryPoint(Map<String, ? super Object> map, File file) throws IOException {
        this.prepareConfigFiles(map);
        if (((String)LAUNCHER_CFG_FORMAT.fetchFrom(map)).equals("prop")) {
            this.writeCfgFile(map, file);
        } else {
            this.writeCfgFile(map, new File(file, MacAppBundler.getLauncherCfgName(map)), "$APPDIR/PlugIns/Java.runtime");
        }
        File file2 = new File(file, "Contents/MacOS/" + this.getLauncherName(map));
        IOUtils.copyFromURL(RAW_EXECUTABLE_URL.fetchFrom(map), file2);
        file2.setExecutable(true, false);
    }

    public static String getLauncherCfgName(Map<String, ? super Object> map) {
        return "Contents/Java/" + (String)StandardBundlerParam.APP_NAME.fetchFrom(map) + ".cfg";
    }

    private void writeCfgFile(Map<String, ? super Object> map, File file) throws FileNotFoundException {
        Map.Entry entry2;
        Object object222;
        File file2 = new File(file, MacAppBundler.getLauncherCfgName(map));
        file2.delete();
        PrintStream printStream = new PrintStream(file2);
        printStream.println("app.runtime=" + this.getRuntimeLocation(map));
        printStream.println("app.mainjar=" + ((RelativeFileSet)StandardBundlerParam.MAIN_JAR.fetchFrom(map)).getIncludedFiles().iterator().next());
        printStream.println("app.version=" + (String)StandardBundlerParam.VERSION.fetchFrom(map));
        printStream.println("app.id=" + (String)StandardBundlerParam.IDENTIFIER.fetchFrom(map));
        printStream.println("app.preferences.id=" + (String)StandardBundlerParam.PREFERENCES_ID.fetchFrom(map));
        printStream.println("app.identifier=" + (String)StandardBundlerParam.IDENTIFIER.fetchFrom(map));
        printStream.println("app.mainclass=" + ((String)StandardBundlerParam.MAIN_CLASS.fetchFrom(map)).replaceAll("\\.", "/"));
        printStream.println("app.classpath=" + (String)StandardBundlerParam.CLASSPATH.fetchFrom(map));
        List list = (List)StandardBundlerParam.JVM_OPTIONS.fetchFrom(map);
        int n = 1;
        for (Object object222 : list) {
            printStream.println("jvmarg." + n + "=" + (String)object222);
            ++n;
        }
        Map map2 = (Map)StandardBundlerParam.JVM_PROPERTIES.fetchFrom(map);
        for (Map.Entry object3 : map2.entrySet()) {
            printStream.println("jvmarg." + n + "=-D" + (String)object3.getKey() + "=" + (String)object3.getValue());
            ++n;
        }
        object222 = (String)StandardBundlerParam.PRELOADER_CLASS.fetchFrom(map);
        if (object222 != null) {
            printStream.println("jvmarg." + n + "=-Djavafx.preloader=" + (String)object222);
        }
        Map map3 = (Map)StandardBundlerParam.USER_JVM_OPTIONS.fetchFrom(map);
        n = 1;
        for (Map.Entry entry2 : map3.entrySet()) {
            if (entry2.getKey() == null || entry2.getValue() == null) {
                Log.info(I18N.getString("message.jvm-user-arg-is-null"));
            } else {
                printStream.println("jvmuserarg." + n + ".name=" + (String)entry2.getKey());
                printStream.println("jvmuserarg." + n + ".value=" + (String)entry2.getValue());
            }
            ++n;
        }
        List list2 = (List)StandardBundlerParam.ARGUMENTS.fetchFrom(map);
        n = 1;
        entry2 = list2.iterator();
        while (entry2.hasNext()) {
            String string = (String)entry2.next();
            printStream.println("arg." + n + "=" + string);
            ++n;
        }
        printStream.close();
    }

    @Override
    public void extractRuntimeFlags(Map<String, ? super Object> map) {
        if (map.containsKey(".runtime.autodetect")) {
            return;
        }
        map.put(".runtime.autodetect", "attempted");
        RelativeFileSet relativeFileSet = MAC_RUNTIME.fetchFrom(map);
        if (relativeFileSet == null) {
            map.put(".runtime.autodetect", "systemjre");
        } else {
            File file = relativeFileSet.getBaseDirectory();
            if (file.getName().equals("jre")) {
                file = file.getParentFile();
            }
            if (file.getName().equals("Home")) {
                file = file.getParentFile();
            }
            if (file.getName().equals("Contents")) {
                file = file.getParentFile();
            }
            try {
                byte[] byArray = Files.readAllBytes(file.toPath().resolve(Paths.get("Contents", "Info.plist")));
                String string = new String(byArray);
                Pattern pattern = Pattern.compile("<key>CFBundleVersion</key>\\s*<string>([^<]+)</string>");
                Matcher matcher = pattern.matcher(string);
                if (matcher.find()) {
                    AbstractImageBundler.extractFlagsFromVersion(map, "java version \"" + matcher.group(1) + "\"\n");
                    map.put(".runtime.autodetect", "succeeded");
                } else {
                    map.put(".runtime.autodetect", "failed");
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                map.put(".runtime.autodetect", "failed");
            }
        }
    }
}

