/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.LinuxSystem;
import java.io.File;
import java.io.IOException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;

class LinuxAbsoluteInputCapabilities {
    private int value;
    private int minimum;
    private int maximum;
    private int fuzz;
    private int flat;
    private int resolution;

    LinuxAbsoluteInputCapabilities(int n, int n2, int n3, int n4, int n5, int n6) {
        this.value = n;
        this.maximum = n2;
        this.minimum = n3;
        this.fuzz = n4;
        this.flat = n5;
        this.resolution = n6;
    }

    private LinuxAbsoluteInputCapabilities(LinuxSystem linuxSystem, LinuxSystem.InputAbsInfo inputAbsInfo, long l, int n) throws IOException {
        linuxSystem.ioctl(l, linuxSystem.EVIOCGABS(n), inputAbsInfo.p);
        this.value = LinuxSystem.InputAbsInfo.getValue(inputAbsInfo.p);
        this.minimum = LinuxSystem.InputAbsInfo.getMinimum(inputAbsInfo.p);
        this.maximum = LinuxSystem.InputAbsInfo.getMaximum(inputAbsInfo.p);
        this.fuzz = LinuxSystem.InputAbsInfo.getFuzz(inputAbsInfo.p);
        this.flat = LinuxSystem.InputAbsInfo.getFlat(inputAbsInfo.p);
        this.resolution = LinuxSystem.InputAbsInfo.getResolution(inputAbsInfo.p);
    }

    static Map<Integer, LinuxAbsoluteInputCapabilities> getCapabilities(File file, BitSet bitSet) throws IOException {
        if (bitSet == null || bitSet.isEmpty()) {
            return null;
        }
        LinuxSystem linuxSystem = LinuxSystem.getLinuxSystem();
        LinuxSystem.InputAbsInfo inputAbsInfo = new LinuxSystem.InputAbsInfo();
        long l = linuxSystem.open(file.getPath(), 0);
        if (l == -1L) {
            throw new IOException(linuxSystem.getErrorMessage());
        }
        HashMap<Integer, LinuxAbsoluteInputCapabilities> hashMap = new HashMap<Integer, LinuxAbsoluteInputCapabilities>();
        int n = 0;
        while ((n = bitSet.nextSetBit(n)) != -1) {
            hashMap.put(n, new LinuxAbsoluteInputCapabilities(linuxSystem, inputAbsInfo, l, n));
            ++n;
        }
        linuxSystem.close(l);
        return hashMap;
    }

    int getValue() {
        return this.value;
    }

    int getMinimum() {
        return this.minimum;
    }

    int getMaximum() {
        return this.maximum;
    }

    int getFuzz() {
        return this.fuzz;
    }

    int getFlat() {
        return this.flat;
    }

    int getResolution() {
        return this.resolution;
    }
}

