<?php

namespace App\Http\Controllers;

use App\BusinessLocation;
use App\Contact;
use App\Transaction;
use App\FacturacionElectronica;
use App\TipoRetencion;
use App\Retencion;
use App\RetencionDt;
use App\TransactionPayment;
use App\Utils\BusinessUtil;
use App\Utils\TransactionUtil;
use App\Utils\Util;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class ExpenseApplyController extends Controller{

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $business_id = request()->session()->get('user.business_id');

        // Obtener todos los clientes
        $clients = Contact::where('business_id', $business_id)->get();
        $locations = BusinessLocation::where('business_id', $business_id)->get();


        $query = Transaction::with('contact','location','tax',
        'types_of_service','sri','retencion.dt')
                        ->where('business_id', $business_id)
                        ->whereIn('type', ['expense','purchase'])
                        ->whereIn('status',['final','received'])
                        ->orderBy('created_at','desc')
                        ->orderBy('invoice_no','desc');


        // Filtro por cliente (si está presente en la solicitud)
        if ($request->has('client_id') && $request->client_id != '') {
            $query->where('contact_id', $request->client_id);
        }

        // Filtro por fecha desde
        if ($request->has('date_from') && $request->date_from != '') {
            $query->whereDate('transaction_date', '>=', $request->date_from);
        }

        // Filtro por fecha hasta
        if ($request->has('date_to') && $request->date_to != '') {
            $query->whereDate('transaction_date', '<=', $request->date_to);
        }

        // Filtro por cliente (si está presente en la solicitud)
        if ($request->has('location_id') && $request->location_id != '') {
            $query->where('location_id', $request->location_id);
        }

        // Obtener los resultados con paginación
        $transaction = $query->paginate(10);

        //dd($transaction );

        return view('expense.index_apply', compact('transaction','clients','locations'));
    }

    public function create(Request $request,$id)
    {
        $business_id = request()->session()->get('user.business_id');

        // Obtener todos los clientes
        $clients = Contact::where('business_id', $business_id)->get();
        $locations = BusinessLocation::where('business_id', $business_id)->get();

        $tipo_retencion_fuente = TipoRetencion::where('type','F')->get();
        $tipo_retencion_iva = TipoRetencion::where('type','I')->get();

        $transaction = Transaction::with('contact','location','tax',
        'types_of_service','sri','retencion.dt','purchase_lines','sell_lines')
                        ->where('business_id', $business_id)
                        ->whereIn('type', ['expense','purchase'])
                        ->whereIn('status',['final','received'])
                        ->find($id);       
        

            // Cargar retenciones existentes en un arreglo
        $retencionesExistentes = [];
        if ($transaction && $transaction->retencion) {
            //dd($transaction->retencion->dt);
            foreach ($transaction->retencion->dt as $retencion) {
                $retencionesExistentes[] = [
                    'descripcion' => $retencion->description,
                    'porcentaje' => $retencion->percentage,
                    'monto' => $retencion->amount,
                    'retencion' => $retencion->retention,
                    'tipoRetencion' => $retencion->type,
                    'code'=> $retencion->code
                ];
            }
        }

        //dd($retencionesExistentes);

        return view('expense.apply_add', compact(
            'transaction','clients','locations',
            'tipo_retencion_fuente','tipo_retencion_iva',
            'retencionesExistentes'
        ));
    }

    public function store(Request $request){

        // Validar los datos de entrada
        $validated = $request->validate([
            'retenciones' => 'required|array|min:1', // Debe ser un arreglo con al menos un elemento
            'retenciones.*.descripcion' => 'required|string|max:255', // Descripción de la retención
            'retenciones.*.porcentaje' => 'required|numeric|min:0|max:100', // Porcentaje entre 0 y 100
            'retenciones.*.monto' => 'required|numeric|min:0', // Monto no negativo
            'retenciones.*.retencion' => 'required|numeric|min:0', // Retención no negativa
            'retenciones.*.tipoRetencion' => 'required|string|in:Fuente,IVA', // Tipo debe ser "Fuente" o "IVA"
            'retenciones.*.code' => 'required', // Tipo debe ser "Fuente" o "IVA"
            //'retenciones.*.value' => 'required', // Tipo debe ser "Fuente" o "IVA"
            'transaction_id' => 'required|integer|exists:transactions,id', // Debe ser un ID válido en la tabla `transactions`
            'total_retenido' => 'required|numeric|min:0', // Total retenido no negativo
            'document'=> 'required',
            'authorization'=> 'required'
        ]);

        
             // Obtener los datos validados
        $data = $validated['retenciones'];
        $transactionId = $validated['transaction_id'];
        $totalRetenido = $validated['total_retenido'];

        $ret = Retencion::where('transaction_id',$transactionId)->first();

        if(!$ret){
            $ret = new Retencion();
        }
        
        $ret->transaction_id = $request->transaction_id;
        $ret->total = $request->total_retenido;
        $ret->document = $request->document;
        $ret->authorization = $request->authorization;
        $ret->save();

        RetencionDt::where('retention_id',$ret->id)->delete();

        // Procesar y guardar los datos en la base de datos
        foreach ($data as $retencion) {
            $retDt = new RetencionDt();
            $retDt->retention_id = $ret->id;
            $retDt->description = $retencion['descripcion'];
            $retDt->percentage = $retencion['porcentaje'];
            $retDt->amount = $retencion['monto'];
            $retDt->retention = $retencion['retencion'];
            $retDt->type = $retencion['tipoRetencion'];
            $retDt->code = $retencion['code'];            
            $retDt->save();
            /*Retencion::create([
                'transaction_id' => $transactionId,
                'descripcion' => $retencion['descripcion'],
                'porcentaje' => $retencion['porcentaje'],
                'monto' => $retencion['monto'],
                'retencion' => $retencion['retencion'],
                'tipo_retencion' => $retencion['tipoRetencion'],
            ]);*/
        }

        // Responder con éxito
        return response()->json([
            'message' => 'Datos guardados exitosamente',
            'total_retenido' => $totalRetenido,
        ], 200);


    }


    public function sendSRI(Request $request, $id){

        $business_id = request()->session()->get('user.business_id');
        /*$transaction = Transaction::with(            
                        'contact','location.business','tax',
                        'types_of_service','sell_lines.product.product_tax',
                        'payment_lines', 'sri'
                        )
                        ->where('business_id', $business_id)
                        ->where('type', 'sell')
                        ->find($id);*/

        $transaction = Transaction::with('contact','location','tax',
        'types_of_service','sri','retencion.dt','format')
                        ->where('business_id', $business_id)
                        ->whereIn('type', ['expense','purchase'])
                        ->whereIn('status',['final','received'])
                        ->find($id);

        //dd($transaction);

        if($transaction->sri != null && count($transaction->sri) > 0){
            if($transaction->sri[0]->estado == 'AUTORIZADO'){

                $dResponse=[
                    "success"=> true,
                    "data" =>[
                        "estado" => 'COMPLETADO'
                    ],                    
                    "message" => 'El documento ya fue procesado'
                ];

                $existsPay = TransactionPayment::where('transaction_id',$id)
                ->where('business_id', $business_id)
                ->where('payment_ref_no', $transaction->invoice_no)
                ->first();

                if(!$existsPay){
                    $pay = new TransactionPayment();
                    $pay->transaction_id = $id;
                    $pay->business_id = $business_id;
                    $pay->amount = $transaction->retencion->total;
                    $pay->method = 'cash';
                    $pay->paid_on = \Carbon\Carbon::now()->format('Y-m-d H:i:s');
                    $pay->note = 'PAGO A TRAVEZ DE RETENCION';
                    $pay->payment_ref_no = $transaction->invoice_no;
                    $pay->save();
                }

                return response()->json($dResponse, 200);
            }elseif($transaction->sri[0]->respuesta_error_sri_msg == 'LIMITE DE INTENTOS NO AUTORIZADOS POR DIA'){
                if($transaction->sri[0]->updated_at->isToday()){
                    $dResponse=[
                        "success"=> true,
                        "data" =>[
                            "estado" => 'LIMITE'
                        ],                    
                        "message" => 'El documento ya excedio el limite de intentos'
                    ];
                    return response()->json($dResponse, 200);
                }
            }elseif($transaction->sri[0]->respuesta_error_sri_msg == 'CLAVE ACCESO REGISTRADA'){
                $dResponse=[
                    "success"=> true,
                    "data" =>[
                        "estado" => 'CLAVE_ACCESO_REGISTRADA'
                    ],                    
                    "message" => 'El documento la clave de acceso registrada'
                ];
                return response()->json($dResponse, 200);
            }

            
        }

        //dd($transaction);

        $formatted_invoice_no = '';

        /*if ($transaction) {
            // Verificar si $transaction->invoice_no tiene el formato esperado
            $invoice_no = $transaction->ref_no ?? '';
            //dd($invoice_no,preg_match('/^\w{6}\/\d+$/', $invoice_no),preg_match('/^[A-Za-z0-9]{6}\/\d+$/', $invoice_no));
            if (preg_match('/^\w{6}\/\d+$/', $invoice_no)) {
                // Extraer la parte numérica después de '/'
                preg_match('/\/(\d+)$/', $invoice_no, $matches);
                $numeric_part = str_pad($matches[1], 9, '0', STR_PAD_LEFT); // Rellenar con ceros hasta 9 dígitos
        
                // Extraer los primeros 7 caracteres de $transaction->transaction_parent->invoice_no
                $parent_invoice_no = $transaction->ref_no ?? '';
                if($transaction->type=='expense'){
                    $parent_prefix = $transaction->format->format_retencion;
                }elseif($transaction->type=='purchase'){                
                    $parent_prefix = $transaction->format->format_retencion_purcharse;
                }

                $formatted_invoice_no = "{$parent_prefix}-{$numeric_part}";
        
            } else {
                //echo "El formato de 'invoice_no' no coincide con el esperado. No se realiza ninguna acción.";
            }
        }*/

        // Verifica si el número de factura está vacío
        if (empty($transaction->invoice_no)) {
            // Define el prefijo del número de factura (puedes personalizarlo)
            $parent_prefix =$transaction->format->format_retencion ?? '001-001';

            // Obtén la secuencia inicial
            $sequence = $transaction->format->sequence ?? 1;
            
            // Obtén la secuencia inicial
            $numeric_part = str_pad($sequence, 9, '0', STR_PAD_LEFT); // Rellenar con ceros hasta 9 dígitos          
            
            // Formatea el número de factura inicial
            $formatted_invoice_no = "{$parent_prefix}-{$numeric_part}";
            
            // Busca si el número ya existe
            while (Transaction::where('invoice_no', $formatted_invoice_no)->where('business_id', $business_id)->whereIn('type', ['expense','purchase'])->whereIn('status',['final','received'])->exists()) {
                $sequence++; // Incrementa la secuencia

                // Obtén la secuencia inicial
                $numeric_part = str_pad($sequence, 9, '0', STR_PAD_LEFT); // Rellenar con ceros hasta 9 dígitos 
                
                $formatted_invoice_no = "{$parent_prefix}-{$numeric_part}"; // Reasigna el nuevo número
            }

            $sequence++;
            
            // Asigna el número de factura formateado al objeto transacción
            $transaction->invoice_no = $formatted_invoice_no;
            
            // Actualiza la secuencia en el formato
            $transaction->format->timestamps = false;
            $transaction->format->sequence = $sequence;
            $transaction->format->save();
            
            // Guarda la transacción
            $transaction->save();
        }

        //dd($formatted_invoice_no);

        if($formatted_invoice_no  != ''){
            //$transaction_update = Transaction::find($id);
            //$transaction_update->invoice_no = $formatted_invoice_no;
            //$transaction_update->save();

            $transaction = Transaction::with('contact','location','tax',
            'types_of_service','sri','retencion.dt')
                            ->where('business_id', $business_id)
                            ->whereIn('type', ['expense','purchase'])
                            ->whereIn('status',['final','received'])
                            ->find($id);
        }


        $direccion_sucursal = $transaction->location->country.' - '.$transaction->location->state.' - '.$transaction->location->city;
        //$contact_type = $transaction->contact->contact_type == 'individual' ? 5 : 4;

        if($transaction->contact->contact_type=='individual'){
            $contact_type = 5;
        }elseif ($transaction->contact->contact_type=='business') {
            $contact_type = 4;
        }elseif ($transaction->contact->contact_type=='passport') {
            $contact_type = 6;
        }

        $contact_id = $transaction->contact->contact_id;

        if($contact_id=='9999999999999'){
            $contact_type = 7;
        }

        $payment = [
            'cash' => [
                "codigoSriDocumentoElectronico" => "01",
                "monto" => 0,
                "cantidadDias" => 0,
                "descripcion" => "SIN UTILIZACION DEL SISTEMA FINACIERO",
            ],
            'card' => [
                "codigoSriDocumentoElectronico" => "16",
                "monto" => 0,
                "cantidadDias" => 0,
                "descripcion" => "TARJETA",
            ],
            'cheque' => [
                "codigoSriDocumentoElectronico" => "20",
                "monto" => 0,
                "cantidadDias" => 0,
                "descripcion" => "OTROS CON UTILIZACIÓN DEL SISTEMA FINACIERO",
            ], 
            'bank_transfer' => [
                "codigoSriDocumentoElectronico" => "17",
                "monto" => 0,
                "cantidadDias" => 0,
                "descripcion" => "DINERO ELECTRONICO",
            ],
            'other' => [
                "codigoSriDocumentoElectronico" => "20",
                "monto" => 0,
                "cantidadDias" => 0,
                "descripcion" => "OTROS CON UTILIZACIÓN DEL SISTEMA FINACIERO",
            ]
        ];

        $listPayment = [];

        foreach($transaction->payment_lines as $pay){
            $itemPay = $payment[$pay->method] ? $payment[$pay->method] : $payment['other'];
            $itemPay['monto'] = $pay->amount;
            $listPayment[]=$itemPay; 
        }

        $listProduct = [];
        $baseGravableIva = 0;
        $baseNoGravableIva = 0;
        $tax_amount = 0;
        $tax_product = 0;



        //dd($transaction->sell_lines);

        /*foreach($transaction->sell_lines as $item){
            $subtotalProducto = $item->quantity * $item->unit_price_before_discount;
            $item_tax_total = $item->item_tax * $item->quantity;
            $itemProduct =[
                "codigoPrincipal" => strval($item->product->sku),
                "codigoAuxiliar" => strval($item->product->sku),
                "descripcionProducto" => $item->product->name,
                "notaProducto" => "",
                "cantidad" => $item->quantity,
                "precioUnitario" => $item->unit_price_before_discount,
                "subtotalProducto" => $subtotalProducto,
                "descuentoProducto" => $item->line_discount_amount,
                "montoIvaProducto" => $item_tax_total 
            ];

            $tax_amount = $tax_amount + $item_tax_total;

            if($item->item_tax > 0){
                $tax_product=$item->product->product_tax->amount;
                $baseGravableIva = $baseGravableIva + $subtotalProducto;
            }else{
                $baseNoGravableIva = $baseNoGravableIva + $subtotalProducto;
            }

            $listProduct[] = $itemProduct;
        }*/

        $impuesto = [
            '0' => [
                "codigoSriAts" => "2",
                "codigoSriDocumentoElectronico" => "0",
                "porcentaje" => 0.00,
            ],
            '13' => [
                "codigoSriAts" => "2",
                "codigoSriDocumentoElectronico" => "10",
                "porcentaje" => 13.00,
            ],
            '14' => [
                "codigoSriAts" => "2",
                "codigoSriDocumentoElectronico" => "3",
                "porcentaje" => 14.00,
            ],
            '15' => [
                "codigoSriAts" => "2",
                "codigoSriDocumentoElectronico" => "4",
                "porcentaje" => 15.00,
            ],
            '5' => [
                "codigoSriAts" => "2",
                "codigoSriDocumentoElectronico" => "5",
                "porcentaje" => 5.00,
            ]
        ];

        //$tax = $impuesto[(int)$transaction->tax->amount];
        //$tax_0 = $impuesto['0'];

        $tax = $impuesto[(int)$tax_product != 0 ? (int)$tax_product : 0 ];
        $tax_0 = $impuesto['0'];

        $payment = [
            'cash' => [
                "codigoSriDocumentoElectronico" => "01",
                "monto" => 0,
                "cantidadDias" => 0,
                "descripcion" => "SIN UTILIZACION DEL SISTEMA FINACIERO",
            ],
            'card' => [
                "codigoSriDocumentoElectronico" => "16",
                "monto" => 0,
                "cantidadDias" => 0,
                "descripcion" => "TARJETA",
            ],
            'cheque' => [
                "codigoSriDocumentoElectronico" => "20",
                "monto" => 0,
                "cantidadDias" => 0,
                "descripcion" => "OTROS CON UTILIZACIÓN DEL SISTEMA FINACIERO",
            ], 
            'bank_transfer' => [
                "codigoSriDocumentoElectronico" => "17",
                "monto" => 0,
                "cantidadDias" => 0,
                "descripcion" => "DINERO ELECTRONICO",
            ],
            'other' => [
                "codigoSriDocumentoElectronico" => "20",
                "monto" => 0,
                "cantidadDias" => 0,
                "descripcion" => "OTROS CON UTILIZACIÓN DEL SISTEMA FINACIERO",
            ]
        ];

        if(count($listPayment) == 0){
            $itemPay = $payment['other'];
            $itemPay['monto'] = number_format($transaction->final_total,2,'.','');
            $listPayment[]=$itemPay; 
        }

        $numDocSustentoOriginal = $transaction->retencion->document;
        $numDocSustento = str_replace('-', '', $transaction->retencion->document);
        $numAutDocSustento = $transaction->retencion->authorization;

        $dataRetencion=[];

        foreach($transaction->retencion->dt as $itemRet){
            $dataRetencion[]=[
                "codigo" => $itemRet->type=='Fuente' ? 1 : 2,
                "codigoRetencion" => $itemRet->code,
                "baseImponible" => $itemRet->amount,
                "porcentajeRetener" => $itemRet->percentage,
                "valorRetenido" => $itemRet->retention
            ];
        }

        $baseGravableIva = $transaction->total_before_tax;
        $baseNoGravableIva = 0;
        $tax_amount = $transaction->tax_amount;

        $data = [
            "dataEmpresa" => [
                "id" => $business_id,
                "ambiente" => env('ambiente'),
                "emision" => 1,
                "razonSocial" => $transaction->location->business->name,
                "nombreComercial" => $transaction->location->name,
                "ruc" => env('RUC'),
                "direccion" => env('direccion'),
                "obligadoContabilidad" => env('obligadoContabilidad'),
                "agenteRetenedor" => env('agenteRetenedor'),
                "resolucionAgenteRetenedor" => env('resolucionAgenteRetenedor'),
                "contribuyenteRimpe" => env('contribuyenteRimpe'),
                "contribuyenteRimpeNegocioPopular" => env('contribuyenteRimpeNegocioPopular'),
                "contribuyenteEspecial" => env('contribuyenteEspecial'),
                "idContribuyenteEspecial" => env('idContribuyenteEspecial'),
                "email" => $transaction->location->business->email ? $transaction->location->business->email: env('email'),
                "rutaLogo" => "logos/1204763948001/logo.png",
                "logoGeneral" => "logos/logo_general.png"
            ],
            "dataInfo" => [
                "numeroDocumento" => $transaction->invoice_no,
                "direccionBodega" =>  $direccion_sucursal,
                "fecha" => \Carbon\Carbon::parse($transaction->retencion->created_at)->format('d-m-Y'),
                "email1" => $transaction->contact->email,
                "email2" => "",
                "email3" => "",
                "codigoCliente" => str_pad($transaction->contact->id, 9, '0', STR_PAD_LEFT),
                "idTipoIdentificacion" => "$contact_type",
                "razonSocial" => $transaction->contact->name,
                "identificacion" => $transaction->contact->contact_id,
                "direccion" =>  $transaction->contact->address_line_1 != null && $transaction->contact->address_line_1 != '' ? $transaction->contact->address_line_1 : "Sin direccion",
                "ciudad" => $transaction->contact->country,
                "telefono" => $transaction->contact->mobile,
                "subtotal" => number_format($baseGravableIva+$baseNoGravableIva,2,'.',''),
                "descuento" => number_format($transaction->discount_amount,2,'.',''),
                "baseGravableIva" => number_format($baseGravableIva,2,'.',''),
                "baseNoGravableIva" => number_format($baseNoGravableIva,2,'.',''),
                "montoIva" => number_format($tax_amount,2,'.',''),
                "montoRecargo" => 0.00,
                "flete" => 0.00,
                "montoNeto" => number_format($transaction->final_total,2,'.',''),
                "moneda" => 'DOLAR',
                "clave" => '12345678',
                "parteRel" => "N",
                "periodoFiscal" => \Carbon\Carbon::parse($transaction->transaction_date)->format('m/Y'),
                "codSustento" => "01",
                "codDocSustento" => "01",
                "numDocSustentoOriginal" => $numDocSustentoOriginal,
                "numDocSustento" => $numDocSustento,
                "fechaEmisionDocSustento" => \Carbon\Carbon::parse($transaction->transaction_date)->format('d-m-Y'),
                "fechaRegistroContable" => \Carbon\Carbon::parse($transaction->transaction_date)->format('d-m-Y'),
                "numAutDocSustento" => $numAutDocSustento,
                "pagoLocExt" => "01"
            ],
            "dataTipoImpuesto" => $tax,
            "dataTipoImpuesto_0" => $tax_0,
            "dataPago" => $listPayment,
            "dataItem" => $listProduct,
            "dataItemAdicional" => [
                ["campo" => "codigo"],
                ["campo" => "email"],
                ["campo" => "direccion"]
            ],
            "dataInfoAdicional" => [
                
            ],
            "dataRetencion" => $dataRetencion
        ];

        //dd($data);

        $jsonData = json_encode($data);

        // Opcional: verifica el resultado
        if ($jsonData === false) {
            echo "Error al convertir el array a JSON: " . json_last_error_msg();
        } else {
            //echo $jsonData; // Muestra el JSON o envíalo a la API
            //dd($jsonData);
        }

        // Enviar los datos JSON a la API con CURL
        /*$ch = curl_init(env('URL_FACTURACION') . '/factura/create'); // Reemplaza con la URL de tu API
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
        ]);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);

        $response = curl_exec($ch);*/

        $url = env('URL_FACTURACION') . '/retencion/create';

        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_POST, TRUE);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $jsonData);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($curl);

        $http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);

        //print_r($response);
        //dd($response);

        if ($response === false) {
            echo "Error en la solicitud CURL: " . curl_error($curl);
            /*Log::error('API request failed', [
                'status' => $response->status(),
                'response' => $response->body()
            ]);*/

            //dd(1,$response);
            return response()->json(['error' => 'API request failed'], 500);

        } else {
            //dd(2,$response);
            // Decodificar JSON a un array asociativo en PHP
            $decodedResponse = json_decode($response, true);

            

            /*$result = [
                'success' => true,
                'data'    => json_decode($response),
                'message' => '',
            ];*/

            //$decodedResponse['data']['errors'] = json_decode($decodedResponse['data']['errors'], true);

            // Verifica si existen 'data' y 'errors' antes de intentar decodificar
            if (isset($decodedResponse['data']['errors'])) {
                $decodedResponse['data']['errors'] = json_decode($decodedResponse['data']['errors'], true);
                
                // Verifica si json_decode falló
                if (json_last_error() !== JSON_ERROR_NONE) {
                    // Maneja el error de JSON
                    //Log::error('Error decodificando JSON:', ['error' => json_last_error_msg()]);
                    $decodedResponse['data']['errors'] = null; // Asigna un valor por defecto si es necesario
                    $decodedResponse['data']['errors_general'] = $decodedResponse['data']['errors'];
                }
            }

            //dd($decodedResponse);
            //PASO SIGUIENTE
            /*  
                - RUC
                - DOCUMENTO
                - AMBIENTE
                - FECHA
                - CREAR UNA TABLA DE FACTURACION ELECTRONICA CON LOS SIGUIENTE CAMPOS
                - CLAVE DE ACCESO        
                - CLAVE DE AUTORIZACION
                - VENTA ID
                - FECHA DE AUTORIZACION
                - ESTADO
                - ERRORS
                - LINK PDF
                - LINK XML GENERADO
                - LINL XML AUTORIADO
            */

            /*
                REENVIO AL SRI
                IMPRIMIR TICKET
                IMPRIMIR RIDE
                IMPRIMIR XML
                REENVIO AL CLIENTE
            */

            $validar = 0;

            if (
                isset($decodedResponse['data']) &&
                $decodedResponse['data']['respuesta'] === 'DEVUELTA' &&
                $decodedResponse['data']['connection'] === 'correcta' &&
                isset($decodedResponse['data']['errors']) &&
                $decodedResponse['data']['errors']['estado'] === 'DEVUELTA' &&
                isset($decodedResponse['data']['errors']['comprobantes']['comprobante']['mensajes']['mensaje']) &&
                $decodedResponse['data']['errors']['comprobantes']['comprobante']['mensajes']['mensaje']['mensaje'] === 'CLAVE ACCESO REGISTRADA'
            ) {
                $validar = 3;
            }

            $respuesta_error_sri = '';
            $respuesta_error_sri_msg = '';
            // Validación paso a paso
            if (isset($decodedResponse['data'])) {
                if (isset($decodedResponse['data']['errors'])) {
                    if (isset($decodedResponse['data']['errors']['comprobantes'])) {
                        if (isset($decodedResponse['data']['errors']['comprobantes']['comprobante'])) {
                            if (isset($decodedResponse['data']['errors']['comprobantes']['comprobante']['mensajes'])) {
                                if (isset($decodedResponse['data']['errors']['comprobantes']['comprobante']['mensajes']['mensaje'])) {
                                    // Guardar el valor de 'mensaje' si se encuentra
                                    $respuesta_error_sri = $decodedResponse['data']['errors']['comprobantes']['comprobante']['mensajes']['mensaje'];
                                    if(isset($decodedResponse['data']['errors']['comprobantes']['comprobante']['mensajes']['mensaje']['mensaje'])){
                                        $respuesta_error_sri_msg = $decodedResponse['data']['errors']['comprobantes']['comprobante']['mensajes']['mensaje']['mensaje'];
                                    }
                                }
                            }
                        }
                    }
                }
            }

            if(isset($decodedResponse['data']) &&
                isset($decodedResponse['data']['connection']) && 
                $decodedResponse['data']['connection'] != 'correcta' && 
                isset($decodedResponse['data']['errors_connection']) != ''
            ){
                $validar = 1;
            }

            

            $clave_acceso = isset($decodedResponse['data']) && 
            isset($decodedResponse['data']['claveAcceso']) ? 
            $decodedResponse['data']['claveAcceso'] : '';

            $connection = isset($decodedResponse['data']) && 
            isset($decodedResponse['data']['connection']) ? 
            $decodedResponse['data']['connection'] : '';

            $errors = isset($decodedResponse['data']) && 
            isset($decodedResponse['data']['errors']) ? 
            $decodedResponse['data']['errors'] : '';

            $respuesta = isset($decodedResponse['data']) && 
            isset($decodedResponse['data']['respuesta']) ? 
            $decodedResponse['data']['respuesta'] : '';

            $link_xml_unsigned = isset($decodedResponse['data']) && 
            isset($decodedResponse['data']['unsigned']) ? 
            $decodedResponse['data']['unsigned'] : '';

            $link_xml_signed = isset($decodedResponse['data']) && 
            isset($decodedResponse['data']['signed']) ? 
            $decodedResponse['data']['signed'] : '';

            $link_pdf = isset($decodedResponse['data']) && 
            isset($decodedResponse['data']['nombreFile']) ? 
            $decodedResponse['data']['nombreFile'].'.pdf' : '';

            $estado = isset($decodedResponse['data']) && 
            isset($decodedResponse['data']['estado']) ? 
            $decodedResponse['data']['estado'] : '';

            // Acceder a los elementos del XML
            $numeroAutorizacion = '';
            $fechaAutorizacion = '';

            if($estado == ''){
                $estado == "SRI NO PROCESO";
            }elseif($estado== "NO AUTORIZADO"){
                if (
                    isset($decodedResponse['data']) &&
                    isset($decodedResponse['data']['errors']) &&
                    isset($decodedResponse['data']['errors']['autorizaciones']) &&
                    isset($decodedResponse['data']['errors']['autorizaciones']['autorizacion']) &&
                    isset($decodedResponse['data']['errors']['autorizaciones']['autorizacion']) &&
                    isset($decodedResponse['data']['errors']['autorizaciones']['autorizacion']['mensajes'])
                ) {
                    // Extraer el contenido de `mensaje`
                    $respuesta_error_sri = $decodedResponse['data']['errors']['autorizaciones']['autorizacion']['mensajes'];
                    if(isset($decodedResponse['data']['errors']['autorizaciones']['autorizacion']['mensajes']['mensaje']) &&
                    isset($decodedResponse['data']['errors']['autorizaciones']['autorizacion']['mensajes']['mensaje']['mensaje'])){
                        $respuesta_error_sri_msg = $decodedResponse['data']['errors']['autorizaciones']['autorizacion']['mensajes']['mensaje']['mensaje'];
                    }
                    //console.log("Contenido de mensaje:", mensaje);
                }
            }elseif($estado=='AUTORIZADO'){
                $xmlContent = $decodedResponse['data']['autorized']; // Aquí pones el contenido de tu XML

                // Crear el objeto XML
                $xml = new \SimpleXMLElement($xmlContent);

                // Acceder a los elementos del XML
                $numeroAutorizacion = (string) $xml->numeroAutorizacion;
                $fechaAutorizacion = (string) $xml->fechaAutorizacion;

                $existsPay = TransactionPayment::where('transaction_id',$id)
                ->where('business_id', $business_id)
                ->where('payment_ref_no', $transaction->invoice_no)
                ->first();

                if(!$existsPay){
                    $pay = new TransactionPayment();
                    $pay->transaction_id = $id;
                    $pay->business_id = $business_id;
                    $pay->amount = $transaction->retencion->total;
                    $pay->method = 'cash';
                    $pay->paid_on = \Carbon\Carbon::now()->format('Y-m-d H:i:s');
                    $pay->note = 'PAGO A TRAVEZ DE RETENCION';
                    $pay->payment_ref_no = $transaction->invoice_no;
                    $pay->save();
                }
            }

        

            $decodedResponse['data']['validar'] = $validar;
            $decodedResponse['data']['respuesta_error_sri'] = $respuesta_error_sri;
            $decodedResponse['data']['respuesta_error_sri_msg'] = $respuesta_error_sri_msg;

            $fact = FacturacionElectronica::where('venta_id',$id)
            ->where('ruc',env('RUC'))
            ->where('documento',$transaction->invoice_no)
            ->first();

            if(!$fact){
                $fact = new FacturacionElectronica();
            }            
            $fact->ruc = env('RUC');
            $fact->documento = $transaction->invoice_no;
            $fact->fecha = \Carbon\Carbon::parse($transaction->transaction_date)->format('Y-m-d');
            $fact->ambiente = env('ambiente');
            $fact->venta_id = $id;
            $fact->clave_acceso = $clave_acceso;
            $fact->fecha_autorizacion = $fechaAutorizacion;
            $fact->autorizacion = $numeroAutorizacion;
            $fact->link_xml_unsigned = $link_xml_unsigned;
            $fact->link_xml_signed = $link_xml_signed;
            $fact->link_pdf = $link_pdf;
            $fact->errors = json_encode($errors);
            $fact->respuesta = $respuesta;
            $fact->conexion = $connection;
            $fact->validar = $validar;
            $fact->respuesta_error_sri = json_encode($respuesta_error_sri);
            $fact->respuesta_error_sri_msg = $respuesta_error_sri_msg;
            $fact->estado = $estado;
            //dd($fact);
            $fact->save();
    
            return response()->json($decodedResponse, 200);
            //echo "Respuesta de la API: " . $response;
        }

        curl_close($curl);

        //dd($response);

        //dd($transaction,$data);




    }

    public function sendSRIClaveRegistrada(Request $request, $id){

        $business_id = request()->session()->get('user.business_id');
        $transaction = Transaction::with('contact','location','tax',
        'types_of_service','sri','retencion.dt','format')
                        ->where('business_id', $business_id)
                        ->whereIn('type', ['expense','purchase'])
                        ->whereIn('status',['final','received'])
                        ->find($id);

        if($transaction->sri != null && count($transaction->sri) > 0){
            if($transaction->sri[0]->estado == 'AUTORIZADO'){

                $dResponse=[
                    "success"=> true,
                    "data" =>[
                        "estado" => 'COMPLETADO'
                    ],                    
                    "message" => 'El documento ya fue procesado'
                ];

                $existsPay = TransactionPayment::where('transaction_id',$id)
                ->where('business_id', $business_id)
                ->where('payment_ref_no', $transaction->invoice_no)
                ->first();

                if(!$existsPay){
                    $pay = new TransactionPayment();
                    $pay->transaction_id = $id;
                    $pay->business_id = $business_id;
                    $pay->amount = $transaction->retencion->total;
                    $pay->method = 'cash';
                    $pay->paid_on = \Carbon\Carbon::now()->format('Y-m-d H:i:s');
                    $pay->note = 'PAGO A TRAVEZ DE RETENCION';
                    $pay->payment_ref_no = $transaction->invoice_no;
                    $pay->save();
                }

                return response()->json($dResponse, 200);
            }elseif($transaction->sri[0]->respuesta_error_sri_msg == 'LIMITE DE INTENTOS NO AUTORIZADOS POR DIA'){
                if($transaction->sri[0]->updated_at->isToday()){
                    $dResponse=[
                        "success"=> true,
                        "data" =>[
                            "estado" => 'LIMITE'
                        ],                    
                        "message" => 'El documento ya excedio el limite de intentos'
                    ];
                    return response()->json($dResponse, 200);
                }
            }elseif($transaction->sri[0]->respuesta_error_sri_msg != 'CLAVE ACCESO REGISTRADA'){
                $dResponse=[
                    "success"=> true,
                    "data" =>[
                        "estado" => 'SINPROCESO'
                    ],                    
                    "message" => 'El documento sin proceso'
                ];
                return response()->json($dResponse, 200);
            }elseif($transaction->sri[0]->respuesta_error_sri_msg == 'CLAVE ACCESO REGISTRADA'){   
                
                $fechaSend = \Carbon\Carbon::parse($transaction->sri[0]->fecha)->format('d-m-Y');
            
                $data = [
                    "claveAcceso" =>$transaction->sri[0]->clave_acceso,
                    "ruc" => $transaction->sri[0]->ruc,
                    "documento" => $transaction->sri[0]->documento,
                    "ambiente" => $transaction->sri[0]->ambiente,
                    "fecha" => $fechaSend
                ];

                // Convertir el array a JSON
                $jsonData = json_encode($data);

                // Opcional: verifica el resultado
                if ($jsonData === false) {
                    echo "Error al convertir el array a JSON: " . json_last_error_msg();
                } else {
                    //echo $jsonData; // Muestra el JSON o envíalo a la API
                    //dd($jsonData);
                }

                $url = env('URL_FACTURACION') . '/verififacion-documento';

                $curl = curl_init();
                curl_setopt($curl, CURLOPT_URL, $url);
                curl_setopt($curl, CURLOPT_POST, TRUE);
                curl_setopt($curl, CURLOPT_POSTFIELDS, $jsonData);
                curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
                curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                $response = curl_exec($curl);

                $http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);

                if ($response === false) {
                    echo "Error en la solicitud CURL: " . curl_error($curl);

                    //dd(1,$response);
                    return response()->json(['error' => 'API request failed'], 500);

                } else {
                    //dd(2,$response);
                    // Decodificar JSON a un array asociativo en PHP
                    $decodedResponse = json_decode($response, true);

                    //dd($decodedResponse);

                    // Verifica si existen 'data' y 'errors' antes de intentar decodificar
                    if (isset($decodedResponse['data']['errors'])) {
                        $decodedResponse['data']['errors'] = json_decode($decodedResponse['data']['errors'], true);
                        
                        // Verifica si json_decode falló
                        if (json_last_error() !== JSON_ERROR_NONE) {
                            // Maneja el error de JSON
                            //Log::error('Error decodificando JSON:', ['error' => json_last_error_msg()]);
                            $decodedResponse['data']['errors'] = null; // Asigna un valor por defecto si es necesario
                            $decodedResponse['data']['errors_general'] = $decodedResponse['data']['errors'];
                        }
                    }

                    $validar = 0;

                    if (
                        isset($decodedResponse['data']) &&
                        $decodedResponse['data']['respuesta'] === 'DEVUELTA' &&
                        $decodedResponse['data']['connection'] === 'correcta' &&
                        isset($decodedResponse['data']['errors']) &&
                        $decodedResponse['data']['errors']['estado'] === 'DEVUELTA' &&
                        isset($decodedResponse['data']['errors']['comprobantes']['comprobante']['mensajes']['mensaje']) &&
                        $decodedResponse['data']['errors']['comprobantes']['comprobante']['mensajes']['mensaje']['mensaje'] === 'CLAVE ACCESO REGISTRADA'
                    ) {
                        $validar = 3;
                    }

                    $respuesta_error_sri = '';
                    $respuesta_error_sri_msg = '';
                    // Validación paso a paso
                    if (isset($decodedResponse['data'])) {
                        if (isset($decodedResponse['data']['errors'])) {
                            if (isset($decodedResponse['data']['errors']['comprobantes'])) {
                                if (isset($decodedResponse['data']['errors']['comprobantes']['comprobante'])) {
                                    if (isset($decodedResponse['data']['errors']['comprobantes']['comprobante']['mensajes'])) {
                                        if (isset($decodedResponse['data']['errors']['comprobantes']['comprobante']['mensajes']['mensaje'])) {
                                            // Guardar el valor de 'mensaje' si se encuentra
                                            $respuesta_error_sri = $decodedResponse['data']['errors']['comprobantes']['comprobante']['mensajes']['mensaje'];
                                            if(isset($decodedResponse['data']['errors']['comprobantes']['comprobante']['mensajes']['mensaje']['mensaje'])){
                                                $respuesta_error_sri_msg = $decodedResponse['data']['errors']['comprobantes']['comprobante']['mensajes']['mensaje']['mensaje'];
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }

                    if(isset($decodedResponse['data']) &&
                        isset($decodedResponse['data']['connection']) && 
                        $decodedResponse['data']['connection'] != 'correcta' && 
                        isset($decodedResponse['data']['errors_connection']) != ''
                    ){
                        $validar = 1;
                    }

                    

                    $clave_acceso = isset($decodedResponse['data']) && 
                    isset($decodedResponse['data']['claveAcceso']) ? 
                    $decodedResponse['data']['claveAcceso'] : '';

                    $connection = isset($decodedResponse['data']) && 
                    isset($decodedResponse['data']['connection']) ? 
                    $decodedResponse['data']['connection'] : '';

                    $errors = isset($decodedResponse['data']) && 
                    isset($decodedResponse['data']['errors']) ? 
                    $decodedResponse['data']['errors'] : '';

                    $respuesta = isset($decodedResponse['data']) && 
                    isset($decodedResponse['data']['respuesta']) ? 
                    $decodedResponse['data']['respuesta'] : '';

                    $link_xml_unsigned = isset($decodedResponse['data']) && 
                    isset($decodedResponse['data']['unsigned']) ? 
                    $decodedResponse['data']['unsigned'] : '';

                    $link_xml_signed = isset($decodedResponse['data']) && 
                    isset($decodedResponse['data']['signed']) ? 
                    $decodedResponse['data']['signed'] : '';

                    $link_pdf = isset($decodedResponse['data']) && 
                    isset($decodedResponse['data']['nombreFile']) ? 
                    $decodedResponse['data']['nombreFile'].'.pdf' : '';

                    $estado = isset($decodedResponse['data']) && 
                    isset($decodedResponse['data']['estado']) ? 
                    $decodedResponse['data']['estado'] : '';

                    // Acceder a los elementos del XML
                    $numeroAutorizacion = '';
                    $fechaAutorizacion = '';

                    if($estado == ''){
                        $estado == "SRI NO PROCESO";
                    }elseif($estado== "NO AUTORIZADO"){
                        if (
                            isset($decodedResponse['data']) &&
                            isset($decodedResponse['data']['errors']) &&
                            isset($decodedResponse['data']['errors']['autorizaciones']) &&
                            isset($decodedResponse['data']['errors']['autorizaciones']['autorizacion']) &&
                            isset($decodedResponse['data']['errors']['autorizaciones']['autorizacion']) &&
                            isset($decodedResponse['data']['errors']['autorizaciones']['autorizacion']['mensajes'])
                        ) {
                            // Extraer el contenido de `mensaje`
                            $respuesta_error_sri = $decodedResponse['data']['errors']['autorizaciones']['autorizacion']['mensajes'];
                            if(isset($decodedResponse['data']['errors']['autorizaciones']['autorizacion']['mensajes']['mensaje']) &&
                            isset($decodedResponse['data']['errors']['autorizaciones']['autorizacion']['mensajes']['mensaje']['mensaje'])){
                                $respuesta_error_sri_msg = $decodedResponse['data']['errors']['autorizaciones']['autorizacion']['mensajes']['mensaje']['mensaje'];
                            }
                            //console.log("Contenido de mensaje:", mensaje);
                        }
                    }elseif($estado=='AUTORIZADO'){
                        $xmlContent = $decodedResponse['data']['autorized']; // Aquí pones el contenido de tu XML

                        // Crear el objeto XML
                        $xml = new \SimpleXMLElement($xmlContent);

                        // Acceder a los elementos del XML
                        $numeroAutorizacion = (string) $xml->numeroAutorizacion;
                        $fechaAutorizacion = (string) $xml->fechaAutorizacion;

                        $existsPay = TransactionPayment::where('transaction_id',$id)
                        ->where('business_id', $business_id)
                        ->where('payment_ref_no', $transaction->invoice_no)
                        ->first();

                        if(!$existsPay){
                            $pay = new TransactionPayment();
                            $pay->transaction_id = $id;
                            $pay->business_id = $business_id;
                            $pay->amount = $transaction->retencion->total;
                            $pay->method = 'cash';
                            $pay->paid_on = \Carbon\Carbon::now()->format('Y-m-d H:i:s');
                            $pay->note = 'PAGO A TRAVEZ DE RETENCION';
                            $pay->payment_ref_no = $transaction->invoice_no;
                            $pay->save();
                        }

                    }

                

                    $decodedResponse['data']['validar'] = $validar;
                    $decodedResponse['data']['respuesta_error_sri'] = $respuesta_error_sri;
                    $decodedResponse['data']['respuesta_error_sri_msg'] = $respuesta_error_sri_msg;

                    $fact = FacturacionElectronica::where('venta_id',$id)
                    ->where('ruc',env('RUC'))
                    ->where('documento',$transaction->invoice_no)
                    ->first();

                    if(!$fact){
                        $fact = new FacturacionElectronica();
                    }            
                    $fact->ruc = env('RUC');
                    $fact->documento = $transaction->invoice_no;
                    $fact->fecha = \Carbon\Carbon::parse($transaction->transaction_date)->format('Y-m-d');
                    //$fact->ambiente = env('ambiente');
                    $fact->venta_id = $id;
                    $fact->clave_acceso = $clave_acceso;
                    $fact->fecha_autorizacion = $fechaAutorizacion;
                    $fact->autorizacion = $numeroAutorizacion;
                    //$fact->link_xml_unsigned = $link_xml_unsigned;
                    //$fact->link_xml_signed = $link_xml_signed;
                    //$fact->link_pdf = $link_pdf;
                    $fact->errors = json_encode($errors);
                    $fact->respuesta = $respuesta;
                    $fact->conexion = $connection;
                    $fact->validar = $validar;
                    $fact->respuesta_error_sri = json_encode($respuesta_error_sri);
                    $fact->respuesta_error_sri_msg = $respuesta_error_sri_msg;
                    $fact->estado = $estado;
                    //dd($fact);
                    $fact->save();
            
                    return response()->json($decodedResponse, 200);
                    //echo "Respuesta de la API: " . $response;
                }

                curl_close($curl);



            }else{
                $dResponse=[
                    "success"=> true,
                    "data" =>[
                        "estado" => 'SINPROCESO_02'
                    ],                    
                    "message" => 'El documento sin proceso'
                ];
                return response()->json($dResponse, 200);
            }

            
        }else{
            $dResponse=[
                "success"=> true,
                "data" =>[
                    "estado" => 'SINPROCESO_02'
                ],                    
                "message" => 'El documento sin proceso'
            ];
            return response()->json($dResponse, 200);
        }

    }


    public function sendSRIRide(Request $request, $id){

        $business_id = request()->session()->get('user.business_id');
        $transaction = Transaction::with('contact','location','tax',
        'types_of_service','sri','retencion.dt','format')
                        ->where('business_id', $business_id)
                        ->whereIn('type', ['expense','purchase'])
                        ->whereIn('status',['final','received'])
                        ->find($id);

        //dd($transaction);

        if($transaction->sri != null && count($transaction->sri) > 0){
            if($transaction->sri[0]->estado != 'AUTORIZADO'){

                $dResponse=[
                    "success"=> true,
                    "data" =>[
                        "estado" => 'NO_COMPLETADO'
                    ],                    
                    "message" => 'El documento ya no fue procesado'
                ];

                return response()->json($dResponse, 200);
            }elseif($transaction->sri[0]->respuesta_error_sri_msg == 'LIMITE DE INTENTOS NO AUTORIZADOS POR DIA'){
                if($transaction->sri[0]->updated_at->isToday()){
                    $dResponse=[
                        "success"=> true,
                        "data" =>[
                            "estado" => 'LIMITE'
                        ],                    
                        "message" => 'El documento ya excedio el limite de intentos'
                    ];
                    return response()->json($dResponse, 200);
                }
            }elseif($transaction->sri[0]->respuesta_error_sri_msg == 'CLAVE ACCESO REGISTRADA'){
                $dResponse=[
                    "success"=> true,
                    "data" =>[
                        "estado" => 'CLAVE_ACCESO_REGISTRADA'
                    ],                    
                    "message" => 'El documento la clave de acceso registrada'
                ];
                return response()->json($dResponse, 200);
            }

            
        }


        $direccion_sucursal = $transaction->location->country.' - '.$transaction->location->state.' - '.$transaction->location->city;
        //$contact_type = $transaction->contact->contact_type == 'individual' ? 5 : 4;

        if($transaction->contact->contact_type=='individual'){
            $contact_type = 5;
        }elseif ($transaction->contact->contact_type=='business') {
            $contact_type = 4;
        }elseif ($transaction->contact->contact_type=='passport') {
            $contact_type = 6;
        }

        $contact_id = $transaction->contact->contact_id;

        if($contact_id=='9999999999999'){
            $contact_type = 7;
        }

        $payment = [
            'cash' => [
                "codigoSriDocumentoElectronico" => "01",
                "monto" => 0,
                "cantidadDias" => 0,
                "descripcion" => "SIN UTILIZACION DEL SISTEMA FINACIERO",
            ],
            'card' => [
                "codigoSriDocumentoElectronico" => "16",
                "monto" => 0,
                "cantidadDias" => 0,
                "descripcion" => "TARJETA",
            ],
            'cheque' => [
                "codigoSriDocumentoElectronico" => "20",
                "monto" => 0,
                "cantidadDias" => 0,
                "descripcion" => "OTROS CON UTILIZACIÓN DEL SISTEMA FINACIERO",
            ], 
            'bank_transfer' => [
                "codigoSriDocumentoElectronico" => "17",
                "monto" => 0,
                "cantidadDias" => 0,
                "descripcion" => "DINERO ELECTRONICO",
            ],
            'other' => [
                "codigoSriDocumentoElectronico" => "20",
                "monto" => 0,
                "cantidadDias" => 0,
                "descripcion" => "OTROS CON UTILIZACIÓN DEL SISTEMA FINACIERO",
            ]
        ];

        $listPayment = [];

        foreach($transaction->payment_lines as $pay){
            $itemPay = $payment[$pay->method] ? $payment[$pay->method] : $payment['other'];
            $itemPay['monto'] = $pay->amount;
            $listPayment[]=$itemPay; 
        }

        $listProduct = [];
        $baseGravableIva = 0;
        $baseNoGravableIva = 0;
        $tax_amount = 0;
        $tax_product = 0;



        //dd($transaction->sell_lines);

        /*foreach($transaction->sell_lines as $item){
            $subtotalProducto = $item->quantity * $item->unit_price_before_discount;
            $item_tax_total = $item->item_tax * $item->quantity;
            $itemProduct =[
                "codigoPrincipal" => strval($item->product->sku),
                "codigoAuxiliar" => strval($item->product->sku),
                "descripcionProducto" => $item->product->name,
                "notaProducto" => "",
                "cantidad" => $item->quantity,
                "precioUnitario" => $item->unit_price_before_discount,
                "subtotalProducto" => $subtotalProducto,
                "descuentoProducto" => $item->line_discount_amount,
                "montoIvaProducto" => $item_tax_total 
            ];

            $tax_amount = $tax_amount + $item_tax_total;

            if($item->item_tax > 0){
                $tax_product=$item->product->product_tax->amount;
                $baseGravableIva = $baseGravableIva + $subtotalProducto;
            }else{
                $baseNoGravableIva = $baseNoGravableIva + $subtotalProducto;
            }

            $listProduct[] = $itemProduct;
        }*/

        $impuesto = [
            '0' => [
                "codigoSriAts" => "2",
                "codigoSriDocumentoElectronico" => "0",
                "porcentaje" => 0.00,
            ],
            '13' => [
                "codigoSriAts" => "2",
                "codigoSriDocumentoElectronico" => "10",
                "porcentaje" => 13.00,
            ],
            '14' => [
                "codigoSriAts" => "2",
                "codigoSriDocumentoElectronico" => "3",
                "porcentaje" => 14.00,
            ],
            '15' => [
                "codigoSriAts" => "2",
                "codigoSriDocumentoElectronico" => "4",
                "porcentaje" => 15.00,
            ],
            '5' => [
                "codigoSriAts" => "2",
                "codigoSriDocumentoElectronico" => "5",
                "porcentaje" => 5.00,
            ]
        ];

        //$tax = $impuesto[(int)$transaction->tax->amount];
        //$tax_0 = $impuesto['0'];

        $tax = $impuesto[(int)$tax_product != 0 ? (int)$tax_product : 0 ];
        $tax_0 = $impuesto['0'];

        $payment = [
            'cash' => [
                "codigoSriDocumentoElectronico" => "01",
                "monto" => 0,
                "cantidadDias" => 0,
                "descripcion" => "SIN UTILIZACION DEL SISTEMA FINACIERO",
            ],
            'card' => [
                "codigoSriDocumentoElectronico" => "16",
                "monto" => 0,
                "cantidadDias" => 0,
                "descripcion" => "TARJETA",
            ],
            'cheque' => [
                "codigoSriDocumentoElectronico" => "20",
                "monto" => 0,
                "cantidadDias" => 0,
                "descripcion" => "OTROS CON UTILIZACIÓN DEL SISTEMA FINACIERO",
            ], 
            'bank_transfer' => [
                "codigoSriDocumentoElectronico" => "17",
                "monto" => 0,
                "cantidadDias" => 0,
                "descripcion" => "DINERO ELECTRONICO",
            ],
            'other' => [
                "codigoSriDocumentoElectronico" => "20",
                "monto" => 0,
                "cantidadDias" => 0,
                "descripcion" => "OTROS CON UTILIZACIÓN DEL SISTEMA FINACIERO",
            ]
        ];

        if(count($listPayment) == 0){
            $itemPay = $payment['other'];
            $itemPay['monto'] = number_format($transaction->final_total,2,'.','');
            $listPayment[]=$itemPay; 
        }

        $numDocSustentoOriginal = $transaction->retencion->document;
        $numDocSustento = str_replace('-', '', $transaction->retencion->document);
        $numAutDocSustento = $transaction->retencion->authorization;

        $dataRetencion=[];

        foreach($transaction->retencion->dt as $itemRet){
            $dataRetencion[]=[
                "codigo" => $itemRet->type=='Fuente' ? 1 : 2,
                "codigoRetencion" => $itemRet->code,
                "baseImponible" => $itemRet->amount,
                "porcentajeRetener" => $itemRet->percentage,
                "valorRetenido" => $itemRet->retention
            ];
        }

        $baseGravableIva = $transaction->total_before_tax;
        $baseNoGravableIva = 0;
        $tax_amount = $transaction->tax_amount;

        $data = [
            "dataEmpresa" => [
                "id" => $business_id,
                "ambiente" => env('ambiente'),
                "emision" => 1,
                "razonSocial" => $transaction->location->business->name,
                "nombreComercial" => $transaction->location->name,
                "ruc" => env('RUC'),
                "direccion" => env('direccion'),
                "obligadoContabilidad" => env('obligadoContabilidad'),
                "agenteRetenedor" => env('agenteRetenedor'),
                "resolucionAgenteRetenedor" => env('resolucionAgenteRetenedor'),
                "contribuyenteRimpe" => env('contribuyenteRimpe'),
                "contribuyenteRimpeNegocioPopular" => env('contribuyenteRimpeNegocioPopular'),
                "contribuyenteEspecial" => env('contribuyenteEspecial'),
                "idContribuyenteEspecial" => env('idContribuyenteEspecial'),
                "email" => $transaction->location->business->email ? $transaction->location->business->email: env('email'),
                "rutaLogo" => "logos/1204763948001/logo.png",
                "logoGeneral" => "logos/logo_general.png"
            ],
            "dataInfo" => [
                "numeroDocumento" => $transaction->invoice_no,
                "direccionBodega" =>  $direccion_sucursal,
                "fecha" => \Carbon\Carbon::parse($transaction->retencion->created_at)->format('d-m-Y'),
                "email1" => $transaction->contact->email,
                "email2" => "",
                "email3" => "",
                "codigoCliente" => str_pad($transaction->contact->id, 9, '0', STR_PAD_LEFT),
                "idTipoIdentificacion" => "$contact_type",
                "razonSocial" => $transaction->contact->name,
                "identificacion" => $transaction->contact->contact_id,
                "direccion" =>  $transaction->contact->address_line_1 != null && $transaction->contact->address_line_1 != '' ? $transaction->contact->address_line_1 : "Sin direccion",
                "ciudad" => $transaction->contact->country,
                "telefono" => $transaction->contact->mobile,
                "subtotal" => number_format($baseGravableIva+$baseNoGravableIva,2,'.',''),
                "descuento" => number_format($transaction->discount_amount,2,'.',''),
                "baseGravableIva" => number_format($baseGravableIva,2,'.',''),
                "baseNoGravableIva" => number_format($baseNoGravableIva,2,'.',''),
                "montoIva" => number_format($tax_amount,2,'.',''),
                "montoRecargo" => 0.00,
                "flete" => 0.00,
                "montoNeto" => number_format($transaction->final_total,2,'.',''),
                "moneda" => 'DOLAR',
                "clave" => $transaction->sri[0]->clave_acceso,
                "autorizacion"=> $transaction->sri[0]->autorizacion,
                "fechaAutorizacion"=> $transaction->sri[0]->fecha_autorizacion,
                "parteRel" => "N",
                "periodoFiscal" => \Carbon\Carbon::parse($transaction->transaction_date)->format('m/Y'),
                "codSustento" => "01",
                "codDocSustento" => "01",
                "numDocSustentoOriginal" => $numDocSustentoOriginal,
                "numDocSustento" => $numDocSustento,
                "fechaEmisionDocSustento" => \Carbon\Carbon::parse($transaction->transaction_date)->format('d-m-Y'),
                "fechaRegistroContable" => \Carbon\Carbon::parse($transaction->transaction_date)->format('d-m-Y'),
                "numAutDocSustento" => $numAutDocSustento,
                "pagoLocExt" => "01"
            ],
            "dataTipoImpuesto" => $tax,
            "dataTipoImpuesto_0" => $tax_0,
            "dataPago" => $listPayment,
            "dataItem" => $listProduct,
            "dataItemAdicional" => [
                ["campo" => "codigo"],
                ["campo" => "email"],
                ["campo" => "direccion"]
            ],
            "dataInfoAdicional" => [
                
            ],
            "dataRetencion" => $dataRetencion
        ];


        $jsonData = json_encode($data);

        // Opcional: verifica el resultado
        if ($jsonData === false) {
            echo "Error al convertir el array a JSON: " . json_last_error_msg();
        } else {
            //echo $jsonData; // Muestra el JSON o envíalo a la API
            //dd($jsonData);
        }

        $url = env('URL_FACTURACION') . '/retencion/create-ride';

        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_POST, TRUE);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $jsonData);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($curl);

        $http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);

        //dd($response);

        if ($response === false) {
            echo "Error en la solicitud CURL: " . curl_error($curl);
            /*Log::error('API request failed', [
                'status' => $response->status(),
                'response' => $response->body()
            ]);*/

            //dd(1,$response);
            return response()->json(['error' => 'API request failed'], 500);

        } else {
            //dd(2,$response);
            // Decodificar JSON a un array asociativo en PHP
            $decodedResponse = json_decode($response, true);

            return response()->json($decodedResponse, 200);
            //echo "Respuesta de la API: " . $response;
        }

        curl_close($curl);



    }

    public function reportRide(Request $request, $id){
        $sri = FacturacionElectronica::where('clave_acceso',$id)->first();

        $ruc = $sri->ruc;
        $folder = \Carbon\Carbon::parse($sri->fecha)->format('Y_m');
        $type = 'ride';
        $document = $sri->documento;
        $file= $id.'_'.$ruc.'_'.$document.'.pdf';
        //$url = env('URL_DOC').'/sri/'.$ruc.'/'.$folder.'/'.$type.'/'.$file;
        $url = env('URL_DOC_FILE').'/'.$ruc.'/'.$folder.'/'.$type.'/'.$file;

        //dd($url);

        return view('sales_order.ride', compact('url'));

    }

    public function reportXml(Request $request, $id){
        $sri = FacturacionElectronica::where('clave_acceso',$id)->first();

        $ruc = $sri->ruc;
        $folder = \Carbon\Carbon::parse($sri->fecha)->format('Y_m');
        $type = 'signed';
        $document = $sri->documento;
        $file= $id.'_'.$ruc.'_'.$document.'.xml';
        //$url = env('URL_DOC').'/sri/'.$ruc.'/'.$folder.'/'.$type.'/'.$file;
        $url = env('URL_DOC_FILE').'/'.$ruc.'/'.$folder.'/'.$type.'/'.$file;

        //dd($url);

        $xmlContent = file_get_contents($url);

        $escapedXmlContent = htmlspecialchars($xmlContent);

        $claveAcceso = $id;

        return view('sales_order.xml', compact('xmlContent','url','escapedXmlContent','claveAcceso'));

        //return view('sales_order.xml', compact('url'));

    }

}