<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;


class IdentificationController extends Controller
{
    public function getSriData(Request $request)
    {
        // Obtén el parámetro `identification` de la solicitud
        $identification = $request->input('identification');

        // Validación: asegurarse de que el parámetro sea numérico y de longitud 10 o 13
        if (!is_numeric($identification) || !in_array(strlen($identification), [10, 13])) {
            return response()->json([
                'error' => 'El parámetro identification debe contener solo números y tener una longitud de 10 o 13.',
            ], 400);
        }

        // Define el tipo de identificación basado en la longitud
        $tipoIdentificacion = strlen($identification) === 10 ? 'C' : 'R';
        
         /*$url = 'http://open24.cloud:4444/api/sri-identification';
         
         $jsonData = json_encode(['identification'=>'0963506506']);

        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_POST, TRUE);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $jsonData);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        // Desactiva la verificación SSL (para evitar problemas con HTTPS o servidores sin SSL)
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false); // Esto desactiva la verificación del certificado SSL

        $response = curl_exec($curl);
        
        if ($response === false) {
    // Imprime el error de cURL
    dd(curl_error($curl));
}

        $http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        
        dd($response);*/
        
        /*$response = Http::post('http://open24.cloud:4444/api/sri-identification');

        if ($response->successful()) {
            dd($response);
            //return response()->json(['data'=>$response->json()]);
        } else {
            dd($response);
            //return response()->json(['error'=>'Error en la solicitud']);
        }*/
        
        //$identification = '0963506506';

        // Define la URL de la API
        //$url = 'https://147.182.188.95:4444/api/sri-identification';
        $url = 'https://apisriruc.open24.cloud/api/sri-identification';
        //$url = 'http://localhost:4000/api/sri-identification';

        // Define el cuerpo del POST
        $data = [
            'identification' => $identification,
        ];

        try {
            // Realiza la solicitud POST
            $response = Http::withoutVerifying()->withOptions(['verify' => false])->timeout(180)->post($url, $data);

            // Verifica si la solicitud fue exitosa
            if ($response->successful()) {
                $responseData = $response->json();

                //dd($responseData);

                // Verifica si hay un error en los datos del contribuyente
                if (isset($responseData['data']['contribuyente']['error'])) {
                    $errorMessage = $responseData['data']['contribuyente']['error'];

                    return response()->json([
                        'error' => $errorMessage,
                    ], 404);
                }

                // Inicializa las variables de salida
                $nombreComercial = null;

                // Verifica si `nombreComercial` está disponible
                if (isset($responseData['data']['contribuyente']['nombreComercial'])) {
                    $nombreComercial = $responseData['data']['contribuyente']['nombreComercial'];
                }

                // Si no hay `nombreComercial`, verifica si hay `nombreCompleto`
                if (empty($nombreComercial) && isset($responseData['data']['contribuyente']['nombreCompleto'])) {
                    $nombreComercial = $responseData['data']['contribuyente']['nombreCompleto'];
                }

                // Si no hay `nombreComercial`, usa `Razon Social:`
                if (empty($nombreComercial) && isset($responseData['data']['infoRuc']['Razon Social:'])) {
                    $nombreComercial = $responseData['data']['infoRuc']['Razon Social:'];
                }

                // Extrae los campos requeridos de infoRuc si existe
                $estadoContribuyente = $responseData['data']['infoRuc']['Estado del Contribuyente en el RUC'] ?? null;
                $actividadEconomica = $responseData['data']['infoRuc']['Actividad Economica Principal'] ?? null;

                // Extrae la ubicación del establecimiento (establecimiento_0)
                $ubicacionEstablecimiento = null;
                if (isset($responseData['data']['infoRuc']['establecimiento'][0]['establecimiento_0']['ubicacion_establecimiento'])) {
                    $ubicacionEstablecimiento = $responseData['data']['infoRuc']['establecimiento'][0]['establecimiento_0']['ubicacion_establecimiento'];
                }

                if($nombreComercial== null){
                    return response()->json([
                        'error' => 'Identificación no valida',
                    ], 404);
                }

                // Retorna la información obtenida
                return response()->json([
                    'tipoIdentificacion' => $tipoIdentificacion,
                    'nombreComercial' => $nombreComercial,
                    'estadoContribuyente' => $estadoContribuyente,
                    'actividadEconomica' => $actividadEconomica,
                    'ubicacionEstablecimiento' => $ubicacionEstablecimiento,
                ]);
            } else {
                // Maneja errores de respuesta
                return response()->json(['error' => 'Error en la API'], 400);
            }
        } catch (\Exception $e) {
            // Maneja excepciones
            return response()->json(['error' => $e->getMessage()], 500);
            return response()->json(['error' => 'Error al consultar'], 500);
        }
    }

}