<?php

namespace App\Http\Controllers;

use App\BusinessLocation;
use App\Contact;
use App\Transaction;
use App\FacturacionElectronica;
use App\Utils\BusinessUtil;
use App\Utils\TransactionUtil;
use App\Utils\Util;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class SalesFacturacionDevolucionController extends Controller{

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $business_id = request()->session()->get('user.business_id');

        // Obtener todos los clientes
        $clients = Contact::where('business_id', $business_id)->get();
        $locations = BusinessLocation::where('business_id', $business_id)->get();


        $query = Transaction::with('contact','location','tax','types_of_service','sri')
                        ->where('business_id', $business_id)
                        ->whereIn('type', ['sell','sell_return'])
                        ->where('status','final')
                        ->orderBy('invoice_no','desc');


        // Filtro por cliente (si está presente en la solicitud)
        if ($request->has('client_id') && $request->client_id != '') {
            $query->where('contact_id', $request->client_id);
        }

        // Filtro por fecha desde
        if ($request->has('date_from') && $request->date_from != '') {
            $query->whereDate('transaction_date', '>=', $request->date_from);
        }

        // Filtro por fecha hasta
        if ($request->has('date_to') && $request->date_to != '') {
            $query->whereDate('transaction_date', '<=', $request->date_to);
        }

        // Filtro por cliente (si está presente en la solicitud)
        if ($request->has('location_id') && $request->location_id != '') {
            $query->where('location_id', $request->location_id);
        }

        // Obtener los resultados con paginación
        $transaction = $query->paginate(10);

        //dd($transaction );

        return view('sales_order.index_facturacion_electronica', compact('transaction','clients','locations'));
    }

    public function reportRide(Request $request, $id){
        $sri = FacturacionElectronica::where('clave_acceso',$id)->first();

        $ruc = $sri->ruc;
        $cadena = $id;

        // Paso 1: Extraer los primeros 8 dígitos
        $primerosOcho = substr($cadena, 0, 8);

        // Paso 2: Tomar los últimos 4 dígitos (el año)
        $anio = substr($primerosOcho, -4);

        // Paso 3: Tomar el mes (tercer y cuarto carácter)
        $mes = substr($primerosOcho, 2, 2);

        // Paso 4: Formar el formato "aaaa_mm"
        $resultado = "{$anio}_{$mes}";
        
        //$folder = \Carbon\Carbon::parse($sri->updated_at)->format('Y_m');
        
        $folder = $resultado;
        //$folder = \Carbon\Carbon::parse($sri->fecha)->format('Y_m');
        $type = 'ride';
        $document = $sri->documento;
        $file= $id.'_'.$ruc.'_'.$document.'.pdf';
        //$url = env('URL_DOC').'/sri/'.$ruc.'/'.$folder.'/'.$type.'/'.$file;
        $url = env('URL_DOC_FILE').'/'.$ruc.'/'.$folder.'/'.$type.'/'.$file;

        //dd($url);

        return view('sales_order.ride', compact('url'));

    }

    public function reportXml(Request $request, $id){
        $sri = FacturacionElectronica::where('clave_acceso',$id)->first();

        $ruc = $sri->ruc;
        $cadena = $id;

        // Paso 1: Extraer los primeros 8 dígitos
        $primerosOcho = substr($cadena, 0, 8);

        // Paso 2: Tomar los últimos 4 dígitos (el año)
        $anio = substr($primerosOcho, -4);

        // Paso 3: Tomar el mes (tercer y cuarto carácter)
        $mes = substr($primerosOcho, 2, 2);

        // Paso 4: Formar el formato "aaaa_mm"
        $resultado = "{$anio}_{$mes}";
        
        //$folder = \Carbon\Carbon::parse($sri->updated_at)->format('Y_m');
        
        $folder = $resultado;
        //$folder = \Carbon\Carbon::parse($sri->fecha)->format('Y_m');
        $type = 'signed';
        $document = $sri->documento;
        $file= $id.'_'.$ruc.'_'.$document.'.xml';
        //$url = env('URL_DOC').'/sri/'.$ruc.'/'.$folder.'/'.$type.'/'.$file;
        $url = env('URL_DOC_FILE').'/'.$ruc.'/'.$folder.'/'.$type.'/'.$file;

        //dd($url);

        $xmlContent = file_get_contents($url);

        $escapedXmlContent = htmlspecialchars($xmlContent);

        $claveAcceso = $id;

        return view('sales_order.xml', compact('xmlContent','url','escapedXmlContent','claveAcceso'));

        //return view('sales_order.xml', compact('url'));

    }

    public function sendSRI(Request $request, $id){

        $business_id = request()->session()->get('user.business_id');
        $transaction = Transaction::with(            
                        'contact','location.business','tax',
                        'types_of_service','sell_lines.product.product_tax',
                        'payment_lines', 'sri','transaction_parent.sell_lines'
                        )
                        ->where('business_id', $business_id)
                        ->where('type', 'sell_return')
                        ->find($id);

        

        

        $formatted_invoice_no = '';

        if ($transaction) {
            // Verificar si $transaction->invoice_no tiene el formato esperado
            $invoice_no = $transaction->invoice_no ?? '';
            //dd($invoice_no,preg_match('/^\w{6}\/\d+$/', $invoice_no),preg_match('/^[A-Za-z0-9]{6}\/\d+$/', $invoice_no));
            if (preg_match('/^\w{6}\/\d+$/', $invoice_no)) {
                // Extraer la parte numérica después de '/'
                preg_match('/\/(\d+)$/', $invoice_no, $matches);
                $numeric_part = str_pad($matches[1], 9, '0', STR_PAD_LEFT); // Rellenar con ceros hasta 9 dígitos
        
                // Extraer los primeros 7 caracteres de $transaction->transaction_parent->invoice_no
                $parent_invoice_no = $transaction->transaction_parent->invoice_no ?? '';
                $parent_prefix = substr($parent_invoice_no, 0, 7); // Tomar los primeros 7 caracteres
        
                // Formar el nuevo formato
                if (!empty($parent_prefix)) {
                    $formatted_invoice_no = "{$parent_prefix}-{$numeric_part}";
                    //echo "Nuevo Formato Invoice No: " . $formatted_invoice_no;
                } else {
                    //echo "No se encontraron los primeros 7 caracteres en 'transaction_parent->invoice_no'.";
                }
            } else {
                if($invoice_no != '' && $transaction->invoice_no ==''){
                    $formatted_invoice_no = $invoice_no;
                }
                //echo "El formato de 'invoice_no' no coincide con el esperado. No se realiza ninguna acción.";
            }
        }

        if($formatted_invoice_no  != ''){
            $transaction_update = Transaction::find($id);
            $transaction_update->invoice_no = $formatted_invoice_no;
            $transaction_update->save();

            $transaction = Transaction::with(            
                'contact','location.business','tax',
                'types_of_service','sell_lines.product.product_tax',
                'payment_lines', 'sri','transaction_parent.sell_lines'
                )
                ->where('business_id', $business_id)
                ->where('type', 'sell_return')
                ->find($id);
        }

        //dd($transaction,$formatted_invoice_no);

        if($transaction->sri != null && count($transaction->sri) > 0){
            if($transaction->sri[0]->estado == 'AUTORIZADO'){

                $dResponse=[
                    "success"=> true,
                    "data" =>[
                        "estado" => 'COMPLETADO'
                    ],                    
                    "message" => 'El documento ya fue procesado'
                ];

                return response()->json($dResponse, 200);
            }elseif($transaction->sri[0]->respuesta_error_sri_msg == 'LIMITE DE INTENTOS NO AUTORIZADOS POR DIA'){
                if($transaction->sri[0]->updated_at->isToday()){
                    $dResponse=[
                        "success"=> true,
                        "data" =>[
                            "estado" => 'LIMITE'
                        ],                    
                        "message" => 'El documento ya excedio el limite de intentos'
                    ];
                    return response()->json($dResponse, 200);
                }
            }elseif($transaction->sri[0]->respuesta_error_sri_msg == 'CLAVE ACCESO REGISTRADA'){
                $dResponse=[
                    "success"=> true,
                    "data" =>[
                        "estado" => 'CLAVE_ACCESO_REGISTRADA'
                    ],                    
                    "message" => 'El documento la clave de acceso registrada'
                ];
                return response()->json($dResponse, 200);
            }

            
        }

        //dd($transaction);


        $direccion_sucursal = $transaction->location->country.' - '.$transaction->location->state.' - '.$transaction->location->city;
        $contact_type = $transaction->contact->contact_type == 'individual' ? 5 : 4;

        if($transaction->contact->contact_type=='individual'){
            $contact_type = 5;
        }elseif ($transaction->contact->contact_type=='business') {
            $contact_type = 4;
        }elseif ($transaction->contact->contact_type=='passport') {
            $contact_type = 6;
        }

        $contact_id = $transaction->contact->contact_id;

        if($contact_id=='9999999999999'){
            $contact_type = 7;
        }

        $payment = [
            'cash' => [
                "codigoSriDocumentoElectronico" => "01",
                "monto" => 0,
                "cantidadDias" => 0,
                "descripcion" => "SIN UTILIZACION DEL SISTEMA FINACIERO",
            ],
            'card' => [
                "codigoSriDocumentoElectronico" => "16",
                "monto" => 0,
                "cantidadDias" => 0,
                "descripcion" => "TARJETA",
            ],
            'cheque' => [
                "codigoSriDocumentoElectronico" => "20",
                "monto" => 0,
                "cantidadDias" => 0,
                "descripcion" => "OTROS CON UTILIZACIÓN DEL SISTEMA FINACIERO",
            ], 
            'bank_transfer' => [
                "codigoSriDocumentoElectronico" => "17",
                "monto" => 0,
                "cantidadDias" => 0,
                "descripcion" => "DINERO ELECTRONICO",
            ],
            'other' => [
                "codigoSriDocumentoElectronico" => "20",
                "monto" => 0,
                "cantidadDias" => 0,
                "descripcion" => "OTROS CON UTILIZACIÓN DEL SISTEMA FINACIERO",
            ]
        ];

        $listPayment = [];

        foreach($transaction->payment_lines as $pay){
            $itemPay = $payment[$pay->method] ? $payment[$pay->method] : $payment['other'];
            $itemPay['monto'] = number_format($pay->amount,2,'.','');
            
            $listPayment[]=$itemPay; 
        }

        $listProduct = [];
        $baseGravableIva = 0;
        $baseNoGravableIva = 0;
        $tax_amount = 0;
        $tax_product = 0;

        foreach($transaction->transaction_parent->sell_lines as $item){

            if($item->quantity_returned > 0){

                $quantity = $item->quantity_returned;

                $subtotalProducto = $quantity * $item->unit_price_before_discount;

                $item_tax_total = $item->item_tax * $quantity;

                $line_discount_amount_unid = $item->line_discount_amount / $item->quantity;

                $line_discount_amount_total = $line_discount_amount_unid * $quantity; 

                //dd($item->quantity_returned, $item->unit_price_before_discount, $item->item_tax, $item->quantity);

                $itemProduct =[
                    "codigoPrincipal" => strval($item->product->sku),
                    "codigoAuxiliar" => strval($item->product->sku),
                    "descripcionProducto" => $item->product->name,
                    "notaProducto" => "",
                    "cantidad" => $quantity,
                    "precioUnitario" => $item->unit_price_before_discount,
                    "subtotalProducto" => $subtotalProducto,
                    "descuentoProducto" => $line_discount_amount_total,
                    "montoIvaProducto" => $item_tax_total 
                ];

                $tax_amount = $tax_amount + $item_tax_total;

                if($item_tax_total > 0){
                    $tax_product=$item->product->product_tax->amount;
                    $baseGravableIva = $baseGravableIva + $subtotalProducto;
                }else{
                    $baseNoGravableIva = $baseNoGravableIva + $subtotalProducto;
                }

                $listProduct[] = $itemProduct;

            }
            
            
        }

        $impuesto = [
            '0' => [
                "codigoSriAts" => "2",
                "codigoSriDocumentoElectronico" => "0",
                "porcentaje" => 0.00,
            ],
            '13' => [
                "codigoSriAts" => "2",
                "codigoSriDocumentoElectronico" => "10",
                "porcentaje" => 13.00,
            ],
            '14' => [
                "codigoSriAts" => "2",
                "codigoSriDocumentoElectronico" => "3",
                "porcentaje" => 14.00,
            ],
            '15' => [
                "codigoSriAts" => "2",
                "codigoSriDocumentoElectronico" => "4",
                "porcentaje" => 15.00,
            ],
            '5' => [
                "codigoSriAts" => "2",
                "codigoSriDocumentoElectronico" => "5",
                "porcentaje" => 5.00,
            ]
        ];

        //$tax = $impuesto[(int)$transaction->tax->amount];
        //$tax_0 = $impuesto['0'];

        $tax = $impuesto[(int)$tax_product != 0 ? (int)$tax_product : 15 ];
        $tax_0 = $impuesto['0'];

        $payment = [
            'cash' => [
                "codigoSriDocumentoElectronico" => "01",
                "monto" => 0,
                "cantidadDias" => 0,
                "descripcion" => "SIN UTILIZACION DEL SISTEMA FINACIERO",
            ],
            'card' => [
                "codigoSriDocumentoElectronico" => "16",
                "monto" => 0,
                "cantidadDias" => 0,
                "descripcion" => "TARJETA",
            ],
            'cheque' => [
                "codigoSriDocumentoElectronico" => "20",
                "monto" => 0,
                "cantidadDias" => 0,
                "descripcion" => "OTROS CON UTILIZACIÓN DEL SISTEMA FINACIERO",
            ], 
            'bank_transfer' => [
                "codigoSriDocumentoElectronico" => "17",
                "monto" => 0,
                "cantidadDias" => 0,
                "descripcion" => "DINERO ELECTRONICO",
            ],
            'other' => [
                "codigoSriDocumentoElectronico" => "20",
                "monto" => 0,
                "cantidadDias" => 0,
                "descripcion" => "OTROS CON UTILIZACIÓN DEL SISTEMA FINACIERO",
            ]
        ];


        $codDocModificado = "01";
		$numDocModificado = $transaction->transaction_parent->invoice_no;
		$motivo = "Devolucion de producto";
		$fechaEmisionDocSustento = \Carbon\Carbon::parse($transaction->transaction_parent->trasacctransaction_date)->format('d-m-Y');


        $data = [
            "dataEmpresa" => [
                "id" => $business_id,
                "ambiente" => env('ambiente'),
                "emision" => 1,
                "razonSocial" => $transaction->location->business->name,
                "nombreComercial" => $transaction->location->name,
                "ruc" => env('RUC'),
                "direccion" => env('direccion'),
                "obligadoContabilidad" => env('obligadoContabilidad'),
                "agenteRetenedor" => env('agenteRetenedor'),
                "resolucionAgenteRetenedor" => env('resolucionAgenteRetenedor'),
                "contribuyenteRimpe" => env('contribuyenteRimpe'),
                "contribuyenteRimpeNegocioPopular" => env('contribuyenteRimpeNegocioPopular'),
                "contribuyenteEspecial" => env('contribuyenteEspecial'),
                "idContribuyenteEspecial" => env('idContribuyenteEspecial'),
                "email" => $transaction->location->business->email ? $transaction->location->business->email: env('email'),
                "rutaLogo" => "logos/1204763948001/logo.png",
                "logoGeneral" => "logos/logo_general.png"
            ],
            "dataInfo" => [
                "numeroDocumento" => $transaction->invoice_no,
                "direccionBodega" =>  $direccion_sucursal,
                "fecha" => \Carbon\Carbon::parse($transaction->transaction_date)->format('d-m-Y'),
                "email1" => $transaction->contact->email,
                "email2" => "",
                "email3" => "",
                "codigoCliente" => str_pad($transaction->contact->id, 9, '0', STR_PAD_LEFT),
                "idTipoIdentificacion" => "$contact_type",
                "razonSocial" => $transaction->contact->name,
                "identificacion" => $transaction->contact->contact_id,
                "direccion" =>  $transaction->contact->address_line_1 != null && $transaction->contact->address_line_1 != '' ? $transaction->contact->address_line_1 : "Sin direccion",
                "ciudad" => $transaction->contact->country,
                "telefono" => $transaction->contact->mobile,
                "subtotal" => number_format($baseGravableIva+$baseNoGravableIva,2,'.',''),
                "descuento" => number_format($transaction->discount_amount,2,'.',''),
                "baseGravableIva" => number_format($baseGravableIva,2,'.',''),
                "baseNoGravableIva" => number_format($baseNoGravableIva,2,'.',''),
                "montoIva" => number_format($tax_amount,2,'.',''),
                "montoRecargo" => 0.00,
                "flete" => 0.00,
                "montoNeto" => number_format($transaction->final_total,2,'.',''),
                "moneda" => 'DOLAR',
                "clave" => '12345678',
                "codDocModificado" => $codDocModificado,
                "numDocModificado" => $numDocModificado,
                "motivo" => $motivo,
                "fechaEmisionDocSustento" => $fechaEmisionDocSustento
            ],
            "dataTipoImpuesto" => $tax,
            "dataTipoImpuesto_0" => $tax_0,
            "dataItem" => $listProduct,
            "dataItemAdicional" => [
                ["campo" => "codigo"],
                ["campo" => "email"],
                ["campo" => "direccion"]
            ],
            "dataInfoAdicional" => [
                
            ]
        ];

        //dd($data);

        //$jsonData = json_encode($data);

        //dd($jsonData);

        /*try {
            $response = Http::withHeaders(['Content-Type' => 'application/json'])->post(env('URL_FACTURACION') . '/factura/create', $data);
            
            // Check if the response was successful
            if ($response->successful()) {
                return $response->json(); // Or handle the response as needed
            } else {
                // Log the response body for more insight
                Log::error('API request failed', [
                    'status' => $response->status(),
                    'response' => $response->body()
                ]);

                dd($response->body());
                return response()->json(['error' => 'API request failed'], $response->status());
            }
        } catch (\Exception $e) {
            // Log the exception details
            Log::error('API request exception', [
                'message' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ]);
            dd($e->getTraceAsString());
            return response()->json(['error' => 'API request exception: ' . $e->getMessage()], 500);
        }

        */

        //dd($transaction,$data);

        // Convertir el array a JSON
        $jsonData = json_encode($data);

        // Opcional: verifica el resultado
        if ($jsonData === false) {
            echo "Error al convertir el array a JSON: " . json_last_error_msg();
        } else {
            //echo $jsonData; // Muestra el JSON o envíalo a la API
            //dd($jsonData);
        }

        // Enviar los datos JSON a la API con CURL
        /*$ch = curl_init(env('URL_FACTURACION') . '/factura/create'); // Reemplaza con la URL de tu API
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
        ]);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);

        $response = curl_exec($ch);*/

        $url = env('URL_FACTURACION') . '/notacredito/create';

        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_POST, TRUE);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $jsonData);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($curl);

        $http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);

        if ($response === false) {
            echo "Error en la solicitud CURL: " . curl_error($curl);
            /*Log::error('API request failed', [
                'status' => $response->status(),
                'response' => $response->body()
            ]);*/

            //dd(1,$response);
            return response()->json(['error' => 'API request failed'], 500);

        } else {
            //dd(2,$response);
            // Decodificar JSON a un array asociativo en PHP
            $decodedResponse = json_decode($response, true);

            

            /*$result = [
                'success' => true,
                'data'    => json_decode($response),
                'message' => '',
            ];*/

            //$decodedResponse['data']['errors'] = json_decode($decodedResponse['data']['errors'], true);

            // Verifica si existen 'data' y 'errors' antes de intentar decodificar
            if (isset($decodedResponse['data']['errors'])) {
                $decodedResponse['data']['errors'] = json_decode($decodedResponse['data']['errors'], true);
                
                // Verifica si json_decode falló
                if (json_last_error() !== JSON_ERROR_NONE) {
                    // Maneja el error de JSON
                    //Log::error('Error decodificando JSON:', ['error' => json_last_error_msg()]);
                    $decodedResponse['data']['errors'] = null; // Asigna un valor por defecto si es necesario
                    $decodedResponse['data']['errors_general'] = $decodedResponse['data']['errors'];
                }
            }

            //dd($decodedResponse);
            //PASO SIGUIENTE
            /*  
                - RUC
                - DOCUMENTO
                - AMBIENTE
                - FECHA
                - CREAR UNA TABLA DE FACTURACION ELECTRONICA CON LOS SIGUIENTE CAMPOS
                - CLAVE DE ACCESO        
                - CLAVE DE AUTORIZACION
                - VENTA ID
                - FECHA DE AUTORIZACION
                - ESTADO
                - ERRORS
                - LINK PDF
                - LINK XML GENERADO
                - LINL XML AUTORIADO
            */

            /*
                REENVIO AL SRI
                IMPRIMIR TICKET
                IMPRIMIR RIDE
                IMPRIMIR XML
                REENVIO AL CLIENTE
            */

            $validar = 0;

            if (
                isset($decodedResponse['data']) &&
                $decodedResponse['data']['respuesta'] === 'DEVUELTA' &&
                $decodedResponse['data']['connection'] === 'correcta' &&
                isset($decodedResponse['data']['errors']) &&
                $decodedResponse['data']['errors']['estado'] === 'DEVUELTA' &&
                isset($decodedResponse['data']['errors']['comprobantes']['comprobante']['mensajes']['mensaje']) &&
                $decodedResponse['data']['errors']['comprobantes']['comprobante']['mensajes']['mensaje']['mensaje'] === 'CLAVE ACCESO REGISTRADA'
            ) {
                $validar = 3;
            }

            $respuesta_error_sri = '';
            $respuesta_error_sri_msg = '';
            // Validación paso a paso
            if (isset($decodedResponse['data'])) {
                if (isset($decodedResponse['data']['errors'])) {
                    if (isset($decodedResponse['data']['errors']['comprobantes'])) {
                        if (isset($decodedResponse['data']['errors']['comprobantes']['comprobante'])) {
                            if (isset($decodedResponse['data']['errors']['comprobantes']['comprobante']['mensajes'])) {
                                if (isset($decodedResponse['data']['errors']['comprobantes']['comprobante']['mensajes']['mensaje'])) {
                                    // Guardar el valor de 'mensaje' si se encuentra
                                    $respuesta_error_sri = $decodedResponse['data']['errors']['comprobantes']['comprobante']['mensajes']['mensaje'];
                                    if(isset($decodedResponse['data']['errors']['comprobantes']['comprobante']['mensajes']['mensaje']['mensaje'])){
                                        $respuesta_error_sri_msg = $decodedResponse['data']['errors']['comprobantes']['comprobante']['mensajes']['mensaje']['mensaje'];
                                    }
                                }
                            }
                        }
                    }
                }
            }

            if(isset($decodedResponse['data']) &&
                isset($decodedResponse['data']['connection']) && 
                $decodedResponse['data']['connection'] != 'correcta' && 
                isset($decodedResponse['data']['errors_connection']) != ''
            ){
                $validar = 1;
            }

            

            $clave_acceso = isset($decodedResponse['data']) && 
            isset($decodedResponse['data']['claveAcceso']) ? 
            $decodedResponse['data']['claveAcceso'] : '';

            $connection = isset($decodedResponse['data']) && 
            isset($decodedResponse['data']['connection']) ? 
            $decodedResponse['data']['connection'] : '';

            $errors = isset($decodedResponse['data']) && 
            isset($decodedResponse['data']['errors']) ? 
            $decodedResponse['data']['errors'] : '';

            $respuesta = isset($decodedResponse['data']) && 
            isset($decodedResponse['data']['respuesta']) ? 
            $decodedResponse['data']['respuesta'] : '';

            $link_xml_unsigned = isset($decodedResponse['data']) && 
            isset($decodedResponse['data']['unsigned']) ? 
            $decodedResponse['data']['unsigned'] : '';

            $link_xml_signed = isset($decodedResponse['data']) && 
            isset($decodedResponse['data']['signed']) ? 
            $decodedResponse['data']['signed'] : '';

            $link_pdf = isset($decodedResponse['data']) && 
            isset($decodedResponse['data']['nombreFile']) ? 
            $decodedResponse['data']['nombreFile'].'.pdf' : '';

            $estado = isset($decodedResponse['data']) && 
            isset($decodedResponse['data']['estado']) ? 
            $decodedResponse['data']['estado'] : '';

            // Acceder a los elementos del XML
            $numeroAutorizacion = '';
            $fechaAutorizacion = '';

            if($estado == ''){
                $estado == "SRI NO PROCESO";
            }elseif($estado== "NO AUTORIZADO"){
                if (
                    isset($decodedResponse['data']) &&
                    isset($decodedResponse['data']['errors']) &&
                    isset($decodedResponse['data']['errors']['autorizaciones']) &&
                    isset($decodedResponse['data']['errors']['autorizaciones']['autorizacion']) &&
                    isset($decodedResponse['data']['errors']['autorizaciones']['autorizacion']) &&
                    isset($decodedResponse['data']['errors']['autorizaciones']['autorizacion']['mensajes'])
                ) {
                    // Extraer el contenido de `mensaje`
                    $respuesta_error_sri = $decodedResponse['data']['errors']['autorizaciones']['autorizacion']['mensajes'];
                    if(isset($decodedResponse['data']['errors']['autorizaciones']['autorizacion']['mensajes']['mensaje']) &&
                    isset($decodedResponse['data']['errors']['autorizaciones']['autorizacion']['mensajes']['mensaje']['mensaje'])){
                        $respuesta_error_sri_msg = $decodedResponse['data']['errors']['autorizaciones']['autorizacion']['mensajes']['mensaje']['mensaje'];
                    }
                    //console.log("Contenido de mensaje:", mensaje);
                }
            }elseif($estado=='AUTORIZADO'){
                $xmlContent = $decodedResponse['data']['autorized']; // Aquí pones el contenido de tu XML

                // Crear el objeto XML
                $xml = new \SimpleXMLElement($xmlContent);

                // Acceder a los elementos del XML
                $numeroAutorizacion = (string) $xml->numeroAutorizacion;
                $fechaAutorizacion = (string) $xml->fechaAutorizacion;
            }

        

            $decodedResponse['data']['validar'] = $validar;
            $decodedResponse['data']['respuesta_error_sri'] = $respuesta_error_sri;
            $decodedResponse['data']['respuesta_error_sri_msg'] = $respuesta_error_sri_msg;

            $fact = FacturacionElectronica::where('venta_id',$id)
            ->where('ruc',env('RUC'))
            ->where('documento',$transaction->invoice_no)
            ->first();

            if(!$fact){
                $fact = new FacturacionElectronica();
            }            
            $fact->ruc = env('RUC');
            $fact->documento = $transaction->invoice_no;
            $fact->fecha = \Carbon\Carbon::parse($transaction->transaction_date)->format('Y-m-d');
            $fact->ambiente = env('ambiente');
            $fact->venta_id = $id;
            $fact->clave_acceso = $clave_acceso;
            $fact->fecha_autorizacion = $fechaAutorizacion;
            $fact->autorizacion = $numeroAutorizacion;
            $fact->link_xml_unsigned = $link_xml_unsigned;
            $fact->link_xml_signed = $link_xml_signed;
            $fact->link_pdf = $link_pdf;
            $fact->errors = json_encode($errors);
            $fact->respuesta = $respuesta;
            $fact->conexion = $connection;
            $fact->validar = $validar;
            $fact->respuesta_error_sri = json_encode($respuesta_error_sri);
            $fact->respuesta_error_sri_msg = $respuesta_error_sri_msg;
            $fact->estado = $estado;
            //dd($fact);
            $fact->save();
    
            return response()->json($decodedResponse, 200);
            //echo "Respuesta de la API: " . $response;
        }

        curl_close($curl);

        //dd($response);

        //dd($transaction,$data);




    }

    public function sendSRIClaveRegistrada(Request $request, $id){

        $business_id = request()->session()->get('user.business_id');
        $transaction = Transaction::with(            
                        'contact','location.business','tax',
                        'types_of_service','sell_lines.product.product_tax',
                        'payment_lines', 'sri','transaction_parent.sell_lines'
                        )
                        ->where('business_id', $business_id)
                        ->where('type', 'sell_return')
                        ->find($id);

        if($transaction->sri != null && count($transaction->sri) > 0){
            if($transaction->sri[0]->estado == 'AUTORIZADO'){

                $dResponse=[
                    "success"=> true,
                    "data" =>[
                        "estado" => 'COMPLETADO'
                    ],                    
                    "message" => 'El documento ya fue procesado'
                ];

                return response()->json($dResponse, 200);
            }elseif($transaction->sri[0]->respuesta_error_sri_msg == 'LIMITE DE INTENTOS NO AUTORIZADOS POR DIA'){
                if($transaction->sri[0]->updated_at->isToday()){
                    $dResponse=[
                        "success"=> true,
                        "data" =>[
                            "estado" => 'LIMITE'
                        ],                    
                        "message" => 'El documento ya excedio el limite de intentos'
                    ];
                    return response()->json($dResponse, 200);
                }
            }elseif($transaction->sri[0]->respuesta_error_sri_msg != 'CLAVE ACCESO REGISTRADA'){
                $dResponse=[
                    "success"=> true,
                    "data" =>[
                        "estado" => 'SINPROCESO'
                    ],                    
                    "message" => 'El documento sin proceso'
                ];
                return response()->json($dResponse, 200);
            }elseif($transaction->sri[0]->respuesta_error_sri_msg == 'CLAVE ACCESO REGISTRADA'){   
                
                $fechaSend = \Carbon\Carbon::parse($transaction->sri[0]->fecha)->format('d-m-Y');
            
                $data = [
                    "claveAcceso" =>$transaction->sri[0]->clave_acceso,
                    "ruc" => $transaction->sri[0]->ruc,
                    "documento" => $transaction->sri[0]->documento,
                    "ambiente" => $transaction->sri[0]->ambiente,
                    "fecha" => $fechaSend
                ];

                // Convertir el array a JSON
                $jsonData = json_encode($data);

                // Opcional: verifica el resultado
                if ($jsonData === false) {
                    echo "Error al convertir el array a JSON: " . json_last_error_msg();
                } else {
                    //echo $jsonData; // Muestra el JSON o envíalo a la API
                    //dd($jsonData);
                }

                $url = env('URL_FACTURACION') . '/verififacion-documento';

                $curl = curl_init();
                curl_setopt($curl, CURLOPT_URL, $url);
                curl_setopt($curl, CURLOPT_POST, TRUE);
                curl_setopt($curl, CURLOPT_POSTFIELDS, $jsonData);
                curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
                curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                $response = curl_exec($curl);

                $http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);

                if ($response === false) {
                    echo "Error en la solicitud CURL: " . curl_error($curl);

                    //dd(1,$response);
                    return response()->json(['error' => 'API request failed'], 500);

                } else {
                    //dd(2,$response);
                    // Decodificar JSON a un array asociativo en PHP
                    $decodedResponse = json_decode($response, true);

                    //dd($decodedResponse);

                    // Verifica si existen 'data' y 'errors' antes de intentar decodificar
                    if (isset($decodedResponse['data']['errors'])) {
                        $decodedResponse['data']['errors'] = json_decode($decodedResponse['data']['errors'], true);
                        
                        // Verifica si json_decode falló
                        if (json_last_error() !== JSON_ERROR_NONE) {
                            // Maneja el error de JSON
                            //Log::error('Error decodificando JSON:', ['error' => json_last_error_msg()]);
                            $decodedResponse['data']['errors'] = null; // Asigna un valor por defecto si es necesario
                            $decodedResponse['data']['errors_general'] = $decodedResponse['data']['errors'];
                        }
                    }

                    $validar = 0;

                    if (
                        isset($decodedResponse['data']) &&
                        $decodedResponse['data']['respuesta'] === 'DEVUELTA' &&
                        $decodedResponse['data']['connection'] === 'correcta' &&
                        isset($decodedResponse['data']['errors']) &&
                        $decodedResponse['data']['errors']['estado'] === 'DEVUELTA' &&
                        isset($decodedResponse['data']['errors']['comprobantes']['comprobante']['mensajes']['mensaje']) &&
                        $decodedResponse['data']['errors']['comprobantes']['comprobante']['mensajes']['mensaje']['mensaje'] === 'CLAVE ACCESO REGISTRADA'
                    ) {
                        $validar = 3;
                    }

                    $respuesta_error_sri = '';
                    $respuesta_error_sri_msg = '';
                    // Validación paso a paso
                    if (isset($decodedResponse['data'])) {
                        if (isset($decodedResponse['data']['errors'])) {
                            if (isset($decodedResponse['data']['errors']['comprobantes'])) {
                                if (isset($decodedResponse['data']['errors']['comprobantes']['comprobante'])) {
                                    if (isset($decodedResponse['data']['errors']['comprobantes']['comprobante']['mensajes'])) {
                                        if (isset($decodedResponse['data']['errors']['comprobantes']['comprobante']['mensajes']['mensaje'])) {
                                            // Guardar el valor de 'mensaje' si se encuentra
                                            $respuesta_error_sri = $decodedResponse['data']['errors']['comprobantes']['comprobante']['mensajes']['mensaje'];
                                            if(isset($decodedResponse['data']['errors']['comprobantes']['comprobante']['mensajes']['mensaje']['mensaje'])){
                                                $respuesta_error_sri_msg = $decodedResponse['data']['errors']['comprobantes']['comprobante']['mensajes']['mensaje']['mensaje'];
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }

                    if(isset($decodedResponse['data']) &&
                        isset($decodedResponse['data']['connection']) && 
                        $decodedResponse['data']['connection'] != 'correcta' && 
                        isset($decodedResponse['data']['errors_connection']) != ''
                    ){
                        $validar = 1;
                    }

                    

                    $clave_acceso = isset($decodedResponse['data']) && 
                    isset($decodedResponse['data']['claveAcceso']) ? 
                    $decodedResponse['data']['claveAcceso'] : '';

                    $connection = isset($decodedResponse['data']) && 
                    isset($decodedResponse['data']['connection']) ? 
                    $decodedResponse['data']['connection'] : '';

                    $errors = isset($decodedResponse['data']) && 
                    isset($decodedResponse['data']['errors']) ? 
                    $decodedResponse['data']['errors'] : '';

                    $respuesta = isset($decodedResponse['data']) && 
                    isset($decodedResponse['data']['respuesta']) ? 
                    $decodedResponse['data']['respuesta'] : '';

                    $link_xml_unsigned = isset($decodedResponse['data']) && 
                    isset($decodedResponse['data']['unsigned']) ? 
                    $decodedResponse['data']['unsigned'] : '';

                    $link_xml_signed = isset($decodedResponse['data']) && 
                    isset($decodedResponse['data']['signed']) ? 
                    $decodedResponse['data']['signed'] : '';

                    $link_pdf = isset($decodedResponse['data']) && 
                    isset($decodedResponse['data']['nombreFile']) ? 
                    $decodedResponse['data']['nombreFile'].'.pdf' : '';

                    $estado = isset($decodedResponse['data']) && 
                    isset($decodedResponse['data']['estado']) ? 
                    $decodedResponse['data']['estado'] : '';

                    // Acceder a los elementos del XML
                    $numeroAutorizacion = '';
                    $fechaAutorizacion = '';

                    if($estado == ''){
                        $estado == "SRI NO PROCESO";
                    }elseif($estado== "NO AUTORIZADO"){
                        if (
                            isset($decodedResponse['data']) &&
                            isset($decodedResponse['data']['errors']) &&
                            isset($decodedResponse['data']['errors']['autorizaciones']) &&
                            isset($decodedResponse['data']['errors']['autorizaciones']['autorizacion']) &&
                            isset($decodedResponse['data']['errors']['autorizaciones']['autorizacion']) &&
                            isset($decodedResponse['data']['errors']['autorizaciones']['autorizacion']['mensajes'])
                        ) {
                            // Extraer el contenido de `mensaje`
                            $respuesta_error_sri = $decodedResponse['data']['errors']['autorizaciones']['autorizacion']['mensajes'];
                            if(isset($decodedResponse['data']['errors']['autorizaciones']['autorizacion']['mensajes']['mensaje']) &&
                            isset($decodedResponse['data']['errors']['autorizaciones']['autorizacion']['mensajes']['mensaje']['mensaje'])){
                                $respuesta_error_sri_msg = $decodedResponse['data']['errors']['autorizaciones']['autorizacion']['mensajes']['mensaje']['mensaje'];
                            }
                            //console.log("Contenido de mensaje:", mensaje);
                        }
                    }elseif($estado=='AUTORIZADO'){
                        $xmlContent = $decodedResponse['data']['autorized']; // Aquí pones el contenido de tu XML

                        // Crear el objeto XML
                        $xml = new \SimpleXMLElement($xmlContent);

                        // Acceder a los elementos del XML
                        $numeroAutorizacion = (string) $xml->numeroAutorizacion;
                        $fechaAutorizacion = (string) $xml->fechaAutorizacion;
                    }

                

                    $decodedResponse['data']['validar'] = $validar;
                    $decodedResponse['data']['respuesta_error_sri'] = $respuesta_error_sri;
                    $decodedResponse['data']['respuesta_error_sri_msg'] = $respuesta_error_sri_msg;

                    $fact = FacturacionElectronica::where('venta_id',$id)
                    ->where('ruc',env('RUC'))
                    ->where('documento',$transaction->invoice_no)
                    ->first();

                    if(!$fact){
                        $fact = new FacturacionElectronica();
                    }            
                    $fact->ruc = env('RUC');
                    $fact->documento = $transaction->invoice_no;
                    $fact->fecha = \Carbon\Carbon::parse($transaction->transaction_date)->format('Y-m-d');
                    //$fact->ambiente = env('ambiente');
                    $fact->venta_id = $id;
                    $fact->clave_acceso = $clave_acceso;
                    $fact->fecha_autorizacion = $fechaAutorizacion;
                    $fact->autorizacion = $numeroAutorizacion;
                    //$fact->link_xml_unsigned = $link_xml_unsigned;
                    //$fact->link_xml_signed = $link_xml_signed;
                    //$fact->link_pdf = $link_pdf;
                    $fact->errors = json_encode($errors);
                    $fact->respuesta = $respuesta;
                    $fact->conexion = $connection;
                    $fact->validar = $validar;
                    $fact->respuesta_error_sri = json_encode($respuesta_error_sri);
                    $fact->respuesta_error_sri_msg = $respuesta_error_sri_msg;
                    $fact->estado = $estado;
                    //dd($fact);
                    $fact->save();
            
                    return response()->json($decodedResponse, 200);
                    //echo "Respuesta de la API: " . $response;
                }

                curl_close($curl);



            }else{
                $dResponse=[
                    "success"=> true,
                    "data" =>[
                        "estado" => 'SINPROCESO_02'
                    ],                    
                    "message" => 'El documento sin proceso'
                ];
                return response()->json($dResponse, 200);
            }

            
        }else{
            $dResponse=[
                "success"=> true,
                "data" =>[
                    "estado" => 'SINPROCESO_02'
                ],                    
                "message" => 'El documento sin proceso'
            ];
            return response()->json($dResponse, 200);
        }

    }


    public function sendSRIRide(Request $request, $id){

        $business_id = request()->session()->get('user.business_id');
        $transaction = Transaction::with(            
                        'contact','location.business','tax',
                        'types_of_service','sell_lines.product.product_tax',
                        'payment_lines', 'sri'
                        )
                        ->where('business_id', $business_id)
                        ->where('type', 'sell_return')
                        ->find($id);

        //dd($transaction);

        if($transaction->sri != null && count($transaction->sri) > 0){
            if($transaction->sri[0]->estado != 'AUTORIZADO'){

                $dResponse=[
                    "success"=> true,
                    "data" =>[
                        "estado" => 'NO_COMPLETADO'
                    ],                    
                    "message" => 'El documento ya no fue procesado'
                ];

                return response()->json($dResponse, 200);
            }elseif($transaction->sri[0]->respuesta_error_sri_msg == 'LIMITE DE INTENTOS NO AUTORIZADOS POR DIA'){
                if($transaction->sri[0]->updated_at->isToday()){
                    $dResponse=[
                        "success"=> true,
                        "data" =>[
                            "estado" => 'LIMITE'
                        ],                    
                        "message" => 'El documento ya excedio el limite de intentos'
                    ];
                    return response()->json($dResponse, 200);
                }
            }elseif($transaction->sri[0]->respuesta_error_sri_msg == 'CLAVE ACCESO REGISTRADA'){
                $dResponse=[
                    "success"=> true,
                    "data" =>[
                        "estado" => 'CLAVE_ACCESO_REGISTRADA'
                    ],                    
                    "message" => 'El documento la clave de acceso registrada'
                ];
                return response()->json($dResponse, 200);
            }

            
        }

        //dd($transaction);


        $direccion_sucursal = $transaction->location->country.' - '.$transaction->location->state.' - '.$transaction->location->city;
        //$contact_type = $transaction->contact->contact_type == 'individual' ? 5 : 4;
        
        if($transaction->contact->contact_type=='individual'){
            $contact_type = 5;
        }elseif ($transaction->contact->contact_type=='business') {
            $contact_type = 4;
        }elseif ($transaction->contact->contact_type=='passport') {
            $contact_type = 6;
        }

        $contact_id = $transaction->contact->contact_id;

        if($contact_id=='9999999999999'){
            $contact_type = 7;
        }

        $listProduct = [];
        $baseGravableIva = 0;
        $baseNoGravableIva = 0;
        $tax_amount = 0;
        $tax_product = 0;

        foreach($transaction->transaction_parent->sell_lines as $item){

            if($item->quantity_returned > 0){

                $quantity = $item->quantity_returned;

                $subtotalProducto = $quantity * $item->unit_price_before_discount;

                $item_tax_total = $item->item_tax * $quantity;

                $line_discount_amount_unid = $item->line_discount_amount / $item->quantity;

                $line_discount_amount_total = $line_discount_amount_unid * $quantity; 

                //dd($item->quantity_returned, $item->unit_price_before_discount, $item->item_tax, $item->quantity);

                $itemProduct =[
                    "codigoPrincipal" => strval($item->product->sku),
                    "codigoAuxiliar" => strval($item->product->sku),
                    "descripcionProducto" => $item->product->name,
                    "notaProducto" => "",
                    "cantidad" => $quantity,
                    "precioUnitario" => $item->unit_price_before_discount,
                    "subtotalProducto" => $subtotalProducto,
                    "descuentoProducto" => $line_discount_amount_total,
                    "montoIvaProducto" => $item_tax_total 
                ];

                $tax_amount = $tax_amount + $item_tax_total;

                if($item_tax_total > 0){
                    $tax_product=$item->product->product_tax->amount;
                    $baseGravableIva = $baseGravableIva + $subtotalProducto;
                }else{
                    $baseNoGravableIva = $baseNoGravableIva + $subtotalProducto;
                }

                $listProduct[] = $itemProduct;

            }
            
            
        }

        $impuesto = [
            '0' => [
                "codigoSriAts" => "2",
                "codigoSriDocumentoElectronico" => "0",
                "porcentaje" => 0.00,
            ],
            '13' => [
                "codigoSriAts" => "2",
                "codigoSriDocumentoElectronico" => "10",
                "porcentaje" => 13.00,
            ],
            '14' => [
                "codigoSriAts" => "2",
                "codigoSriDocumentoElectronico" => "3",
                "porcentaje" => 14.00,
            ],
            '15' => [
                "codigoSriAts" => "2",
                "codigoSriDocumentoElectronico" => "4",
                "porcentaje" => 15.00,
            ],
            '5' => [
                "codigoSriAts" => "2",
                "codigoSriDocumentoElectronico" => "5",
                "porcentaje" => 5.00,
            ]
        ];

        //$tax = $impuesto[(int)$transaction->tax->amount];
        //$tax_0 = $impuesto['0'];

        $tax = $impuesto[(int)$tax_product != 0 ? (int)$tax_product : 15 ];
        $tax_0 = $impuesto['0'];

        $payment = [
            'cash' => [
                "codigoSriDocumentoElectronico" => "01",
                "monto" => 0,
                "cantidadDias" => 0,
                "descripcion" => "SIN UTILIZACION DEL SISTEMA FINACIERO",
            ],
            'card' => [
                "codigoSriDocumentoElectronico" => "16",
                "monto" => 0,
                "cantidadDias" => 0,
                "descripcion" => "TARJETA",
            ],
            'cheque' => [
                "codigoSriDocumentoElectronico" => "20",
                "monto" => 0,
                "cantidadDias" => 0,
                "descripcion" => "OTROS CON UTILIZACIÓN DEL SISTEMA FINACIERO",
            ], 
            'bank_transfer' => [
                "codigoSriDocumentoElectronico" => "17",
                "monto" => 0,
                "cantidadDias" => 0,
                "descripcion" => "DINERO ELECTRONICO",
            ],
            'other' => [
                "codigoSriDocumentoElectronico" => "20",
                "monto" => 0,
                "cantidadDias" => 0,
                "descripcion" => "OTROS CON UTILIZACIÓN DEL SISTEMA FINACIERO",
            ]
        ];


        $codDocModificado = "01";
		$numDocModificado = $transaction->transaction_parent->invoice_no;
		$motivo = "Devolucion de producto";
		$fechaEmisionDocSustento = \Carbon\Carbon::parse($transaction->transaction_parent->trasacctransaction_date)->format('d-m-Y');


        $data = [
            "dataEmpresa" => [
                "id" => $business_id,
                "ambiente" => env('ambiente'),
                "emision" => 1,
                "razonSocial" => $transaction->location->business->name,
                "nombreComercial" => $transaction->location->name,
                "ruc" => env('RUC'),
                "direccion" => env('direccion'),
                "obligadoContabilidad" => env('obligadoContabilidad'),
                "agenteRetenedor" => env('agenteRetenedor'),
                "resolucionAgenteRetenedor" => env('resolucionAgenteRetenedor'),
                "contribuyenteRimpe" => env('contribuyenteRimpe'),
                "contribuyenteRimpeNegocioPopular" => env('contribuyenteRimpeNegocioPopular'),
                "contribuyenteEspecial" => env('contribuyenteEspecial'),
                "idContribuyenteEspecial" => env('idContribuyenteEspecial'),
                "email" => $transaction->location->business->email ? $transaction->location->business->email: env('email'),
                "rutaLogo" => "logos/1204763948001/logo.png",
                "logoGeneral" => "logos/logo_general.png"
            ],
            "dataInfo" => [
                "numeroDocumento" => $transaction->invoice_no,
                "direccionBodega" =>  $direccion_sucursal,
                "fecha" => \Carbon\Carbon::parse($transaction->transaction_date)->format('d-m-Y'),
                "email1" => $transaction->contact->email,
                "email2" => "",
                "email3" => "",
                "codigoCliente" => str_pad($transaction->contact->id, 9, '0', STR_PAD_LEFT),
                "idTipoIdentificacion" => "$contact_type",
                "razonSocial" => $transaction->contact->name,
                "identificacion" => $transaction->contact->contact_id,
                "direccion" =>  $transaction->contact->address_line_1 != null && $transaction->contact->address_line_1 != '' ? $transaction->contact->address_line_1 : "Sin direccion",
                "ciudad" => $transaction->contact->country,
                "telefono" => $transaction->contact->mobile,
                "subtotal" => number_format($baseGravableIva+$baseNoGravableIva,2,'.',''),
                "descuento" => number_format($transaction->discount_amount,2,'.',''),
                "baseGravableIva" => number_format($baseGravableIva,2,'.',''),
                "baseNoGravableIva" => number_format($baseNoGravableIva,2,'.',''),
                "montoIva" => number_format($tax_amount,2,'.',''),
                "montoRecargo" => 0.00,
                "flete" => 0.00,
                "montoNeto" => number_format($transaction->final_total,2,'.',''),
                "moneda" => 'DOLAR',
                "clave" => $transaction->sri[0]->clave_acceso,
                "autorizacion"=> $transaction->sri[0]->autorizacion,
                "fechaAutorizacion"=> $transaction->sri[0]->fecha_autorizacion,
                "codDocModificado" => $codDocModificado,
                "numDocModificado" => $numDocModificado,
                "motivo" => $motivo,
                "fechaEmisionDocSustento" => $fechaEmisionDocSustento
            ],
            "dataTipoImpuesto" => $tax,
            "dataTipoImpuesto_0" => $tax_0,
            "dataItem" => $listProduct,
            "dataItemAdicional" => [
                ["campo" => "codigo"],
                ["campo" => "email"],
                ["campo" => "direccion"]
            ],
            "dataInfoAdicional" => [
                
            ]
        ];

        //dd($data);

        $jsonData = json_encode($data);

        // Opcional: verifica el resultado
        if ($jsonData === false) {
            echo "Error al convertir el array a JSON: " . json_last_error_msg();
        } else {
            //echo $jsonData; // Muestra el JSON o envíalo a la API
            //dd($jsonData);
        }

        $url = env('URL_FACTURACION') . '/notacredito/create-ride';

        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_POST, TRUE);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $jsonData);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($curl);

        $http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);

        //dd($response);

        if ($response === false) {
            echo "Error en la solicitud CURL: " . curl_error($curl);
            /*Log::error('API request failed', [
                'status' => $response->status(),
                'response' => $response->body()
            ]);*/

            //dd(1,$response);
            return response()->json(['error' => 'API request failed'], 500);

        } else {
            //dd(2,$response);
            // Decodificar JSON a un array asociativo en PHP
            $decodedResponse = json_decode($response, true);

            return response()->json($decodedResponse, 200);
            //echo "Respuesta de la API: " . $response;
        }

        curl_close($curl);

    }

}

