<div class="row">
  <div class="col-sm-12">
    <table class="table table-condensed">
        
        <tr>
            <th>
              @lang('expense.expenses'):
            </th>
        </tr>        
        
        <tr>
            <th>@lang('expense.expense_category')</th>
            <th>@lang('expense.expense')</th>
            <th>@lang('expense.expense_status')</th>
            <th>@lang('expense.expense_note')</th>
        </tr>
        
        @php
            $total_expense = 0;
            use App\Utils\TransactionUtil;
            $transactionUtil = new TransactionUtil();
            
            $expenses = $transactionUtil->getListExpensesPOS('1',
                                                             $register_details->location_id,
                                                             $register_details->open_time,
                                                             $register_details->close_time ?? now(),
                                                             $register_details->user_id
                                                            );
        @endphp
        
        @foreach($expenses as $expense)
            @if($expense['type'] == 'expense')
            
                <tr>
                    <td>{{$expense['category']}}</td>
                    <td><span class="display_currency" data-currency_symbol="true">{{$expense['final_total']}}</span></td>
                    <td>{{$expense['payment_status']}}</td>
                    <td>{{$expense['additional_notes']}}</td>
                </tr>
                 
                @php
                    $total_expense += $expense['final_total'];
                @endphp
            @endif    
        @endforeach
        <tr class="success">
            <th>
              @lang('expense.total_expense')
            </th>
            <td>
              <b><span class="display_currency" data-currency_symbol="true">{{$total_expense}}</span></b>
            </td>
         </tr>  
    </table>
  </div>
</div>
