<!-- business information here -->

<div class="row" style="color: #000000 !important;">
    <div class="col-xs-12 text-center">
        <h2 class="text-center">
            COMANDA
        </h2>
    </div>
    <div class="col-xs-12 text-center">
        <p style="width: 100% !important" class="word-wrap">
            <span class="pull-left text-left word-wrap">
                @if (!empty($receipt_details->invoice_no_prefix))
                    <b>{!! $receipt_details->invoice_no_prefix !!}</b>
                @endif

                {{ $receipt_details->invoice_no }}

                @if (!empty($receipt_details->table_label) || !empty($receipt_details->table))
                    <br />
                    <span class="pull-left text-left">
                        @if (!empty($receipt_details->table_label))
                            <b>{!! $receipt_details->table_label !!}</b>
                        @endif

                        {{ $receipt_details->table }}
                    </span>
                @endif

                @if (!empty($receipt_details->sales_person_label))
                    <br />
                    <b>{{ $receipt_details->sales_person_label }}</b> {{ $receipt_details->sales_person }}
                @endif
            </span>

            <span class="pull-right text-left">
                <b>{{ $receipt_details->date_label }}</b> {{ $receipt_details->invoice_date }}


                @if (!empty($receipt_details->service_staff_label) || !empty($receipt_details->service_staff))
                    <br />
                    @if (!empty($receipt_details->service_staff_label))
                        <b>{!! $receipt_details->service_staff_label !!}</b>
                    @endif
                    {{ $receipt_details->service_staff }}
                @endif
            </span>
        </p>
    </div>
</div>

<div class="row" style="color: #000000 !important;">
    <div class="col-xs-12">
        <br />
        <table class="table table-responsive table-slim">
            <thead>
                <tr>
                    <th class="text-left"  width="85%">{{ $receipt_details->table_product_label }}</th>
                    <th class="text-right" width="15%">{{ $receipt_details->table_qty_label }}</th>
                </tr>
            </thead>
            <tbody>
                @forelse($receipt_details->lines as $line)
                    <tr>
                        <td class="text-left">
                            {{ $line['name'] }} {{ $line['product_variation'] }} {{ $line['variation'] }}
                            @if (!empty($line['sub_sku']))
                            , {{ $line['sub_sku'] }}
                            @endif 
                            @if (!empty($line['brand']))
                            , {{ $line['brand'] }}
                            @endif 
                            @if (!empty($line['cat_code']))
                                , {{ $line['cat_code'] }}
                            @endif
                            @if (!empty($line['product_custom_fields']))
                                , {{ $line['product_custom_fields'] }}
                            @endif
                            @if (!empty($line['product_description']))
                                <small>
                                    {!! $line['product_description'] !!}
                                </small>
                            @endif
                            @if (!empty($line['sell_line_note']))
                                <br>
                                <small>
                                    {!! $line['sell_line_note'] !!}
                                </small>
                            @endif
                            @if (!empty($line['lot_number']))
                                <br> {{ $line['lot_number_label'] }}: {{ $line['lot_number'] }}
                            @endif
                            @if (!empty($line['product_expiry']))
                                , {{ $line['product_expiry_label'] }}: {{ $line['product_expiry'] }}
                            @endif

                            @if (!empty($line['warranty_name']))
                            <br><small>{{ $line['warranty_name'] }} </small>
                            @endif 
                            @if (!empty($line['warranty_exp_date']))
                                <small>- {{ @format_date($line['warranty_exp_date']) }} </small>
                            @endif
                            @if (!empty($line['warranty_description']))
                                <small> {{ $line['warranty_description'] ?? '' }}</small>
                            @endif

                            @if ($receipt_details->show_base_unit_details && $line['quantity'] && $line['base_unit_multiplier'] !== 1)
                                <br><small>
                                    1 {{ $line['units'] }} = {{ $line['base_unit_multiplier'] }}
                                    {{ $line['base_unit_name'] }} <br>
                                    {{ $line['base_unit_price'] }} x {{ $line['orig_quantity'] }} =
                                    {{ $line['line_total'] }}
                                </small>
                            @endif
                        </td>
                        <td class="text-right">
                            {{ $line['quantity'] }} {{ $line['units'] }}

                            @if ($receipt_details->show_base_unit_details && $line['quantity'] && $line['base_unit_multiplier'] !== 1)
                                <br><small>
                                    {{ $line['quantity'] }} x {{ $line['base_unit_multiplier'] }} =
                                    {{ $line['orig_quantity'] }} {{ $line['base_unit_name'] }}
                                </small>
                            @endif
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="2">&nbsp;</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>