@extends('layouts.app')
@section('title', __( 'lang_v1.sales_order'))
@section('css')
    <style>
        /* Mensaje flotante sobre la página */
        .processing-message {
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            background-color: rgba(0, 0, 0, 0.8); /* Fondo oscuro */
            color: white;
            padding: 1rem 2rem;
            font-size: 1.25rem;
            border-radius: 8px;
            box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.2);
            z-index: 2000; /* Más alto que otros elementos */
            text-align: center;
        }

        /* Clase oculta */
        .d-none {
            display: none;
        }
    </style>

    <!-- Incluir Select2 CSS -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
@endsection
@section('content')
@php
    function getTypeString($t){
        if($t == 'sell'){
            return 'FAC';
        }elseif ($t == 'sell_return') {
            return 'DEV';
        }

        return '';
    }
@endphp
<div id="preloader" class="d-none text-center">
    <div class="spinner-border text-primary" role="status">
        <span class="sr-only">Cargando...</span>
    </div>
</div>


<!-- Content Header (Page header) -->
<section class="content-header no-print">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">Facturación Electronica
    </h1>
</section>

<!-- Main content -->
<section class="content no-print">


<!-- Mensaje personalizado (oculto por defecto) -->
<div id="processingMessage" class="processing-message d-none">
    Procesando solicitud, por favor espera...
</div>   

@component('components.filters', ['title' => __('report.filters')])
<form method="GET" action="{{ route('get_sales_orders_sri.index') }}"> 
    <div class="col-md-12">
        <!-- Filtro por Cliente -->
        <div class="form-group">
            <label for="client_id">Cliente:</label>
            <select name="client_id" id="client_id" class="form-control" style="width: 100%">
                <option value="">Seleccionar Cliente</option>
                @foreach($clients as $client)
                    <option value="{{ $client->id }}" {{ request('client_id') == $client->id ? 'selected' : '' }}>
                        {{ $client->name }} - {{ $client->contact_id }}
                    </option>
                @endforeach
            </select>
        </div>
    </div>
    <div class="col-md-4">
        <!-- Filtro por Fecha Desde -->
        <div class="form-group">
            <label for="date_from">Fecha Desde:</label>
            <input type="date" name="date_from" id="date_from" class="form-control" value="{{ request('date_from') }}">
        </div>
    </div>
    <div class="col-md-4">
        <!-- Filtro por Fecha Hasta -->
        <div class="form-group">
            <label for="date_to">Fecha Hasta:</label>
            <input type="date" name="date_to" id="date_to" class="form-control" value="{{ request('date_to') }}">
        </div>
    </div>
    <div class="col-md-4">
        <!-- Filtro por Localidad -->
        <div class="form-group">
            <label for="location_id">Localidad:</label>
            <select name="location_id" id="location_id" class="form-control" style="width: 100%">
                <option value="">Seleccionar Localidad</option>
                @foreach($locations as $location)
                    <option value="{{ $location->id }}" {{ request('location_id') == $location->id ? 'selected' : '' }}>
                        {{ $location->name }}
                    </option>
                @endforeach
            </select>
        </div>
    </div>
    <div class="col-md-6">
        <!-- Botón de Buscar -->
        <button type="submit" class="btn btn-primary">Buscar</button>
    </div>
</form>
@endcomponent
@component('components.widget', ['class' => 'box-primary', 'title' => 'Documentos'])
<div class="relative overflow-x-auto">
    <div class="table-responsive">
        <table class="table table-bordered table-striped ajax_view" id="">
            <thead>
                <tr>
                    <th>Accion</th>
                    <th>Tipo</th>
                    <th>Documento</th>
                    <th>Fecha</th>
                    <th width="200">Cliente</th>
                    <th>Valor</th>
                    <th>Correo</th>
                    <th>Estado</th>
                    <th>Respuesta del SRI</th>
                    <th>Detalle</th>
                    
                </tr>
            </thead>

            <tbody>
                @foreach ($transaction as $t) 
                    @php
                        $codeStatus = 0;
                        $status = 'PENDIENTE';
                        $message = '';
                        $detalle = '';
                        $claveAcceso = '';
                        if(count($t->sri) > 0){
                            $sri = (object) $t->sri[0];
                            //dd($sri);
                            $claveAcceso = $sri->clave_acceso;
                            $status = $sri->estado;
                            $message = $sri->respuesta_error_sri_msg; 
                            $detalle = $sri->respuesta_error_sri != '' && $sri->respuesta_error_sri != "\"\""? $sri->respuesta_error_sri  : '';
                            if($status == ''){
                                $status = "ERROR";
                                $codeStatus = 3;
                            }elseIf($status == 'AUTORIZADO'){
                                $codeStatus = 1;
                            }elseIf($status == 'NO AUTORIZADO'){
                                $codeStatus = 3;
                            }else{
                                $codeStatus = 2;
                            }
                        }
                    @endphp
                    <tr>
                        <td>                            
                            
                            <div class="btn-group">
                                <button type="button" class="tw-dw-btn 
                                    tw-dw-btn-xs tw-dw-btn-outline tw-dw-btn-info
                                    tw-w-max dropdown-toggle" 
                                    data-toggle="dropdown" 
                                    aria-expanded="false">Acciones<span class="caret"></span>
                                    <span class="sr-only">Toggle Dropdown</span>
                                </button>
                                    <ul class="dropdown-menu dropdown-menu-left" 
                                    role="menu">
                                        @if($codeStatus!=1)
                                            @if($message=='CLAVE ACCESO REGISTRADA')
                                                <li>
                                                    <a href="javascript:void(0)" 
                                                    onclick="getSalesOrdersSriVerify({{$t->id}},'{{$t->type}}')" class="btn-modal">                                            
                                                        <i class="fas fa-sync-alt"></i>
                                                        Validar
                                                    </a>
                                                </li>
                                            @else
                                                <li>
                                                    <a href="javascript:void(0)" 
                                                    onclick="getSalesOrdersSriSend({{$t->id}},'{{$t->type}}')" class="btn-modal">                                            
                                                        <i class="fas fa-sync-alt"></i>
                                                        Enviar al SRI
                                                    </a>
                                                </li>
                                            @endif
                                        @endif
                                        @if($codeStatus==1)
                                        
                                            <li>
                                                <a href="javascript:void(0)" 
                                                onclick="getSalesOrdersReevio({{$t->id}},'{{$t->type}}')" class="btn-modal">
                                                    <i class="fas fa-envelope"></i>
                                                    Reenvio
                                                </a>
                                            </li>                                        
                                            <li>
                                                <a href="{{url('/get-sales-orders-report-ride/'.$claveAcceso)}}" target="_blank">
                                                    <i class="fas fa-file-pdf"></i> 
                                                    Ride
                                                </a>
                                            </li>
                                            <li>
                                                <a href="{{url('/get-sales-orders-report-xml/'.$claveAcceso)}}" target="_blank">
                                                    <i class="fas fa-file-alt"></i>
                                                    XML
                                                </a>
                                            </li>
                                        @endif
                                        
                                    </ul>
                            </div>  
                        
                        </td>
                        <td>{{getTypeString($t->type)}}</td>
                        <td>{{$t->invoice_no}}</td>
                        <td>{{$t->transaction_date}}</td>
                        <td>{{$t->contact->contact_id }} - {{$t->contact->name}}</td>
                        <td>${{number_format($t->final_total,2,'.','')}}</td>
                        <td>{{$t->contact->email}}</td>
                        <td>
                            @if($codeStatus==1)
                            <span class="label" style="background-color: rgb(22 101 52);">
                                {{$status}}
                            </span>
                            @endif
                            @if($codeStatus==0)
                            <span class="label" style="background-color: rgb(245 158 11);">
                                {{$status}}
                            </span>
                            @endif
                            @if($codeStatus==3)
                            <span class="label" style="background-color: rgb(127 29 29);">
                                {{$status}}
                            </span>
                            @endif
                            @if($codeStatus==2)
                            <span class="label" style="background-color: rgb(79 70 229);">
                                {{$status}}
                            </span>
                            @endif
                        </td>
                        <td>{{$message}}</td>
                        <td ><div style="font-size:12px !important;">{{$detalle}}</div></td>
                        
                    </tr>
                @endforeach
            </tbody>
        
        </table>

        <br>
        <div class="text-right">{{ $transaction->appends(request()->query())->links() }}</div>
        <br>

    </div>
</div>

<div class="modal fade" id="processingModal" tabindex="-1" role="dialog" aria-labelledby="processingModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="processingModalLabel">Procesando solicitud</h5>
        </div>
        <div class="modal-body text-center">
          <div class="spinner-border text-primary" role="status">
            <span class="sr-only">Cargando...</span>
          </div>
          <p class="mt-3">Por favor, espera mientras procesamos tu solicitud.</p>
        </div>
      </div>
    </div>
  </div>
@endcomponent


@php
//dd($transaction )
@endphp
</section>

<!-- /.content -->
@stop
@section('javascript')
@includeIf('sales_order.common_js')

<!-- Incluir Select2 JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>



<script type="text/javascript">

const APP_URL = "{{ config('app.url') }}";

$(document).ready( function(){
    
    $('#sell_list_filter_date_range').daterangepicker(
        dateRangeSettings,
        function (start, end) {
            $('#sell_list_filter_date_range').val(start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format));
            sell_table.ajax.reload();
        }
    );
    $('#sell_list_filter_date_range').on('cancel.daterangepicker', function(ev, picker) {
        $('#sell_list_filter_date_range').val('');
        sell_table.ajax.reload();
    });
    sell_table = $('#sell_table').DataTable({
        processing: true,
        serverSide: true,
        aaSorting: [[1, 'desc']],
        "ajax": {
            "url": '/sells?sale_type=sales_order',
            "data": function ( d ) {
                if($('#sell_list_filter_date_range').val()) {
                    var start = $('#sell_list_filter_date_range').data('daterangepicker').startDate.format('YYYY-MM-DD');
                    var end = $('#sell_list_filter_date_range').data('daterangepicker').endDate.format('YYYY-MM-DD');
                    d.start_date = start;
                    d.end_date = end;
                }

                if($('#sell_list_filter_location_id').length) {
                    d.location_id = $('#sell_list_filter_location_id').val();
                }
                d.customer_id = $('#sell_list_filter_customer_id').val();

                if ($('#so_list_filter_status').length) {
                    d.status = $('#so_list_filter_status').val();
                }
                if ($('#so_list_shipping_status').length) {
                    d.shipping_status = $('#so_list_shipping_status').val();
                }

                if($('#created_by').length) {
                    d.created_by = $('#created_by').val();
                }
            }
        },
        columnDefs: [ {
            "targets": 7,
            "orderable": false,
            "searchable": false
        } ],
        columns: [
            { data: 'action', name: 'action'},
            { data: 'transaction_date', name: 'transaction_date'  },
            { data: 'invoice_no', name: 'invoice_no'},
            { data: 'conatct_name', name: 'conatct_name'},
            { data: 'mobile', name: 'contacts.mobile'},
            { data: 'business_location', name: 'bl.name'},
            { data: 'status', name: 'status'},
            { data: 'shipping_status', name: 'shipping_status'},
            { data: 'so_qty_remaining', name: 'so_qty_remaining', "searchable": false},
            { data: 'added_by', name: 'u.first_name'},
        ]
    });
    $(document).on('change', '#sell_list_filter_location_id, #sell_list_filter_customer_id, #created_by, #so_list_filter_status, #so_list_shipping_status',  function() {
        sell_table.ajax.reload();
    });
});


function getSalesOrdersSriVerify(id,type) {

    const message = document.getElementById('processingMessage');

    // Mostrar el mensaje
    message.classList.remove('d-none');

    let url = ''; 

    if(type=='sell'){
        url = `${APP_URL}/get-sales-orders-sri-verify/${id}`;
    }else if(type=='sell_return'){
        url = `${APP_URL}/get-sales-orders-sri-verify-dev/${id}`;
    }
    
    const csrfToken = document.querySelector('meta[name="csrf-token"]').content;

    fetch(url,{
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': csrfToken
        }
    })
        .then(response => {
            if (!response.ok) {
                throw new Error(`Error: ${response.status}`);
            }
            return response.json(); // Asume que el servidor retorna JSON
        })
        .then(data => {
            console.log("Respuesta del servidor:", data);
            
            setTimeout(() => {
                location.reload(); // Recargar la página
            }, 2000); // Espera de 2 segundos
        })
        .catch(error => {
            console.error("Error en la solicitud:", error);
            
            setTimeout(() => {
                location.reload(); // Recargar la página
            }, 2000); // Espera de 2 segundos
        });
}

function getSalesOrdersSriSend(id,type) {

const message = document.getElementById('processingMessage');

// Mostrar el mensaje
message.classList.remove('d-none');

let url = '';

//const url = `/get-sales-orders-sri-send/${id}`;
if(type=='sell'){
    url = `${APP_URL}get-sales-orders-sri-send/${id}`;
}else if(type=='sell_return'){
    url = `${APP_URL}get-sales-orders-sri-send-dev/${id}`;
}
const csrfToken = document.querySelector('meta[name="csrf-token"]').content;

fetch(url,{
    headers: {
        'Content-Type': 'application/json',
        'X-CSRF-TOKEN': csrfToken
    }
})
    .then(response => {
        if (!response.ok) {
            throw new Error(`Error: ${response.status}`);
        }
        return response.json(); // Asume que el servidor retorna JSON
    })
    .then(data => {
        console.log("Respuesta del servidor:", data);
        
        setTimeout(() => {
            location.reload(); // Recargar la página
        }, 2000); // Espera de 2 segundos
    })
    .catch(error => {
        console.error("Error en la solicitud:", error);
        
        setTimeout(() => {
            //location.reload(); // Recargar la página
        }, 2000); // Espera de 2 segundos
    });
}

function getSalesOrdersReevio(id,type) {

const message = document.getElementById('processingMessage');

// Mostrar el mensaje
message.classList.remove('d-none');

let url = '';

//const url = `/get-sales-orders-sri-ride/${id}`;
if(type=='sell'){
    url = `https://grupokalabi.com.ec/mypymes/public/get-sales-orders-sri-ride/${id}`;
}else if(type=='sell_return'){
    url = `https://grupokalabi.com.ec/mypymes/public/get-sales-orders-sri-ride-dev/${id}`;
}
const csrfToken = document.querySelector('meta[name="csrf-token"]').content;

fetch(url,{
    headers: {
        'Content-Type': 'application/json',
        'X-CSRF-TOKEN': csrfToken
    }
})
    .then(response => {
        if (!response.ok) {
            throw new Error(`Error: ${response.status}`);
        }
        return response.json(); // Asume que el servidor retorna JSON
    })
    .then(data => {
        console.log("Respuesta del servidor:", data);
        
        setTimeout(() => {
            location.reload(); // Recargar la página
        }, 2000); // Espera de 2 segundos
    })
    .catch(error => {
        console.error("Error en la solicitud:", error);
        
        setTimeout(() => {
            location.reload(); // Recargar la página
        }, 2000); // Espera de 2 segundos
    });
}




</script>
	
@endsection