<div class="modal-dialog modal-lg" role="document">
  <div class="modal-content">

  <?php

    if(isset($update_action)) {
        $url = $update_action;
        $customer_groups = [];
        $opening_balance = 0;
        $lead_users = $contact->leadUsers->pluck('id');
    } else {
      $url = action([\App\Http\Controllers\ContactController::class, 'update'], [$contact->id]);
      $sources = [];
      $life_stages = [];
      $lead_users = [];
      $assigned_to_users = $contact->userHavingAccess->pluck('id');
    }
  ?>

    <?php echo Form::open(['url' => $url, 'method' => 'PUT', 'id' => 'contact_edit_form']); ?>


    <div class="modal-header">
      <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
      <h4 class="modal-title"><?php echo app('translator')->get('contact.edit_contact'); ?></h4>
    </div>

    <div class="modal-body">

      <div class="row">

        <div class="col-md-4">
          <div class="form-group">
              <?php echo Form::label('type', __('contact.contact_type') . ':*' ); ?>

              <div class="input-group">
                  <span class="input-group-addon">
                      <i class="fa fa-user"></i>
                  </span>
                  <?php echo Form::select('type', $types, $contact->type, ['class' => 'form-control', 'id' => 'contact_type','placeholder' => __('messages.please_select'), 'required']); ?>

              </div>
          </div>
        </div>
        <div class="col-md-4 mt-15">
            <label class="radio-inline">
                <input type="radio" name="contact_type_radio" <?php if($contact->contact_type == 'individual'): ?> checked <?php endif; ?> id="inlineRadio1" value="individual" onclick="radioChange('individual')">
                <?php echo app('translator')->get('lang_v1.individual'); ?>
            </label>
            <label class="radio-inline">
                <input type="radio" name="contact_type_radio" <?php if($contact->contact_type == 'business'): ?> checked <?php endif; ?> id="inlineRadio2" value="business" onclick="radioChange('business')">
                <?php echo app('translator')->get('business.business'); ?>
            </label>
            <label class="radio-inline">
                <input type="radio" name="contact_type_radio" <?php if($contact->contact_type == 'passport'): ?> checked <?php endif; ?> id="inlineRadio3" value="passport" onclick="radioChange('passport')">
                Pasaporte
            </label>
        </div>
        <div class="col-md-4">
          <div class="form-group">
              <?php echo Form::label('contact_id', __('lang_v1.contact_id') . ':'); ?>

              <div class="input-group">
                  <span class="input-group-addon">
                      <i class="fa fa-id-badge"></i>
                  </span>
                  <input type="hidden" id="hidden_id" value="<?php echo e($contact->id, false); ?>">
                  <?php echo Form::text('contact_id', $contact->contact_id, ['class' => 'form-control','placeholder' => __('lang_v1.contact_id')]); ?>

                  <span class="input-group-addon" style="padding:0px;">
                    <button 
                        class="btn btn-outline-secondary" 
                        type="button" 
                        id="button-addon2"
                        onclick="searchIdentification()"
                    >
                        <i class="fa fa-search"></i>
                    </button>
                    
                  </span>
              </div>
              <p class="help-block" id="preload-idenfication" style="display: none;">
                <span id="preloader-icon" style="display: inline-block; margin-right: 8px;">🔄</span>
                <span id="preloader-text">Buscando...</span>
              </p>
              
              
          </div>
        </div>
        <div class="col-md-12">
            <hr/>
          </div>
          
          <div class="col-md-6">
            <div class="form-group">
                <?php echo Form::label('address_line_1', __('lang_v1.address_line_1') . ':'); ?>

                <?php echo Form::text('address_line_1', $contact->address_line_1, ['class' => 'form-control', 'placeholder' => __('lang_v1.address_line_1'), 'rows' => 3]); ?>

            </div>
          </div>
          <div class="col-md-6">
            <div class="form-group">
                <?php echo Form::label('address_line_2', __('lang_v1.address_line_2') . ':'); ?>

                <?php echo Form::text('address_line_2', $contact->address_line_2, ['class' => 'form-control', 
                    'placeholder' => __('lang_v1.address_line_2'), 'rows' => 3]); ?>

            </div>
          </div>
        <div class="col-md-4 customer_fields">
          <div class="form-group">
              <?php echo Form::label('customer_group_id', __('lang_v1.customer_group') . ':'); ?>

              <div class="input-group">
                  <span class="input-group-addon">
                      <i class="fa fa-users"></i>
                  </span>
                  <?php echo Form::select('customer_group_id', $customer_groups, $contact->customer_group_id, ['class' => 'form-control']); ?>

              </div>
          </div>
        </div>
        <div class="col-md-8">
            <div class="form-group">
                <?php echo Form::label('email', __('business.email') . ':'); ?>

                <div class="input-group">
                    <span class="input-group-addon">
                        <i class="fa fa-envelope"></i>
                    </span>
                    <?php echo Form::email('email', $contact->email, ['class' => 'form-control','placeholder' => __('business.email')]); ?>

                </div>
            </div>
        </div>
        <div class="clearfix customer_fields"></div>
        <div class="col-md-12 business" <?php if($contact->contact_type == 'individual' || $contact->contact_type == 'passport' || empty($contact->contact_type)): ?> style="display: none;"  <?php endif; ?>>
          <div class="form-group">
              <?php echo Form::label('supplier_business_name', __('business.business_name') . ':'); ?>

              <div class="input-group">
                  <span class="input-group-addon">
                      <i class="fa fa-briefcase"></i>
                  </span>
                  <?php echo Form::text('supplier_business_name', 
                  $contact->supplier_business_name, ['class' => 'form-control', 'placeholder' => __('business.business_name')]); ?>

              </div>
          </div>
        </div>
        <div class="clearfix"></div>
        <div class="col-md-3 individual"  <?php if($contact->contact_type == 'business' || $contact->contact_type == 'passport' || empty($contact->contact_type)): ?> style="display: none;"  <?php endif; ?>>
                <div class="form-group">
                    <?php echo Form::label('prefix', __( 'business.prefix' ) . ':'); ?>

                    <?php echo Form::text('prefix', $contact->prefix, ['class' => 'form-control', 'placeholder' => __( 'business.prefix_placeholder' ) ]); ?>

                </div>
            </div>
            <div class="col-md-3 individual" <?php if($contact->contact_type == 'business' || $contact->contact_type == 'passport' || empty($contact->contact_type)): ?> style="display: none;"  <?php endif; ?>>
                <div class="form-group">
                    <?php echo Form::label('first_name', __( 'business.first_name' ) . ':*'); ?>

                    <?php echo Form::text('first_name', $contact->first_name, ['class' => 'form-control', 'required', 'placeholder' => __( 'business.first_name' ) ]); ?>

                </div>
            </div>
            <div class="col-md-3 individual" <?php if($contact->contact_type == 'business' || $contact->contact_type == 'passport' || empty($contact->contact_type)): ?> style="display: none;"  <?php endif; ?>>
                <div class="form-group">
                    <?php echo Form::label('middle_name', __( 'lang_v1.middle_name' ) . ':'); ?>

                    <?php echo Form::text('middle_name', $contact->middle_name, ['class' => 'form-control', 'placeholder' => __( 'lang_v1.middle_name' ) ]); ?>

                </div>
            </div>
            <div class="col-md-3 individual" <?php if($contact->contact_type == 'business' || $contact->contact_type == 'passport' || empty($contact->contact_type)): ?> style="display: none;"  <?php endif; ?>>
                <div class="form-group">
                    <?php echo Form::label('last_name', __( 'business.last_name' ) . ':'); ?>

                    <?php echo Form::text('last_name', $contact->last_name, ['class' => 'form-control', 'placeholder' => __( 'business.last_name' ) ]); ?>

                </div>
            </div>
            <div class="clearfix"></div>

            <div class="col-md-3 passport"  <?php if($contact->contact_type == 'business' || $contact->contact_type == 'individual' || empty($contact->contact_type)): ?> style="display: none;"  <?php endif; ?>>
                <div class="form-group">
                    <?php echo Form::label('prefix', __( 'business.prefix' ) . ':'); ?>

                    <?php echo Form::text('prefix', $contact->prefix, ['class' => 'form-control', 'placeholder' => __( 'business.prefix_placeholder' ) ]); ?>

                </div>
            </div>
            <div class="col-md-3 passport" <?php if($contact->contact_type == 'business' || $contact->contact_type == 'individual' || empty($contact->contact_type)): ?> style="display: none;"  <?php endif; ?>>
                <div class="form-group">
                    <?php echo Form::label('first_name', __( 'business.first_name' ) . ':*'); ?>

                    <?php echo Form::text('first_name', $contact->first_name, ['class' => 'form-control', 'required', 'placeholder' => __( 'business.first_name' ) ]); ?>

                </div>
            </div>
            <div class="col-md-3 passport" <?php if($contact->contact_type == 'business' || $contact->contact_type == 'individual' || empty($contact->contact_type)): ?> style="display: none;"  <?php endif; ?>>
                <div class="form-group">
                    <?php echo Form::label('middle_name', __( 'lang_v1.middle_name' ) . ':'); ?>

                    <?php echo Form::text('middle_name', $contact->middle_name, ['class' => 'form-control', 'placeholder' => __( 'lang_v1.middle_name' ) ]); ?>

                </div>
            </div>
            <div class="col-md-3 passport" <?php if($contact->contact_type == 'business' || $contact->contact_type == 'individual' || empty($contact->contact_type)): ?> style="display: none;"  <?php endif; ?>>
                <div class="form-group">
                    <?php echo Form::label('last_name', __( 'business.last_name' ) . ':'); ?>

                    <?php echo Form::text('last_name', $contact->last_name, ['class' => 'form-control', 'placeholder' => __( 'business.last_name' ) ]); ?>

                </div>
            </div>
            <div class="clearfix"></div>

      <div class="col-md-4">
        <div class="form-group">
            <?php echo Form::label('mobile', __('contact.mobile') . ':*'); ?>

            <div class="input-group">
                <span class="input-group-addon">
                    <i class="fa fa-mobile"></i>
                </span>
                <?php echo Form::text('mobile', $contact->mobile, ['class' => 'form-control', 'required', 'placeholder' => __('contact.mobile')]); ?>

            </div>
        </div>
      </div>
      <div class="col-md-4">
        <div class="form-group">
            <?php echo Form::label('alternate_number', __('contact.alternate_contact_number') . ':'); ?>

            <div class="input-group">
                <span class="input-group-addon">
                    <i class="fa fa-phone"></i>
                </span>
                <?php echo Form::text('alternate_number', $contact->alternate_number, ['class' => 'form-control', 'placeholder' => __('contact.alternate_contact_number')]); ?>

            </div>
        </div>
      </div>
      <div class="col-md-4">
        <div class="form-group">
            <?php echo Form::label('landline', __('contact.landline') . ':'); ?>

            <div class="input-group">
                <span class="input-group-addon">
                    <i class="fa fa-phone"></i>
                </span>
                <?php echo Form::text('landline', $contact->landline, ['class' => 'form-control', 'placeholder' => __('contact.landline')]); ?>

            </div>
        </div>
      </div>
      

        <div class="col-sm-4">
            <div class="form-group individual" <?php if($contact->contact_type == 'business'): ?> style="display: none;"  <?php endif; ?>>
                <?php echo Form::label('dob', __('lang_v1.dob') . ':'); ?>

                <div class="input-group">
                    <span class="input-group-addon">
                        <i class="fa fa-calendar"></i>
                    </span>
                    
                    <?php echo Form::text('dob', !empty($contact->dob) ? \Carbon::createFromTimestamp(strtotime($contact->dob))->format(session('business.date_format')) : null, ['class' => 'form-control dob-date-picker','placeholder' => __('lang_v1.dob'), 'readonly']); ?>

                </div>
            </div>
        </div>
        
        <!-- lead additional field -->
        <div class="col-md-4 lead_additional_div">
          <div class="form-group">
              <?php echo Form::label('crm_source', __('lang_v1.source') . ':' ); ?>

              <div class="input-group">
                  <span class="input-group-addon">
                      <i class="fas fa fa-search"></i>
                  </span>
                  <?php echo Form::select('crm_source', $sources, $contact->crm_source , ['class' => 'form-control', 'id' => 'crm_source','placeholder' => __('messages.please_select')]); ?>

              </div>
          </div>
        </div>
        <div class="col-md-4 lead_additional_div">
          <div class="form-group">
              <?php echo Form::label('crm_life_stage', __('lang_v1.life_stage') . ':' ); ?>

              <div class="input-group">
                  <span class="input-group-addon">
                      <i class="fas fa fa-life-ring"></i>
                  </span>
                  <?php echo Form::select('crm_life_stage', $life_stages, $contact->crm_life_stage , ['class' => 'form-control', 'id' => 'crm_life_stage','placeholder' => __('messages.please_select')]); ?>

              </div>
          </div>
        </div>
        <div class="col-md-6 lead_additional_div">
          <div class="form-group">
              <?php echo Form::label('user_id', __('lang_v1.assigned_to') . ':*' ); ?>

              <div class="input-group">
                  <span class="input-group-addon">
                      <i class="fa fa-user"></i>
                  </span>
                  <?php echo Form::select('user_id[]', $users, $lead_users , ['class' => 'form-control select2', 'id' => 'user_id', 'multiple', 'required', 'style' => 'width: 100%;']); ?>

              </div>
          </div>
        </div>

        <?php if(config('constants.enable_contact_assign') && $contact->type !== 'lead'): ?>
          <!-- User in create customer & supplier -->
          <div class="col-md-6">
                <div class="form-group">
                    <?php echo Form::label('assigned_to_users', __('lang_v1.assigned_to') . ':' ); ?>

                    <div class="input-group">
                        <span class="input-group-addon">
                            <i class="fa fa-user"></i>
                        </span>
                        <?php echo Form::select('assigned_to_users[]', $users, $assigned_to_users ?? [] , ['class' => 'form-control select2', 'id' => 'assigned_to_users', 'multiple', 'style' => 'width: 100%;']); ?>

                    </div>
                </div>
          </div>
        <?php endif; ?>

        <div class="col-md-12">
            <button type="button" class="tw-dw-btn tw-dw-btn-primary tw-text-white center-block more_btn" data-target="#more_div"><?php echo app('translator')->get('lang_v1.more_info'); ?> <i class="fa fa-chevron-down"></i></button>
        </div>
        
        <div id="more_div" class="hide">

            <div class="col-md-12"><hr/></div>
        
        <div class="col-md-4">
          <div class="form-group">
              <?php echo Form::label('tax_number', __('contact.tax_no') . ':'); ?>

              <div class="input-group">
                  <span class="input-group-addon">
                      <i class="fa fa-info"></i>
                  </span>
                  <?php echo Form::text('tax_number', $contact->tax_number, ['class' => 'form-control', 'placeholder' => __('contact.tax_no')]); ?>

              </div>
          </div>
        </div>

        
        <div class="col-md-4 opening_balance">
          <div class="form-group">
              <?php echo Form::label('opening_balance', __('lang_v1.opening_balance') . ':'); ?>

              <div class="input-group">
                  <span class="input-group-addon">
                      <i class="fas fa-money-bill-alt"></i>
                  </span>
                  <?php echo Form::text('opening_balance', $opening_balance, ['class' => 'form-control input_number']); ?>

              </div>
          </div>
        </div>

        <div class="col-md-4 pay_term">
          <div class="form-group">
            <div class="multi-input">
              <?php echo Form::label('pay_term_number', __('contact.pay_term') . ':'); ?> <?php
                if(session('business.enable_tooltip')){
                    echo '<i class="fa fa-info-circle text-info hover-q no-print " aria-hidden="true" 
                    data-container="body" data-toggle="popover" data-placement="auto bottom" 
                    data-content="' . __('tooltip.pay_term') . '" data-html="true" data-trigger="hover"></i>';
                }
                ?>
              <br/>
              <?php echo Form::number('pay_term_number', $contact->pay_term_number, ['class' => 'form-control width-40 pull-left', 'placeholder' => __('contact.pay_term')]); ?>


              <?php echo Form::select('pay_term_type', ['months' => __('lang_v1.months'), 'days' => __('lang_v1.days')], $contact->pay_term_type, ['class' => 'form-control width-60 pull-left','placeholder' => __('messages.please_select')]); ?>

            </div>
          </div>
        </div>
        <div class="clearfix"></div>
        
        <div class="col-md-4 customer_fields">
          <div class="form-group">
              <?php echo Form::label('credit_limit', __('lang_v1.credit_limit') . ':'); ?>

              <div class="input-group">
                  <span class="input-group-addon">
                      <i class="fas fa-money-bill-alt"></i>
                  </span>
                  <?php echo Form::text('credit_limit', $contact->credit_limit != null ? number_format($contact->credit_limit, session('business.currency_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator']) : null, ['class' => 'form-control input_number']); ?>

              </div>
              <p class="help-block"><?php echo app('translator')->get('lang_v1.credit_limit_help'); ?></p>
          </div>
        </div>
          
      <div class="col-md-12">
        <hr/>
      </div>
      
      <!--<div class="col-md-6">
        <div class="form-group">
            <?php echo Form::label('address_line_1', __('lang_v1.address_line_1') . ':'); ?>

            <?php echo Form::text('address_line_1', $contact->address_line_1, ['class' => 'form-control', 'placeholder' => __('lang_v1.address_line_1'), 'rows' => 3]); ?>

        </div>
      </div>
      <div class="col-md-6">
        <div class="form-group">
            <?php echo Form::label('address_line_2', __('lang_v1.address_line_2') . ':'); ?>

            <?php echo Form::text('address_line_2', $contact->address_line_2, ['class' => 'form-control', 
                'placeholder' => __('lang_v1.address_line_2'), 'rows' => 3]); ?>

        </div>
      </div>-->
      <div class="clearfix"></div>
      <div class="col-md-3">
        <div class="form-group">
            <?php echo Form::label('city', __('business.city') . ':'); ?>

            <div class="input-group">
                <span class="input-group-addon">
                    <i class="fa fa-map-marker"></i>
                </span>
                <?php echo Form::text('city', $contact->city, ['class' => 'form-control', 'placeholder' => __('business.city')]); ?>

            </div>
        </div>
      </div>
      <div class="col-md-3">
        <div class="form-group">
            <?php echo Form::label('state', __('business.state') . ':'); ?>

            <div class="input-group">
                <span class="input-group-addon">
                    <i class="fa fa-map-marker"></i>
                </span>
                <?php echo Form::text('state', $contact->state, ['class' => 'form-control', 'placeholder' => __('business.state')]); ?>

            </div>
        </div>
      </div>
      <div class="col-md-3">
        <div class="form-group">
            <?php echo Form::label('country', __('business.country') . ':'); ?>

            <div class="input-group">
                <span class="input-group-addon">
                    <i class="fa fa-globe"></i>
                </span>
                <?php echo Form::text('country', $contact->country, ['class' => 'form-control', 'placeholder' => __('business.country')]); ?>

            </div>
        </div>
      </div>
      <div class="col-md-3">
        <div class="form-group">
            <?php echo Form::label('zip_code', __('business.zip_code') . ':'); ?>

            <div class="input-group">
                <span class="input-group-addon">
                    <i class="fa fa-map-marker"></i>
                </span>
                <?php echo Form::text('zip_code', $contact->zip_code, ['class' => 'form-control', 
                'placeholder' => __('business.zip_code_placeholder')]); ?>

            </div>
        </div>
      </div>
      <div class="clearfix"></div>
      <div class="col-md-12">
        <hr/>
      </div>
      <?php
        $custom_labels = json_decode(session('business.custom_labels'), true);
        $contact_custom_field1 = !empty($custom_labels['contact']['custom_field_1']) ? $custom_labels['contact']['custom_field_1'] : __('lang_v1.contact_custom_field1');
        $contact_custom_field2 = !empty($custom_labels['contact']['custom_field_2']) ? $custom_labels['contact']['custom_field_2'] : __('lang_v1.contact_custom_field2');
        $contact_custom_field3 = !empty($custom_labels['contact']['custom_field_3']) ? $custom_labels['contact']['custom_field_3'] : __('lang_v1.contact_custom_field3');
        $contact_custom_field4 = !empty($custom_labels['contact']['custom_field_4']) ? $custom_labels['contact']['custom_field_4'] : __('lang_v1.contact_custom_field4');
        $contact_custom_field5 = !empty($custom_labels['contact']['custom_field_5']) ? $custom_labels['contact']['custom_field_5'] : __('lang_v1.custom_field', ['number' => 5]);
        $contact_custom_field6 = !empty($custom_labels['contact']['custom_field_6']) ? $custom_labels['contact']['custom_field_6'] : __('lang_v1.custom_field', ['number' => 6]);
        $contact_custom_field7 = !empty($custom_labels['contact']['custom_field_7']) ? $custom_labels['contact']['custom_field_7'] : __('lang_v1.custom_field', ['number' => 7]);
        $contact_custom_field8 = !empty($custom_labels['contact']['custom_field_8']) ? $custom_labels['contact']['custom_field_8'] : __('lang_v1.custom_field', ['number' => 8]);
        $contact_custom_field9 = !empty($custom_labels['contact']['custom_field_9']) ? $custom_labels['contact']['custom_field_9'] : __('lang_v1.custom_field', ['number' => 9]);
        $contact_custom_field10 = !empty($custom_labels['contact']['custom_field_10']) ? $custom_labels['contact']['custom_field_10'] : __('lang_v1.custom_field', ['number' => 10]);
      ?>
      <div class="col-md-3">
        <div class="form-group">
            <?php echo Form::label('custom_field1', $contact_custom_field1 . ':'); ?>

            <?php echo Form::text('custom_field1', $contact->custom_field1, ['class' => 'form-control', 
                'placeholder' => $contact_custom_field1]); ?>

        </div>
      </div>
      <div class="col-md-3">
        <div class="form-group">
            <?php echo Form::label('custom_field2', $contact_custom_field2 . ':'); ?>

            <?php echo Form::text('custom_field2', $contact->custom_field2, ['class' => 'form-control', 
                'placeholder' => $contact_custom_field2]); ?>

        </div>
      </div>
      <div class="col-md-3">
        <div class="form-group">
            <?php echo Form::label('custom_field3', $contact_custom_field3 . ':'); ?>

            <?php echo Form::text('custom_field3', $contact->custom_field3, ['class' => 'form-control', 
                'placeholder' => $contact_custom_field3]); ?>

        </div>
      </div>
      <div class="col-md-3">
        <div class="form-group">
            <?php echo Form::label('custom_field4', $contact_custom_field4 . ':'); ?>

            <?php echo Form::text('custom_field4', $contact->custom_field4, ['class' => 'form-control', 
                'placeholder' => $contact_custom_field4]); ?>

        </div>
      </div>
      <div class="col-md-3">
        <div class="form-group">
            <?php echo Form::label('custom_field5', $contact_custom_field5 . ':'); ?>

            <?php echo Form::text('custom_field5', $contact->custom_field5, ['class' => 'form-control', 
                'placeholder' => $contact_custom_field5]); ?>

        </div>
      </div>
      <div class="col-md-3">
        <div class="form-group">
            <?php echo Form::label('custom_field6', $contact_custom_field6 . ':'); ?>

            <?php echo Form::text('custom_field6', $contact->custom_field6, ['class' => 'form-control', 
                'placeholder' => $contact_custom_field6]); ?>

        </div>
      </div>
      <div class="col-md-3">
        <div class="form-group">
            <?php echo Form::label('custom_field7', $contact_custom_field7 . ':'); ?>

            <?php echo Form::text('custom_field7', $contact->custom_field7, ['class' => 'form-control', 
                'placeholder' => $contact_custom_field7]); ?>

        </div>
      </div>
      <div class="col-md-3">
        <div class="form-group">
            <?php echo Form::label('custom_field8', $contact_custom_field8 . ':'); ?>

            <?php echo Form::text('custom_field8', $contact->custom_field8, ['class' => 'form-control', 
                'placeholder' => $contact_custom_field8]); ?>

        </div>
      </div>
      <div class="col-md-3">
        <div class="form-group">
            <?php echo Form::label('custom_field9', $contact_custom_field9 . ':'); ?>

            <?php echo Form::text('custom_field9', $contact->custom_field9, ['class' => 'form-control', 
                'placeholder' => $contact_custom_field9]); ?>

        </div>
      </div>
      <div class="col-md-3">
        <div class="form-group">
            <?php echo Form::label('custom_field10', $contact_custom_field10 . ':'); ?>

            <?php echo Form::text('custom_field10', $contact->custom_field10, ['class' => 'form-control', 
                'placeholder' => $contact_custom_field10]); ?>

        </div>
      </div>
      <div class="clearfix"></div>
      <div class="col-md-12 shipping_addr_div"><hr></div>
      <div class="col-md-8 col-md-offset-2 shipping_addr_div mb-10" >
          <strong><?php echo e(__('lang_v1.shipping_address'), false); ?></strong><br>
          <?php echo Form::text('shipping_address', $contact->shipping_address, ['class' => 'form-control', 
                'placeholder' => __('lang_v1.search_address'), 'id' => 'shipping_address']); ?>

        <div class="mb-10" id="map"></div>
      </div>
      <?php echo Form::hidden('position', $contact->position, ['id' => 'position']); ?>

        <?php
            $shipping_custom_label_1 = !empty($custom_labels['shipping']['custom_field_1']) ? $custom_labels['shipping']['custom_field_1'] : '';

            $shipping_custom_label_2 = !empty($custom_labels['shipping']['custom_field_2']) ? $custom_labels['shipping']['custom_field_2'] : '';

            $shipping_custom_label_3 = !empty($custom_labels['shipping']['custom_field_3']) ? $custom_labels['shipping']['custom_field_3'] : '';

            $shipping_custom_label_4 = !empty($custom_labels['shipping']['custom_field_4']) ? $custom_labels['shipping']['custom_field_4'] : '';

            $shipping_custom_label_5 = !empty($custom_labels['shipping']['custom_field_5']) ? $custom_labels['shipping']['custom_field_5'] : '';
        ?>

        <?php if(!empty($custom_labels['shipping']['is_custom_field_1_contact_default']) && !empty($shipping_custom_label_1)): ?>
            <?php
                $label_1 = $shipping_custom_label_1 . ':';
            ?>

            <div class="col-md-4">
                <div class="form-group">
                    <?php echo Form::label('shipping_custom_field_1', $label_1 ); ?>

                    <?php echo Form::text('shipping_custom_field_details[shipping_custom_field_1]', !empty($contact->shipping_custom_field_details['shipping_custom_field_1']) ? $contact->shipping_custom_field_details['shipping_custom_field_1'] : null, ['class' => 'form-control','placeholder' => $shipping_custom_label_1]); ?>

                </div>
            </div>
        <?php endif; ?>
        <?php if(!empty($custom_labels['shipping']['is_custom_field_2_contact_default']) && !empty($shipping_custom_label_2)): ?>
            <?php
                $label_2 = $shipping_custom_label_2 . ':';
            ?>

            <div class="col-md-4">
                <div class="form-group">
                    <?php echo Form::label('shipping_custom_field_2', $label_2 ); ?>

                    <?php echo Form::text('shipping_custom_field_details[shipping_custom_field_2]', !empty($contact->shipping_custom_field_details['shipping_custom_field_2']) ? $contact->shipping_custom_field_details['shipping_custom_field_2'] : null, ['class' => 'form-control','placeholder' => $shipping_custom_label_2]); ?>

                </div>
            </div>
        <?php endif; ?>
        <?php if(!empty($custom_labels['shipping']['is_custom_field_3_contact_default']) && !empty($shipping_custom_label_3)): ?>
            <?php
                $label_3 = $shipping_custom_label_3 . ':';
            ?>

            <div class="col-md-4">
                <div class="form-group">
                    <?php echo Form::label('shipping_custom_field_3', $label_3 ); ?>

                    <?php echo Form::text('shipping_custom_field_details[shipping_custom_field_3]', !empty($contact->shipping_custom_field_details['shipping_custom_field_3']) ? $contact->shipping_custom_field_details['shipping_custom_field_3'] : null, ['class' => 'form-control','placeholder' => $shipping_custom_label_3]); ?>

                </div>
            </div>
        <?php endif; ?>
        <?php if(!empty($custom_labels['shipping']['is_custom_field_4_contact_default']) && !empty($shipping_custom_label_4)): ?>
            <?php
                $label_4 = $shipping_custom_label_4 . ':';
            ?>

            <div class="col-md-4">
                <div class="form-group">
                    <?php echo Form::label('shipping_custom_field_4', $label_4 ); ?>

                    <?php echo Form::text('shipping_custom_field_details[shipping_custom_field_4]', !empty($contact->shipping_custom_field_details['shipping_custom_field_4']) ? $contact->shipping_custom_field_details['shipping_custom_field_4'] : null, ['class' => 'form-control','placeholder' => $shipping_custom_label_4]); ?>

                </div>
            </div>
        <?php endif; ?>
        <?php if(!empty($custom_labels['shipping']['is_custom_field_5_contact_default']) && !empty($shipping_custom_label_5)): ?>
            <?php
                $label_5 = $shipping_custom_label_5 . ':';
            ?>

            <div class="col-md-4">
                <div class="form-group">
                    <?php echo Form::label('shipping_custom_field_5', $label_5 ); ?>

                    <?php echo Form::text('shipping_custom_field_details[shipping_custom_field_5]', !empty($contact->shipping_custom_field_details['shipping_custom_field_5']) ? $contact->shipping_custom_field_details['shipping_custom_field_5'] : null, ['class' => 'form-control','placeholder' => $shipping_custom_label_5]); ?>

                </div>
            </div>
        <?php endif; ?>
        <?php
          $common_settings = session()->get('business.common_settings');
        ?>
        <?php if(!empty($common_settings['is_enabled_export'])): ?>
            <div class="col-md-12 mb-12">
                <div class="form-check">
                    <input type="checkbox" name="is_export" class="form-check-input" id="is_customer_export" <?php if(!empty($contact->is_export)): ?> checked <?php endif; ?>>
                    <label class="form-check-label" for="is_customer_export"><?php echo app('translator')->get('lang_v1.is_export'); ?></label>
                </div>
            </div>
            <?php
                $i = 1;
            ?>
            <?php for($i; $i <= 6 ; $i++): ?>
                <div class="col-md-4 export_div" style="display: none;">
                    <div class="form-group">
                        <?php echo Form::label('export_custom_field_'.$i, __('lang_v1.export_custom_field'.$i).':' ); ?>

                        <?php echo Form::text('export_custom_field_'.$i, !empty($contact['export_custom_field_'.$i]) ? $contact['export_custom_field_'.$i] : null, ['class' => 'form-control','placeholder' => __('lang_v1.export_custom_field'.$i)]); ?>

                    </div>
                </div>
            <?php endfor; ?>
        <?php endif; ?>
    </div>
</div>
    </div>

    <div class="modal-footer">
      <button type="submit" id="submit" class="tw-dw-btn tw-dw-btn-primary tw-text-white"><?php echo app('translator')->get( 'messages.update' ); ?></button>
      <button type="button" class="tw-dw-btn tw-dw-btn-neutral tw-text-white" data-dismiss="modal"><?php echo app('translator')->get( 'messages.close' ); ?></button>
    </div>

    <?php echo Form::close(); ?>


  </div><!-- /.modal-content -->
</div><!-- /.modal-dialog -->
<script>

    const info = {
        identification: null, // Cambia a un valor válido para probar
        type_identification: null,
        name: null,
        address: null
    };

    let API_BASE_URL = "<?php echo e(url('/'), false); ?>";

    function radioChange(type){
        // Selecciona todos los radios del grupo
        const radios = type;
        const passportFields = document.querySelectorAll('.passport');
        const individualFields = document.querySelectorAll('.individual');
        const businessFields = document.querySelectorAll('.business');

        console.log(type);
       
        if (type === 'passport') {
            // Ocultar los campos si se selecciona otra opción
            individualFields.forEach((field) => {
                field.style.display = 'none';
            });
            // Ocultar los campos si se selecciona otra opción
            businessFields.forEach((field) => {
                field.style.display = 'none';
            });
            passportFields.forEach((field) => {
                field.style.display = 'block'; // Mostrar
            });
            
        } else {
            // Ocultar los campos si se selecciona otra opción
            passportFields.forEach((field) => {
                field.style.display = 'none';
            });
        }
        
    };


    const searchIdentification = async () => {

        const preloadElement = document.getElementById('preload-idenfication');
        const identification = document.getElementById('contact_id').value;

        console.log(identification)

        if (identification=='') { // Verifica si es null, undefined o vacío
            console.log('vacio');
            alert('La identificación no es válida o no se ha encontrado');
            return;
        }

        // Mostrar el preloader
        preloadElement.style.display = 'block';

        // Reiniciar valores
        info.identification = identification;
        info.type_identification = null;
        info.name = null;
        info.address = null;

        console.log("Cargando..."); // Simulación de $q.loading.show()

        try {
            
            const response = await fetch(
            `${API_BASE_URL}/api/identification-search`, // Ajusta la URL a tu entorno
            {
                method: 'POST',
                headers: {
                'Content-Type': 'application/json',
                
                },
                body: JSON.stringify({ identification: info.identification })
            }
            );

            if (!response.ok) {
            throw new Error('Error en la respuesta del servidor');
            }

            const dataResponse = await response.json();
            console.log(dataResponse);

            // Obtener y asignar valores desde la respuesta
            const type_identification = dataResponse.tipoIdentificacion || null;
            let type = null;

            if (type_identification === 'C') {
            type = 1;
            } else if (type_identification === 'R') {
            type = 2;
            }

            // Selecciona los elementos de los radios
            const radioIndividual = document.getElementById('inlineRadio1');
            const radioBusiness = document.getElementById('inlineRadio2');

            info.type_identification = type;
            info.name = dataResponse.nombreComercial || null;
            info.address = dataResponse.ubicacionEstablecimiento || null;



            // Selecciona el radio basado en el valor de `type`
            if (type === 1) {
                radioIndividual.click(); // Selecciona el radio "individual"
            } else if (type === 2) {
                radioBusiness.click(); // Selecciona el radio "business"
            }

            // Suponiendo que info.name contiene un nombre completo
            if (info.name) {
            const nameParts = info.name.trim().split(' '); // Divide el nombre en palabras

            // Extrae las palabras según el orden requerido
            const lastName = nameParts.slice(0, 2).join(' '); // Las primeras dos palabras
            const firstName = nameParts[2] || ''; // La tercera palabra (si existe)
            const middleName = nameParts[3] || ''; // La cuarta palabra (si existe)

            // Asigna los valores a los campos correspondientes
            /*document.querySelector('input[name="last_name"]').value = lastName;
            document.querySelector('input[name="first_name"]').value = firstName;
            document.querySelector('input[name="middle_name"]').value = middleName;*/

            // Asignar los valores a todos los inputs correspondientes
            setInputValues("last_name", lastName);
            setInputValues("first_name", firstName);
            setInputValues("middle_name", middleName);

            // Asigna el valor completo de info.name a supplier_business_name
            document.querySelector('input[name="supplier_business_name"]').value = info.name.trim();

            }

            if(info.address){
                document.querySelector('input[name="address_line_1"]').value = info.address.trim();
            }
            



        } catch (error) {
            console.error("Error al buscar identificación:", error);
            alert('La identificación no es válida o no se ha encontrado'); // Simulación de $q.notify
        } finally {
            console.log("Carga finalizada"); // Simulación de $q.loading.hide()
            // Ocultar el preloader
            preloadElement.style.display = 'none';
        }
    };

    // Función para asignar valores a todos los inputs con el mismo name
    const setInputValues = (name, value) => {
        document.querySelectorAll(`input[name="${name}"]`).forEach(input => {
            input.value = value;
        });
    };

    document.addEventListener("click", function (event) {
    if (event.target && event.target.id === "submit") {
        let isValid = true;
        let errorMessage = "";

        // 1. Validar tipo de contacto
        let contactType = document.querySelector('input[name="contact_type_radio"]:checked');
        if (!contactType) {
            isValid = false;
            errorMessage += "Debe seleccionar un tipo de identificación.\n";
        } else {
            contactType = contactType.value;
        }

        // 2. Validar 'contact_id'
        let contactId = document.getElementById("contact_id").value.trim();
        if (contactType === "individual" && !/^\d{10}$/.test(contactId)) {
            isValid = false;
            errorMessage += "El ID debe tener 10 dígitos para Individual.\n";
        } else if (contactType === "business" && !/^\d{13}$/.test(contactId)) {
            isValid = false;
            errorMessage += "El ID debe tener 13 dígitos para Business.\n";
        } else if (contactType === "passport" && contactId === "") {
            isValid = false;
            errorMessage += "Debe ingresar un ID para Passport.\n";
        }

        // 3. Validar dirección
        let address = document.getElementById("address_line_1").value.trim();
        if (address === "") {
            isValid = false;
            errorMessage += "Debe ingresar una dirección.\n";
        }

        // 4. Validar email
        let email = document.getElementById("email").value.trim();
        let emailPattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        if (email === "") {
            isValid = false;
            errorMessage += "Debe ingresar un correo electrónico.\n";
        } else if (!emailPattern.test(email)) {
            isValid = false;
            errorMessage += "El correo electrónico no es válido.\n";
        }

        // 5. Validar nombres
        let lastName = document.querySelector('input[name="last_name"]').value.trim();
        let firstName = document.querySelector('input[name="first_name"]').value.trim();
        let middleName = document.querySelector('input[name="middle_name"]').value.trim();
        let supplierBusinessName = document.querySelector('input[name="supplier_business_name"]').value.trim();

        if (lastName === "" && supplierBusinessName === "") {
            isValid = false;
            errorMessage += "Debe ingresar al menos el Nombre o el Nombre del negocio.\n";
        }

        // 6. Concatenar nombres
        if (firstName !== "" || middleName !== "" || lastName !== "") {
            document.querySelector('input[name="supplier_business_name"]').value = `${firstName} ${middleName} ${lastName}`.trim();
        } else if (supplierBusinessName !== "") {
            //document.querySelector('input[name="last_name"]').value = supplierBusinessName;
            setInputValues("last_name", supplierBusinessName);
        }

        // Si hay errores, mostrar alerta y detener el envío
        if (!isValid) {
            event.preventDefault();
            alert(errorMessage);
        }
    }
});
</script><?php /**PATH /home/pharmavi/public_html/mypymes/resources/views/contact/edit.blade.php ENDPATH**/ ?>