

<?php $__env->startSection('title', __( 'lang_v1.sales_order')); ?>
<?php $__env->startSection('content'); ?>

<!-- Content Header (Page header) -->
<section class="content-header no-print">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">Documento XML Autorizado
    </h1>
</section>

<!-- Main content -->
<section class="content no-print">

    
    <div class="text-right">
        <!-- Botón para descargar el archivo -->
        <button class="btn btn-primary" id="download-xml">Descargar XML</button>
    </div>
    <br>

    <!-- Mostrar el XML en un <pre> -->
    <pre id="xml-content" style="background: #f4f4f4; padding: 10px; border: 1px solid #ddd; overflow: auto; white-space: pre-wrap;">
        
    </pre>

</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
<script>
    function escapeXml(unsafe) {
        return unsafe.replace(/&/g, "&amp;")
                     .replace(/</g, "&lt;")
                     .replace(/>/g, "&gt;")
                     .replace(/"/g, "&quot;")
                     .replace(/'/g, "&#039;");
    }

    // Contenido XML dinámico pasado desde Blade
    const rawXmlContent = <?php echo json_encode($xmlContent); ?>;

    // Escapar el contenido antes de mostrarlo
    const escapedXmlContent = escapeXml(rawXmlContent);

    // Insertar el contenido escapado en el <pre>
    const xmlViewer = document.getElementById('xml-content');
    xmlViewer.textContent = rawXmlContent;

    // Función para descargar el XML como archivo
    const downloadButton = document.getElementById('download-xml');
    downloadButton.addEventListener('click', () => {
        const blob = new Blob([rawXmlContent], { type: 'application/xml' });
        const url = URL.createObjectURL(blob);
        const a = document.createElement('a');
        a.href = url;
        a.download = <?php echo json_encode($claveAcceso); ?>+'xml'; // Nombre del archivo descargado
        a.click();
        URL.revokeObjectURL(url); // Limpieza de memoria
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/pharmavi/public_html/mypymes/resources/views/sales_order/xml.blade.php ENDPATH**/ ?>