
<?php $__env->startSection('title', __( 'lang_v1.sales_order')); ?>
<?php $__env->startSection('css'); ?>
    <style>
        /* Mensaje flotante sobre la página */
        .processing-message {
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            background-color: rgba(0, 0, 0, 0.8); /* Fondo oscuro */
            color: white;
            padding: 1rem 2rem;
            font-size: 1.25rem;
            border-radius: 8px;
            box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.2);
            z-index: 2000; /* Más alto que otros elementos */
            text-align: center;
        }

        /* Clase oculta */
        .d-none {
            display: none;
        }
    </style>

    <!-- Incluir Select2 CSS -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<?php
    $totalIva = 0;
    if($transaction->type == 'purchase'){
        foreach ($transaction->purchase_lines as $value) {
            $totalIva = $totalIva + $value->item_tax;
        }
    }
?>
<div id="preloader" class="d-none text-center">
    <div class="spinner-border text-primary" role="status">
        <span class="sr-only">Cargando...</span>
    </div>
</div>


<!-- Content Header (Page header) -->
<section class="content-header no-print">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">Generar Retención
    </h1>
</section>

<!-- Main content -->
<section class="content no-print">


<!-- Mensaje personalizado (oculto por defecto) -->
<div id="processingMessage" class="processing-message d-none">
    Procesando solicitud, por favor espera...
</div>  
<?php $__env->startComponent('components.widget', ['class' => 'box-primary', 'title' => 'Información Documentos']); ?>
<div class="relative overflow-x-auto">
    <div class="row">
        <div class="col-xs-4">
            <span class="text-bold">Numero</span> <br>
            <?php echo e($transaction->ref_no, false); ?>

        </div>
        <div class="col-xs-8">
            <span class="text-bold">Proveedor</span> <br>
            <?php echo e($transaction->contact->contact_id, false); ?> - <?php echo e($transaction->contact->name, false); ?>

        </div>
        <div class="col-xs-12 mt-5">

        </div>
        <div class="col-xs-4">
            <span class="text-bold">Total Fuente</span> <br>
            <?php if($transaction->type == 'purchase'): ?>
                <?php echo e(number_format($transaction->total_before_tax-$totalIva,2,'.',''), false); ?>

            <?php else: ?>
                <?php echo e(number_format($transaction->total_before_tax,2,'.',''), false); ?>

            <?php endif; ?>            
        </div>
        <div class="col-xs-4">
            <span class="text-bold">Total Iva</span> <br>
            <?php if($transaction->type == 'purchase'): ?>
                <?php echo e(number_format($totalIva,2,'.',''), false); ?>

            <?php else: ?>
                <?php echo e(number_format($transaction->tax_amount,2,'.',''), false); ?>

            <?php endif; ?>  
            
        </div>

        <div class="col-xs-4">
            <span class="text-bold">Total General</span> <br>
            <?php echo e(number_format($transaction->final_total,2,'.',''), false); ?>

        </div>

        <div class="col-xs-12 mt-5">
            <hr>
        </div>

        <div class="col-xs-4">
            <div class="form-group mt-5 m-5">
                <label for="document">Documento:</label>  
                <input name="document" id="document" class="form-control" type="text" value="<?php echo e($transaction->retencion ? $transaction->retencion->document : '', false); ?>">
            </div>
        </div>

        <div class="col-xs-8">
            <div class="form-group mt-5 m-5">
                <label for="authorization">Autorización:</label>  
                <input name="authorization" id="authorization" class="form-control" type="text" value="<?php echo e($transaction->retencion ? $transaction->retencion->authorization : '', false); ?>">
            </div>
        </div>

        <div class="col-xs-6 mt-5 text-bold">
            <?php $__env->startComponent('components.widget', ['class' => 'box-primary', 'title' => 'Aplicar Retencion sobre la Fuente']); ?>
                <div class="form-group mt-5 m-5">
                    <label for="monto_fuente">Monto:</label>  
                    <input name="monto_fuente" id="monto_fuente" class="form-control" type="number">
                </div>
            

                <div class="form-group mt-5 m-5">
                    <label for="fuente_id">Tipo:</label>
                    <select name="fuente_id" id="fuente_id" class="form-control" style="width: 100%">
                        <option value="" data-porcentaje="">Seleccionar</option>
                        <?php $__currentLoopData = $tipo_retencion_fuente; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($item->id, false); ?>" 
                                data-porcentaje="<?php echo e($item->percentage, false); ?>"
                                data-code="<?php echo e($item->code, false); ?>"
                                data-value="<?php echo e($item->id, false); ?>"
                            >
                                <?php echo e($item->description, false); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <button class="btn btn-primary mb-5 mt-5 ml-5 mr-5 m-5 add"
                    id="btn_fuente" data-type="fuente"
                >
                    Agregar
                </button>
            <?php echo $__env->renderComponent(); ?>
        </div>

        <div class="col-xs-6 mt-5 text-bold">
            
            <?php $__env->startComponent('components.widget', ['class' => 'box-primary', 'title' => 'Aplicar Retencion sobre el iva']); ?>
                    <div class="form-group mt-5 m-5">
                        <label for="monto_iva">Monto:</label>  
                        <input name="monto_iva" id="monto_iva" class="form-control" type="number">
                    </div>

                    <div class="form-group mt-5 m-5">
                        <label for="iva_id">Tipo:</label>
                        <select name="iva_id" id="iva_id" class="form-control" style="width: 100%">
                            <option value="" data-porcentaje="" >Seleccionar</option>
                            <?php $__currentLoopData = $tipo_retencion_iva; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($item->id, false); ?>" 
                                    data-porcentaje="<?php echo e($item->percentage, false); ?>"
                                    data-code="<?php echo e($item->code, false); ?>"
                                    data-value="<?php echo e($item->id, false); ?>"
                                >
                                    <?php echo e($item->description, false); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <button class="btn btn-primary mb-5 mt-5 ml-5 mr-5 m-5 add"
                        id="btn_iva" data-type="iva"
                    >
                        Agregar
                    </button>
            <?php echo $__env->renderComponent(); ?>
        </div>

        <div class="col-xs-12 mt-5">
            <table class="table table-bordered" id="retencionTable">
                <thead>
                    <tr>
                        <th>Descripción</th>
                        <th>Porcentaje</th>
                        <th>Monto</th>
                        <th>Retención</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    <!-- Las filas se agregarán aquí dinámicamente -->
                </tbody>
            </table>
        </div>

        <div class="col-xs-12 mt-5">
            <p id="totalRetenido">Total Retenido: $0.00</p> <!-- Monto total retenido -->
            <p class="text-right">
                <button id="saveBtn" class="btn btn-success ">Guardar</button>
            </p>
            
        </div>

        <?php
            //dd($transaction)
        ?>
    </div>
</div>
<div class="modal fade" id="processingModal" tabindex="-1" role="dialog" aria-labelledby="processingModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="processingModalLabel">Procesando solicitud</h5>
        </div>
        <div class="modal-body text-center">
            <div class="spinner-border text-primary" role="status">
            <span class="sr-only">Cargando...</span>
            </div>
            <p class="mt-3">Por favor, espera mientras procesamos tu solicitud.</p>
        </div>
        </div>
    </div>
    </div>
<?php echo $__env->renderComponent(); ?>


<?php
//dd($transaction )
?>
</section>

<!-- /.content -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('javascript'); ?>
<script>

    // Crear un arreglo vacío para almacenar las retenciones
    //let retenciones = [];
    let totalRetenido = 0; // Variable para almacenar el total retenido

    // Inicializar arreglo de retenciones con datos precargados del servidor
    let retenciones = <?php echo json_encode($retencionesExistentes, 15, 512) ?>;

    console.log('retenciones',retenciones);

    // Función para renderizar la tabla
    function renderTablaRetenciones() {
        let tbody = $('#retencionTable tbody');
        tbody.empty();

        totalRetenido = 0;
        retenciones.forEach((item, index) => {
            totalRetenido += parseFloat(item.retencion);
            tbody.append(`
                <tr>
                    <td>${item.descripcion}</td>
                    <td>${item.porcentaje}%</td>
                    <td>${item.monto}</td>
                    <td>${item.retencion.toFixed(2)}</td>
                    <td>${item.tipoRetencion}</td>
                    <td>
                        <button class="btn btn-danger btn-sm removeRow">Eliminar</button>
                    </td>
                </tr>
            `);
        });

        // Mostrar el total retenido
        //$('#totalRetenido').text(totalRetenido.toFixed(2));
        $('#totalRetenido').text('Total Retenido: $' + totalRetenido.toFixed(2));
    }

    // Renderizar la tabla al cargar la página
    renderTablaRetenciones();

$(document).ready(function() {

    

    // Cuando se haga clic en el botón "Agregar"
    $('button.add').on('click', function(e) {
        e.preventDefault(); // Prevenir el comportamiento por defecto del botón

        // Identificar qué tipo de botón fue presionado (Fuente o IVA)
        var tipoSeleccionado = $(this).data('type'); // 'fuente' o 'iva'

        console.log(tipoSeleccionado);
        if(!tipoSeleccionado){
            return false;
        }

        var monto = 0;
        var tipoDescripcion = '';
        var porcentaje = 0;
        var code= '';
        var value= '';

        // Si el botón es de Fuente
        if (tipoSeleccionado == 'fuente') {
            monto = $('#monto_fuente').val();
            console.log(monto);
            tipoDescripcion = $('#fuente_id option:selected').text();
            porcentaje = $('#fuente_id option:selected').data('porcentaje');
            code = $('#fuente_id option:selected').data('code');
            value = $('#fuente_id option:selected').data('value');
        }
        // Si el botón es de IVA
        else if (tipoSeleccionado == 'iva') {
            monto = $('#monto_iva').val();
            tipoDescripcion = $('#iva_id option:selected').text();
            porcentaje = $('#iva_id option:selected').data('porcentaje');
            code = $('#iva_id option:selected').data('code');
            value = $('#iva_id option:selected').data('value');
        }

        console.log(monto, tipoDescripcion, porcentaje);

        // Verificar que los valores estén completos
        if (monto && tipoDescripcion && porcentaje) {
            // Calcular la retención
            var retencion = (monto * porcentaje) / 100;

            // Determinar si es Fuente o IVA
            var tipoRetencion = tipoSeleccionado === 'fuente' ? 'Fuente' : 'IVA';

            // Crear la nueva fila en la tabla
            var newRow = `
                <tr>
                    <td>${tipoDescripcion}</td>
                    <td>${porcentaje}%</td>
                    <td>${monto}</td>
                    <td>${retencion.toFixed(2)}</td>
                    <td>${tipoRetencion}</td>
                    <td><button class="btn btn-danger btn-sm removeRow">Eliminar</button></td>
                </tr>
            `;

            // Añadir la nueva fila a la tabla
            $('#retencionTable tbody').append(newRow);

            // Agregar la retención al arreglo
            retenciones.push({
                descripcion: tipoDescripcion,
                porcentaje: porcentaje,
                monto: monto,
                retencion: retencion.toFixed(2),
                tipoRetencion: tipoRetencion,
                code: code,
                value: value
            });

            // Actualizar el total retenido
            totalRetenido += retencion;
            $('#totalRetenido').text('Total Retenido: $' + totalRetenido.toFixed(2));


            // Limpiar los campos después de agregar la fila
            $('#monto_fuente').val('');
            $('#fuente_id').val('');
            $('#monto_iva').val('');
            $('#iva_id').val('');
        } else {
            alert('Por favor completa todos los campos.');
        }
        });

        // Funcionalidad para eliminar una fila
        $(document).on('click', '.removeRow', function() {

            
            
            var row = $(this).closest('tr');
            
            var retencionEliminada = parseFloat(row.find('td:nth-child(4)').text()); // Obtener el monto de la retención eliminada

            console.log(row,retencionEliminada, totalRetenido,retenciones);

            // Actualizar el total retenido
            totalRetenido = Number(totalRetenido.toFixed(2)) - Number(retencionEliminada);
            $('#totalRetenido').text('Total Retenido: $' + totalRetenido.toFixed(2));            

            // Eliminar la retención correspondiente del arreglo
            var index = row.index();
            retenciones.splice(index, 1);

            // Eliminar la fila
            row.remove();

            console.log(retenciones); // Ver el arreglo después de la eliminación
        });


        // Guardar los datos y enviarlos a la API (por ejemplo, al hacer clic en un botón "Guardar")
        $('#saveBtn').on('click', function(e) {
            e.preventDefault();

            // Asegúrate de que el arreglo de retenciones no esté vacío
            if (retenciones.length > 0) {
                // Obtener el ID de la transacción
                var transactionId = '<?php echo e($transaction->id, false); ?>'; // Asumimos que $transaction->id está disponible en el blade
                let document = $('#document').val();
                let authorization = $('#authorization').val();

                // Enviar los datos a la API mediante AJAX
                $.ajax({
                    url: '/expenses-apply-save', // Reemplaza con la ruta de tu API
                    method: 'POST',
                    data: {
                        _token: '<?php echo e(csrf_token(), false); ?>', // Asegúrate de incluir el token CSRF
                        transaction_id: transactionId, // Enviar el ID de la transacción
                        total_retenido: totalRetenido.toFixed(2), // Enviar el total retenido
                        retenciones: retenciones, // Enviar las retenciones
                        document: document,
                        authorization: authorization
                    },
                    success: function(response) {
                        // Manejar la respuesta de la API
                        alert('Datos guardados exitosamente');
                        console.log(response);
                    },
                    error: function(xhr, status, error) {
                        // Manejar errores
                        alert('Hubo un error al guardar los datos');
                        console.log(xhr, status, error);
                    }
                });
            } else {
                alert('No hay retenciones para guardar');
            }
        });
    });

</script>
	
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/onoboait/farmacia.onoboaits.com/mypymes/resources/views/expense/apply_add.blade.php ENDPATH**/ ?>