
<?php $__env->startSection('title', __( 'lang_v1.sales_order')); ?>
<?php $__env->startSection('css'); ?>
    <style>
        /* Mensaje flotante sobre la página */
        .processing-message {
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            background-color: rgba(0, 0, 0, 0.8); /* Fondo oscuro */
            color: white;
            padding: 1rem 2rem;
            font-size: 1.25rem;
            border-radius: 8px;
            box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.2);
            z-index: 2000; /* Más alto que otros elementos */
            text-align: center;
        }

        /* Clase oculta */
        .d-none {
            display: none;
        }
    </style>

    <!-- Incluir Select2 CSS -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<?php
    function getTypeString($t){
        if($t == 'sell'){
            return 'FAC';
        }elseif ($t == 'sell_return') {
            return 'DEV';
        }else{
            return 'RET';
        }

        return '';
    }
?>
<div id="preloader" class="d-none text-center">
    <div class="spinner-border text-primary" role="status">
        <span class="sr-only">Cargando...</span>
    </div>
</div>


<!-- Content Header (Page header) -->
<section class="content-header no-print">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">Aplicar Retencion
    </h1>
</section>

<!-- Main content -->
<section class="content no-print">


<!-- Mensaje personalizado (oculto por defecto) -->
<div id="processingMessage" class="processing-message d-none">
    Procesando solicitud, por favor espera...
</div>   

<?php $__env->startComponent('components.filters', ['title' => __('report.filters')]); ?>
<form method="GET" action="<?php echo e(route('get_sales_orders_sri.index'), false); ?>"> 
    <div class="col-md-12">
        <!-- Filtro por Cliente -->
        <div class="form-group">
            <label for="client_id">Cliente:</label>
            <select name="client_id" id="client_id" class="form-control" style="width: 100%">
                <option value="">Seleccionar Cliente</option>
                <?php $__currentLoopData = $clients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($client->id, false); ?>" <?php echo e(request('client_id') == $client->id ? 'selected' : '', false); ?>>
                        <?php echo e($client->name, false); ?> - <?php echo e($client->contact_id, false); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
    </div>
    <div class="col-md-4">
        <!-- Filtro por Fecha Desde -->
        <div class="form-group">
            <label for="date_from">Fecha Desde:</label>
            <input type="date" name="date_from" id="date_from" class="form-control" value="<?php echo e(request('date_from'), false); ?>">
        </div>
    </div>
    <div class="col-md-4">
        <!-- Filtro por Fecha Hasta -->
        <div class="form-group">
            <label for="date_to">Fecha Hasta:</label>
            <input type="date" name="date_to" id="date_to" class="form-control" value="<?php echo e(request('date_to'), false); ?>">
        </div>
    </div>
    <div class="col-md-4">
        <!-- Filtro por Localidad -->
        <div class="form-group">
            <label for="location_id">Localidad:</label>
            <select name="location_id" id="location_id" class="form-control" style="width: 100%">
                <option value="">Seleccionar Localidad</option>
                <?php $__currentLoopData = $locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $location): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($location->id, false); ?>" <?php echo e(request('location_id') == $location->id ? 'selected' : '', false); ?>>
                        <?php echo e($location->name, false); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
    </div>
    <div class="col-md-6">
        <!-- Botón de Buscar -->
        <button type="submit" class="btn btn-primary">Buscar</button>
    </div>
</form>
<?php echo $__env->renderComponent(); ?>
<?php $__env->startComponent('components.widget', ['class' => 'box-primary', 'title' => 'Documentos']); ?>
<div class="relative overflow-x-auto">
    <div class="table-responsive">
        <table class="table table-bordered table-striped ajax_view" id="">
            <thead>
                <tr>
                    <th>Accion</th>
                    <th>Tipo</th>
                    <th>Documento</th>
                    <th>Fecha</th>
                    <th width="200">Proveedor</th>
                    <th>Valor</th>
                    <th>Correo</th>
                    <th>Estado</th>
                    <th>Respuesta del SRI</th>
                    <th>Detalle</th>
                    
                </tr>
            </thead>

            <tbody>
                <?php $__currentLoopData = $transaction; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> 
                    <?php
                        $codeStatus = 0;
                        $status = 'NO APLICADA';
                        $message = 'NO APLICADA';
                        $detalle = '';
                        $claveAcceso = '';
                        if(count($t->sri) > 0){
                            $sri = (object) $t->sri[0];
                            //dd($sri);
                            $claveAcceso = $sri->clave_acceso;
                            $status = $sri->estado;
                            $message = $sri->respuesta_error_sri_msg; 
                            $detalle = $sri->respuesta_error_sri != '' && $sri->respuesta_error_sri != "\"\""? $sri->respuesta_error_sri  : '';
                            if($status == ''){
                                $status = "ERROR";
                                $codeStatus = 3;
                            }elseIf($status == 'AUTORIZADO'){
                                $codeStatus = 1;
                            }elseIf($status == 'NO AUTORIZADO'){
                                $codeStatus = 3;
                            }else{
                                $codeStatus = 2;
                            }
                        }elseif($t->retencion && isset($t->retencion->dt)){
                            $status = 'PENDIENTE';
                            $message = 'PENDIENTE';
                            $codeStatus = 0;

                        }
                    ?>
                    <tr>
                        <td>                            
                            
                            <div class="btn-group">
                                <button type="button" class="tw-dw-btn 
                                    tw-dw-btn-xs tw-dw-btn-outline tw-dw-btn-info
                                    tw-w-max dropdown-toggle" 
                                    data-toggle="dropdown" 
                                    aria-expanded="false">Acciones<span class="caret"></span>
                                    <span class="sr-only">Toggle Dropdown</span>
                                </button>
                                    <ul class="dropdown-menu dropdown-menu-left" 
                                    role="menu">
                                        <?php if($codeStatus!=1): ?>
                                            <?php if($message=='CLAVE ACCESO REGISTRADA'): ?>
                                                <li>
                                                    <a href="javascript:void(0)" 
                                                    onclick="getSalesOrdersSriVerify(<?php echo e($t->id, false); ?>,'<?php echo e($t->type, false); ?>')" class="btn-modal">                                            
                                                        <i class="fas fa-sync-alt"></i>
                                                        Validar
                                                    </a>
                                                </li>
                                            <?php elseif($message=='NO APLICADA'): ?>
                                                <li>
                                                    <a href="<?php echo e(url('/get-expenses-apply-add/'.$t->id), false); ?>" target="_blank" >                                            
                                                        <i class="fas fa-sync-alt"></i>
                                                        Aplicar Retención
                                                    </a>
                                                </li>
                                            <?php else: ?>
                                                <li>
                                                    <a href="javascript:void(0)" 
                                                    onclick="getSalesOrdersSriSend(<?php echo e($t->id, false); ?>,'<?php echo e($t->type, false); ?>')" class="btn-modal">                                            
                                                        <i class="fas fa-sync-alt"></i>
                                                        Enviar al SRI
                                                    </a>
                                                </li>
                                                <li>
                                                    <a href="<?php echo e(url('/get-expenses-apply-add/'.$t->id), false); ?>" target="_blank" >                                            
                                                        <i class="fas fa-sync-alt"></i>
                                                        Editar Aplicar Retención
                                                    </a>
                                                </li>                                            <?php endif; ?>
                                        <?php endif; ?>
                                        <?php if($codeStatus==1): ?>
                                        
                                            <li>
                                                <a href="javascript:void(0)" 
                                                onclick="getSalesOrdersReevio(<?php echo e($t->id, false); ?>,'<?php echo e($t->type, false); ?>')" class="btn-modal">
                                                    <i class="fas fa-envelope"></i>
                                                    Reenvio
                                                </a>
                                            </li>                                        
                                            <li>
                                                <a href="<?php echo e(url('/get-expenses-report-ride/'.$claveAcceso), false); ?>" target="_blank">
                                                    <i class="fas fa-file-pdf"></i> 
                                                    Ride
                                                </a>
                                            </li>
                                            <li>
                                                <a href="<?php echo e(url('/get-expenses-report-xml/'.$claveAcceso), false); ?>" target="_blank">
                                                    <i class="fas fa-file-alt"></i>
                                                    XML
                                                </a>
                                            </li>
                                        <?php endif; ?>
                                        
                                    </ul>
                            </div>  
                        
                        </td>
                        <td><?php echo e(getTypeString($t->type), false); ?></td>
                        <td><?php echo e($t->invoice_no, false); ?></td>
                        <td><?php echo e($t->transaction_date, false); ?></td>
                        <td><?php echo e($t->contact->contact_id, false); ?> - <?php echo e($t->contact->name == '' || $t->contact->name == null ? $t->contact->supplier_business_name : $t->contact->name, false); ?></td>
                        <td>$<?php echo e(number_format($t->final_total,2,'.',''), false); ?></td>
                        <td><?php echo e($t->contact->email, false); ?></td>
                        <td>
                            <?php if($codeStatus==1): ?>
                            <span class="label" style="background-color: rgb(22 101 52);">
                                <?php echo e($status, false); ?>

                            </span>
                            <?php endif; ?>
                            <?php if($codeStatus==0): ?>
                            <span class="label" style="background-color: rgb(245 158 11);">
                                <?php echo e($status, false); ?>

                            </span>
                            <?php endif; ?>
                            <?php if($codeStatus==3): ?>
                            <span class="label" style="background-color: rgb(127 29 29);">
                                <?php echo e($status, false); ?>

                            </span>
                            <?php endif; ?>
                            <?php if($codeStatus==2): ?>
                            <span class="label" style="background-color: rgb(79 70 229);">
                                <?php echo e($status, false); ?>

                            </span>
                            <?php endif; ?>
                        </td>
                        <td><?php echo e($message, false); ?></td>
                        <td ><div style="font-size:12px !important;"><?php echo e($detalle, false); ?></div></td>
                        
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        
        </table>

        <br>
        <div class="text-right"><?php echo e($transaction->appends(request()->query())->links(), false); ?></div>
        <br>

    </div>
</div>

<div class="modal fade" id="processingModal" tabindex="-1" role="dialog" aria-labelledby="processingModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="processingModalLabel">Procesando solicitud</h5>
        </div>
        <div class="modal-body text-center">
          <div class="spinner-border text-primary" role="status">
            <span class="sr-only">Cargando...</span>
          </div>
          <p class="mt-3">Por favor, espera mientras procesamos tu solicitud.</p>
        </div>
      </div>
    </div>
  </div>
<?php echo $__env->renderComponent(); ?>


<?php
//dd($transaction )
?>
</section>

<!-- /.content -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('javascript'); ?>
<?php if ($__env->exists('sales_order.common_js')) echo $__env->make('sales_order.common_js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- Incluir Select2 JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>



<script type="text/javascript">
$(document).ready( function(){
    
    $('#sell_list_filter_date_range').daterangepicker(
        dateRangeSettings,
        function (start, end) {
            $('#sell_list_filter_date_range').val(start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format));
            sell_table.ajax.reload();
        }
    );
    $('#sell_list_filter_date_range').on('cancel.daterangepicker', function(ev, picker) {
        $('#sell_list_filter_date_range').val('');
        sell_table.ajax.reload();
    });
    sell_table = $('#sell_table').DataTable({
        processing: true,
        serverSide: true,
        aaSorting: [[1, 'desc']],
        "ajax": {
            "url": '/sells?sale_type=sales_order',
            "data": function ( d ) {
                if($('#sell_list_filter_date_range').val()) {
                    var start = $('#sell_list_filter_date_range').data('daterangepicker').startDate.format('YYYY-MM-DD');
                    var end = $('#sell_list_filter_date_range').data('daterangepicker').endDate.format('YYYY-MM-DD');
                    d.start_date = start;
                    d.end_date = end;
                }

                if($('#sell_list_filter_location_id').length) {
                    d.location_id = $('#sell_list_filter_location_id').val();
                }
                d.customer_id = $('#sell_list_filter_customer_id').val();

                if ($('#so_list_filter_status').length) {
                    d.status = $('#so_list_filter_status').val();
                }
                if ($('#so_list_shipping_status').length) {
                    d.shipping_status = $('#so_list_shipping_status').val();
                }

                if($('#created_by').length) {
                    d.created_by = $('#created_by').val();
                }
            }
        },
        columnDefs: [ {
            "targets": 7,
            "orderable": false,
            "searchable": false
        } ],
        columns: [
            { data: 'action', name: 'action'},
            { data: 'transaction_date', name: 'transaction_date'  },
            { data: 'invoice_no', name: 'invoice_no'},
            { data: 'conatct_name', name: 'conatct_name'},
            { data: 'mobile', name: 'contacts.mobile'},
            { data: 'business_location', name: 'bl.name'},
            { data: 'status', name: 'status'},
            { data: 'shipping_status', name: 'shipping_status'},
            { data: 'so_qty_remaining', name: 'so_qty_remaining', "searchable": false},
            { data: 'added_by', name: 'u.first_name'},
        ]
    });
    $(document).on('change', '#sell_list_filter_location_id, #sell_list_filter_customer_id, #created_by, #so_list_filter_status, #so_list_shipping_status',  function() {
        sell_table.ajax.reload();
    });
});


function getSalesOrdersSriVerify(id,type) {

    const message = document.getElementById('processingMessage');

    // Mostrar el mensaje
    message.classList.remove('d-none');

    let url = ''; 

    /*if(type=='sell'){
        url = `/get-sales-orders-sri-verify/${id}`;
    }else if(type=='sell_return'){
        url = `/get-sales-orders-sri-verify-dev/${id}`;
    }*/

   url = `${APP_URL}/get-expenses-sri-verify/${id}`;
    
    const csrfToken = document.querySelector('meta[name="csrf-token"]').content;

    fetch(url,{
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': csrfToken
        }
    })
        .then(response => {
            if (!response.ok) {
                throw new Error(`Error: ${response.status}`);
            }
            return response.json(); // Asume que el servidor retorna JSON
        })
        .then(data => {
            console.log("Respuesta del servidor:", data);
            
            setTimeout(() => {
                location.reload(); // Recargar la página
            }, 2000); // Espera de 2 segundos
        })
        .catch(error => {
            console.error("Error en la solicitud:", error);
            
            setTimeout(() => {
                location.reload(); // Recargar la página
            }, 2000); // Espera de 2 segundos
        });
}

function getSalesOrdersSriSend(id,type) {

const message = document.getElementById('processingMessage');

// Mostrar el mensaje
message.classList.remove('d-none');

let url = '';

//const url = `/get-sales-orders-sri-send/${id}`;
//if(type=='sell'){
//    url = `/get-sales-orders-sri-send/${id}`;
//}else if(type=='sell_return'){
url = `https://grupokalabi.com.ec/mypymes/public/get-expenses-sri-send/${id}`;
//}
const csrfToken = document.querySelector('meta[name="csrf-token"]').content;

fetch(url,{
    headers: {
        'Content-Type': 'application/json',
        'X-CSRF-TOKEN': csrfToken
    }
})
    .then(response => {
        if (!response.ok) {
            throw new Error(`Error: ${response.status}`);
        }
        return response.json(); // Asume que el servidor retorna JSON
    })
    .then(data => {
        console.log("Respuesta del servidor:", data);
        
        setTimeout(() => {
            location.reload(); // Recargar la página
        }, 2000); // Espera de 2 segundos
    })
    .catch(error => {
        console.error("Error en la solicitud:", error);
        
        setTimeout(() => {
            location.reload(); // Recargar la página
        }, 2000); // Espera de 2 segundos
    });
}

function getSalesOrdersReevio(id,type) {

const message = document.getElementById('processingMessage');

// Mostrar el mensaje
message.classList.remove('d-none');

let url = '';

//const url = `/get-sales-orders-sri-ride/${id}`;
/*if(type=='sell'){
    url = `/get-sales-orders-sri-ride/${id}`;
}else if(type=='sell_return'){
    url = `/get-sales-orders-sri-ride-dev/${id}`;
}*/

url = `https://grupokalabi.com.ec/mypymes/public/get-expenses-sri-ride/${id}`;

const csrfToken = document.querySelector('meta[name="csrf-token"]').content;

fetch(url,{
    headers: {
        'Content-Type': 'application/json',
        'X-CSRF-TOKEN': csrfToken
    }
})
    .then(response => {
        if (!response.ok) {
            throw new Error(`Error: ${response.status}`);
        }
        return response.json(); // Asume que el servidor retorna JSON
    })
    .then(data => {
        console.log("Respuesta del servidor:", data);
        
        setTimeout(() => {
            location.reload(); // Recargar la página
        }, 2000); // Espera de 2 segundos
    })
    .catch(error => {
        console.error("Error en la solicitud:", error);
        
        setTimeout(() => {
            location.reload(); // Recargar la página
        }, 2000); // Espera de 2 segundos
    });
}




</script>
	
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/pharmavi/public_html/mypymes/resources/views/expense/index_apply.blade.php ENDPATH**/ ?>